/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.jcr;

import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.search.retrieval.dao.CommentCache;
import com.sas.svcs.content.search.retrieval.dao.CommentEntry;
import com.sas.svcs.content.search.retrieval.dao.util.AbstractIndexDataCommentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class JCRIndexDataCommentsUtil
extends AbstractIndexDataCommentsUtil {
    protected JcrTemplate template;
    protected JcrContentUtils jcrUtils = new JcrContentUtils();
    protected ObjectTypeService objectTypeService;

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setTemplate(JcrTemplate template) {
        this.template = template;
    }

    protected void mapGuidsToCache(CommentCache commentCache, List<String> updatedGuids) {
        final List<String> guidList = updatedGuids;
        List result = (List)this.template.execute((JcrCallback)new JcrCallback<List<CommentEntry>>(){

            public List<CommentEntry> doInJcr(Session session) throws RepositoryException {
                ArrayList<CommentEntry> result = new ArrayList<CommentEntry>();
                for (String uuid : guidList) {
                    try {
                        Node node = session.getNodeByIdentifier(uuid);
                        long nodeType = JCRIndexDataCommentsUtil.this.jcrUtils.getLongProperty(node, "sas:objectType");
                        ObjectType objectType = JCRIndexDataCommentsUtil.this.objectTypeService.getTypeById(nodeType);
                        result.add(new CommentEntry(uuid, objectType.getName()));
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                    }
                    catch (Exception exception) {}
                }
                return result;
            }
        });
        for (CommentEntry entry : result) {
            commentCache.addComment(entry.getObjectTypeName(), entry.getIdentity());
        }
    }
}

