/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.jcr;

import com.sas.svcs.comments.client.CommentServiceInterface;
import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.relationship.client.RelationshipService;
import com.sas.svcs.content.search.client.ContentSearchObject;
import com.sas.svcs.content.search.client.IndexDataAttribute;
import com.sas.svcs.content.search.client.IndexDataType;
import com.sas.svcs.content.search.retrieval.dao.CommentCache;
import com.sas.svcs.content.search.retrieval.dao.jcr.JCRIndexDataCommentsUtil;
import com.sas.svcs.content.search.retrieval.dao.jcr.JCRIndexDataSupportTemplate;
import com.sas.svcs.content.search.retrieval.dao.util.IndexDataRelationshipUtil;
import com.sas.svcs.content.search.spi.IndexDataSchemaDAO;
import com.sas.svcs.identity.client.IdentityInformationService;
import com.sas.svcs.identity.client.User;
import com.sas.svcs.notifications.client.AlertNotificationRetrievalServiceInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BaseJCRIndexDataDAO
implements IndexDataSchemaDAO {
    private static final long DEFAULT_USER_TIMEOUT = 1440L;
    public static final String VALUE_DELIMITER = ";";
    protected static SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.getDefault());
    protected static SimpleDateFormat ISO8601OUTPUT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
    CommentCache commentCache;
    protected JCRIndexDataSupportTemplate supportTemplate;
    protected JCRIndexDataCommentsUtil commentsUtil;
    protected IndexDataRelationshipUtil relationshipUtil;
    protected JcrTemplate template;
    protected JcrContentUtils contentUtils;
    protected ObjectTypeService objectTypeService;
    protected CommentServiceInterface commentService;
    protected RelationshipService relationshipService;
    protected LookupService lookupService;
    protected IdentityInformationService identityService;
    protected Map<String, String> userDisplayNameMap;
    protected Date userMapLoad;
    private static final String REFRESH_STRING = System.getProperty("WIP_INDEX_DATA_USER_REFRESH_MINUTES");

    public BaseJCRIndexDataDAO() {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        ISO8601OUTPUT.setTimeZone(gmt);
        this.commentCache = new CommentCache();
        this.supportTemplate = new JCRIndexDataSupportTemplate();
        this.commentsUtil = new JCRIndexDataCommentsUtil();
        this.relationshipUtil = new IndexDataRelationshipUtil();
        this.contentUtils = new JcrContentUtils();
        this.userDisplayNameMap = null;
    }

    @Autowired
    public void setIdentityInformationService(IdentityInformationService iisvc) {
        this.identityService = iisvc;
    }

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
        this.commentsUtil.setObjectTypeService(objectTypeService);
    }

    @Autowired
    public void setAlertNotificationRetrievalService(AlertNotificationRetrievalServiceInterface notificationRetrievalService) {
        this.commentsUtil.setAlertNotificationRetrievalService(notificationRetrievalService);
    }

    @Autowired
    public void setTemplate(JcrTemplate template) {
        this.template = template;
        this.commentsUtil.setTemplate(template);
    }

    @Autowired
    public void setCommentService(CommentServiceInterface commentService) {
        this.commentService = commentService;
        this.commentsUtil.setCommentService(commentService);
    }

    @Autowired
    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipUtil.setRelationshipService(relationshipService);
    }

    @Autowired
    public void setLookupService(LookupService lookupService) {
        this.relationshipUtil.setLookupService(lookupService);
    }

    public JcrTemplate getTemplate() {
        return this.template;
    }

    public Set<ContentSearchObject> getObjects(long objectType, Date modifiedSince, boolean doBrowse) {
        ArrayList<String> guidList = new ArrayList<String>();
        ObjectType theType = this.objectTypeService.getTypeById(objectType);
        if (modifiedSince != null) {
            this.commentCache = this.commentsUtil.getCommentCache(this.commentCache, modifiedSince);
            List entries = this.commentCache.getCommentsOfType(theType.getName());
            for (Iterator<Object> entry : entries) {
                guidList.add(entry.getIdentity());
            }
            Map relationshipMap = this.relationshipUtil.getRelationshipUpdates(modifiedSince, theType.getName());
            for (String ident : relationshipMap.keySet()) {
                guidList.add(ident);
            }
        }
        List<ContentObject> objectList = this.findAll(objectType, modifiedSince);
        ArrayList<String> gotGuids = new ArrayList<String>(objectList.size());
        for (ContentObject nextObject : objectList) {
            gotGuids.add(nextObject.getId());
        }
        for (String nextguid : guidList) {
            if (gotGuids.contains(nextguid)) continue;
            final long objectTypeId = theType.getId();
            final String objectTypeName = theType.getName();
            final String uuid = nextguid;
            ContentNode result = (ContentNode)this.getTemplate().execute((JcrCallback)new JcrCallback<ContentNode>(){

                public ContentNode doInJcr(Session session) throws RepositoryException {
                    ContentNode result = new ContentNode();
                    try {
                        Node node = session.getNodeByIdentifier(uuid);
                        BaseJCRIndexDataDAO.this.contentUtils.populateContentNodeFromJCRNode(result, node, objectTypeId, objectTypeName);
                    }
                    catch (ItemNotFoundException node) {
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                    return result;
                }
            });
            objectList.add((ContentObject)result);
        }
        guidList.clear();
        ArrayList<ObjectIdentity> identityList = new ArrayList<ObjectIdentity>(objectList.size());
        HashSet<ContentSearchObject> result = new HashSet<ContentSearchObject>();
        if (objectList != null && objectList.size() > 0) {
            this.loadUserMap();
            for (ContentObject cob : objectList) {
                identityList.add(new ObjectIdentity((Identifiable)cob));
                ContentSearchObject cso = this.makeSearchObjectFromContentObject(cob);
                result.add(cso);
                guidList.add(cso.getObjectIdentity().getId());
            }
        }
        List commentList = new ArrayList();
        if (guidList.size() > 0) {
            commentList = this.commentsUtil.getAllComments(guidList);
        }
        Map relationshipMap = this.relationshipUtil.getRelationshipData(identityList);
        for (ContentSearchObject nextObject : result) {
            Map relationships;
            Map attributes = nextObject.getAttributes();
            String guid = (String)attributes.get("sasid");
            if (guid != null) {
                this.commentsUtil.addComments(commentList, attributes);
            }
            if ((relationships = (Map)relationshipMap.get(guid)) == null) continue;
            attributes.putAll(relationships);
        }
        return result;
    }

    private ContentSearchObject makeSearchObjectFromContentObject(ContentObject cob) {
        String path;
        ContentSearchObject result = null;
        ObjectIdentity identity = new ObjectIdentity((Identifiable)cob);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("objecttype", "" + cob.getObjectType());
        attributeMap.put("sasid", cob.getId());
        attributeMap.put("guid", cob.getId());
        attributeMap.put("auth", cob.getId() + "/" + cob.getObjectType());
        attributeMap.put("authtype", "1");
        attributeMap.put("title", cob.getName());
        if (cob.getDescription() != null && cob.getDescription().length() > 0) {
            attributeMap.put("description", cob.getDescription());
        }
        attributeMap.put("sastype", cob.getObjectTypeName());
        attributeMap.put("creationdate", ISO8601OUTPUT.format(cob.getCreationDate()));
        attributeMap.put("modifieddate", ISO8601OUTPUT.format(cob.getModifiedDate()));
        attributeMap.put("creationdatelong", "" + cob.getCreationDate().getTime());
        attributeMap.put("modifieddatelong", "" + cob.getModifiedDate().getTime());
        attributeMap.put("createdby", cob.getCreatedBy());
        String createdByDisplay = this.getUserDisplayName(cob.getCreatedBy());
        if (createdByDisplay != null && createdByDisplay.length() > 0) {
            attributeMap.put("createdbydisplay", createdByDisplay);
        }
        attributeMap.put("lastmodifiedby", cob.getModifiedBy());
        String modifiedByDisplay = this.getUserDisplayName(cob.getModifiedBy());
        if (modifiedByDisplay != null && modifiedByDisplay.length() > 0) {
            attributeMap.put("lastmodifiedbydisplay", modifiedByDisplay);
        }
        if (cob instanceof ContentNode && (path = ((ContentNode)cob).getPath()) != null && path.length() > 0) {
            attributeMap.put("saspath", path);
        }
        result = new ContentSearchObject(identity, attributeMap);
        return result;
    }

    public List<ContentObject> findAll(long objectType, Date modifiedSince) {
        ArrayList<ContentObject> result = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("/jcr:root/sascontent//*[@sas:objectType='" + objectType + (modifiedSince == null ? "'" : "' and sas:lastModified >= xs:dateTime('" + ISO8601FORMAT.format(modifiedSince) + "')") + "]");
        final String statement = sb.toString();
        ObjectType fullType = this.objectTypeService.getTypeById(objectType);
        final String objectTypeName = fullType.getName();
        final long objectTypeId = objectType;
        result = (List)this.getTemplate().execute((JcrCallback)new JcrCallback<List<ContentObject>>(){

            public List<ContentObject> doInJcr(Session session) throws RepositoryException {
                String lang = "xpath";
                ArrayList<ContentObject> result = new ArrayList<ContentObject>();
                QueryManager manager = session.getWorkspace().getQueryManager();
                Query query = manager.createQuery(statement, lang);
                QueryResult qresult = query.execute();
                try {
                    NodeIterator nit = qresult.getNodes();
                    while (nit.hasNext()) {
                        Node node = nit.nextNode();
                        ContentNode nextPackage = new ContentNode();
                        BaseJCRIndexDataDAO.this.contentUtils.populateContentNodeFromJCRNode(nextPackage, node, objectTypeId, objectTypeName);
                        result.add((ContentObject)nextPackage);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                return result;
            }
        });
        return result;
    }

    public void addToStringBuilder(StringBuilder sb, String string) {
        if (sb.length() > 0) {
            sb.append(VALUE_DELIMITER);
        }
        sb.append(string);
    }

    private String getUserDisplayName(String userid) {
        String displayName = this.userDisplayNameMap.get(userid);
        return displayName;
    }

    private void loadUserMap() {
        if (this.userDisplayNameMap == null || this.isUserMapExpired()) {
            Set userSet = this.identityService.getAllUsers();
            this.userMapLoad = new Date();
            this.userDisplayNameMap = new HashMap<String, String>(userSet.size() * 2);
            for (User user : userSet) {
                this.userDisplayNameMap.put(user.getId(), user.getDisplayName());
            }
        }
    }

    private boolean isUserMapExpired() {
        if (this.userMapLoad == null) {
            return true;
        }
        Date now = new Date();
        long diff = now.getTime() - this.userMapLoad.getTime();
        long diffMinutes = diff / 60000L;
        long refreshTime = 1440L;
        if (REFRESH_STRING != null) {
            refreshTime = Long.valueOf(REFRESH_STRING);
        }
        return diffMinutes > refreshTime;
    }

    public final List<IndexDataAttribute> getFieldMetadataForType(long type) {
        ArrayList<IndexDataAttribute> result = new ArrayList<IndexDataAttribute>();
        result.add(new IndexDataAttribute("auth", false, IndexDataType.STRING, "Authentication Id"));
        result.add(new IndexDataAttribute("authtype", false, IndexDataType.STRING, "Authentication Type"));
        result.add(new IndexDataAttribute("commentssubject", false, IndexDataType.STRINGLIST, "Comment Subject"));
        result.add(new IndexDataAttribute("commentscontent", false, IndexDataType.STRINGLIST, "Comment Content"));
        result.add(new IndexDataAttribute("createdby", true, IndexDataType.STRING, "Created By"));
        result.add(new IndexDataAttribute("createdbydisplay", true, IndexDataType.STRING, "Created By Display"));
        result.add(new IndexDataAttribute("creationdate", false, IndexDataType.STRING, "Creation Date"));
        result.add(new IndexDataAttribute("creationdatelong", false, IndexDataType.NUMERIC, "Creation Date Long"));
        result.add(new IndexDataAttribute("description", false, IndexDataType.STRING, "Description"));
        result.add(new IndexDataAttribute("guid", false, IndexDataType.STRING, "Guid"));
        result.add(new IndexDataAttribute("sasid", false, IndexDataType.STRING, "SAS Object Id"));
        result.add(new IndexDataAttribute("keywords", false, IndexDataType.STRINGLIST, "Keywords"));
        result.add(new IndexDataAttribute("lastmodifiedby", true, IndexDataType.STRING, "Last Modified By"));
        result.add(new IndexDataAttribute("lastmodifiedbydisplay", true, IndexDataType.STRING, "Last Modified By Display"));
        result.add(new IndexDataAttribute("modifieddate", false, IndexDataType.STRING, "Modified Date"));
        result.add(new IndexDataAttribute("modifieddatelong", false, IndexDataType.NUMERIC, "Modified Date Long"));
        result.add(new IndexDataAttribute("title", false, IndexDataType.STRING, "Title"));
        result.add(new IndexDataAttribute("objecttype", false, IndexDataType.NUMERIC, "Object Type"));
        result.add(new IndexDataAttribute("sastype", true, IndexDataType.STRING, "SAS Type"));
        result.add(new IndexDataAttribute("saspath", false, IndexDataType.STRING, "SAS Path"));
        result.add(new IndexDataAttribute("relationship.parent.name", false, IndexDataType.STRING, "Parent Relationships"));
        result.add(new IndexDataAttribute("relationship.parent.id", false, IndexDataType.STRING, "Parent Ids"));
        result.add(new IndexDataAttribute("relationship.child.name", false, IndexDataType.STRING, "Child Relationships"));
        result.add(new IndexDataAttribute("relationship.child.id", false, IndexDataType.STRING, "Child Ids"));
        result.add(new IndexDataAttribute("relationship.depends.name", false, IndexDataType.STRING, "Depends Relationships"));
        result.add(new IndexDataAttribute("relationship.depends.id", false, IndexDataType.STRING, "Depends Ids"));
        result.add(new IndexDataAttribute("relationship.depended.name", false, IndexDataType.STRING, "Dependent Relationships"));
        result.add(new IndexDataAttribute("relationship.depended.id", false, IndexDataType.STRING, "Dependent Ids"));
        result.add(new IndexDataAttribute("relationship.includes.name", false, IndexDataType.STRING, "Includes Relationships"));
        result.add(new IndexDataAttribute("relationship.includes.id", false, IndexDataType.STRING, "Includes Ids"));
        result.add(new IndexDataAttribute("relationsip.included.name", false, IndexDataType.STRING, "Included relationships"));
        result.add(new IndexDataAttribute("relationship.included.id", false, IndexDataType.STRING, "Included Ids"));
        result.add(new IndexDataAttribute("relationship.associated.name", false, IndexDataType.STRING, "Associated Relationships"));
        result.add(new IndexDataAttribute("relationship.associated.id", false, IndexDataType.STRING, "Associated Ids"));
        result.add(new IndexDataAttribute("relationship.equivalent.name", false, IndexDataType.STRING, "Equivalent relationships"));
        result.add(new IndexDataAttribute("relationship.equivalent.id", false, IndexDataType.STRING, "Equivalent Ids"));
        result.add(new IndexDataAttribute("relationship.synonymous.name", false, IndexDataType.STRING, "Synonymous relationships"));
        result.add(new IndexDataAttribute("relationship.synonymous.id", false, IndexDataType.STRING, "Synonymous Ids"));
        return result;
    }
}

