/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.jcr;

import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import java.io.Serializable;

public class ExportAccessControl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PRINCIPAL_TYPE_USER = 1;
    public static final int PRINCIPAL_TYPE_GROUP = 2;
    public static final int PERMISSION_VALUE_UNSET = 0;
    public static final int PERMISSION_VALUE_GRANTED = 1;
    public static final int PERMISSION_VALUE_DENIED = 2;
    private String principalName;
    private int principalType;
    private int administrationPermission;
    private int createPermission;
    private int deletePermission;
    private int readPermission;
    private int writePermission;

    public ExportAccessControl() {
    }

    public ExportAccessControl(AccessControlEntry ace) {
        this.principalName = ace.getPrincipal().getName();
        this.principalType = ace.getPrincipal().getType() == AuthorizationPrincipal.PrincipalType.User ? 1 : 2;
        this.readPermission = ExportAccessControl.getPermissionValue(ace.getReadPermission());
        this.writePermission = ExportAccessControl.getPermissionValue(ace.getWritePermission());
        this.deletePermission = ExportAccessControl.getPermissionValue(ace.getDeletePermission());
        this.administrationPermission = ExportAccessControl.getPermissionValue(ace.getAdministrationPermission());
        this.createPermission = ExportAccessControl.getPermissionValue(ace.getCreatePermission());
    }

    public AccessControlEntry getAce() {
        AccessControlEntry result = new AccessControlEntry();
        result.setPrincipal(new AuthorizationPrincipal(this.principalName, this.principalType == 1 ? AuthorizationPrincipal.PrincipalType.User : AuthorizationPrincipal.PrincipalType.Group));
        result.setAdministrationPermission(ExportAccessControl.getAceValue(this.administrationPermission));
        result.setCreatePermission(ExportAccessControl.getAceValue(this.createPermission));
        result.setDeletePermission(ExportAccessControl.getAceValue(this.deletePermission));
        result.setReadPermission(ExportAccessControl.getAceValue(this.readPermission));
        result.setWritePermission(ExportAccessControl.getAceValue(this.writePermission));
        return result;
    }

    public static AccessControlEntry.PermissionValue getAceValue(int value) {
        if (value == 1) {
            return AccessControlEntry.PermissionValue.GRANTED;
        }
        if (value == 2) {
            return AccessControlEntry.PermissionValue.DENIED;
        }
        return AccessControlEntry.PermissionValue.UNSET;
    }

    public static int getPermissionValue(AccessControlEntry.PermissionValue value) {
        if (value == AccessControlEntry.PermissionValue.DENIED) {
            return 2;
        }
        if (value == AccessControlEntry.PermissionValue.GRANTED) {
            return 1;
        }
        if (value == AccessControlEntry.PermissionValue.UNSET) {
            return 0;
        }
        return -1;
    }

    public final String getPrincipalName() {
        return this.principalName;
    }

    public final void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public final int getPrincipalType() {
        return this.principalType;
    }

    public final void setPrincipalType(int principalType) {
        this.principalType = principalType;
    }

    public final int getReadPermission() {
        return this.readPermission;
    }

    public final void setReadPermission(int readPermission) {
        this.readPermission = readPermission;
    }

    public final int getWritePermission() {
        return this.writePermission;
    }

    public final void setWritePermission(int writePermission) {
        this.writePermission = writePermission;
    }

    public final int getDeletePermission() {
        return this.deletePermission;
    }

    public final void setDeletePermission(int deletePermission) {
        this.deletePermission = deletePermission;
    }

    public final int getAdministrationPermission() {
        return this.administrationPermission;
    }

    public final void setAdministrationPermission(int administrationPermission) {
        this.administrationPermission = administrationPermission;
    }

    public final int getCreatePermission() {
        return this.createPermission;
    }

    public final void setCreatePermission(int createPermission) {
        this.createPermission = createPermission;
    }
}

