/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.jcr;

import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.acl.client.AclService;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.folder.client.Folder;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.client.ImportOperation;
import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.ImportDAO;
import com.sas.svcs.content.lifecycle.dao.jcr.AbstractJcrPromotionDAO;
import com.sas.svcs.content.lifecycle.dao.jcr.BaseJcrExportDAO;
import com.sas.svcs.content.lifecycle.dao.jcr.ExportAccessControlList;
import com.sas.svcs.content.lifecycle.spi.ImportResult;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.xml.sax.EntityResolver;

public abstract class BaseJcrImportDAO
extends AbstractJcrPromotionDAO
implements ImportDAO {
    protected FolderService folderService;
    protected XMLContext xmlContext = new XMLContext();
    protected Class<? extends ContentObject> unmarshallerClass;
    private AclService aclService;

    @Autowired
    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    @Autowired
    public void setFolderService(@Qualifier(value="folderContentService") FolderService folderService) {
        this.folderService = folderService;
    }

    public void validateContents(List<ImportNode> nodes, ImportOperation operation) {
    }

    public ImportResult importObjects(List<ImportNode> importList, ImportOperation importOperation) throws ContentException {
        ImportResult result = new ImportResult();
        ContainerNode container = importOperation.getTargetContainer();
        ObjectIdentity folderIdentity = new ObjectIdentity((Identifiable)container.getContentObject());
        Folder folder = this.folderService.getFolderById(folderIdentity);
        Folder parentFolder = null;
        String packageId = importOperation.getPackageId();
        ExportPackage exportPackage = this.exportPackageService.getPackageById(new ObjectIdentity(159L, packageId));
        ExportTypeSubpackage subpackage = this.getSubpackage(exportPackage, this.packageType);
        ContentItem transportItem = this.getContentItemFromPackage(subpackage, "TransportMetadata");
        if (transportItem == null) {
            throw new RuntimeException("No transport data was found in export package.");
        }
        String transportString = this.getContentString(transportItem);
        HashMap<String, Folder> folderMap = new HashMap<String, Folder>();
        Map<String, String> transportMap = this.makeTransportMap(transportString, this.mappingTypeName);
        Mapping mapping = new Mapping();
        mapping.setEntityResolver((EntityResolver)this.customResolver);
        URL mappingURL = BaseJcrExportDAO.class.getResource(this.mappingFile);
        try {
            mapping.loadMapping(mappingURL);
        }
        catch (MappingException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
        try {
            for (ImportNode nextNode : importList) {
                ContentItem contentItem;
                AccessControlList acl;
                ConnectionPoint parentConnection;
                String parentId;
                if (nextNode.getTransportState().isStateSet(1)) continue;
                ImportNode importNode = this.getNodeFromOperation(nextNode, importOperation);
                List cpList = importNode.getConnectionPoints();
                if (cpList != null && cpList.size() > 0 && (parentId = (parentConnection = (ConnectionPoint)cpList.get(0)).getTargetId()) != null && (parentFolder = (Folder)folderMap.get(parentId)) == null) {
                    ObjectIdentity parentIdentity = new ObjectIdentity(79L, parentId);
                    parentFolder = this.folderService.getFolderById(parentIdentity);
                    if (parentFolder == null) {
                        parentFolder = folder;
                    } else {
                        folderMap.put(parentFolder.getId(), parentFolder);
                    }
                }
                if (parentFolder == null) {
                    parentFolder = folder;
                }
                String objectId = nextNode.getId();
                String transportXML = transportMap.get(objectId);
                StringReader reader = new StringReader(transportXML);
                Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
                unmarshaller.setClass(this.unmarshallerClass);
                unmarshaller.setMapping(mapping);
                ContentObject node = (ContentObject)unmarshaller.unmarshal((Reader)reader);
                String path = parentFolder.getPath() + "/" + nextNode.getName();
                ContentObject existingNode = this.getComponentByPath(path);
                if (existingNode == null) {
                    node = this.createObject(parentFolder, node);
                } else {
                    this.updateFromExistingNode(existingNode, node);
                    node = existingNode;
                }
                ContentItem aclItem = this.getAccessControls(subpackage, objectId);
                ObjectIdentity nodeIdentity = new ObjectIdentity((Identifiable)node);
                if (aclItem != null && (acl = this.makeAccessControls(aclItem)) != null) {
                    try {
                        if (this.aclService.aclExists(nodeIdentity)) {
                            AccessControlList theAcl = this.aclService.getAcl(nodeIdentity);
                            theAcl.getAces().addAll(acl.getAces());
                            this.aclService.updateAcl(nodeIdentity, theAcl);
                        } else {
                            this.aclService.createAcl(nodeIdentity, acl);
                        }
                    }
                    catch (Exception ex) {
                        this.logMessage((TransportOperation<?>)importOperation, 200, "Error creating access controls.", ex);
                    }
                }
                if ((contentItem = this.getContentItemFromPackage(subpackage, objectId)) != null) {
                    this.importContent(node, contentItem);
                }
                ContentObject co = new ContentObject();
                co.setName(node.getName());
                co.setDescription(node.getDescription());
                co.setId(node.getId());
                co.setObjectType(node.getObjectType());
                co.setObjectTypeName(node.getObjectTypeName());
                ImportNode newNode = new ImportNode();
                newNode.setConnectionPoints(nextNode.getConnectionPoints());
                newNode.setContainer(nextNode.getContainer());
                newNode.setContentObject((ContentComponent)co);
                newNode.setId(node.getId());
                newNode.setModelPath(nextNode.getModelPath());
                newNode.setObjectType(node.getObjectType());
                newNode.setProcessingState(NodeProcessingState.SUCCESS);
                newNode.setTargetId(node.getId());
                newNode.setTargetPath(nextNode.getTargetPath());
                newNode.setTransportState(nextNode.getTransportState());
                result.addImportNode(newNode);
            }
            return result;
        }
        catch (MappingException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
        catch (MarshalException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
        catch (ValidationException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected ContentObject updateFromExistingNode(ContentObject existingNode, ContentObject node) {
        return existingNode;
    }

    protected abstract ContentObject getComponentByPath(String var1);

    private ImportNode getNodeFromOperation(ImportNode node, ImportOperation importOperation) {
        List nodeList = importOperation.getImportNodes();
        String id = node.getId();
        for (ImportNode nextNode : nodeList) {
            if (!id.equals(nextNode.getId())) continue;
            return nextNode;
        }
        return null;
    }

    protected void importContent(ContentObject node, ContentItem contentItem) throws ContentException {
    }

    protected abstract ContentObject createObject(Folder var1, ContentObject var2) throws ContentException;

    protected AccessControlList makeAccessControls(ContentItem item) throws ContentException {
        AccessControlList result = null;
        if (item == null) {
            return null;
        }
        String sourceXML = this.getContentString(item);
        List<String> aclSections = this.makeAclSegments(sourceXML);
        sourceXML = aclSections.get(0);
        Mapping mapping = new Mapping();
        mapping.setEntityResolver((EntityResolver)this.customResolver);
        URL mappingURL = BaseJcrExportDAO.class.getResource("/com/sas/svcs/content/lifecycle/dao/jcr/ExportAccessControlMapping.xml");
        try {
            mapping.loadMapping(mappingURL);
            Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
            unmarshaller.setClass(ExportAccessControlList.class);
            unmarshaller.setMapping(mapping);
            StringReader reader = new StringReader(sourceXML);
            ExportAccessControlList acl = (ExportAccessControlList)unmarshaller.unmarshal((Reader)reader);
            result = acl.getAccessControlList();
            return result;
        }
        catch (MappingException ex) {
            throw new ContentException(ex.getMessage());
        }
        catch (ValidationException ex) {
            throw new ContentException(ex.getMessage());
        }
        catch (MarshalException ex) {
            throw new ContentException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getContentString(ContentItem item) throws ContentException {
        String result = null;
        ObjectIdentity identity = new ObjectIdentity((Identifiable)item);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.streamService.getStreamContents(identity, (OutputStream)outputStream);
            result = new String(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw new ContentException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    protected List<String> makeAclSegments(String xmlString) {
        int index2;
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        String startString = "<export-access-control-list";
        String endString = "</export-access-control-list>";
        while (index < xmlString.length() && (index2 = xmlString.indexOf(startString, index)) > -1) {
            int index3 = xmlString.indexOf(endString, index2);
            if (index3 > -1) {
                String nextObject = xmlString.substring(index2, index3 + endString.length());
                result.add(nextObject);
            }
            index = index3;
        }
        return result;
    }

    protected Map<String, String> makeTransportMap(String xmlString, String typeName) {
        int index2;
        HashMap<String, String> result = new HashMap<String, String>();
        int index = 0;
        String startString = "<" + typeName;
        while (index < xmlString.length() && (index2 = xmlString.indexOf(startString, index)) > -1) {
            String nextObject;
            int index4;
            int index3 = this.findElementEnd(xmlString, index2, typeName);
            if (index3 > -1 && (index4 = (nextObject = xmlString.substring(index2, index3)).indexOf("identifier=")) > -1) {
                int index5 = nextObject.indexOf("\"", index4 + 12);
                String identifier = nextObject.substring(index4 + 12, index5);
                result.put(identifier, nextObject);
            }
            index = index3;
        }
        return result;
    }

    protected int findElementEnd(String xmlString, int startIndex, String typeName) {
        boolean found_end = false;
        int index = startIndex;
        char anteTerm = xmlString.charAt(index++);
        char term = xmlString.charAt(index++);
        while (term != '>' && index < xmlString.length()) {
            anteTerm = term;
            term = xmlString.charAt(index++);
        }
        if (term == '>') {
            found_end = true;
        }
        if (anteTerm != '/') {
            index = xmlString.indexOf("</" + typeName + ">", startIndex);
            if (index == -1) {
                return index;
            }
            index = index + typeName.length() + 3;
        }
        if (!found_end) {
            return -1;
        }
        return index;
    }

    protected final ContentItem getAccessControls(ExportTypeSubpackage subpackage, String name) {
        List contentItems = subpackage.getContentItems();
        String aclContentItemName = name + "-AccessControl";
        return this.getContentItemFromPackage(contentItems, aclContentItemName);
    }
}

