/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.jcr;

import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authorization.acl.client.AccessControlEntry;
import com.sas.svcs.authorization.acl.client.AccessControlList;
import com.sas.svcs.authorization.acl.client.AclService;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.common.client.dao.jcr.JcrContentUtils;
import com.sas.svcs.common.client.dao.omr.UserSessionContextProvider;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.commons.springextensions.jcr.JcrCallback;
import com.sas.svcs.content.commons.springextensions.jcr.JcrTemplate;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.lifecycle.client.CopyNode;
import com.sas.svcs.content.lifecycle.client.CopyOperation;
import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.dao.AbstractOperationDAO;
import com.sas.svcs.content.lifecycle.dao.CopyDAO;
import com.sas.svcs.content.lifecycle.dao.NameValidator;
import com.sas.svcs.content.lifecycle.spi.CopyResult;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BaseJCRCopyDAO
extends AbstractOperationDAO
implements CopyDAO {
    protected JcrTemplate template;
    protected JcrContentUtils jcrUtils = new JcrContentUtils();
    protected UserSessionContextProvider contextProvider = null;
    protected AclService aclService = null;
    protected NavigationService navService = null;

    @Autowired
    public void setAclService(AclService aclService) {
        this.aclService = aclService;
    }

    @Autowired
    public void setNavigationService(@Qualifier(value="navigationContentService") NavigationService navigationService) {
        this.navService = navigationService;
    }

    @Autowired
    public void setTemplate(JcrTemplate template) {
        this.template = template;
    }

    @Autowired
    public void setSessionContextProvider(@Qualifier(value="userSessionProvider") UserSessionContextProvider provider) {
        this.contextProvider = provider;
    }

    protected JcrTemplate getTemplate() {
        return this.template;
    }

    protected JcrContentUtils getJcrContentUtils() {
        return this.jcrUtils;
    }

    public boolean isCopyAllowed(CopyNode node, CopyOperation operation) throws ContentException {
        return true;
    }

    public CopyResult copyObject(CopyNode node, CopyOperation operation) throws ContentException {
        String srcPath = ((ContentNode)node.getContentObject()).getPath();
        String fullTargetPath = node.getTargetPath();
        int index = fullTargetPath.lastIndexOf("/");
        String parentPath = fullTargetPath.substring(0, index);
        String targetPath = fullTargetPath.substring(0, index) + "/" + node.getName();
        NavigationNode parentNavNode = this.navService.getObjectByPath(parentPath, 79L);
        ObjectIdentity parentIdentity = new ObjectIdentity((Identifiable)parentNavNode.getContentObject());
        this.preCopyProcess(node, operation);
        this.template.copy(srcPath, targetPath);
        final String finalPath = targetPath;
        ContentObject jcrNode = (ContentObject)this.getTemplate().execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Node node = BaseJCRCopyDAO.this.jcrUtils.getNodeByPath(finalPath, session);
                ContentObject cob = new ContentObject();
                cob.setId(node.getUUID());
                cob.setObjectType(node.getProperty("sas:objectType").getLong());
                return cob;
            }
        });
        try {
            UserContextInterface userContext = this.contextProvider.getUserContext();
            String userName = userContext.getName();
            userName.trim();
            ObjectIdentity identity = new ObjectIdentity((Identifiable)jcrNode);
            node.setTargetId(identity.getId());
            AccessControlList acl = null;
            ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
            AuthorizationPrincipal principal = new AuthorizationPrincipal(userName, AuthorizationPrincipal.PrincipalType.User);
            entries.add(new AccessControlEntry(principal, AccessControlEntry.PermissionValue.GRANTED, AccessControlEntry.PermissionValue.GRANTED, AccessControlEntry.PermissionValue.GRANTED, AccessControlEntry.PermissionValue.GRANTED, AccessControlEntry.PermissionValue.GRANTED));
            if (!this.aclService.aclExists(identity)) {
                acl = new AccessControlList(entries, principal, parentIdentity, false);
                this.aclService.createAcl(identity, acl);
            } else {
                acl = this.aclService.getAcl(identity);
                acl.getAces().addAll(entries);
                this.aclService.updateAcl(identity, acl);
            }
            this.copyAcls((Identifiable)jcrNode, (Identifiable)node);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        this.postCopyProcess(node, operation);
        this.copyContent(node, operation);
        node.setProcessingState(NodeProcessingState.SUCCESS);
        node.setTargetPath(targetPath);
        CopyResult result = new CopyResult();
        result.setCopyNode(node);
        return result;
    }

    protected NameValidator getNameValidator() {
        return null;
    }

    protected void preCopyProcess(CopyNode node, CopyOperation operation) throws ContentException {
    }

    protected void postCopyProcess(CopyNode nodes, CopyOperation operation) throws ContentException {
    }

    protected void copyContent(CopyNode node, CopyOperation operation) {
    }

    protected void copyAcls(Identifiable newFolder, Identifiable oldFolder) {
        AccessControlList oldAcl = this.aclService.getAcl(new ObjectIdentity(oldFolder));
        AccessControlList newAcl = this.aclService.getAcl(new ObjectIdentity(newFolder));
        List oldEntries = oldAcl.getAces();
        List newEntries = newAcl.getAces();
        boolean isUpdated = false;
        for (AccessControlEntry nextEntry : oldEntries) {
            boolean gotPrincipal = false;
            String principalName = nextEntry.getPrincipal().getName();
            for (AccessControlEntry newEntry : newEntries) {
                if (!newEntry.getPrincipal().getName().equals(principalName)) continue;
                gotPrincipal = true;
            }
            if (gotPrincipal) continue;
            newEntries.add(nextEntry);
            isUpdated = true;
        }
        if (isUpdated) {
            this.aclService.updateAcl(new ObjectIdentity(newFolder), newAcl);
        }
    }
}

