/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.Container;
import com.sas.awt.TextArea;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Permuter;
import com.sas.util.Countable;
import com.sas.util.EventGateInterface;
import com.sas.util.IndexedSetInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.SpinButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class UpDownTextArea
extends Container
implements AdjustmentListener,
ContentsChangedListener {
    private static final String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    protected TextArea items;
    protected SpinButton reorder;

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public TextArea getTextArea() {
        return this.items;
    }

    public SpinButton getSpinButton() {
        return this.reorder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object eSource = e.getSource();
        String propName = e.getPropertyName();
        if (eSource == this.items && propName.equals("caretRow")) {
            this.synchronizeButtons();
        }
        if (propName.equals("rows") || propName.equals("editable") || propName.equals("columns") || propName.equals("caretRow")) {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        } else if (eSource == this.items) {
            this.firePropertyChange("textArea", null, this.items);
        } else if (eSource == this.reorder) {
            this.firePropertyChange("textArea", null, this.reorder);
        }
    }

    public void contentsChanged(ContentsChangedEvent e) {
        this.synchronizeButtons();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.reorder) {
            int type = e.getAdjustmentType();
            if (type == 2) {
                this.moveSelection(-1);
            } else if (type == 1) {
                this.moveSelection(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveSelection(int offset) {
        ModelInterface model = this.getModelInterface();
        OrderedCollectionInterface ociModel = (OrderedCollectionInterface)model;
        int selectedIndex = this.items.getCaretRow();
        if (selectedIndex >= 0 && selectedIndex < ociModel.count()) {
            try {
                EventGateInterface gate = null;
                try {
                    if (ociModel instanceof EventGateInterface) {
                        gate = (EventGateInterface)ociModel;
                        gate.disableEvents();
                    }
                    Permuter.move((IndexedSetInterface)ociModel, (int)selectedIndex, (int)offset);
                }
                finally {
                    if (gate != null) {
                        gate.enableEvents();
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.synchronizeButtons();
    }

    public void synchronizeButtons() {
        Countable model = (Countable)this.getModelInterface();
        int selectedIndex = this.items.getCaretRow();
        boolean decrementEnabled = true;
        boolean incrementEnabled = true;
        if (selectedIndex == 0) {
            decrementEnabled = false;
        }
        if (selectedIndex == model.count() - 1) {
            incrementEnabled = false;
        }
        if (selectedIndex == -1 || selectedIndex > model.count() - 1) {
            decrementEnabled = false;
            incrementEnabled = false;
        }
        this.reorder.setIncrementEnabled(incrementEnabled);
        this.reorder.setDecrementEnabled(decrementEnabled);
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        this.items.detachModel(model);
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        this.items.attachModel(model);
        this.synchronizeButtons();
    }

    public int getCaretRow() {
        return this.items.getCaretRow();
    }

    public boolean isEditable() {
        return this.items.isEditable();
    }

    public void setEditable(boolean e) {
        this.items.setEditable(e);
    }

    public int getColumns() {
        return this.items.getColumns();
    }

    public void setColumns(int col) {
        this.items.setColumns(col);
    }

    public int getRows() {
        return this.items.getRows();
    }

    public void setRows(int r) {
        this.items.setRows(r);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 0, 0, true, true, true);
        layout.setRemainderRow(1);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        Container spinButtonContainer = new Container();
        this.items = new TextArea();
        this.reorder = new SpinButton();
        spinButtonContainer.initialize();
        this.items.initialize();
        this.reorder.initialize();
        this.items.setSelectRowText(true);
        spinButtonContainer.setLayout(new BorderLayout());
        this.reorder.setOrientation(1);
        this.reorder.swapButtonFunction();
        this.reorder.setMinimum(Integer.MIN_VALUE);
        this.reorder.setMaximum(Integer.MAX_VALUE);
        this.reorder.addAdjustmentListener(this);
        spinButtonContainer.add((Component)this.reorder, "South");
        this.reorder.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.items.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.add(this.items);
        this.add(spinButtonContainer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        throw new IOException();
    }
}

