/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

class TreeLine {
    public int x1;
    public int x2;
    public int y1;
    public int y2;
    public TreeLine bisectee;

    public TreeLine() {
    }

    public TreeLine(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void merge(TreeLine line) {
        if (this.sameXCoordinates(line)) {
            if (!this.yOverlaps(line)) throw new IllegalArgumentException("lines can't be merged");
            this.y1 = Math.min(this.y1, line.y1);
            this.y2 = Math.max(this.y2, line.y2);
            return;
        } else {
            if (!this.sameYCoordinates(line)) throw new IllegalArgumentException("lines can't be merged");
            if (!this.xOverlaps(line)) throw new IllegalArgumentException("lines can't be merged");
            this.x1 = Math.min(this.x1, line.x1);
            this.x2 = Math.max(this.x2, line.x2);
        }
    }

    public final boolean sameXCoordinates(TreeLine line) {
        return line.x1 == this.x1 && line.x2 == this.x2;
    }

    public final boolean sameYCoordinates(TreeLine line) {
        return line.y1 == this.y1 && line.y2 == this.y2;
    }

    public final boolean yOverlaps(TreeLine line) {
        return line.y1 >= this.y1 && line.y1 <= this.y2 + 1 || line.y2 >= this.y1 - 1 && line.y2 <= this.y2 || line.y1 < this.y1 && line.y2 > this.y2;
    }

    public final boolean xOverlaps(TreeLine line) {
        return line.x1 >= this.x1 && line.x1 <= this.x2 + 1 || line.x2 >= this.x1 - 1 && line.x2 <= this.x2 || line.x1 < this.x1 && line.x2 > this.x2;
    }

    public final boolean doesLineConnect(TreeLine line) {
        if (this.sameXCoordinates(line)) {
            return this.yOverlaps(line);
        }
        if (this.sameYCoordinates(line)) {
            return this.xOverlaps(line);
        }
        return false;
    }

    public boolean contains(TreeLine line) {
        if (this.sameXCoordinates(line)) {
            return line.y1 >= this.y1 && line.y2 <= this.y2;
        }
        if (this.sameYCoordinates(line)) {
            return line.x1 >= this.x1 && line.x2 <= this.x2;
        }
        return false;
    }

    public boolean bisects(TreeLine line) {
        if (this.x1 == this.x2 && line.x1 != line.x2 && (line.x1 == this.x1 || line.x2 == this.x1)) {
            return true;
        }
        return this.y1 == this.y2 && line.y1 != line.y2 && (line.y1 == this.y1 || line.y2 == this.y1);
    }

    public TreeLine[] split(TreeLine line) {
        if (!this.contains(line)) {
            return new TreeLine[2];
        }
        TreeLine[] ret = new TreeLine[2];
        if (this.sameXCoordinates(line)) {
            if (line.y1 > this.y1) {
                ret[0] = new TreeLine(this.x1, this.y1, this.x2, line.y1 - 1);
            }
            if (line.y2 < this.y2) {
                ret[1] = new TreeLine(this.x1, line.y2 + 1, this.x2, this.y2);
            }
        } else {
            if (line.x1 > this.x1) {
                ret[0] = new TreeLine(this.x1, this.y1, line.x1 - 1, this.y2);
            }
            if (line.x2 < this.x2) {
                ret[1] = new TreeLine(line.x2 + 1, this.y1, this.x2, this.y2);
            }
        }
        return ret;
    }

    public String toString() {
        return "x1: " + this.x1 + " y1: " + this.y1 + " x2: " + this.x2 + " y2: " + this.y2;
    }
}

