/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ToolbarLayout
implements LayoutManager,
Serializable {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected int orientation = 1;
    protected boolean wrapped = false;
    protected int gap = 1;
    protected Vector components = new Vector();

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public int elementCount() {
        return this.components.size();
    }

    public Enumeration elements() {
        return this.components.elements();
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public Component add(Component comp) {
        int index = this.components.size();
        this.addLayoutComponent("" + index, comp);
        return comp;
    }

    public void add(int space) {
        int index = this.components.size();
        this.insert(space, index);
    }

    public void add(int space, int pos) {
        this.components.insertElementAt(new Integer(space), pos);
        try {
            this.components.insertElementAt(new Integer(space), pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.components.addElement(new Integer(space));
        }
    }

    public void insert(int space, int pos) {
        this.add(space, pos);
    }

    public Component add(Component comp, int pos) {
        this.addLayoutComponent("" + pos, comp);
        return comp;
    }

    public void remove(Component comp) {
        this.removeLayoutComponent(comp);
    }

    public void remove(int space, int pos) {
        try {
            Object element = this.components.elementAt(pos);
            if (element instanceof Integer && (Integer)element == space) {
                this.components.removeElementAt(pos);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int index = this.components.size();
            try {
                index = new Integer(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.components.insertElementAt(comp, index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutContainer(parent, this.orientation, this.wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension();
            dim = this.orientation == 0 ? this.minimumVerticalLayoutSize(parent) : this.minimumHorizontalLayoutSize(parent);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension();
            dim = this.orientation == 0 ? this.preferredVerticalLayoutSize(-1, -1) : this.preferredHorizontalLayoutSize(-1, -1);
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            try {
                this.components.removeElement(comp);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected Dimension preferredVerticalLayoutSize(int start, int end) {
        Dimension dim = new Dimension();
        int count = 0;
        try {
            count = this.components.size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        start = start < 0 || start > end || start > count ? 0 : start;
        end = end < 0 || end > count || end < start ? count : end;
        for (int i = start; i < end; ++i) {
            Dimension size;
            Object object = this.components.elementAt(i);
            if (object instanceof Integer) {
                size = new Dimension(0, (Integer)object);
            } else if (object instanceof Component) {
                size = ((Component)object).getPreferredSize();
                dim.width = Math.max(size.width, dim.width);
            } else {
                size = new Dimension(0, 0);
            }
            dim.height += size.height;
        }
        dim.height += (end - start - 1) * this.gap;
        return dim;
    }

    protected Dimension preferredHorizontalLayoutSize(int start, int end) {
        Dimension dim = new Dimension();
        int count = 0;
        try {
            count = this.components.size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        start = start < 0 || start > end || start > count ? 0 : start;
        end = end < 0 || end > count || end < start ? count : end;
        for (int i = start; i < end; ++i) {
            Dimension size;
            Object object = this.components.elementAt(i);
            if (object instanceof Integer) {
                size = new Dimension((Integer)object, 0);
            } else if (object instanceof Component) {
                size = ((Component)object).getPreferredSize();
                dim.height = Math.max(size.height, dim.height);
            } else {
                size = new Dimension(0, 0);
            }
            dim.width += size.width;
        }
        dim.width += (end - start - 1) * this.gap;
        return dim;
    }

    public Dimension minimumVerticalLayoutSize(Container parent) {
        return new Dimension(parent.getSize());
    }

    public Dimension minimumHorizontalLayoutSize(Container parent) {
        return new Dimension(parent.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent, int orientation, boolean wrapped) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Rectangle rectangle = new Rectangle(new Point(), parent.getSize());
            Insets insets = parent.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            if (wrapped) {
                this.layoutContainerWrapped(rectangle);
            } else if (orientation == 0) {
                this.layoutContainerVertical(rectangle, -1, -1);
            } else {
                this.layoutContainerHorizontal(rectangle, -1, -1);
            }
        }
    }

    protected void layoutContainerWrapped(Rectangle parent) {
        int start = 0;
        int count = 0;
        Rectangle line = new Rectangle();
        boolean laidout = false;
        try {
            count = this.components.size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int end = count;
        line.x = parent.x;
        line.y = parent.y;
        if (this.orientation == 0) {
            while (!laidout) {
                Dimension size = this.preferredVerticalLayoutSize(start, end);
                while (size.height > parent.height) {
                    size = this.preferredVerticalLayoutSize(start, --end);
                    if (end != start) continue;
                    size = this.preferredVerticalLayoutSize(start, ++end);
                    break;
                }
                line.width = size.width;
                line.height = size.height;
                this.layoutContainerVertical(line, start, end);
                line.x += size.width + this.gap;
                laidout = end >= count;
                start = end;
                end = count;
            }
        } else {
            while (!laidout) {
                Dimension size = this.preferredHorizontalLayoutSize(start, end);
                while (size.width > parent.width) {
                    size = this.preferredHorizontalLayoutSize(start, --end);
                    if (end != start) continue;
                    size = this.preferredVerticalLayoutSize(start, ++end);
                    break;
                }
                line.width = size.width;
                line.height = size.height;
                this.layoutContainerHorizontal(line, start, end);
                laidout = end >= count;
                line.y += size.height + this.gap;
                start = end;
                end = count;
            }
        }
    }

    protected void layoutContainerVertical(Rectangle parent, int start, int end) {
        Point point = new Point(parent.x, parent.y);
        int count = 0;
        try {
            count = this.components.size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        start = start < 0 || start > end || start > count ? 0 : start;
        end = end < 0 || end > count || end < start ? count : end;
        for (int i = start; i < end; ++i) {
            Dimension size;
            Object object = this.components.elementAt(i);
            if (object instanceof Integer) {
                size = new Dimension(0, (Integer)object);
            } else if (object instanceof Component && ((Component)object).isVisible()) {
                size = ((Component)object).getPreferredSize();
                ((Component)object).setBounds(point.x + (parent.width - size.width) / 2, point.y, size.width, size.height);
            } else {
                size = new Dimension(0, 0);
            }
            point.y += size.height + this.gap;
        }
    }

    protected void layoutContainerHorizontal(Rectangle parent, int start, int end) {
        Point point = new Point(parent.x, parent.y);
        int count = 0;
        try {
            count = this.components.size();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        start = start < 0 || start > end || start > count ? 0 : start;
        end = end < 0 || end > count || end < start ? count : end;
        for (int i = start; i < end; ++i) {
            Dimension size;
            Object object = this.components.elementAt(i);
            if (object instanceof Integer) {
                size = new Dimension((Integer)object, 0);
            } else if (object instanceof Component && ((Component)object).isVisible()) {
                size = ((Component)object).getPreferredSize();
                ((Component)object).setBounds(point.x, point.y + (parent.height - size.height) / 2, size.width, size.height);
            } else {
                size = new Dimension(0, 0);
            }
            point.x += size.width + this.gap;
        }
    }
}

