/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.collection.OrderedCollectionInterface;
import com.sas.visuals.StyledLabelView;
import com.sas.visuals.TextElement;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class TextPositionMouseAdapter
implements MouseListener {
    transient StyledLabelView labelView;
    transient boolean pressed;
    transient boolean rollover;
    transient ActionEvent actionEvent;

    public TextPositionMouseAdapter(StyledLabelView label) {
        this.labelView = label;
        this.actionEvent = null;
        this.pressed = false;
        this.rollover = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point clickPt = e.getPoint();
        TextElement textElements = this.labelView.getTextElement();
        if (!textElements.isSubElementsSet()) {
            return;
        }
        Insets insets = this.labelView.getInsets();
        Dimension size = this.labelView.getSize();
        Point initPoint = this.labelView.getInitialPoint(insets.left, insets.top, size.width, size.height);
        int linePos = 0;
        OrderedCollectionInterface lineElements = textElements.getSubElements();
        for (int i = 0; i < lineElements.count(); ++i) {
            TextElement lineElement = (TextElement)((Object)lineElements.get(i));
            Point lineLocation = lineElement.getDisplayLocation();
            Dimension lineSize = lineElement.getDisplaySize();
            Point linePoint = new Point();
            linePoint.x = lineLocation.x + initPoint.x;
            linePoint.y = linePos + initPoint.y;
            Rectangle lineRectangle = new Rectangle(linePoint, lineSize);
            if (lineRectangle.contains(clickPt)) {
                if (!lineElement.isSubElementsSet()) {
                    return;
                }
                OrderedCollectionInterface objectElements = lineElement.getSubElements();
                for (int j = 0; j < objectElements.count(); ++j) {
                    TextElement objectElement = (TextElement)((Object)objectElements.get(j));
                    int objectX = objectElement.getDisplayLocation().x + initPoint.x;
                    int objectWidth = objectElement.getDisplaySize().width;
                    if (clickPt.x >= objectX + objectWidth || clickPt.x < objectX) continue;
                    if (objectElement.isActionCommandSet()) {
                        this.actionEvent = new ActionEvent(this.labelView, 1001, objectElement.getActionCommand());
                        this.pressed = true;
                    } else {
                        this.actionEvent = null;
                        this.pressed = false;
                    }
                    return;
                }
            }
            linePos += lineSize.height;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.pressed && this.rollover && this.actionEvent != null) {
            this.labelView.processActionEvent(this.actionEvent);
        }
        this.actionEvent = null;
        this.pressed = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.pressed) {
            this.rollover = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.rollover = true;
    }
}

