/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.TextField;
import com.sas.beans.Util;
import com.sas.lang.StringDataInterface;
import com.sas.visuals.CompositeContainer;
import com.sas.visuals.PushButton;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class TextEditComposite
extends CompositeContainer
implements ActionListener,
FocusListener,
StringDataInterface {
    static final long serialVersionUID = -5422594362655253935L;
    private static String DEFAULT_TEXT = "defaultText";
    private static String TEXT_VIEW = "textView";
    private static String TEXT_EDIT = "textEdit";
    protected Component defaultTextCard;
    protected Component textViewCard;
    protected Component textEditCard;
    protected boolean editable;
    static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    static int defaultWidth = 124;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public TextEditComposite() {
    }

    public TextEditComposite(String defaultViewText) {
        this.setDefaultViewText(defaultViewText);
    }

    public Component getDefaultViewComponent() {
        return this.defaultTextCard;
    }

    public Component getTextViewComponent() {
        return this.textViewCard;
    }

    public Component getTextEditComponent() {
        return this.textEditCard;
    }

    public String getDefaultViewText() {
        if (this.defaultTextCard instanceof StringDataInterface) {
            return ((StringDataInterface)this.defaultTextCard).getText();
        }
        return null;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public String getText() {
        if (this.defaultTextCard instanceof StringDataInterface) {
            return ((StringDataInterface)this.textViewCard).getText();
        }
        return null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Util.addPropertyChangeListener((Object)this.defaultTextCard, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.textViewCard, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.textEditCard, (PropertyChangeListener)((Object)this));
    }

    public void setEditable(boolean edit) {
        if (edit != this.editable) {
            this.editable = edit;
            if (!this.editable) {
                CardLayout cardLayout = (CardLayout)this.getLayout();
                cardLayout.show(this, TEXT_VIEW);
            }
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"editable", (boolean)this.editable);
        }
    }

    public void setDefaultViewText(String defaultText) {
        if (this.defaultTextCard instanceof StringDataInterface) {
            ((StringDataInterface)this.defaultTextCard).setText(defaultText);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEditable(enabled);
    }

    public void setText(String text) {
        if (this.textEditCard instanceof StringDataInterface) {
            ((StringDataInterface)this.textEditCard).setText(text);
        } else if (this.textEditCard instanceof TextComponent) {
            ((TextComponent)this.textEditCard).setText(text);
        }
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (text == null || text.length() == 0) {
            cardLayout.show(this, DEFAULT_TEXT);
        } else if (this.defaultTextCard.isVisible()) {
            cardLayout.show(this, TEXT_VIEW);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.editable = true;
        this.setIDEDnDDropBarrier(true);
        this.setIDEDnDDropTarget(false);
        this.createComponents();
        this.layoutComponents();
    }

    protected void createComponents() {
        PushButton textButton = new PushButton();
        PushButton noTextButton = new PushButton();
        TextField textField = new TextField();
        this.initializeButton(noTextButton, "", SystemColor.textHighlightText, SystemColor.textInactiveText);
        this.initializeButton(textButton, "", SystemColor.textHighlightText, SystemColor.textText);
        textField.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        textField.addFocusListener(this);
        textButton.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        textButton.addActionListener(this);
        textButton.addFocusListener(this);
        noTextButton.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        noTextButton.addActionListener(this);
        noTextButton.addFocusListener(this);
        this.defaultTextCard = noTextButton;
        this.textViewCard = textButton;
        this.textEditCard = textField;
    }

    protected void layoutComponents() {
        CardLayout cardLayout = new CardLayout();
        this.setLayout(cardLayout);
        this.add(this.defaultTextCard, DEFAULT_TEXT);
        this.add(this.textViewCard, TEXT_VIEW);
        this.add(this.textEditCard, TEXT_EDIT);
        cardLayout.show(this, DEFAULT_TEXT);
    }

    protected void initializeButton(PushButton btn, String text, Color background, Color foreground) {
        btn.setText(text);
        btn.setBorderPainted(false);
        btn.setBackground(background);
        btn.setForeground(foreground);
        btn.setContentShift(new Point(0, 0));
        btn.setHorizontalAlignment(1);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        if (propName != null && propName.equals("text")) {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (eSource == this.textViewCard) {
                this.firePropertyChange("text", oldValue, newValue);
            } else if (eSource == this.defaultTextCard) {
                this.firePropertyChange("defaultViewText", oldValue, newValue);
            } else if (eSource == this.textEditCard && this.textViewCard instanceof StringDataInterface) {
                ((StringDataInterface)this.textViewCard).setText((String)newValue);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eSource = event.getSource();
        if ((eSource == this.textViewCard || eSource == this.defaultTextCard) && this.editable) {
            CardLayout cardLayout = (CardLayout)this.getLayout();
            cardLayout.show(this, TEXT_EDIT);
            this.textEditCard.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        Object eSource = event.getSource();
        if ((eSource == this.textViewCard || eSource == this.defaultTextCard) && this.editable) {
            CardLayout cardLayout = (CardLayout)this.getLayout();
            cardLayout.show(this, TEXT_EDIT);
            this.textEditCard.requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object eSource = event.getSource();
        if (eSource == this.textEditCard) {
            String text = null;
            if (this.textEditCard instanceof StringDataInterface) {
                text = ((StringDataInterface)this.textEditCard).getText();
            } else if (this.textEditCard instanceof TextComponent) {
                text = ((TextComponent)this.textEditCard).getText();
            }
            CardLayout cardLayout = (CardLayout)this.getLayout();
            if (text == null || text.length() == 0) {
                cardLayout.show(this, DEFAULT_TEXT);
            } else {
                cardLayout.show(this, TEXT_VIEW);
            }
        }
    }
}

