/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.util.Util;
import com.sas.visuals.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class TextBorder
extends Border {
    static final long serialVersionUID = 1272955305698820085L;
    public static final int CENTER = 256;
    public static final int RIGHT = 2;
    public static final int LEFT = 1;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    protected String text;
    protected int textBorderGap;
    protected int textPosition;
    protected int textHAlignment;
    protected int textVAlignment;
    protected int textMargin;
    protected Font textFont;
    protected Color textColor;
    protected Border border;
    protected Component component;

    public TextBorder() {
        this(null, null, null, 0, 0, 0, null, null);
    }

    public TextBorder(Component comp, String txt) {
        this(comp, txt, null, 0, 0, 0, null, null);
    }

    public TextBorder(Component comp, String txt, Border b) {
        this(comp, txt, b, 0, 0, 0, null, null);
    }

    public TextBorder(Component comp, String txt, Border b, int textHAlign, int textVAlign, int textPos) {
        this(comp, txt, b, textHAlign, textVAlign, textPos, null, null);
    }

    public TextBorder(Component comp, String txt, Border b, int textHAlign, int textVAlign, int textPos, Font f) {
        this(comp, txt, b, textHAlign, textVAlign, textPos, f, null);
    }

    public TextBorder(Component comp, String txt, Border b, int textHAlign, int textVAlign, int textPos, Font f, Color c) {
        this.component = comp;
        this.text = txt;
        this.border = b;
        this.textPosition = textPos;
        this.textHAlignment = textHAlign;
        this.textVAlignment = textVAlign;
        this.textMargin = 10;
        this.textBorderGap = 2;
        this.textFont = f;
        this.textColor = c;
    }

    @Override
    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        int hAlign;
        if (g == null) {
            return;
        }
        String txt = this.getText();
        Border b = this.getBorder();
        if ((txt == null || txt.length() == 0) && b != null) {
            b.drawInRect(g, x, y, width, height);
            return;
        }
        Insets borderInsets = new Insets(0, 0, 0, 0);
        if (b != null) {
            borderInsets = b.getInsets();
        }
        Color currentColor = g.getColor();
        Font currentFont = g.getFont();
        Component compTemp = this.getComponent();
        Font f = this.getTextFont();
        if (f == null) {
            if (compTemp != null) {
                f = compTemp.getFont();
            } else if (this.component != null) {
                f = this.component.getFont();
            }
        }
        if (f == null) {
            f = g.getFont();
        }
        if (f == null) {
            f = Util.getDialogFont();
        }
        g.setFont(f);
        FontMetrics fontMetrics = g.getFontMetrics();
        int ascent = fontMetrics.getAscent();
        int descent = fontMetrics.getDescent();
        int textHeight = ascent + descent;
        int textWidth = fontMetrics.stringWidth(txt);
        Rectangle borderRect = new Rectangle(x, y, width, height);
        Point textPoint = new Point(0, 0);
        int textPos = this.getTextPosition();
        int vAlign = this.getVerticalAlignment();
        if (vAlign == 4) {
            if (textPos == 8) {
                textPoint.y = y + height - borderInsets.bottom - this.getTextBorderGap() - descent;
            } else {
                textPoint.y = y + ascent;
                borderRect.y = y + textHeight + this.getTextBorderGap();
                borderRect.height = height - textHeight - this.getTextBorderGap();
            }
        } else if (vAlign == 8) {
            if (textPos == 8) {
                textPoint.y = y + height - descent;
                borderRect.height = height - this.getTextBorderGap() - textHeight;
            } else {
                textPoint.y = y + borderInsets.top + this.getTextBorderGap() + ascent;
            }
        } else if (textPos == 8) {
            if (borderInsets.bottom > textHeight) {
                textPoint.y = y + height - borderInsets.bottom / 2 + textHeight / 2 - descent;
            } else {
                textPoint.y = y + height - descent;
                borderRect.height = height - textHeight / 2 + borderInsets.bottom / 2;
            }
        } else if (borderInsets.top > textHeight) {
            textPoint.y = y + borderInsets.top / 2 - textHeight / 2 + ascent;
        } else {
            textPoint.y = ascent;
            borderRect.y = y + textHeight / 2 - borderInsets.top / 2;
            borderRect.height = height - textHeight / 2 + borderInsets.top / 2;
        }
        if (b != null) {
            b.drawInRect(comp, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
        }
        textPoint.x = (hAlign = this.getHorizontalAlignment()) == 256 ? x + width / 2 - textWidth / 2 : (hAlign == 2 ? x + width - this.getTextMargin() - textWidth : x + this.getTextMargin());
        if (compTemp != null) {
            g.setColor(compTemp.getBackground());
        } else if (comp != null) {
            g.setColor(comp.getBackground());
        } else {
            g.setColor(Color.lightGray);
        }
        g.fillRect(textPoint.x - 3, textPoint.y - ascent, textWidth + 6, textHeight);
        Color newColor = this.getTextColor();
        if (newColor != null) {
            g.setColor(newColor);
        } else if (compTemp != null) {
            g.setColor(compTemp.getForeground());
        } else if (comp != null) {
            g.setColor(comp.getForeground());
        } else {
            g.setColor(Color.black);
        }
        boolean enabled = true;
        if (compTemp != null) {
            enabled = compTemp.isEnabled();
        } else if (comp != null) {
            enabled = comp.isEnabled();
        }
        Util.drawString(g, txt, textPoint.x, textPoint.y, enabled);
        g.setColor(currentColor);
        g.setFont(currentFont);
    }

    public Border getBorder() {
        return this.border;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getHorizontalAlignment() {
        return this.textHAlignment;
    }

    @Override
    public Insets getInsets(Component comp) {
        Component compTemp;
        Border b = this.getBorder();
        Insets insets = new Insets(0, 0, 0, 0);
        if (b != null) {
            insets = b.getInsets(comp);
        }
        if ((compTemp = this.getComponent()) == null) {
            compTemp = comp;
        }
        if (compTemp != null) {
            int textHeight = this.getTextHeight(compTemp);
            int vAlign = this.getVerticalAlignment();
            if (textHeight != 0) {
                if (this.getTextPosition() == 4) {
                    if (vAlign == 4 || vAlign == 8) {
                        insets.top = textHeight + insets.top + this.getTextBorderGap();
                    } else if (textHeight > insets.top) {
                        insets.top = textHeight;
                    }
                } else if (this.getTextPosition() == 8) {
                    if (vAlign == 4 || vAlign == 8) {
                        insets.bottom = textHeight + insets.bottom + this.getTextBorderGap();
                    } else if (textHeight > insets.bottom) {
                        insets.bottom = textHeight;
                    }
                }
            }
        }
        return insets;
    }

    public String getText() {
        return this.text;
    }

    public int getTextBorderGap() {
        return this.textBorderGap;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    protected int getTextHeight(Component c) {
        if (c == null || this.text == null || this.text.length() == 0) {
            return 0;
        }
        Font f = this.textFont;
        if (f == null) {
            f = c.getFont();
        }
        if (f == null) {
            f = Util.getDialogFont();
        }
        FontMetrics fm = c.getFontMetrics(f);
        int height = fm.getAscent() + fm.getDescent();
        return height;
    }

    public int getTextMargin() {
        return this.textMargin;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public int getVerticalAlignment() {
        return this.textVAlignment;
    }

    public void setBorder(Border b) {
        if (b != this.border) {
            Border oldValue = this.border;
            this.border = b;
            this.firePropertyChange("border", (Object)oldValue, (Object)this.border);
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }

    public void setComponent(Component comp) {
        if (comp != this.component) {
            Component oldValue = this.component;
            this.component = comp;
            this.firePropertyChange("component", oldValue, this.component);
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }

    public void setHorizontalAlignment(int hAlign) {
        if (hAlign != this.textHAlignment) {
            int oldValue = this.textHAlignment;
            this.textHAlignment = hAlign;
            this.firePropertyChange("horizontalAlignment", new Integer(oldValue), new Integer(this.textHAlignment));
        }
    }

    public void setText(String txt) {
        if (txt != this.text) {
            String oldValue = this.text;
            this.text = txt;
            this.firePropertyChange("text", oldValue, this.text);
            if (oldValue == null || oldValue.length() == 0) {
                this.firePropertyChange("insets", null, this.getInsets());
            }
        }
    }

    public void setTextBorderGap(int gap) {
        if (gap != this.textBorderGap) {
            int oldValue = this.textBorderGap;
            this.textBorderGap = gap;
            this.firePropertyChange("textBorderGap", new Integer(oldValue), new Integer(this.textBorderGap));
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }

    public void setTextColor(Color c) {
        if (c != this.textColor) {
            Color oldValue = this.textColor;
            this.textColor = c;
            this.firePropertyChange("textColor", oldValue, this.textColor);
        }
    }

    public void setTextFont(Font f) {
        if (f != this.textFont) {
            Font oldValue = this.textFont;
            this.textFont = f;
            this.firePropertyChange("textFont", oldValue, this.textFont);
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }

    public void setTextMargin(int margin) {
        if (margin != this.textMargin) {
            int oldValue = this.textMargin;
            this.textMargin = margin;
            this.firePropertyChange("textMargin", new Integer(oldValue), new Integer(this.textMargin));
        }
    }

    public void setTextPosition(int textPos) {
        if (textPos != this.textPosition && (textPos == 4 || textPos == 8)) {
            int oldValue = this.textPosition;
            this.textPosition = textPos;
            this.firePropertyChange("textPosition", new Integer(oldValue), new Integer(this.textPosition));
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }

    public void setVerticalAlignment(int vAlign) {
        if (vAlign != this.textVAlignment) {
            int oldValue = this.textVAlignment;
            this.textVAlignment = vAlign;
            this.firePropertyChange("verticalAlignment", new Integer(oldValue), new Integer(this.textVAlignment));
            this.firePropertyChange("insets", null, this.getInsets());
        }
    }
}

