/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.util.Util;
import com.sas.visuals.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class TabBorder
extends Border {
    static final long serialVersionUID = -7979238711478816846L;
    public static final int NONE = 0;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    protected int orientation;
    protected Color highlightColor;
    protected Color lightHighlightColor;
    protected Color shadowColor;
    protected Color darkShadowColor;

    public TabBorder() {
        this(0);
    }

    public TabBorder(int orient) {
        this.orientation = orient;
        this.setStyle(1);
        this.highlightColor = SystemColor.controlHighlight;
        this.lightHighlightColor = SystemColor.controlLtHighlight;
        this.shadowColor = SystemColor.controlShadow;
        this.darkShadowColor = SystemColor.controlDkShadow;
    }

    @Override
    public Insets getInsets(Component comp) {
        Insets insets = new Insets(4, 4, 4, 4);
        switch (this.getOrientation()) {
            case 4: {
                insets.bottom = 2;
                break;
            }
            case 2: {
                insets.left = 2;
                break;
            }
            case 1: {
                insets.right = 2;
                break;
            }
            case 8: {
                insets.top = 2;
            }
        }
        return insets;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        if (orient != this.orientation) {
            int oldOrient = this.orientation;
            this.orientation = orient;
            this.firePropertyChange("orientation", new Integer(oldOrient), new Integer(this.orientation));
        }
    }

    @Override
    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.getStyle() == 0) {
            return;
        }
        Color currentColor = g.getColor();
        Dimension tabSize = new Dimension(width, height);
        int spacing = 2;
        if (this.getLightSource() == 10) {
            spacing = 0;
        }
        if (this.orientation != 2) {
            g.setColor(this.lightHighlightColor);
            g.drawLine(x + spacing, y + tabSize.height - 3 - spacing, x + spacing, y + 2 + spacing);
            g.drawLine(x + 1 + spacing, y + 1 + spacing, x + 1 + spacing, 1 + spacing);
            g.drawLine(x + 1 + spacing, y + tabSize.height - 2 - spacing, x + 1 + spacing, y + tabSize.height - 2 - spacing);
            g.setColor(this.highlightColor);
            g.drawLine(x + 1 + spacing, y + tabSize.height - 3 - spacing, x + 1 + spacing, y + 2 + spacing);
        }
        if (this.orientation != 8) {
            g.setColor(this.lightHighlightColor);
            g.drawLine(x + 2 + spacing, y + spacing, x + tabSize.width - 3 - spacing, y + spacing);
            g.setColor(this.highlightColor);
            g.drawLine(x + 2 + spacing, y + 1 + spacing, x + tabSize.width - 3 - spacing, y + 1 + spacing);
        }
        if (this.orientation != 1) {
            g.setColor(this.darkShadowColor);
            g.drawLine(x + tabSize.width - 1 - spacing, y + 2 + spacing, x + tabSize.width - 1 - spacing, y + tabSize.height - 3 - spacing);
            g.drawLine(x + tabSize.width - 2 - spacing, y + 1 + spacing, x + tabSize.width - 2 - spacing, y + 1 + spacing);
            g.drawLine(x + tabSize.width - 2 - spacing, y + tabSize.height - 2 - spacing, x + tabSize.width - 2 - spacing, y + tabSize.height - 2 - spacing);
            g.setColor(this.shadowColor);
            g.drawLine(x + tabSize.width - 2 - spacing, y + 2 + spacing, x + tabSize.width - 2 - spacing, y + tabSize.height - 3 - spacing);
        }
        if (this.orientation != 4) {
            g.setColor(this.darkShadowColor);
            g.drawLine(x + 2 + spacing, y + tabSize.height - 1 - spacing, x + tabSize.width - 3 - spacing, y + tabSize.height - 1 - spacing);
            g.setColor(this.shadowColor);
            g.drawLine(x + 2 + spacing, y + tabSize.height - 2 - spacing, x + tabSize.width - 3 - spacing, y + tabSize.height - 2 - spacing);
        }
        switch (this.orientation) {
            case 4: {
                g.setColor(this.lightHighlightColor);
                g.drawLine(x + spacing, y + tabSize.height - 2, x + spacing, y + tabSize.height - 4);
                g.setColor(this.highlightColor);
                g.drawLine(x + spacing + 1, y + tabSize.height - 2, x + spacing + 1, y + tabSize.height - 4);
                g.setColor(this.darkShadowColor);
                g.drawLine(x + tabSize.width - 1 - spacing, y + tabSize.height - 2, x + tabSize.width - 1 - spacing, y + tabSize.height - 4);
                g.setColor(this.shadowColor);
                g.drawLine(x + tabSize.width - 2 - spacing, y + tabSize.height - 2, x + tabSize.width - 2 - spacing, y + tabSize.height - 4);
                if (this.getLightSource() == 5) {
                    g.setColor(this.lightHighlightColor);
                    g.drawLine(x + spacing, y + tabSize.height - 2, x + tabSize.width - 1 - spacing, y + tabSize.height - 2);
                    g.setColor(this.highlightColor);
                    g.drawLine(x + spacing, y + tabSize.height - 1, x + tabSize.width - 1 - spacing, y + tabSize.height - 1);
                    break;
                }
                if (comp == null) break;
                g.setColor(comp.getBackground());
                g.drawRect(x + 2, y + 2, width - 5, height - 3);
                g.drawRect(x + 3, y + 3, width - 7, height - 5);
                break;
            }
            case 8: {
                g.setColor(this.lightHighlightColor);
                g.drawLine(x + spacing, y + 1, x + spacing, y + 3);
                g.setColor(this.highlightColor);
                g.drawLine(x + spacing + 1, y + 1, x + spacing + 1, y + 3);
                g.setColor(this.darkShadowColor);
                g.drawLine(x + tabSize.width - 1 - spacing, y + 1, x + tabSize.width - 1 - spacing, y + 3);
                g.setColor(this.shadowColor);
                g.drawLine(x + tabSize.width - 2 - spacing, y + 1, x + tabSize.width - 2 - spacing, y + 3);
                if (this.getLightSource() == 5) {
                    g.setColor(this.darkShadowColor);
                    g.drawLine(x + spacing, y + 1, x + tabSize.width - 1 - spacing, y + 1);
                    g.setColor(this.shadowColor);
                    g.drawLine(x + spacing, y + 0, x + tabSize.width - 1 - spacing, y + 0);
                    break;
                }
                if (comp == null) break;
                g.setColor(comp.getBackground());
                g.drawRect(x + 2, y, width - 5, height - 3);
                g.drawRect(x + 3, y + 1, width - 7, height - 5);
                break;
            }
            case 2: {
                g.setColor(this.lightHighlightColor);
                g.drawLine(x + 1, y + spacing, x + 3, y + spacing);
                g.setColor(this.highlightColor);
                g.drawLine(x + 1, y + spacing + 1, 3, y + spacing + 1);
                g.setColor(this.darkShadowColor);
                g.drawLine(x + 1, y + tabSize.height - 1 - spacing, x + 3, y + tabSize.height - 1 - spacing);
                g.setColor(this.shadowColor);
                g.drawLine(x + 1, y + tabSize.height - 2 - spacing, x + 3, y + tabSize.height - 2 - spacing);
                if (this.getLightSource() == 5) {
                    g.setColor(this.shadowColor);
                    g.drawLine(x + 0, y + spacing, x + 0, y + tabSize.height - 1 - spacing);
                    g.setColor(this.darkShadowColor);
                    g.drawLine(x + 1, y + spacing, x + 1, y + tabSize.height - 1 - spacing);
                    break;
                }
                if (comp == null) break;
                g.setColor(comp.getBackground());
                g.drawRect(x, y + 2, width - 3, height - 5);
                g.drawRect(x + 1, y + 3, width - 5, height - 7);
                break;
            }
            case 1: {
                g.setColor(this.lightHighlightColor);
                g.drawLine(x + tabSize.width - 2, y + spacing, x + tabSize.width - 4, y + spacing);
                g.setColor(this.highlightColor);
                g.drawLine(x + tabSize.width - 2, y + spacing + 1, tabSize.width - 4, y + spacing + 1);
                g.setColor(this.darkShadowColor);
                g.drawLine(x + tabSize.width - 2, y + tabSize.height - 1 - spacing, x + tabSize.width - 4, y + tabSize.height - 1 - spacing);
                g.setColor(this.shadowColor);
                g.drawLine(x + tabSize.width - 2, y + tabSize.height - 2 - spacing, x + tabSize.width - 4, y + tabSize.height - 2 - spacing);
                if (this.getLightSource() == 5) {
                    g.setColor(this.highlightColor);
                    g.drawLine(x + tabSize.width - 1, y + spacing, x + tabSize.width - 1, y + tabSize.height - 1 - spacing);
                    g.setColor(this.lightHighlightColor);
                    g.drawLine(x + tabSize.width - 2, y + spacing, x + tabSize.width - 2, y + tabSize.height - 1 - spacing);
                    break;
                }
                if (comp == null) break;
                g.setColor(comp.getBackground());
                g.drawRect(x + 2, y + 2, width - 3, height - 5);
                g.drawRect(x + 3, y + 3, width - 5, height - 7);
            }
        }
        g.setColor(currentColor);
    }

    public void setLightHighlightColor(Color c) {
        if (!Util.equal((Object)c, (Object)this.lightHighlightColor)) {
            Color oldColor = this.lightHighlightColor;
            this.lightHighlightColor = c;
            this.firePropertyChange("lightHighlightColor", oldColor, this.lightHighlightColor);
        }
    }

    public void setDarkShadowColor(Color c) {
        if (!Util.equal((Object)c, (Object)this.darkShadowColor)) {
            Color oldColor = this.darkShadowColor;
            this.darkShadowColor = c;
            this.firePropertyChange("darkShadowColor", oldColor, this.darkShadowColor);
        }
    }

    public void setHighlightColor(Color c) {
        if (!Util.equal((Object)c, (Object)this.highlightColor)) {
            Color oldColor = this.highlightColor;
            this.highlightColor = c;
            this.firePropertyChange("highlightColor", oldColor, this.highlightColor);
        }
    }

    public void setShadowColor(Color c) {
        if (!Util.equal((Object)c, (Object)this.shadowColor)) {
            Color oldColor = this.shadowColor;
            this.shadowColor = c;
            this.firePropertyChange("shadowColor", oldColor, this.shadowColor);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.shadowColor == null) {
            this.shadowColor = SystemColor.controlShadow;
        }
        if (this.highlightColor == null) {
            this.highlightColor = SystemColor.controlHighlight;
        }
        if (this.lightHighlightColor == null) {
            this.lightHighlightColor = SystemColor.controlLtHighlight;
        }
        if (this.darkShadowColor == null) {
            this.darkShadowColor = SystemColor.controlDkShadow;
        }
    }
}

