/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.GlobalInfoTable;
import com.sas.ModelInterface;
import com.sas.RunningObjectTable;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.InvalidElementTypeException;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.graphics.ElasticComponentList;
import com.sas.graphics.IDEDnDManager;
import com.sas.util.Util;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.Border;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.RB;
import com.sas.visuals.RowLayout;
import com.sas.visuals.SelectableInterface;
import com.sas.visuals.SelectionGroup;
import com.sas.visuals.SelectionGroupInterface;
import com.sas.visuals.SpinButton;
import com.sas.visuals.TabBarInterface;
import com.sas.visuals.TabButton;
import com.sas.visuals.TabButtonInterface;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class TabBar
extends CompositePanel
implements TabBarInterface,
AdjustmentListener,
ContentsChangedListener {
    static final long serialVersionUID = -2325128583635804519L;
    public static final String RB_KEY = "TabBar.";
    private static final String defaultTabButtonClass = "com.sas.visuals.TabButton";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    private transient boolean modelInvoked;
    private transient boolean viewerInvoked;
    private transient boolean adjustableChanged;
    private transient Image offscreen;
    private transient ActionListener actionListener;
    private transient ItemListener itemListener;
    private transient Dimension prevSize;
    private transient Component selectedComponent;
    private transient int prevRow;
    private transient int prevGroup;
    private Vector lwComponents;
    private String tabButtonClassName;
    private SelectionGroupInterface tabSelectionGroup;
    private Class tabButtonClass;
    private TransformInterface displayTransform;
    private TransformInterface inputTransform;
    private TransformInterface outputTransform;
    protected SpinButton spinBtn;
    protected Dimension spinBtnSize;
    private int spinBtnAlignment;
    private int spinBtnOrientation;
    private int spinBtnGap;
    protected int style;
    protected int orientation;
    protected BorderInterface border;
    private Border rowBorder;
    private boolean noPrevAdd;
    private OrderedCollection defaultModel;
    private static int defaultHeight = 23;
    private static int defaultWidth = 248;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "bottomMargin"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"bottomMargin.pd.txt")}}, {{"Name", "displayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "fillFrom"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"fillFrom.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "justification"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"justification.pd.txt")}, {"Property editor class", "com.sas.beans.editors._JustificationEditor"}}, {{"Name", "layout"}, {"Hidden", "true"}}, {{"Name", "leftMargin"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"leftMargin.pd.txt")}}, {{"Name", "orientation"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"orientation.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SideOrientationEditor"}}, {{"Name", "outputTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "rightMargin"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"rightMargin.pd.txt")}}, {{"Name", "rowBorder"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"rowBorder.pd.txt")}, {"Expert", "true"}}, {{"Name", "rowCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"rowCount.pd.txt")}}, {{"Name", "rowSpacing"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"rowSpacing.pd.txt")}}, {{"Name", "selectedIndex"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedIndex.pd.txt")}}, {{"Name", "selectedItem"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectedItem.pd.txt")}}, {{"Name", "selectionGroup"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"selectionGroup.pd.txt")}}, {{"Name", "sizing"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"sizing.pd.txt")}, {"Property editor class", "com.sas.beans.editors._TabBarSizingEditor"}}, {{"Name", "tabSpacing"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"tabSpacing.pd.txt")}}, {{"Name", "spinButtonGap"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"spinButtonGap.pd.txt")}, {"Expert", "true"}}, {{"Name", "spinButtonAlignment"}, {"Property editor class", "com.sas.beans.editors._HorizontalAlignmentEditor"}, {"Hidden", "true"}}, {{"Name", "spinButtonOrientation"}, {"Property editor class", "com.sas.beans.editors._SideOrientationEditor"}, {"Hidden", "true"}}, {{"Name", "startIndex"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"startIndex.pd.txt")}}, {{"Name", "style"}, {"Description", "Row style for tabs."}, {"Property editor class", "com.sas.beans.editors._TabBarStyleEditor"}}, {{"Name", "tabSize"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"tabSize.pd.txt")}}, {{"Name", "tabButtonClass"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"tabButtonClass.pd.txt")}, {"Expert", "true"}}, {{"Name", "topMargin"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"topMargin.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public TabBar() {
    }

    public TabBar(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof TabButtonInterface) {
            try {
                ModelInterface model;
                if (!this.modelInvoked && (model = this.getModelInterface()) != null && model instanceof OrderedCollectionInterface) {
                    this.viewerInvoked = true;
                    if (index == -1) {
                        ((OrderedCollectionInterface)model).add(((SelectableInterface)((Object)comp)).getItem());
                    } else {
                        ((OrderedCollectionInterface)model).add(((SelectableInterface)((Object)comp)).getItem(), index);
                    }
                }
                int idx = index;
                if (index != -1) {
                    idx = index + 1;
                }
                if (constraints instanceof Integer || constraints instanceof String) {
                    super.addImpl(comp, constraints, idx);
                } else {
                    super.addImpl(comp, null, idx);
                }
                com.sas.beans.Util.addPropertyChangeListener((Object)comp, (PropertyChangeListener)((Object)this));
                this.lwComponents.addElement(comp);
                ((TabButtonInterface)((Object)comp)).setDisplayTransform(this.displayTransform);
                ((TabButtonInterface)((Object)comp)).setOrientation(this.orientation);
                if (index == -1) {
                    this.tabSelectionGroup.add((TabButtonInterface)((Object)comp), this.lwComponents.size() - 1);
                } else {
                    this.tabSelectionGroup.add((TabButtonInterface)((Object)comp), index);
                }
                if (index != -1 || index != this.lwComponents.size()) {
                    ((RowLayout)this.getLayout()).reorderComponents((Container)this);
                }
                if (this.style == 0 && this.spinBtn != null) {
                    if (((RowLayout)this.getLayout()).getEndIndex() == this.lwComponents.size() - 1) {
                        this.spinBtn.setIncrementEnabled(false);
                    }
                    this.spinBtn.setMaximum(this.lwComponents.size());
                }
                if (this.getSelectedIndex() != -1) return;
                this.setSelectedIndex(0);
                return;
            }
            finally {
                this.modelInvoked = false;
            }
        } else {
            if (comp != this.spinBtn) throw new InvalidElementTypeException();
            super.addImpl(comp, new Integer(-1), index);
        }
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, listener);
    }

    public Component addItem(Object tabItem) {
        return this.addItem(tabItem, new Integer(0), -1);
    }

    public Component addItem(Object tabItem, int index) {
        return this.addItem(tabItem, new Integer(0), index);
    }

    public Component addItem(Object tabItem, Integer grpIndex) {
        return this.addItem(tabItem, grpIndex, -1);
    }

    @Override
    public Component addItem(Object item, Integer grpIndex, int index) {
        ModelInterface model = this.getModelInterface();
        if (model == null) {
            return this.addModelItem(item, grpIndex, index);
        }
        if (model instanceof OrderedCollectionInterface) {
            Object itemData = item;
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println("TransformException in TabBar::addItem( Object item, Integer grpIndex, int index ) ");
                }
            }
            if (index == -1) {
                index = ((OrderedCollectionInterface)model).count();
            }
            ((OrderedCollectionInterface)model).add(itemData, index);
        }
        return null;
    }

    protected synchronized Component addModelItem(Object tabItem, Integer grpIndex, int index) {
        try {
            TabButtonInterface tab = (TabButtonInterface)this.tabButtonClass.newInstance();
            if (tab instanceof Component) {
                tab.setItem(tabItem);
                this.modelInvoked = true;
                this.add((Component)((Object)tab), grpIndex, index);
                if (this.isDesignTime()) {
                    IDEDnDManager.insertNewComponent(new Frame(), tab);
                }
                return (Component)((Object)tab);
            }
        }
        catch (InstantiationException classInstantiationException) {
            Util.println((String)"TabBar: InstantiationException thrown in addItem( Object tabItem, Integer grpIndex, int index ) for tabButtonClass");
        }
        catch (IllegalAccessException classIllegalAccessException) {
            Util.println((String)"TabBar: IllegalAccessException thrown in addItem( Object tabItem, Integer grpIndex, int index ) for tabButtonClass");
        }
        return null;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (evt.getSource() != this.spinBtn) {
            return;
        }
        RowLayout layout = (RowLayout)this.getLayout();
        int prevStartIndex = layout.getStartIndex();
        int adjustType = evt.getAdjustmentType();
        if (adjustType == 1 || adjustType == 4) {
            layout.incrementEndIndex();
        } else if (adjustType == 2 || adjustType == 3) {
            layout.decrementStartIndex();
        } else {
            return;
        }
        this.invalidate();
        this.validate();
        this.repaint();
        this.firePropertyChange("startIndex", new Integer(prevStartIndex), new Integer(layout.getStartIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentsChanged(ContentsChangedEvent evt) {
        try {
            OrderedCollectionInterface eSource = (OrderedCollectionInterface)evt.getSource();
            ModelInterface modelInterface = this.getModelInterface();
            if (eSource != modelInterface) {
                return;
            }
            if (modelInterface != null && !this.viewerInvoked) {
                OrderedCollectionInterface model = (OrderedCollectionInterface)modelInterface;
                if (evt instanceof CollectionChangedInfo && ((CollectionChangedInfo)evt).howChanged != HowChanged.OTHER && ((CollectionChangedInfo)evt).howChanged != HowChanged.REORDERED) {
                    CollectionChangedInfo evtInfo = (CollectionChangedInfo)evt;
                    if (evtInfo.howChanged == HowChanged.ADDED) {
                        if (evtInfo.whatChanged != null) {
                            Object dItem = evtInfo.whatChanged;
                            this.addModelItem(dItem, new Integer(0), evtInfo.start);
                        } else {
                            Enumeration modelE = model.getItems(evtInfo.start, evtInfo.end);
                            int position = evtInfo.start;
                            while (modelE.hasMoreElements()) {
                                Object dItem = modelE.nextElement();
                                this.addModelItem(dItem, new Integer(0), position++);
                            }
                        }
                    } else if (evtInfo.howChanged == HowChanged.REMOVED) {
                        this.modelInvoked = true;
                        if (model.count() == 0) {
                            this.removeAll();
                        } else {
                            for (int i = evtInfo.end - 1; i >= evtInfo.start; --i) {
                                this.modelInvoked = true;
                                this.remove(i);
                            }
                        }
                    } else if (evtInfo.howChanged == HowChanged.REPLACED) {
                        Object obj = model.get(evtInfo.start);
                        ((SelectableInterface)this.tabSelectionGroup.get(evtInfo.start)).setItem(obj);
                    }
                } else {
                    int modelCount = model.count();
                    int componentCount = this.tabSelectionGroup.count();
                    int n = 0;
                    Enumeration groupE = this.tabSelectionGroup.getItems();
                    Enumeration modelE = model.getItems();
                    while (n < modelCount || n < componentCount) {
                        if (n < componentCount && n < modelCount) {
                            ((SelectableInterface)groupE.nextElement()).setItem(modelE.nextElement());
                            ++n;
                            continue;
                        }
                        if (n < componentCount && n >= modelCount) {
                            this.modelInvoked = true;
                            this.remove(n);
                            componentCount = this.tabSelectionGroup.count();
                            continue;
                        }
                        if (n >= componentCount && n < modelCount) {
                            this.addModelItem(modelE.nextElement(), new Integer(0), -1);
                            ++n;
                            continue;
                        }
                        ++n;
                    }
                }
            }
            this.doLayout();
            this.firePropertyChange("", null, null);
        }
        finally {
            this.viewerInvoked = false;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model == this.defaultModel) {
            this.defaultModel.removeAll();
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
    }

    @Override
    public void doLayout() {
        if (this.style == 1) {
            super.doLayout();
            return;
        }
        RowLayout layout = (RowLayout)this.getLayout();
        if (layout.getStartIndex() == 0) {
            switch (this.spinBtnOrientation) {
                case 1: 
                case 2: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setTopMargin(0);
                        break;
                    }
                    layout.setBottomMargin(0);
                    break;
                }
                case 4: 
                case 8: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setLeftMargin(0);
                        break;
                    }
                    layout.setRightMargin(0);
                }
            }
        }
        super.doLayout();
        boolean incrementable = layout.isIncrementable();
        boolean decrementable = layout.isDecrementable();
        switch (this.spinBtnOrientation) {
            case 1: 
            case 2: {
                if (this.spinBtnAlignment == 1) {
                    layout.setTopMargin(0);
                    break;
                }
                layout.setBottomMargin(0);
                break;
            }
            case 4: 
            case 8: {
                if (this.spinBtnAlignment == 1) {
                    layout.setLeftMargin(0);
                    break;
                }
                layout.setRightMargin(0);
            }
        }
        if (!incrementable && !decrementable) {
            this.spinBtn.setVisible(false);
            super.doLayout();
            return;
        }
        this.spinBtn.setVisible(true);
        this.spinBtn.setIncrementEnabled(incrementable);
        this.spinBtn.setDecrementEnabled(decrementable);
        Dimension tabBarSize = this.getSize();
        Insets rowInsets = this.getInsets();
        int topMargin = layout.getTopMargin();
        int bottomMargin = layout.getBottomMargin();
        int leftMargin = layout.getLeftMargin();
        int rightMargin = layout.getRightMargin();
        int availHeight = tabBarSize.height - rowInsets.top - rowInsets.bottom - topMargin - bottomMargin;
        int availWidth = tabBarSize.width - rowInsets.left - rowInsets.right - leftMargin - rightMargin;
        int startX = 0;
        int startY = 0;
        Insets borderInsets = this.border.getInsets((Component)this);
        switch (this.spinBtnOrientation) {
            case 1: {
                startX = borderInsets.left + leftMargin;
                if (this.spinBtnAlignment == 1) {
                    startY = topMargin;
                    layout.setTopMargin(this.spinBtnSize.width + this.spinBtnGap);
                } else {
                    startY = availHeight - this.spinBtnSize.width + bottomMargin;
                    layout.setBottomMargin(this.spinBtnSize.width + this.spinBtnGap);
                }
                this.spinBtn.setBounds(rowInsets.left + startX, rowInsets.top + startY, this.spinBtnSize.height, this.spinBtnSize.width);
                break;
            }
            case 2: {
                startX = availWidth - this.spinBtnSize.height - borderInsets.right;
                if (this.spinBtnAlignment == 1) {
                    startY = topMargin;
                    layout.setTopMargin(this.spinBtnSize.width + this.spinBtnGap);
                } else {
                    startY = availHeight - this.spinBtnSize.width + topMargin;
                    layout.setBottomMargin(this.spinBtnSize.width + this.spinBtnGap);
                }
                this.spinBtn.setBounds(rowInsets.left + startX, rowInsets.top + startY, this.spinBtnSize.height, this.spinBtnSize.width);
                break;
            }
            case 4: {
                startY = topMargin + borderInsets.top;
                if (this.spinBtnAlignment == 1) {
                    startX = leftMargin;
                    layout.setLeftMargin(this.spinBtnSize.width + this.spinBtnGap);
                } else {
                    startX = availWidth - this.spinBtnSize.width + leftMargin;
                    layout.setRightMargin(this.spinBtnSize.width + this.spinBtnGap);
                }
                this.spinBtn.setBounds(rowInsets.left + startX, rowInsets.top + startY, this.spinBtnSize.width, this.spinBtnSize.height);
                break;
            }
            case 8: {
                startY = availHeight - this.spinBtnSize.height - borderInsets.bottom;
                if (this.spinBtnAlignment == 1) {
                    startX = leftMargin;
                    layout.setLeftMargin(this.spinBtnSize.width + this.spinBtnGap);
                } else {
                    startX = availWidth - this.spinBtnSize.width + leftMargin;
                    layout.setRightMargin(this.spinBtnSize.width + this.spinBtnGap);
                }
                this.spinBtn.setBounds(rowInsets.left + startX, rowInsets.top + startY, this.spinBtnSize.width, this.spinBtnSize.height);
            }
        }
        super.doLayout();
        Rectangle tabBarBounds = new Rectangle(tabBarSize);
        for (int j = 0; j < this.lwComponents.size(); ++j) {
            Component comp = (Component)this.lwComponents.elementAt(j);
            if (!comp.isVisible() || !tabBarBounds.contains(comp.getLocation())) continue;
            return;
        }
        incrementable = layout.isIncrementable();
        decrementable = layout.isDecrementable();
        if (!incrementable && !decrementable) {
            this.spinBtn.setVisible(false);
        }
        int selectedIndex = this.tabSelectionGroup.getSelectedIndex();
        Component selectedTab = (Component)this.tabSelectionGroup.get(selectedIndex);
        selectedTab.setBounds(new Rectangle(0, 0, tabBarSize.width, tabBarSize.height));
    }

    @Override
    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation == 4) {
            try {
                Class tabButtonInterface = GlobalInfoTable.loadClass((String)"com.sas.visuals.TabButtonInterface");
                Class dropElementClass = GlobalInfoTable.loadClass((String)((String)data.elementAt(0)));
                if (tabButtonInterface.isAssignableFrom(dropElementClass)) {
                    ElasticComponentList.setDropSite(this);
                    return 2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Util.println((String)"TabBar: exception thrown in dragOver(point, representation, keyState, data) for DropElement Class name");
            }
            ElasticComponentList.setDropSite(null);
            return 4;
        }
        return super.dragOver(point, representation, keyState, data);
    }

    public int getBottomMargin() {
        return ((RowLayout)this.getLayout()).getBottomMargin();
    }

    public int getIndex(TabButtonInterface tab) {
        return this.tabSelectionGroup.getIndex(tab);
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public int getFillFrom() {
        return ((RowLayout)this.getLayout()).getFillFrom();
    }

    @Override
    public int getGroupCount() {
        return ((RowLayout)this.getLayout()).getGroupCount();
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    public String[] getInitialItems() {
        int i = 0;
        int modelCount = this.defaultModel.count();
        String[] items = new String[modelCount];
        Enumeration modelE = this.defaultModel.getItems();
        EnumerationTransform initialItemsE = new EnumerationTransform(modelE, this.outputTransform);
        while (initialItemsE.hasMoreElements()) {
            items[i++] = initialItemsE.nextElement().toString();
        }
        return items;
    }

    public synchronized void setInitialItems(String[] items) {
        int i = 0;
        int modelCount = this.defaultModel.count();
        int itemsCount = items.length;
        while (i < itemsCount || i < modelCount) {
            Object itemData = items[i];
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println("TransformException in TabBar::setInitialItems( String[] items ) ");
                }
            }
            if (i < modelCount) {
                if (i < itemsCount) {
                    this.defaultModel.set(i, itemData);
                } else {
                    this.defaultModel.removeAt(itemsCount);
                }
                ++i;
                continue;
            }
            this.defaultModel.add(itemData, i++);
        }
        ModelInterface model = this.getModelInterface();
        if (model == null || model != this.defaultModel) {
            this.detachModel(model);
        }
    }

    public int getJustification() {
        return ((RowLayout)this.getLayout()).getJustification();
    }

    public int getLeftMargin() {
        return ((RowLayout)this.getLayout()).getLeftMargin();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public int getRightMargin() {
        return ((RowLayout)this.getLayout()).getRightMargin();
    }

    @Override
    public BorderInterface getRowBorder() {
        return this.border;
    }

    public int getRowSpacing() {
        return ((RowLayout)this.getLayout()).getRowSpacing();
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public SelectionGroupInterface getSelectionGroup() {
        return this.tabSelectionGroup;
    }

    public int getSelectedGroupIndex() {
        return this.prevGroup;
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.tabSelectionGroup.getSelectedObjects();
    }

    public int getSizing() {
        return ((RowLayout)this.getLayout()).getSizing();
    }

    public int getTabSpacing() {
        return ((RowLayout)this.getLayout()).getSpacing();
    }

    public Class getTabButtonClass() {
        return this.tabButtonClass;
    }

    public int getSpinButtonAlignment() {
        return this.spinBtnAlignment;
    }

    public int getSpinButtonOrientation() {
        return this.spinBtnOrientation;
    }

    public int getSpinButtonGap() {
        return this.spinBtnGap;
    }

    public int getStartIndex() {
        return ((RowLayout)this.getLayout()).getStartIndex();
    }

    @Override
    public int getSelectedIndex() {
        return this.tabSelectionGroup.getSelectedIndex();
    }

    @Override
    public Object getSelectedItem() {
        return this.tabSelectionGroup.getSelectedItem();
    }

    @Override
    public int getTabGroupIndex(TabButtonInterface tab) {
        if (tab instanceof Component) {
            return ((RowLayout)this.getLayout()).getGroupIndex((Component)((Object)tab));
        }
        return -1;
    }

    public Dimension getTabSize() {
        return ((RowLayout)this.getLayout()).getComponentSize();
    }

    public int getTopMargin() {
        return ((RowLayout)this.getLayout()).getTopMargin();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.isDesignTime() && this.noPrevAdd && this.defaultModel.count() == 0) {
            this.defaultModel.add((Object)RB.getStringResource((String)RB_KEY, (String)"defaultTab1.txt"));
            this.defaultModel.add((Object)RB.getStringResource((String)RB_KEY, (String)"defaultTab2.txt"));
        }
        this.noPrevAdd = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int index;
        Object source = e.getSource();
        if (e.getStateChange() == 1 && source.equals(this.tabSelectionGroup) && (index = this.tabSelectionGroup.getSelectedIndex()) != -1) {
            Object tab = this.tabSelectionGroup.get(index);
            this.selectedComponent = (Component)tab;
            this.reorderComponents();
            this.repaint();
            this.processEvent(new ActionEvent(this, 1001, ((TabButtonInterface)tab).getActionCommand()));
            this.processEvent(new ItemEvent(this, 701, e.getItem(), e.getStateChange()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Dimension barSize = this.getSize();
        if ((this.offscreen == null || this.prevSize.width != barSize.width || this.prevSize.height != barSize.height) && barSize.width > 0 && barSize.height > 0) {
            this.offscreen = this.createImage(barSize.width, barSize.height);
            this.prevSize.width = barSize.width;
            this.prevSize.height = barSize.height;
        }
        if (this.offscreen == null) {
            return;
        }
        Graphics og = this.offscreen.getGraphics();
        og.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.paintRowBorder(og);
        if (this.isShowing()) {
            Rectangle cr;
            int ncomponents = this.lwComponents.size();
            Rectangle clip = og.getClipBounds();
            for (int i = ncomponents - 1; i >= 0; --i) {
                Rectangle cr2;
                Component comp = (Component)this.lwComponents.elementAt(i);
                if (comp == null || !comp.isVisible() || !(cr2 = comp.getBounds()).intersects(clip)) continue;
                Graphics cg = og.create(cr2.x, cr2.y, cr2.width, cr2.height);
                try {
                    comp.paint(cg);
                    continue;
                }
                finally {
                    cg.dispose();
                }
            }
            if (this.spinBtn != null && this.spinBtn.isVisible() && (cr = this.spinBtn.getBounds()).intersects(clip)) {
                Graphics cg = og.create(cr.x, cr.y, cr.width, cr.height);
                try {
                    this.spinBtn.paint(cg);
                }
                finally {
                    cg.dispose();
                }
            }
        }
        if (this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, null);
        }
        og.dispose();
    }

    protected void paintRowBorder(Graphics g) {
        Dimension rowLength = this.getSize();
        Color background = this.getBackground();
        if (background != null) {
            g.setColor(background);
            g.fillRect(0, 0, rowLength.width, rowLength.height);
        }
        int rowHeight = ((RowLayout)this.getLayout()).getRowHeight();
        Vector rowStarts = ((RowLayout)this.getLayout()).getRowStartPositions();
        int rowCount = rowStarts.size();
        Rectangle borderRect = new Rectangle(0, 0);
        Insets borderInsets = this.border.getInsets((Component)this);
        for (int i = 0; i < rowCount; ++i) {
            Point rowPos = (Point)rowStarts.elementAt(i);
            switch (this.orientation) {
                case 4: {
                    borderRect.x = 0;
                    borderRect.y = rowPos.y + rowHeight - borderInsets.top;
                    int rowY = rowPos.y + rowHeight;
                    borderRect.width = rowLength.width;
                    borderRect.height = rowLength.height;
                    break;
                }
                case 8: {
                    borderRect.x = 0;
                    borderRect.y = -10;
                    int rowY = rowPos.y + 10;
                    borderRect.width = rowLength.width;
                    borderRect.height = 10 + rowPos.y + borderInsets.bottom;
                    break;
                }
                case 1: {
                    borderRect.x = rowPos.x + rowHeight - borderInsets.left;
                    borderRect.y = 0;
                    int rowX = rowPos.x + rowHeight;
                    borderRect.width = rowLength.width;
                    borderRect.height = rowLength.height;
                    break;
                }
                case 2: {
                    borderRect.x = -10;
                    borderRect.y = 0;
                    int rowX = rowPos.x + 10;
                    borderRect.width = 10 + rowPos.x + borderInsets.right;
                    borderRect.height = rowLength.height;
                }
            }
            this.border.drawInRect(g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
        }
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object eSource = event.getSource();
        if (eSource == this.tabSelectionGroup) {
            if (event.getPropertyName() != null && event.getPropertyName().equals("selectedIndex")) {
                this.firePropertyChange("selectedIndex", event.getOldValue(), event.getNewValue());
            } else if (event.getPropertyName() != null && event.getPropertyName().equals("selectedItem")) {
                this.firePropertyChange("selectedItem", event.getOldValue(), event.getNewValue());
            }
            this.firePropertyChange("selectionGroup", null, this.tabSelectionGroup);
        } else if (!this.modelInvoked && eSource instanceof TabButtonInterface && eSource instanceof Component && ((Component)eSource).getParent() == this && event.getPropertyName() != null && event.getPropertyName().equals("item")) {
            int index = this.tabSelectionGroup.getIndex((SelectableInterface)eSource);
            ModelInterface model = this.getModelInterface();
            if (model instanceof OrderedCollectionInterface) {
                this.viewerInvoked = true;
                ((OrderedCollectionInterface)model).set(index, ((SelectableInterface)eSource).getItem());
            }
        } else if (eSource == this.displayTransform) {
            this.firePropertyChange("displayTransform", null, this.displayTransform);
        } else if (eSource == this.inputTransform) {
            this.firePropertyChange("inputTransform", null, this.inputTransform);
        } else if (eSource == this.outputTransform) {
            this.firePropertyChange("outputTransform", null, this.outputTransform);
        } else if (eSource == this.border) {
            this.invalidate();
            this.validate();
            this.repaint();
            this.firePropertyChange("rowBorder", null, this.border);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListener);
        AWTEventMulticaster2.save(s, "itemL", this.itemListener);
        s.writeObject(null);
    }

    @Override
    public void validateObject() {
        super.validateObject();
        if (this.tabSelectionGroup != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.tabSelectionGroup, (PropertyChangeListener)((Object)this));
        }
        if (this.displayTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)((Object)this));
        }
        if (this.inputTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)((Object)this));
        }
        if (this.outputTransform != null) {
            com.sas.beans.Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)((Object)this));
        }
        if (this.lwComponents != null) {
            Enumeration tabCompsEnum = this.lwComponents.elements();
            while (tabCompsEnum.hasMoreElements()) {
                Object tab = tabCompsEnum.nextElement();
                if (!(tab instanceof TabButtonInterface)) continue;
                com.sas.beans.Util.addPropertyChangeListener(tab, (PropertyChangeListener)((Object)this));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        RowLayout rowLayout;
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        if (this.border == null) {
            this.border = this.rowBorder;
            this.rowBorder = null;
        }
        this.prevSize = new Dimension();
        this.noPrevAdd = false;
        try {
            this.tabButtonClass = GlobalInfoTable.loadClass((String)this.tabButtonClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("TabBar: exception thrown in tabButtonClass creation");
        }
        LayoutManager layout = this.getLayout();
        if (layout instanceof RowLayout && (rowLayout = (RowLayout)layout).getThresholdCount() == 0) {
            rowLayout.setThresholdCount(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            try {
                if (model instanceof OrderedCollectionInterface) {
                    ((OrderedCollectionInterface)model).addContentsChangedListener((ContentsChangedListener)this);
                }
                int modelCount = ((StaticOrderedCollectionInterface)model).count();
                int componentCount = this.tabSelectionGroup.count();
                int n = 0;
                Enumeration groupE = this.tabSelectionGroup.getItems();
                Enumeration modelE = ((StaticOrderedCollectionInterface)model).getItems();
                while (n < modelCount || n < componentCount) {
                    if (n < componentCount && n < modelCount) {
                        ((SelectableInterface)groupE.nextElement()).setItem(modelE.nextElement());
                        ++n;
                        continue;
                    }
                    if (n < componentCount && n >= modelCount) {
                        this.modelInvoked = true;
                        this.remove(n);
                        componentCount = this.tabSelectionGroup.count();
                        continue;
                    }
                    if (n >= componentCount && n < modelCount) {
                        this.addModelItem(modelE.nextElement(), new Integer(0), -1);
                        ++n;
                        continue;
                    }
                    ++n;
                }
                this.validate();
            }
            finally {
                this.viewerInvoked = false;
            }
        }
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Component comp) {
        try {
            int index;
            ModelInterface model = this.getModelInterface();
            if (model instanceof OrderedCollectionInterface && (index = this.tabSelectionGroup.getIndex((SelectableInterface)((Object)comp))) != -1) {
                ((OrderedCollectionInterface)model).removeAt(index);
            }
        }
        finally {
            this.modelInvoked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(int index) {
        block6: {
            try {
                ModelInterface model = this.getModelInterface();
                if (model == null || this.modelInvoked) {
                    Component comp = (Component)this.tabSelectionGroup.get(index);
                    this.tabSelectionGroup.removeAt(index);
                    this.lwComponents.removeElement(comp);
                    super.remove(index + 1);
                    this.validate();
                    this.repaint();
                    if (!this.isDesignTime()) break block6;
                    Enumeration comps = RunningObjectTable.getComponents();
                    while (comps.hasMoreElements()) {
                        Object compInIDE = comps.nextElement();
                        if (compInIDE != comp) continue;
                        IDEDnDManager.removeComponentFromIDE(new Frame(), comp);
                        break block6;
                    }
                    break block6;
                }
                if (model instanceof OrderedCollectionInterface) {
                    ((OrderedCollectionInterface)model).removeAt(index);
                }
            }
            finally {
                this.modelInvoked = false;
            }
        }
    }

    @Override
    public synchronized void removeItem(Object item) {
        ModelInterface model = this.getModelInterface();
        if (model == null) {
            int index = this.tabSelectionGroup.getItemIndex(item);
            this.remove(index);
        } else if (model instanceof OrderedCollectionInterface) {
            Object itemData = item;
            if (this.inputTransform != null) {
                try {
                    itemData = this.inputTransform.transform(itemData);
                }
                catch (TransformException te) {
                    System.out.println("TransformException in RadioBox::removeItem( Object ) ");
                }
            }
            ((OrderedCollectionInterface)model).remove(itemData);
        }
    }

    @Override
    public synchronized void removeAll() {
        try {
            ModelInterface model = this.getModelInterface();
            if (model == null || this.modelInvoked) {
                this.tabSelectionGroup.removeAll();
                super.removeAll();
                super.add(this.spinBtn);
                this.validate();
                this.lwComponents.removeAllElements();
                this.repaint();
            } else if (model instanceof OrderedCollectionInterface) {
                ((OrderedCollectionInterface)model).removeAll();
            }
        }
        finally {
            this.modelInvoked = false;
        }
    }

    protected void reorderComponents() {
        Vector group;
        int tabIndex;
        int rowIndex;
        int grpIndex;
        if (this.selectedComponent == null) {
            return;
        }
        RowLayout layout = (RowLayout)this.getLayout();
        if (layout.getRowStyle() == 1 && (grpIndex = layout.getGroupIndex(this.selectedComponent)) >= 0 && ((rowIndex = layout.getRowIndex(grpIndex, tabIndex = (group = layout.getGroup(grpIndex)).indexOf(this.selectedComponent))) != this.prevRow && rowIndex >= 0 || grpIndex != this.prevGroup)) {
            this.prevRow = rowIndex;
            this.prevGroup = grpIndex;
            layout.setFirstRow(rowIndex);
            layout.setFirstGroup(grpIndex);
            this.invalidate();
            this.validate();
            this.lwComponents.removeAllElements();
            Vector groups = layout.getAllGroups();
            for (int i = 0; i < groups.size(); ++i) {
                this.lwComponents.addElement(groups.elementAt(i));
            }
        }
        this.lwComponents.removeElement(this.selectedComponent);
        if (this.selectedComponent.getParent() == this) {
            this.lwComponents.insertElementAt(this.selectedComponent, 0);
        }
    }

    @Override
    public void setBackground(Color c) {
        if (c != this.getBackground()) {
            Color oldColor = this.getBackground();
            super.setBackground(c);
            Enumeration e = this.tabSelectionGroup.getItems();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                ((Component)comp).setBackground(c);
            }
            this.firePropertyChange("background", oldColor, c);
        }
    }

    @Override
    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            Color oldColor = this.getForeground();
            super.setForeground(c);
            Enumeration e = this.tabSelectionGroup.getItems();
            while (e.hasMoreElements()) {
                Object comp = e.nextElement();
                ((Component)comp).setForeground(c);
            }
            this.firePropertyChange("foreground", oldColor, c);
        }
    }

    public void setBottomMargin(int margin) {
        if (margin != this.getBottomMargin()) {
            int prevMargin = this.getBottomMargin();
            ((RowLayout)this.getLayout()).setBottomMargin(margin);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("bottomMargin", new Integer(prevMargin), new Integer(margin));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.lwComponents = new Vector();
        this.tabButtonClassName = defaultTabButtonClass;
        this.tabButtonClass = GlobalInfoTable._loadClass((String)defaultTabButtonClass);
        this.tabSelectionGroup = new SelectionGroup();
        this.noPrevAdd = true;
        this.prevSize = new Dimension();
        this.tabSelectionGroup.addItemListener(this);
        com.sas.beans.Util.addPropertyChangeListener((Object)this.tabSelectionGroup, (PropertyChangeListener)((Object)this));
        this.style = 0;
        this.orientation = 4;
        RowLayout layout = new RowLayout(0, 1, 4, 2, 0, -4, -6);
        this.setLayout((LayoutManager)layout);
        layout.setComponentSize(new Dimension(75, 23));
        this.border = new BaseBorder(4);
        this.modelInvoked = false;
        this.viewerInvoked = false;
        this.spinBtn = new SpinButton();
        this.spinBtn.initialize();
        this.spinBtn.setOrientation(0);
        this.spinBtn.setMinimum(0);
        this.spinBtn.setMaximum(1);
        this.spinBtn.setValue(0);
        this.spinBtnOrientation = 8;
        this.spinBtnAlignment = 2;
        this.spinBtn.addAdjustmentListener(this);
        this.spinBtnSize = new Dimension(30, 18);
        super.add(this.spinBtn);
        this.setIDEDnDDropTarget(false);
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (transform != this.displayTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)((Object)this));
            }
            if (this.displayTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.displayTransform, (PropertyChangeListener)((Object)this));
            }
            this.tabSelectionGroup.setDisplayTransform(this.displayTransform);
            this.firePropertyChange("displayTransform", oldTransform, transform);
        }
    }

    public void setFillFrom(int direction) {
        if (direction != this.getFillFrom()) {
            int prevFillFrom = this.getFillFrom();
            ((RowLayout)this.getLayout()).setFillFrom(direction);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("fillFrom", new Integer(prevFillFrom), new Integer(direction));
        }
    }

    public void setInputTransform(TransformInterface transform) {
        if (transform != this.inputTransform) {
            TransformInterface oldTransform = this.inputTransform;
            this.inputTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)((Object)this));
            }
            if (this.inputTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.inputTransform, (PropertyChangeListener)((Object)this));
            }
            this.tabSelectionGroup.setInputTransform(this.inputTransform);
            this.firePropertyChange("inputTransform", oldTransform, transform);
        }
    }

    public void setJustification(int justify) {
        if (justify != this.getJustification()) {
            int prevJustification = this.getJustification();
            ((RowLayout)this.getLayout()).setJustification(justify);
            if (justify == 1) {
                this.setSpinButtonAlignment(2);
            } else if (justify == 2) {
                this.setSpinButtonAlignment(1);
            }
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("justification", new Integer(prevJustification), new Integer(justify));
        }
    }

    public void setLeftMargin(int margin) {
        if (margin != this.getLeftMargin()) {
            int prevMargin = this.getLeftMargin();
            ((RowLayout)this.getLayout()).setLeftMargin(margin);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("leftMargin", new Integer(prevMargin), new Integer(margin));
        }
    }

    @Override
    public void setOrientation(int orient) {
        if (this.orientation != orient) {
            int prevOrient = this.orientation;
            ((RowLayout)this.getLayout()).setOrientation(orient);
            for (int i = 0; i < this.lwComponents.size(); ++i) {
                TabButton comp = (TabButton)this.lwComponents.elementAt(i);
                comp.setOrientation(orient);
            }
            switch (orient) {
                case 2: {
                    this.setSpinButtonOrientation(1);
                    this.spinBtn.setOrientation(1);
                    if (this.orientation != 4 && this.orientation != 8) break;
                    this.spinBtn.swapButtonFunction();
                    break;
                }
                case 1: {
                    this.setSpinButtonOrientation(2);
                    this.spinBtn.setOrientation(1);
                    if (this.orientation != 4 && this.orientation != 8) break;
                    this.spinBtn.swapButtonFunction();
                    break;
                }
                case 4: {
                    this.setSpinButtonOrientation(8);
                    if (this.orientation == 1 || this.orientation == 2) {
                        this.spinBtn.swapButtonFunction();
                    }
                    this.spinBtn.setOrientation(0);
                    break;
                }
                case 8: {
                    this.setSpinButtonOrientation(4);
                    if (this.orientation == 1 || this.orientation == 2) {
                        this.spinBtn.swapButtonFunction();
                    }
                    this.spinBtn.setOrientation(0);
                }
            }
            this.orientation = orient;
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("orientation", new Integer(prevOrient), new Integer(this.orientation));
        }
    }

    public void setOutputTransform(TransformInterface transform) {
        if (transform != this.outputTransform) {
            TransformInterface oldTransform = this.outputTransform;
            this.outputTransform = transform;
            if (oldTransform != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)oldTransform, (PropertyChangeListener)((Object)this));
            }
            if (this.outputTransform != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.outputTransform, (PropertyChangeListener)((Object)this));
            }
            this.tabSelectionGroup.setOutputTransform(this.outputTransform);
            this.firePropertyChange("outputTransform", oldTransform, transform);
        }
    }

    public void setRightMargin(int margin) {
        if (margin != this.getRightMargin()) {
            int prevMargin = this.getRightMargin();
            ((RowLayout)this.getLayout()).setRightMargin(margin);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("rightMargin", new Integer(prevMargin), new Integer(margin));
        }
    }

    @Override
    public void setRowBorder(BorderInterface border) {
        if (this.border != border) {
            BorderInterface prevRowBorder = this.border;
            this.border = border;
            if (prevRowBorder != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)prevRowBorder, (PropertyChangeListener)((Object)this));
            }
            if (this.border != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.border, (PropertyChangeListener)((Object)this));
            }
            this.firePropertyChange("rowBorder", prevRowBorder, this.border);
        }
    }

    public void setRowSpacing(int spacing) {
        if (spacing != this.getRowSpacing()) {
            int prevRowSpacing = this.getRowSpacing();
            ((RowLayout)this.getLayout()).setRowSpacing(spacing);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("rowSpacing", new Integer(prevRowSpacing), new Integer(this.getRowSpacing()));
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        this.tabSelectionGroup.setSelectedIndex(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        this.tabSelectionGroup.setSelectedItem(item);
    }

    public synchronized void setSelectionGroup(SelectionGroupInterface selectionGrp) {
        if (selectionGrp != null && selectionGrp != this.tabSelectionGroup) {
            this.tabSelectionGroup.removeItemListener(this);
            Enumeration tabsE = this.tabSelectionGroup.getItems();
            while (tabsE.hasMoreElements()) {
                selectionGrp.add((SelectableInterface)tabsE.nextElement());
            }
            SelectionGroupInterface prevSelectionGrp = this.tabSelectionGroup;
            this.tabSelectionGroup = selectionGrp;
            this.tabSelectionGroup.addItemListener(this);
            if (prevSelectionGrp != null) {
                com.sas.beans.Util.removePropertyChangeListener((Object)prevSelectionGrp, (PropertyChangeListener)((Object)this));
            }
            if (this.tabSelectionGroup != null) {
                com.sas.beans.Util.addPropertyChangeListener((Object)this.tabSelectionGroup, (PropertyChangeListener)((Object)this));
            }
            this.firePropertyChange("selectionGroup", prevSelectionGrp, this.tabSelectionGroup);
        }
    }

    public void setSizing(int sizing) {
        if (sizing != this.getSizing()) {
            int prevSizing = this.getSizing();
            ((RowLayout)this.getLayout()).setSizing(sizing);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("sizing", new Integer(prevSizing), new Integer(sizing));
        }
    }

    public void setTabSpacing(int spacing) {
        if (spacing != this.getTabSpacing()) {
            int prevSpacing = this.getTabSpacing();
            ((RowLayout)this.getLayout()).setSpacing(spacing);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("tabSpacing", new Integer(prevSpacing), new Integer(spacing));
        }
    }

    public void setSpinButtonGap(int gap) {
        if (this.spinBtnGap != gap) {
            int prevSpinBtnGap = this.spinBtnGap;
            this.spinBtnGap = gap;
            if (this.style == 0) {
                this.invalidate();
                this.validate();
            }
            this.firePropertyChange("spinButtonGap", new Integer(prevSpinBtnGap), new Integer(this.spinBtnGap));
        }
    }

    public void setSpinButtonAlignment(int align) {
        if (align != this.spinBtnAlignment) {
            RowLayout layout = (RowLayout)this.getLayout();
            switch (this.spinBtnOrientation) {
                case 1: 
                case 2: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setTopMargin(0);
                        break;
                    }
                    layout.setBottomMargin(0);
                    break;
                }
                case 4: 
                case 8: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setLeftMargin(0);
                        break;
                    }
                    layout.setRightMargin(0);
                }
            }
            int prevSpinBtnAlign = this.spinBtnAlignment;
            this.spinBtnAlignment = align;
            if (this.style == 0) {
                this.invalidate();
                this.validate();
            }
            this.firePropertyChange("spinButtonAlignment", new Integer(prevSpinBtnAlign), new Integer(this.spinBtnAlignment));
        }
    }

    protected void setSpinButtonOrientation(int orient) {
        if (orient != this.spinBtnOrientation) {
            RowLayout layout = (RowLayout)this.getLayout();
            switch (this.spinBtnOrientation) {
                case 1: 
                case 2: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setTopMargin(0);
                        break;
                    }
                    layout.setBottomMargin(0);
                    break;
                }
                case 4: 
                case 8: {
                    if (this.spinBtnAlignment == 1) {
                        layout.setLeftMargin(0);
                        break;
                    }
                    layout.setRightMargin(0);
                }
            }
            int prevSpinBtnOrient = this.spinBtnOrientation;
            this.spinBtnOrientation = orient;
            if (this.style == 0) {
                this.invalidate();
                this.validate();
            }
            this.firePropertyChange("spinButtonOrientation", new Integer(prevSpinBtnOrient), new Integer(this.spinBtnOrientation));
        }
    }

    public void setStartIndex(int start) {
        if (start != this.getStartIndex()) {
            int prevStartIndex = this.getStartIndex();
            ((RowLayout)this.getLayout()).setStartIndex(start);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("startIndex", new Integer(prevStartIndex), new Integer(start));
        }
    }

    @Override
    public void setStyle(int newStyle) {
        if (this.style != newStyle) {
            int prevStyle = this.style;
            this.style = newStyle;
            RowLayout layout = (RowLayout)this.getLayout();
            if (this.style == 0) {
                this.spinBtn.setMinimum(0);
                this.spinBtn.setMaximum(this.lwComponents.size());
                this.spinBtn.setValue(0);
                this.spinBtn.setVisible(true);
                layout.setStartIndex(0);
                layout.setRowStyle(0);
            } else {
                this.spinBtn.setVisible(false);
                switch (this.spinBtnOrientation) {
                    case 1: 
                    case 2: {
                        if (this.spinBtnAlignment == 1) {
                            layout.setTopMargin(0);
                            break;
                        }
                        layout.setBottomMargin(0);
                        break;
                    }
                    case 4: 
                    case 8: {
                        if (this.spinBtnAlignment == 1) {
                            layout.setLeftMargin(0);
                            break;
                        }
                        layout.setRightMargin(0);
                    }
                }
                layout.setStartIndex(0);
                layout.setRowStyle(1);
            }
            this.invalidate();
            this.validate();
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
                parent.validate();
            } else {
                this.validate();
            }
            this.reorderComponents();
            this.firePropertyChange("style", new Integer(prevStyle), new Integer(this.style));
        }
    }

    @Override
    public void setTabButtonClass(Class tClass) {
        if (tClass != null && tClass != this.tabButtonClass) {
            Class oldTabButtonClass = this.tabButtonClass;
            try {
                Class tabButtonInterfaceClass = GlobalInfoTable.loadClass((String)"com.sas.visuals.TabButtonInterface");
                Class<Component> componentClass = Component.class;
                if (!componentClass.isAssignableFrom(tClass) || !tabButtonInterfaceClass.isAssignableFrom(tClass)) {
                    return;
                }
                this.tabButtonClass = tClass;
                this.tabButtonClassName = this.tabButtonClass.getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("TabBar: exception thrown in setTabButtonClass()");
                return;
            }
            this.firePropertyChange("tabButtonClass", oldTabButtonClass, this.tabButtonClass);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            if (this.lwComponents != null) {
                for (int i = 0; i < this.lwComponents.size(); ++i) {
                    ((Component)this.lwComponents.elementAt(i)).setEnabled(enabled);
                }
                this.spinBtn.setEnabled(enabled);
                if (enabled) {
                    RowLayout layout = (RowLayout)this.getLayout();
                    this.spinBtn.setIncrementEnabled(layout.isIncrementable());
                    this.spinBtn.setDecrementEnabled(layout.isDecrementable());
                }
            }
        }
    }

    @Override
    public void setTabEnabled(boolean enabled, Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        this.setTabEnabled(enabled, index);
    }

    @Override
    public void setTabEnabled(boolean enabled, int index) {
        if (index < this.lwComponents.size() && index >= 0) {
            Component comp = this.getComponent(index + 1);
            comp.setEnabled(enabled);
            comp.repaint();
        }
    }

    public void setTabSize(Dimension size) {
        if (size != null && !size.equals(this.getTabSize())) {
            Dimension prevTabSize = this.getTabSize();
            ((RowLayout)this.getLayout()).setComponentSize(size);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("tabSize", prevTabSize, size);
        }
    }

    @Override
    public void setTabVisible(boolean visible, Object item) {
        int index = this.tabSelectionGroup.getItemIndex(item);
        this.setTabVisible(visible, index);
    }

    @Override
    public void setTabVisible(boolean visible, int index) {
        if (index < this.lwComponents.size() && index >= 0) {
            Component comp = this.getComponent(index + 1);
            comp.setVisible(visible);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.repaint();
        }
    }

    public void setTopMargin(int margin) {
        if (margin != this.getTopMargin()) {
            int prevMargin = this.getTopMargin();
            ((RowLayout)this.getLayout()).setTopMargin(margin);
            this.invalidate();
            this.validate();
            this.reorderComponents();
            this.firePropertyChange("topMargin", new Integer(prevMargin), new Integer(margin));
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

