/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.AWTEventMulticaster2;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StringCollection;
import com.sas.util.CharBuffer;
import com.sas.visuals.LabelView;
import com.sas.visuals.TextElement;
import com.sas.visuals.TextPositionMouseAdapter;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StyledLabelView
extends LabelView {
    static final long serialVersionUID = 5733843951012358858L;
    transient TextElement textElements;
    transient TextPositionMouseAdapter textPositionMouseAdapter;
    transient String actionCommand;
    transient ActionListener actionListenerList;
    private static int defaultHeight = 46;
    private static int defaultWidth = 124;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = "Multi-line with style tags text label";
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public StyledLabelView() {
    }

    public StyledLabelView(String text) {
        super(text);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, listener);
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        if (this.getText() == null) {
            return;
        }
        if (this.currentTextSize == null) {
            this.currentTextSize = this.calculateTextDisplay();
            if (this.currentTextSize == null) {
                return;
            }
        }
        Point initPoint = this.getInitialPoint(x, y, width, height);
        Rectangle clipBounds = g.getClipBounds();
        Dimension size = this.getSize();
        g.clipRect(0, 0, size.width, size.height);
        this.paintTextElements(g, this.textElements, initPoint.x, initPoint.y);
        g.setClip(clipBounds);
    }

    protected void paintTextElements(Graphics g, TextElement element, int x, int y) {
        if (element.isSubElementsSet()) {
            OrderedCollectionInterface subElements = element.getSubElements();
            int count = subElements.count();
            for (int i = 0; i < count; ++i) {
                this.paintTextElements(g, (TextElement)((Object)subElements.get(i)), x, y);
            }
        } else {
            this.paintTextElement(g, element, x, y);
        }
    }

    protected void paintTextElement(Graphics g, TextElement element, int x, int y) {
        if (!(element.isTextSet() && element.isDisplayLocationSet() && element.isDisplaySizeSet())) {
            return;
        }
        Point elementLocation = element.getDisplayLocation();
        Dimension elementSize = element.getDisplaySize();
        String txt = element.getText();
        Font font = (Font)element.get("font", this.getFont());
        Color color = (Color)element.get("color", this.getForeground());
        if (color == null) {
            color = Color.black;
        }
        g.setFont(font);
        g.setColor(color);
        boolean underlined = false;
        if (element.isUnderlinedSet()) {
            underlined = element.isUnderlined();
        }
        int startX = x + elementLocation.x;
        int startY = y + elementLocation.y;
        Util.drawString(g, txt, startX, startY, this.isEnabled());
        if (underlined) {
            FontMetrics fontInfo = this.getFontMetrics(font);
            int descent = fontInfo.getDescent() - 1;
            g.drawLine(startX, startY + descent, startX + elementSize.width, startY + descent);
        }
    }

    protected Point getInitialPoint(int x, int y, int width, int height) {
        Insets insets = this.getInsets();
        Dimension paintSize = new Dimension();
        Point initPoint = new Point(x, y);
        paintSize.width = width - insets.left - insets.right;
        paintSize.height = height - insets.top - insets.bottom;
        if (this.vAlign == 256) {
            initPoint.y = (paintSize.height - this.currentTextSize.height) / 2 + y;
        } else if (this.vAlign == 8) {
            initPoint.y = paintSize.height - this.currentTextSize.height + y;
        }
        if (this.hAlign == 256) {
            initPoint.x = (paintSize.width - this.currentTextSize.width) / 2 + x;
        } else if (this.hAlign == 2) {
            initPoint.x = paintSize.width - this.currentTextSize.width + x;
        }
        return initPoint;
    }

    @Override
    protected void parseText() {
        String txt = this.getText();
        this.textElements = new TextElement();
        OrderedCollection lineElements = new OrderedCollection();
        this.multilineText = new StringCollection(txt, '\n');
        Font currentFont = this.getFont();
        Color currentColor = this.getForeground();
        boolean currentUnderlined = false;
        String currentActionCmd = null;
        if (currentFont == null) {
            currentFont = Util.getDialogFont();
            super.setFont(currentFont);
        }
        Font newFont = currentFont;
        Color newColor = currentColor;
        boolean underlinedOn = false;
        String actionCmd = null;
        for (int i = 0; i < this.multilineText.count(); ++i) {
            TextElement lineElement = new TextElement();
            OrderedCollection objectElements = new OrderedCollection();
            CharBuffer textLine = new CharBuffer((String)this.multilineText.get(i));
            int currentIndex = 0;
            int startIndex = 0;
            int endIndex = 0;
            TextElement objectElement = new TextElement();
            while (currentIndex < textLine.length()) {
                if (textLine.charAt(currentIndex) == '<') {
                    int actionIndex;
                    boolean objectDone = false;
                    if (currentIndex + 1 < textLine.length() && textLine.charAt(currentIndex + 1) == '/') {
                        if (textLine.toString().regionMatches(currentIndex, "</u>", 0, 3)) {
                            objectDone = true;
                            underlinedOn = false;
                            textLine.remove(currentIndex, currentIndex + 4);
                        } else if (textLine.toString().regionMatches(currentIndex, "</color>", 0, 7)) {
                            objectDone = true;
                            newColor = this.getForeground();
                            textLine.remove(currentIndex, currentIndex + 8);
                        } else if (textLine.toString().regionMatches(currentIndex, "</font>", 0, 6)) {
                            objectDone = true;
                            newFont = this.getFont();
                            textLine.remove(currentIndex, currentIndex + 7);
                        } else if (textLine.toString().regionMatches(currentIndex, "</action>", 0, 8)) {
                            objectDone = true;
                            actionCmd = null;
                            textLine.remove(currentIndex, currentIndex + 9);
                        }
                    } else if (textLine.toString().regionMatches(currentIndex, "<u>", 0, 3)) {
                        underlinedOn = true;
                        objectDone = true;
                        textLine.remove(currentIndex, currentIndex + 3);
                    } else if (textLine.toString().regionMatches(currentIndex, "<color:", 0, 7)) {
                        int colorIndex = textLine.indexOf('>', currentIndex);
                        if (colorIndex != -1) {
                            try {
                                String colorString = textLine.substring(currentIndex + 7, colorIndex);
                                colorString.trim();
                                newColor = Color.decode(colorString);
                                objectDone = true;
                                textLine.remove(currentIndex, colorIndex + 1);
                            }
                            catch (NumberFormatException e) {
                                System.out.println("exception " + e);
                                textLine.remove(currentIndex, colorIndex + 1);
                                newColor = currentColor;
                            }
                        }
                    } else if (textLine.toString().regionMatches(currentIndex, "<font:", 0, 6)) {
                        int fontIndex = textLine.indexOf('>', currentIndex);
                        if (fontIndex != -1) {
                            String fontString = textLine.substring(currentIndex + 6, fontIndex);
                            fontString.trim();
                            newFont = Font.decode(fontString);
                            objectDone = true;
                            textLine.remove(currentIndex, fontIndex + 1);
                        }
                    } else if (textLine.toString().regionMatches(currentIndex, "<action:", 0, 8) && (actionIndex = textLine.indexOf('>', currentIndex)) != -1) {
                        String actionString = textLine.substring(currentIndex + 8, actionIndex);
                        actionCmd = actionString.trim();
                        objectDone = true;
                        textLine.remove(currentIndex, actionIndex + 1);
                    }
                    if (objectDone) {
                        int newEndIndex = currentIndex - 1;
                        if (newEndIndex > 0 && endIndex != newEndIndex) {
                            endIndex = newEndIndex;
                            String newText = textLine.substring(startIndex, currentIndex);
                            objectElement.setText(newText);
                            startIndex = currentIndex;
                            objectElement.setFont(currentFont);
                            objectElement.setColor(currentColor);
                            objectElement.setUnderlined(currentUnderlined);
                            if (currentActionCmd != null) {
                                objectElement.setActionCommand(currentActionCmd);
                            }
                            objectElements.add((Object)objectElement);
                            objectElement = new TextElement();
                        }
                        currentFont = newFont;
                        currentColor = newColor;
                        currentUnderlined = underlinedOn;
                        currentActionCmd = actionCmd;
                        continue;
                    }
                    ++currentIndex;
                    continue;
                }
                ++currentIndex;
            }
            if (startIndex < currentIndex) {
                objectElement.setText(textLine.substring(startIndex, -1));
                objectElement.setFont(currentFont);
                objectElement.setColor(currentColor);
                objectElement.setUnderlined(currentUnderlined);
                if (currentActionCmd != null) {
                    objectElement.setActionCommand(currentActionCmd);
                }
                objectElements.add((Object)objectElement);
            }
            lineElement.setText(textLine.toString());
            lineElement.setSubElements((OrderedCollectionInterface)objectElements);
            lineElements.add((Object)lineElement);
        }
        this.textElements.setSubElements((OrderedCollectionInterface)lineElements);
    }

    private void dumpTextElements() {
        System.out.println(" dumpTextElements ");
        if (!this.textElements.isSubElementsSet()) {
            return;
        }
        OrderedCollectionInterface lineElements = this.textElements.getSubElements();
        for (int k = 0; k < lineElements.count(); ++k) {
            TextElement lineElem = (TextElement)((Object)lineElements.get(k));
            OrderedCollectionInterface objElements = lineElem.getSubElements();
            System.out.println(" Line " + k);
            for (int j = 0; j < objElements.count(); ++j) {
                TextElement element = (TextElement)((Object)objElements.get(j));
                System.out.println(j + " text = " + element.getText());
                System.out.println(j + " size = " + element.get("displaySize", new Dimension(-1, -1)));
                System.out.println(j + " location = " + element.get("displayLocation", new Point(-1, -1)));
                System.out.println(j + " underlined = " + element.get("underlined"));
                System.out.println(j + " color = " + element.get("color"));
                System.out.println(j + " font = " + element.get("font"));
                if (!element.isActionCommandSet()) continue;
                System.out.println(j + " actionCommand = " + element.get("actionCommand"));
            }
        }
    }

    @Override
    protected Dimension calculateTextDisplay() {
        if (this.textElements != null) {
            int i;
            FontMetrics currentFontInfo;
            Font currentFont = this.getFont();
            FontMetrics fontInfo = currentFontInfo = this.getFontMetrics(currentFont);
            int fontAscent = currentFontInfo.getAscent();
            int fontDescent = currentFontInfo.getDescent();
            int fontHeight = currentFontInfo.getHeight();
            int curPos = 0;
            int maxWidth = 0;
            if (!this.textElements.isSubElementsSet()) {
                return null;
            }
            OrderedCollectionInterface lineElements = this.textElements.getSubElements();
            for (i = 0; i < lineElements.count(); ++i) {
                int lineHeight = 0;
                int lineWidth = 0;
                int lineAscent = 0;
                TextElement lineElement = (TextElement)((Object)lineElements.get(i));
                OrderedCollectionInterface objectElements = lineElement.getSubElements();
                for (int j = 0; j < objectElements.count(); ++j) {
                    TextElement objectElement = (TextElement)((Object)objectElements.get(j));
                    Font f = objectElement.getFont();
                    fontInfo = f.equals(currentFont) ? currentFontInfo : this.getFontMetrics(f);
                    fontAscent = fontInfo.getAscent();
                    fontDescent = fontInfo.getDescent();
                    fontHeight = fontInfo.getHeight();
                    Dimension textSize = new Dimension(fontInfo.stringWidth(objectElement.getText()), fontHeight);
                    Point textLocation = new Point(lineWidth, 0);
                    objectElement.setDisplaySize(textSize);
                    objectElement.setDisplayLocation(textLocation);
                    lineWidth += textSize.width;
                    if (fontHeight > lineHeight) {
                        lineHeight = fontHeight;
                    }
                    if (fontAscent <= lineAscent) continue;
                    lineAscent = fontAscent;
                }
                lineElement.setDisplaySize(new Dimension(lineWidth, lineHeight));
                lineElement.setDisplayLocation(new Point(0, lineAscent + curPos));
                if (lineWidth > maxWidth) {
                    maxWidth = lineWidth;
                }
                curPos += lineHeight;
            }
            for (i = 0; i < lineElements.count(); ++i) {
                TextElement lineElement = (TextElement)((Object)lineElements.get(i));
                Dimension lineSize = lineElement.getDisplaySize();
                Point lineLocation = lineElement.getDisplayLocation();
                if (this.getHorizontalAlignment() == 256) {
                    lineLocation.x = (maxWidth - lineSize.width) / 2;
                } else if (this.hAlign == 2) {
                    lineLocation.x = maxWidth - lineSize.width;
                }
                lineElement.setDisplayLocation(lineLocation);
                OrderedCollectionInterface objectElements = lineElement.getSubElements();
                for (int j = 0; j < objectElements.count(); ++j) {
                    TextElement objectElement = (TextElement)((Object)objectElements.get(j));
                    Point objectLocation = objectElement.getDisplayLocation();
                    objectLocation.x += lineLocation.x;
                    objectLocation.y = lineLocation.y;
                    objectElement.setDisplayLocation(objectLocation);
                }
            }
            return new Dimension(maxWidth, curPos);
        }
        return null;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(e);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            s.readObject();
        }
        this.textPositionMouseAdapter = new TextPositionMouseAdapter(this);
        this.addMouseListener(this.textPositionMouseAdapter);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListenerList);
        s.writeObject(null);
    }

    TextElement getTextElement() {
        return this.textElements;
    }

    @Override
    public void setDefaultValues() {
        this.textElements = null;
        super.setDefaultValues();
        this.textPositionMouseAdapter = new TextPositionMouseAdapter(this);
        this.addMouseListener(this.textPositionMouseAdapter);
    }

    @Override
    public void setForeground(Color fgColor) {
        super.setForeground(fgColor);
        this.refresh();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.refresh();
    }

    @Override
    public void setHorizontalAlignment(int align) {
        super.setHorizontalAlignment(align);
        this.calculateTextDisplay();
    }
}

