/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.security.SecuritySupport;
import com.sas.visuals.ImageView;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Splash
implements Runnable {
    Thread m_thread = null;
    Container m_container;
    String m_imageName;
    Window m_window;
    Image m_image;
    int m_maxTime;
    int m_minTime;
    boolean m_complete = false;
    boolean m_blocked = true;

    public Splash(Container container, String imageName, int minMilliSeconds, int maxMilliSeconds) {
        this.m_container = container;
        this.m_imageName = imageName;
        this.m_minTime = minMilliSeconds;
        this.m_maxTime = maxMilliSeconds;
    }

    public Splash(Container container, String imageName) {
        this(container, imageName, 1500, 10000);
    }

    public Splash(Container container, Image image, int minMilliSeconds, int maxMilliSeconds) {
        this.m_container = container;
        this.m_image = image;
        this.m_minTime = minMilliSeconds;
        this.m_maxTime = maxMilliSeconds;
    }

    public Splash(Container container, Image image) {
        this(container, image, 1500, 10000);
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = SecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
        while (this.m_blocked) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public void stop() {
        this.m_blocked = false;
        this.dispose();
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
    }

    public void setComplete(boolean value) {
        this.m_complete = value;
    }

    @Override
    public void run() {
        boolean didLoad = false;
        if (this.m_container != null) {
            for (Container parent = this.m_container; parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Frame)) continue;
                didLoad = this.loadImage(this.m_imageName);
                if (!didLoad) break;
                this.createSplash((Frame)parent);
                break;
            }
        }
        this.m_blocked = false;
        if (didLoad) {
            int elapsed = 0;
            int cycle = 250;
            boolean forever = false;
            if (this.m_maxTime < 0) {
                forever = true;
            }
            while (forever || elapsed < this.m_maxTime) {
                try {
                    Thread.sleep(cycle);
                    elapsed += cycle;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (elapsed < this.m_minTime || !this.m_complete) continue;
            }
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadImage(String imageName) {
        boolean loaded = true;
        InputStream in = null;
        byte[] b = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return false;
        }
        if (this.m_image != null) {
            return true;
        }
        if (imageName == null) {
            return false;
        }
        if (this.m_container instanceof Applet) {
            try {
                Applet a = (Applet)this.m_container;
                URL imageURL = new URL(a.getCodeBase() + imageName);
                this.m_image = toolkit.getImage(imageURL);
            }
            catch (Exception a) {
                // empty catch block
            }
        }
        if (this.m_image == null) {
            try {
                in = ClassLoader.getSystemResourceAsStream(imageName);
                if (in != null) {
                    b = new byte[in.available()];
                    in.read(b);
                } else {
                    loaded = false;
                }
            }
            catch (IOException ex) {
                loaded = false;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!loaded) {
                return loaded;
            }
            this.m_image = toolkit.createImage(b);
        }
        return this.m_image != null;
    }

    protected void createSplash(Frame frame) {
        ImageView imageview = new ImageView(this.m_image);
        this.m_window = new SplashWindow(frame);
        this.m_window.add((Component)imageview, "Center");
        this.m_window.pack();
        Point p = null;
        try {
            p = frame.getLocationOnScreen();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Dimension fsize = frame.getSize();
        Dimension wsize = this.m_window.getSize();
        int w = -1;
        int h = -1;
        if (p != null) {
            w = p.x + fsize.width / 2 - wsize.width / 2;
            h = p.y + fsize.height / 2 - wsize.height / 2;
        }
        if (w < 0 || h < 0) {
            Dimension ssize = Toolkit.getDefaultToolkit().getScreenSize();
            w = ssize.width / 2 - wsize.width / 2;
            h = ssize.height / 2 - wsize.height / 2;
        }
        this.m_window.setLocation(w, h);
        imageview.repaint();
        this.show();
    }

    public void dispose() {
        if (this.m_window != null) {
            this.m_window.dispose();
            this.m_window = null;
        }
    }

    public void show() {
        if (this.m_window != null) {
            this.m_window.pack();
            this.m_window.toFront();
            this.m_window.setVisible(true);
            this.repaint();
        }
    }

    public void repaint() {
        if (this.m_window != null) {
            this.m_window.repaint();
        }
    }

    private class SplashWindow
    extends Window {
        public SplashWindow(Frame f) {
            super(f);
            this.setBackground(Color.black);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }
    }
}

