/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class SerialImage
implements Serializable {
    protected int _w;
    protected int _h;
    protected transient Image _image;
    protected transient int[] _pixels;
    protected boolean _isURL;
    protected String _filename;

    public SerialImage(Image image, Component c) {
        if (c != null) {
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image != null) {
            this._w = image.getWidth(c);
            this._h = image.getHeight(c);
            this._image = image;
        }
        this._filename = null;
        this._isURL = false;
    }

    public SerialImage(URL location, Component c) {
        this(Toolkit.getDefaultToolkit().getImage(location), c);
        this._filename = location.toExternalForm();
        this._isURL = true;
    }

    public SerialImage(String location, Component c) {
        this(Toolkit.getDefaultToolkit().getImage(location), c);
        this._filename = location;
        this._isURL = false;
    }

    public Image getImage() {
        if (this._image == null) {
            if (this._filename != null) {
                this._image = this.createImage(this._filename, this._isURL);
            } else if (this._pixels != null) {
                this._image = this.createImage(this._pixels, this._w, this._h);
            }
        }
        return this._image;
    }

    public Object getImageLocation() {
        if (this._isURL && this._filename != null) {
            try {
                return new URL(this._filename);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this._filename;
    }

    private Image createImage(String location, boolean urlString) {
        Image image = null;
        if (location != null) {
            if (urlString) {
                try {
                    URL url = new URL(location);
                    image = Toolkit.getDefaultToolkit().getImage(url);
                }
                catch (MalformedURLException e) {
                    System.out.println(e);
                }
            } else {
                image = Toolkit.getDefaultToolkit().getImage(location);
            }
        }
        return image;
    }

    private Image createImage(int[] pixels, int width, int height) {
        Image image = null;
        if (pixels != null) {
            MemoryImageSource mis = new MemoryImageSource(this._w, this._h, pixels, 0, this._w);
            image = Toolkit.getDefaultToolkit().createImage(mis);
        }
        return image;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this._filename == null) {
            byte[] bytes = new byte[this._w * this._h * 4];
            s.read(bytes);
            this._pixels = this.byteArrayToIntArray(bytes);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._image != null && this._filename == null) {
            int[] pixels = new int[this._w * this._h];
            PixelGrabber pg = new PixelGrabber(this._image, 0, 0, this._w, this._h, pixels, 0, this._w);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                return;
            }
            if ((pg.getStatus() & 0x80) != 0) {
                return;
            }
            if ((pg.getStatus() & 0x40) != 0) {
                return;
            }
            byte[] bytes = this.intArrayToByteArray(pixels);
            s.write(bytes);
        }
    }

    private byte[] intArrayToByteArray(int[] values) {
        byte[] b = new byte[values.length * 4];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            b[j++] = (byte)((values[i] >> 24) % 256);
            b[j++] = (byte)((values[i] >> 16) % 256);
            b[j++] = (byte)((values[i] >> 8) % 256);
            b[j++] = (byte)(values[i] % 256);
        }
        return b;
    }

    private int[] byteArrayToIntArray(byte[] bytes) {
        int j;
        byte[] b;
        int pad = bytes.length % 4;
        if (pad > 0) {
            b = new byte[bytes.length + pad];
            j = 0;
            for (int i = 0; i < b.length; ++i) {
                b[i] = i < pad ? (byte)0 : bytes[j++];
            }
        } else {
            b = bytes;
        }
        int[] values = new int[b.length / 4];
        j = 0;
        for (int i = 0; i < values.length; ++i) {
            int newval = b[j++];
            newval <<= 8;
            newval |= b[j++] & 0xFF;
            newval <<= 8;
            newval |= b[j++] & 0xFF;
            newval <<= 8;
            values[i] = newval |= b[j++] & 0xFF;
        }
        return values;
    }
}

