/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.PublicClonable;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.visuals.BaseButton;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.LabelView;
import com.sas.visuals.RB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PushButton
extends BaseButton
implements PublicClonable {
    static final long serialVersionUID = -2117134711200355878L;
    protected LabelView label;
    protected Point contentShift;
    private static int defaultHeight = 23;
    private static int defaultWidth = 75;
    public static String RB_KEY = "PushButton.";

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "source"}, {"Default value", ""}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"sourceSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"source.pd.txt")}, {"Property editor class", "com.sas.beans.editors._FileNameEditor"}}, {{"Name", "selectedIcon"}, {"Default value", "null"}, {"Expert", "true"}}, {{"Name", "contentShift"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"contentShift.pd.txt")}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.pd.txt");
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public PushButton() {
        this(null, null);
        if (this.isDesignTime()) {
            this.setItem(RB.getStringResource((String)RB_KEY, (String)"label.txt"));
        }
    }

    public PushButton(String txt) {
        this(txt, null);
    }

    public PushButton(IconInterface defaultImg) {
        this(null, defaultImg);
    }

    public PushButton(String txt, IconInterface defaultImg) {
        this.getBorder().setStyle(4);
        this.setHorizontalTextAlignment(256);
        this.setVerticalTextAlignment(256);
        this.setItem(txt);
        this.setDefaultIcon(defaultImg);
        this.setBackgroundColor(SystemColor.control);
        this.setTransparent(false);
        this.contentShift = new Point(1, 1);
    }

    @Override
    protected void buttonModelArmed(ButtonModelInterface btnModel) {
        if (btnModel.isArmed() && btnModel.isPressed()) {
            this.getBorder().setLightSource(10);
        } else {
            this.getBorder().setLightSource(5);
        }
        super.buttonModelArmed(btnModel);
    }

    @Override
    protected void buttonModelPressed(ButtonModelInterface btnModel) {
        if (btnModel.isArmed() && btnModel.isPressed()) {
            this.getBorder().setLightSource(10);
        } else {
            this.getBorder().setLightSource(5);
        }
        super.buttonModelPressed(btnModel);
    }

    public Point contentShift() {
        ButtonModelInterface btnModel = this.getButtonModel();
        Point cShift = new Point(0, 0);
        if (btnModel.isArmed() && btnModel.isPressed() && this.pressedIcon == null) {
            cShift.x = this.contentShift.x;
            cShift.y = this.contentShift.y;
        }
        return cShift;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PushButton clone = (PushButton)super.clone();
        clone.label = new LabelView(this.getText());
        clone.initialize();
        return clone;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension iconSize = new Dimension();
        Dimension textSize = new Dimension();
        if (this.getDefaultIcon() != null) {
            iconSize = this.getDefaultIcon().getPreferredSize();
        }
        if (this.label != null && this.getText() != null) {
            Font currentFont = this.getFont();
            Font labelFont = this.label.getFont();
            if (currentFont != null && !currentFont.equals(labelFont)) {
                this.label.setFont(currentFont);
            }
            textSize = this.label.getMinimumSize();
        }
        Dimension contentSize = this.getContentSize(textSize, iconSize);
        Dimension minimumSize = new Dimension();
        Insets newInsets = this.getInsets();
        int focusDist = 0;
        if (this.isFocusPainted()) {
            focusDist = this.getFocusGap();
        }
        minimumSize.width = 2 + contentSize.width + newInsets.left + newInsets.right + 2 * focusDist;
        minimumSize.height = 2 + contentSize.height + newInsets.top + newInsets.bottom + 2 * focusDist;
        return minimumSize;
    }

    @Override
    public void paint(Graphics g) {
        String currentText = this.getText();
        IconInterface defaultIcon = this.getDefaultIcon();
        IconInterface disabledIcon = this.getDisabledIcon();
        IconInterface rolloverIcon = this.getRolloverIcon();
        IconInterface pressedIcon = this.getPressedIcon();
        ButtonModelInterface btnModel = this.getButtonModel();
        Rectangle bounds = this.getBounds();
        if (!this.isTransparent()) {
            this.paintBackground(g);
        }
        Dimension contentSize = new Dimension();
        Dimension textSize = new Dimension();
        Dimension iconSize = new Dimension();
        if (currentText != null) {
            if (this.label.getFont() == null) {
                this.label.setFont(this.getFont());
            }
            textSize = this.label.getMinimumSize();
            contentSize.width = textSize.width;
            contentSize.height = textSize.height;
        }
        if (defaultIcon != null) {
            iconSize = defaultIcon.getPreferredSize();
            contentSize.width = iconSize.width;
            contentSize.height = iconSize.height;
        }
        Point textPoint = new Point(0, 0);
        Point iconPoint = new Point(0, 0);
        if (currentText != null && defaultIcon != null) {
            switch (this.getTextPosition()) {
                case 4: {
                    iconPoint.y = textSize.height + this.getIconTextGap();
                    if (textSize.width <= iconSize.width) {
                        textSize.width = iconSize.width;
                        break;
                    }
                    if (textSize.width <= iconSize.width) break;
                    iconPoint.x = (textSize.width - iconSize.width) / 2;
                    break;
                }
                case 8: {
                    textPoint.y = iconSize.height + this.getIconTextGap();
                    if (textSize.width <= iconSize.width) {
                        textSize.width = iconSize.width;
                        break;
                    }
                    if (textSize.width <= iconSize.width) break;
                    iconPoint.x = (textSize.width - iconSize.width) / 2;
                    break;
                }
                case 1: {
                    iconPoint.x = textSize.width + this.getIconTextGap();
                    if (textSize.height <= iconSize.height) {
                        textSize.height = iconSize.height;
                        break;
                    }
                    if (textSize.height <= iconSize.height) break;
                    iconPoint.y = (textSize.height - iconSize.height) / 2;
                    break;
                }
                case 2: {
                    textPoint.x = iconSize.width + this.getIconTextGap();
                    if (textSize.height <= iconSize.height) {
                        textSize.height = iconSize.height;
                        break;
                    }
                    if (textSize.height <= iconSize.height) break;
                    iconPoint.y = (textSize.height - iconSize.height) / 2;
                    break;
                }
            }
            contentSize = this.getContentSize(textSize, iconSize);
        }
        int contentGap = 1;
        if (this.isFocusPainted()) {
            contentGap = this.getFocusGap();
        }
        Insets newInsets = this.getInsets();
        Point cShift = this.contentShift();
        Point initPoint = new Point(contentGap + newInsets.left + cShift.x, contentGap + newInsets.top + cShift.y);
        int vAlign = this.getVerticalAlignment();
        int hAlign = this.getHorizontalAlignment();
        if (vAlign == 256) {
            initPoint.y = (bounds.height - contentSize.height) / 2 + cShift.y;
        } else if (vAlign == 8) {
            initPoint.y = bounds.height - initPoint.y + newInsets.top - newInsets.bottom - contentSize.height + 2 * cShift.y;
        }
        if (hAlign == 256) {
            initPoint.x = (bounds.width - contentSize.width) / 2 + cShift.x;
        } else if (hAlign == 2) {
            initPoint.x = bounds.width - initPoint.x + newInsets.left - newInsets.right - contentSize.width + 2 * cShift.x;
        }
        boolean disabled = btnModel.isDisabled();
        if (defaultIcon != null) {
            if (disabledIcon != null && disabled) {
                disabledIcon.paint((Component)this, g, initPoint.x + iconPoint.x, initPoint.y + iconPoint.y, iconSize.width, iconSize.height);
            } else if (btnModel.isPressed() && btnModel.isArmed() && pressedIcon != null) {
                pressedIcon.paint((Component)this, g, initPoint.x + iconPoint.x, initPoint.y + iconPoint.y, iconSize.width, iconSize.height);
            } else if (btnModel.isRollover() && rolloverIcon != null) {
                rolloverIcon.paint((Component)this, g, initPoint.x + iconPoint.x, initPoint.y + iconPoint.y, iconSize.width, iconSize.height);
            } else {
                defaultIcon.paint((Component)this, g, initPoint.x + iconPoint.x, initPoint.y + iconPoint.y, iconSize.width, iconSize.height);
            }
        }
        if (currentText != null && this.label != null) {
            this.label.setEnabled(!disabled);
            this.label.paint(this, g, initPoint.x + textPoint.x, initPoint.y + textPoint.y, textSize.width, textSize.height);
        }
        if (this.isBorderPainted()) {
            this.getBorder().drawInRect((Component)this, g, 0, 0, bounds.width, bounds.height);
        }
        if (this.isFocusPainted() && this.hasFocus && this.isEnabled()) {
            this.paintFocus(g);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.label != null) {
            Font currentFont = this.getFont();
            Font labelFont = this.label.getFont();
            if (currentFont != null && !currentFont.equals(labelFont)) {
                this.label.setFont(currentFont);
            }
        }
        if (this.contentShift == null) {
            this.contentShift = new Point(1, 1);
        }
    }

    protected void paintBackground(Graphics g) {
        Dimension size = this.getSize();
        Color prevColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(prevColor);
    }

    protected void paintFocus(Graphics g) {
        int borderInsetsWidth = 0;
        int borderInsetsHeight = 0;
        Insets borderInsets = this.getBorder().getInsets();
        Rectangle bounds = this.getBounds();
        Rectangle textRect = new Rectangle(0, 0, bounds.width, bounds.height);
        if (this.isBorderPainted()) {
            borderInsetsWidth = borderInsets.left + borderInsets.right;
            borderInsetsHeight = borderInsets.top + borderInsets.bottom;
            textRect.translate(borderInsets.left, borderInsets.top);
        }
        int fGap = this.getFocusGap();
        textRect.x += fGap;
        textRect.y += fGap;
        textRect.width = textRect.width - borderInsetsWidth - 2 * fGap;
        textRect.height = textRect.height - borderInsetsHeight - 2 * fGap;
        Util.drawFocusRect(g, textRect.x, textRect.y, textRect.width, textRect.height, false);
    }

    public Point getContentShift() {
        return this.contentShift;
    }

    public void setContentShift(Point pt) {
        if (pt != null && pt.x != this.contentShift.x && pt.y != this.contentShift.y) {
            Point oldPt = this.contentShift;
            this.contentShift = pt;
            this.firePropertyChange("contentShift", oldPt, this.contentShift);
        }
    }

    @Override
    public void setFont(Font f) {
        if (this.label != null) {
            this.label.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public void setHorizontalTextAlignment(int hAlign) {
        if (this.label != null) {
            this.label.setHorizontalAlignment(hAlign);
        }
        super.setHorizontalTextAlignment(hAlign);
    }

    @Override
    public void setVerticalTextAlignment(int vAlign) {
        if (this.label != null) {
            this.label.setVerticalAlignment(vAlign);
        }
        super.setVerticalTextAlignment(vAlign);
    }

    @Override
    public void setText(String txt) {
        if (txt != null && this.label == null) {
            this.label = new LabelView(txt);
            Font currentFont = this.getFont();
            Font labelFont = this.label.getFont();
            if (currentFont != null && !currentFont.equals(labelFont)) {
                this.label.setFont(currentFont);
            }
            this.label.setHorizontalAlignment(this.getHorizontalTextAlignment());
            this.label.setVerticalAlignment(this.getVerticalTextAlignment());
        } else if (this.label != null) {
            this.label.setText(txt);
        }
        super.setText(txt);
    }

    public String getSource() {
        IconInterface defaultImg = this.getDefaultIcon();
        if (defaultImg != null && defaultImg instanceof ImageView) {
            return ((ImageView)defaultImg).getSource();
        }
        return null;
    }

    public void setSource(String src) {
        IconInterface defaultImg = this.getDefaultIcon();
        if (defaultImg == null) {
            this.setDefaultIcon(new ImageView(src));
        } else if (defaultImg instanceof ImageView) {
            ((ImageView)defaultImg).setSource(src);
        }
        this.resizeToFit();
        this.repaint();
    }
}

