/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Frame;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.awt.PanelContainerComponent;
import com.sas.awt.ScrollPane;
import com.sas.beans.Introspector;
import com.sas.beans.Util;
import com.sas.util.CloseWindowAdaptor;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.IndexedPropertyEditorHost;
import com.sas.visuals.PropertyEditorHost;
import com.sas.visuals.PropertySheetPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropertySheet
extends ScrollPane
implements PropertyChangeListener,
MouseListener {
    static final long serialVersionUID = 3489032679479523378L;
    protected Hashtable editorAssoc = new Hashtable();
    protected Hashtable labelAssoc = new Hashtable();
    protected Object bean;
    protected Vector hostsList = new Vector();
    protected Panel panel;
    protected boolean alwaysShowControls;
    protected boolean inPropertyChange = false;

    public static Frame getPropertySheet(Object bean) {
        Frame frame = new Frame("Property Sheet");
        frame.initialize();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1);
        layout.setFillCell(true);
        layout.setUseColumnRemainder(true);
        layout.setUseRowRemainder(true);
        frame.setLayout((LayoutManager)layout);
        PropertySheet propertySheet = new PropertySheet();
        propertySheet.initialize();
        propertySheet.setObject(bean);
        frame.add(propertySheet);
        frame.pack();
        Dimension psPreferredSize = propertySheet.getPreferredSize();
        psPreferredSize.width += propertySheet.getVScrollbarWidth();
        psPreferredSize.height += propertySheet.getHScrollbarHeight() + 20;
        frame.setSize(psPreferredSize);
        return frame;
    }

    public static Frame showPropertySheet(Object bean) {
        Frame frame = PropertySheet.getPropertySheet(bean);
        new CloseWindowAdaptor((Window)frame);
        frame.setVisible(true);
        return frame;
    }

    public PropertySheet() {
        Util.prependToPropertyEditorSearchPath((String)"com.sas.beans.editors");
        this.setBackgroundColor(Color.white);
        this.panel = new PropertySheetPanel();
        this.panel.initialize();
        this.panel.setInsets(2, 2, 2, 2);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 2);
        layout.setFillCell(true);
        layout.setUseColumnRemainder(true);
        layout.setRemainderColumn(2);
        layout.setVgap(1);
        layout.setHgap(4);
        this.panel.setLayout((LayoutManager)layout);
        this.add(this.panel);
    }

    public Object getObject() {
        return this.bean;
    }

    public void setObject(Object bean) {
        this.bean = bean;
        this.populate();
    }

    public boolean getAlwaysShowControls() {
        return this.alwaysShowControls;
    }

    public void setAlwaysShowControls(boolean alwaysShowControls) {
        this.alwaysShowControls = alwaysShowControls;
    }

    protected void populate() {
        if (this.bean == null) {
            return;
        }
        Class<?> beanClass = this.bean.getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Container propHost;
                Label propName;
                if (props[i] instanceof IndexedPropertyDescriptor) {
                    if (props[i].isHidden()) continue;
                    propName = new Label(props[i].getName());
                    propName.initialize();
                    this.panel.add(propName);
                    propHost = new IndexedPropertyEditorHost();
                    ((IndexedPropertyEditorHost)propHost).initialize();
                    ((IndexedPropertyEditorHost)propHost).setProperty(this.bean, props[i].getName());
                    this.panel.add(propHost);
                    continue;
                }
                if (props[i].isHidden()) continue;
                propName = new Label(props[i].getName());
                propName.addMouseListener(this);
                propName.initialize();
                this.panel.add(propName);
                propHost = new PropertyEditorHost();
                ((PropertyEditorHost)propHost).setAlwaysShowControls(this.alwaysShowControls);
                ((PropertyEditorHost)propHost).initialize();
                ((PropertyEditorHost)propHost).setProperty(this.bean, props[i].getName());
                ((PanelContainerComponent)propHost).setInsets(0, 2, 0, 0);
                this.panel.add(propHost);
                if (((PropertyEditorHost)propHost).getPropertyEditor() != null) {
                    this.labelAssoc.put(propName, propHost);
                    this.editorAssoc.put(((PropertyEditorHost)propHost).getPropertyEditor(), props[i].getName());
                    ((PropertyEditorHost)propHost).getPropertyEditor().addPropertyChangeListener(this);
                }
                this.hostsList.addElement(propHost);
            }
        }
        catch (IntrospectionException e) {
            System.out.println(e.toString());
            return;
        }
        Util.addPropertyChangeListener((Object)this.bean, (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.bean) {
            if (this.inPropertyChange) {
                return;
            }
            this.inPropertyChange = true;
            Enumeration hosts = this.hostsList.elements();
            while (hosts.hasMoreElements()) {
                PropertyEditorHost host = (PropertyEditorHost)hosts.nextElement();
                host.updateValue();
            }
            this.inPropertyChange = false;
            return;
        }
        String propertyName = (String)this.editorAssoc.get(evt.getSource());
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.bean.getClass());
            PropertyDescriptor propertyDescriptor = Introspector.getPropertyDescriptor((String)propertyName, (BeanInfo)beanInfo);
            if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)propertyDescriptor;
                if (ipd.getIndexedWriteMethod() != null) {
                    Object propertyValue = ((PropertyEditor)evt.getSource()).getValue();
                    Util.setIndexedPropertyValue((Object)this.bean, (String)propertyName, (Object)propertyValue, (int)0);
                }
            } else if (propertyDescriptor.getWriteMethod() != null) {
                Object propertyValue = ((PropertyEditor)evt.getSource()).getValue();
                Util.setPropertyValue((Object)this.bean, (String)propertyName, (Object)propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        PropertyEditorHost peHost = (PropertyEditorHost)this.labelAssoc.get(evt.getSource());
        if (peHost != null && peHost.isFocusTraversable()) {
            peHost.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

