/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.VisualInterface;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.PainterInterface;
import com.sas.visuals.VisualAspects;
import com.sas.visuals.Windows95Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class Part
extends Rectangle
implements VisualAspects,
PainterInterface,
Serializable {
    protected Component _parent;
    protected int _borderStyle = -1;
    protected Color _fg;
    protected Color _bg;
    protected Font _font;
    protected boolean _visible = true;
    protected Boolean _transparent;
    protected BorderInterface _border;

    protected Part() {
    }

    public Part(Component parent) {
        this();
        this.setParent(parent);
    }

    public Part(Component parent, Dimension size) {
        super(size);
        this.setParent(parent);
    }

    public Part(Component parent, Rectangle size) {
        super(size);
        this.setParent(parent);
    }

    public Part(Part p) {
        this(p.getParent(), p.getSize());
        this.setBackground(p.getBackground());
        this.setForeground(p.getForeground());
        this.setFont(p.getFont());
        this.setWindowBorderStyle(p.getWindowBorderStyle());
    }

    public Component getParent() {
        return this._parent;
    }

    public void setParent(Component parent) {
        if (parent != null && !parent.equals(this._parent)) {
            this._parent = parent;
        }
    }

    public void repaint() {
        try {
            Component parent = this.getParent();
            parent.repaint(this.x, this.y, this.width, this.height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        try {
            Rectangle clip = g.getClipBounds();
            if (this.isVisible() && this.intersects(clip)) {
                Font font = g.getFont();
                Rectangle c = this.getBounds();
                c = this.intersection(clip);
                g.setClip(c.x, c.y, c.width, c.height);
                g.setFont(this.getFont());
                if (!this.isTransparent()) {
                    this.paintBackground(g);
                }
                if (g instanceof PrintGraphics) {
                    this.printView((PrintGraphics)((Object)g));
                } else {
                    this.paintView(g);
                }
                BorderInterface border = this.getBorder();
                if (border != null) {
                    border.drawInRect(g, this.x, this.y, this.width, this.height);
                }
                if (clip != null) {
                    g.setClip(clip);
                }
                g.setFont(font);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        this.setParent(component);
        this.paint(g);
    }

    protected void paintView(Graphics g) {
    }

    protected void paintBackground(Graphics g) {
    }

    protected void printView(PrintGraphics g) {
        this.paintView((Graphics)((Object)g));
    }

    public void setWindowBorderStyle(int s) {
        BorderInterface b = this.getBorder();
        if (b == null) {
            this.setBorder(new Windows95Border(s));
            ((Windows95Border)this.getBorder()).setComponent(this.getParent());
        } else {
            b.setStyle(s);
            if (b instanceof Windows95Border) {
                ((Windows95Border)b).setComponent(this.getParent());
            }
        }
    }

    public int getWindowBorderStyle() {
        BorderInterface b = this.getBorder();
        if (b != null) {
            return b.getStyle();
        }
        return -1;
    }

    public BorderInterface getBorder() {
        return this._border;
    }

    public void setBorder(BorderInterface border) {
        this._border = border;
    }

    public Insets getInsets() {
        BorderInterface border = this.getBorder();
        if (border != null) {
            return border.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    public Dimension getPreferredSize(Graphics g) {
        Insets insets = this.getInsets();
        Dimension size = new Dimension(0, 0);
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension size = new Dimension(0, 0);
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setBackground(Color c) {
        this._bg = c instanceof SystemColor ? new Color(c.getRGB()) : c;
    }

    public Color getBackground() {
        Color bg = null;
        if (this._bg != null) {
            bg = this._bg;
        } else {
            try {
                bg = this._parent.getBackground();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bg;
    }

    public void setForeground(Color c) {
        this._fg = c instanceof SystemColor ? new Color(c.getRGB()) : c;
    }

    public Color getForeground() {
        Color fg = null;
        if (this._fg != null) {
            fg = this._fg;
        } else {
            try {
                fg = this._parent.getForeground();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return fg;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public Font getFont() {
        Font font = null;
        if (this._font != null) {
            font = this._font;
        } else {
            try {
                font = this._parent.getFont();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return font;
    }

    public void setVisible(boolean visible) {
        if (this._visible != visible) {
            this._visible = visible;
        }
    }

    public boolean isVisible() {
        Component parent = this.getParent();
        boolean visible = false;
        if (parent != null) {
            visible = parent.isVisible();
        }
        return this._visible && !this.isEmpty();
    }

    public void setTransparent(boolean transparent) {
        this._transparent = new Boolean(transparent);
    }

    public boolean isTransparent() {
        Component parent = this.getParent();
        boolean transparent = true;
        if (this._transparent == null) {
            if (parent != null && parent instanceof VisualInterface) {
                transparent = ((VisualInterface)((Object)parent)).isTransparent();
            }
            if (this._bg != null && transparent) {
                transparent = false;
            }
        } else {
            transparent = this._transparent;
        }
        return transparent;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

