/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.MessageBoxListener;

public final class MessageBoxListenerList {
    private int numberOfListeners;
    private MessageBoxListener[] listenerList;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;

    public MessageBoxListenerList() {
        this.increment = 8;
    }

    public MessageBoxListenerList(int initialIncrement) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
    }

    private int indexOf(MessageBoxListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                if (this.listenerList[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(MessageBoxListener listener) {
        if (this.indexOf(listener) != -1) {
            return;
        }
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            MessageBoxListener[] newListenerList = new MessageBoxListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized MessageBoxListener[] getListeners() {
        MessageBoxListener[] listeners = new MessageBoxListener[this.numberOfListeners];
        if (this.numberOfListeners > 0) {
            System.arraycopy(this.listenerList, 0, listeners, 0, this.numberOfListeners);
        }
        return listeners;
    }

    public synchronized void remove(MessageBoxListener listener) {
        int i = this.indexOf(listener);
        if (i == -1) {
            return;
        }
        int n = this.listenerList.length - 1;
        while (i < n) {
            this.listenerList[i] = this.listenerList[i + 1];
            ++i;
        }
        this.listenerList[i] = null;
    }
}

