/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.util.Util;
import com.sas.collection.StringCollection;
import com.sas.util.Strings;
import com.sas.visuals.AnimationIconInterface;
import com.sas.visuals.ImageConsumerList;
import com.sas.visuals.ImageView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Vector;

public class MarqueeIcon
extends Component
implements AnimationIconInterface {
    static final long serialVersionUID = 4221065533212195509L;
    protected String precedingText;
    protected String trailingText;
    protected String text;
    protected int imgTextGap;
    protected int hContentAlign;
    protected int vContentAlign;
    protected int hTextAlign;
    protected int vTextAlign;
    protected int hImageAlign;
    protected int vImageAlign;
    protected int direction;
    protected int scrollingSpeed;
    protected int imageAnimationSpeed;
    protected int startingPosition;
    protected int textPosition;
    protected int textJustification;
    protected String[] imageSources;
    protected URL[] imageURLs;
    protected boolean appletRelative;
    protected transient Font prevFont;
    protected transient Dimension imageSize;
    protected transient Dimension currentTextSize;
    protected transient StringCollection multilineText;
    protected transient Image offScreen;
    protected transient Graphics offScreenGraphics;
    protected transient int count;
    protected transient int rollingI;
    protected transient Vector images;
    protected transient Vector lineWidths;
    protected transient MediaTracker tracker;
    protected transient ImageView img;
    private transient ImageConsumerList[] consumerListFilter;

    public MarqueeIcon() {
        this.setDefaultValues();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(0, 0);
        return prefSize;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getTextJustification() {
        return this.textJustification;
    }

    public int getHorizontalContentAlignment() {
        return this.hContentAlign;
    }

    public int getVerticalContentAlignment() {
        return this.vContentAlign;
    }

    public int getHorizontalTextAlignment() {
        return this.hTextAlign;
    }

    public int getVerticalTextAlignment() {
        return this.vTextAlign;
    }

    public int getHorizontalImageAlignment() {
        return this.hImageAlign;
    }

    public int getVerticalImageAlignment() {
        return this.vImageAlign;
    }

    public int getImageAnimationSpeed() {
        return this.imageAnimationSpeed;
    }

    public int getImageTextGap() {
        return this.imgTextGap;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public String getText() {
        return this.text;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public int getScrollingSpeed() {
        return this.scrollingSpeed;
    }

    public String[] getSourceSequence() {
        return this.imageSources;
    }

    public URL[] getURLSequence() {
        return this.imageURLs;
    }

    public boolean isSourceAppletRelative() {
        return this.appletRelative;
    }

    public void setSourceAppletRelative(boolean b) {
        if (b != this.appletRelative) {
            this.appletRelative = b;
            Image[] imgs = this.loadImageSequence(this.getSourceSequence());
            this.setImageSequence(imgs);
        }
    }

    public void setDirection(int d) {
        this.direction = d;
    }

    public void setTextJustification(int j) {
        this.textJustification = j;
    }

    public void setHorizontalContentAlignment(int align) {
        this.hContentAlign = align;
    }

    public void setVerticalContentAlignment(int align) {
        this.vContentAlign = align;
    }

    public void setHorizontalTextAlignment(int align) {
        this.hTextAlign = align;
    }

    public void setVerticalTextAlignment(int align) {
        this.vTextAlign = align;
    }

    public void setHorizontalImageAlignment(int align) {
        this.hImageAlign = align;
    }

    public void setVerticalImageAlignment(int align) {
        this.vImageAlign = align;
    }

    public void setImageAnimationSpeed(int animateSpeed) {
        this.count = 0;
        this.imageAnimationSpeed = animateSpeed;
    }

    public void setImageTextGap(int g) {
        this.imgTextGap = g;
    }

    public void setText(String txt) {
        this.text = txt;
        if (this.text == null) {
            this.multilineText = null;
        } else {
            this.multilineText = new StringCollection();
            txt = Strings.replace((String)txt, (int)0, (int)-1, (String)"\t", (String)"    ");
            int txtLength = txt.length() - 1;
            int[] positions = Strings.positions((String)txt, (int)0, (int)-1, (char)'\n');
            int posLength = positions.length;
            String subString = "";
            StringCollection tempMultilineText = new StringCollection();
            for (int i = 0; i < posLength; ++i) {
                subString = i == 0 ? txt.substring(0, positions[i]) : txt.substring(positions[i - 1], positions[i]);
                if (subString.length() == 1 && subString.equals("\n")) {
                    tempMultilineText.add(" ");
                } else if (subString.startsWith("\n")) {
                    tempMultilineText.add(subString.substring(1));
                } else {
                    tempMultilineText.add(subString);
                }
                if (positions[i] != txtLength) continue;
                tempMultilineText.add(" ");
            }
            if (posLength == 0) {
                tempMultilineText.add(txt);
            } else if (positions[posLength - 1] < txtLength) {
                tempMultilineText.add(txt.substring(positions[positions.length - 1] + 1));
            }
            int tempCount = tempMultilineText.count();
            for (int i = 0; i < tempCount; ++i) {
                this.multilineText.add(tempMultilineText.get(i));
            }
        }
        this.currentTextSize = null;
    }

    public void setTextPosition(int pos) {
        this.textPosition = pos;
    }

    public void setScrollingSpeed(int speed) {
        this.scrollingSpeed = speed;
    }

    public synchronized void setSourceSequence(String[] sources) {
        if (sources == null) {
            this.imageSources = null;
        } else {
            this.imageSources = new String[sources.length];
            System.arraycopy(sources, 0, this.imageSources, 0, sources.length);
        }
        Image[] imgs = this.loadImageSequence(this.imageSources);
        this.setImageSequence(imgs);
    }

    public synchronized void setURLSequence(URL[] sources) {
        if (sources == null) {
            this.imageURLs = null;
        } else {
            this.imageURLs = new URL[sources.length];
            System.arraycopy(sources, 0, this.imageURLs, 0, sources.length);
        }
        Image[] imgs = this.loadImageSequence(this.imageURLs);
        this.setImageSequence(imgs);
    }

    public synchronized void setImageSequence(Image[] imgs) {
        if (this.tracker != null && this.images != null) {
            int s = this.images.size();
            for (int j = 0; j < s; ++j) {
                Image imag = (Image)this.images.get(j);
                this.tracker.removeImage(imag);
                this.consumerListFilter[j].removeConsumers(imag.getSource());
            }
        }
        this.images.removeAllElements();
        if (imgs == null || imgs.length == 0) {
            this.loadImageSize();
            return;
        }
        this.consumerListFilter = new ImageConsumerList[imgs.length];
        if (this.tracker == null) {
            this.tracker = new MediaTracker(this);
        }
        for (int i = 0; i < imgs.length; ++i) {
            if (imgs[i] == null) continue;
            this.consumerListFilter[i] = new ImageConsumerList();
            imgs[i] = this.createImage(new FilteredImageSource(imgs[i].getSource(), this.consumerListFilter[i]));
            this.images.addElement(imgs[i]);
            this.tracker.addImage(imgs[i], 0);
        }
        try {
            this.tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.loadImageSize();
    }

    @Override
    public void reset() {
        this.count = 0;
        this.startingPosition = 0;
    }

    @Override
    public void increment() {
        this.startingPosition += this.scrollingSpeed;
        ++this.count;
        if (this.count == this.imageAnimationSpeed) {
            ++this.rollingI;
            this.count = 0;
        }
        if (this.rollingI >= this.images.size()) {
            this.rollingI = 0;
        }
    }

    @Override
    public void decrement() {
        this.startingPosition -= this.scrollingSpeed;
        ++this.count;
        if (this.count == this.imageAnimationSpeed) {
            ++this.rollingI;
            this.count = 0;
        }
        if (this.rollingI >= this.images.size()) {
            this.rollingI = 0;
        }
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.offScreen = comp.createImage(width, height);
        this.offScreenGraphics = this.offScreen.getGraphics();
        this.paintAnimation(comp, g, x, y, width, height);
    }

    @Override
    public void paintAnimation(Component comp, Graphics g, int x, int y, int width, int height) {
        if (comp.isVisible()) {
            if (this.offScreen == null || this.offScreenGraphics == null) {
                if (width <= 0 || height <= 0) {
                    return;
                }
                this.offScreen = comp.createImage(width, height);
                this.offScreenGraphics = this.offScreen.getGraphics();
            }
            this.offScreenGraphics.setColor(comp.getBackground());
            this.offScreenGraphics.fillRect(0, 0, width + 1, height + 1);
            this.offScreenGraphics.setColor(comp.getForeground());
            this.paintContent(comp, this.offScreenGraphics, x, y, width, height);
            g.drawImage(this.offScreen, x, y, null);
        }
    }

    protected void paintContent(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.text == null && this.images == null) {
            return;
        }
        int multilineCount = 0;
        int fontHeight = 0;
        int fontDescent = 0;
        int fontAscent = 0;
        Font currentFont = comp.getFont();
        Dimension textSize = new Dimension(0, 0);
        if (currentFont != null && this.text != null) {
            g.setFont(currentFont);
            FontMetrics fontInfo = g.getFontMetrics(currentFont);
            fontAscent = fontInfo.getAscent();
            fontDescent = fontInfo.getDescent();
            fontHeight = fontInfo.getHeight();
            multilineCount = this.multilineText.count();
            if (this.currentTextSize == null || this.prevFont != currentFont) {
                this.prevFont = currentFont;
                this.currentTextSize = new Dimension(0, fontHeight * multilineCount);
                this.lineWidths.removeAllElements();
                for (int i = 0; i < multilineCount; ++i) {
                    int textWidth = fontInfo.stringWidth(this.multilineText.getString(i));
                    this.lineWidths.addElement(new Integer(textWidth));
                    if (textWidth <= this.currentTextSize.width) continue;
                    this.currentTextSize.width = textWidth;
                }
            }
            textSize = new Dimension(this.currentTextSize);
        }
        int gap = this.imgTextGap;
        if (this.text == null || this.text.length() == 0 || this.images == null) {
            gap = 0;
        }
        Point textPos = new Point();
        Point imgPos = new Point();
        Dimension contentSize = new Dimension();
        if (this.textPosition == 1 || this.textPosition == 2) {
            contentSize.width = this.imageSize.width + gap + textSize.width;
            contentSize.height = textSize.height > this.imageSize.height ? textSize.height : this.imageSize.height;
        } else {
            contentSize.height = this.imageSize.height + gap + textSize.height;
            contentSize.width = textSize.width > this.imageSize.width ? textSize.width : this.imageSize.width;
        }
        Point startPos = new Point(0, 0);
        if (this.direction == 1 || this.direction == 2) {
            startPos.x = this.startingPosition;
            if (this.vContentAlign == 256) {
                startPos.y = (height - contentSize.height) / 2;
            } else if (this.vContentAlign == 8) {
                startPos.y = height - contentSize.height;
            }
        } else {
            startPos.y = this.startingPosition;
            if (this.hContentAlign == 256) {
                startPos.x = (width - contentSize.width) / 2;
            } else if (this.hContentAlign == 2) {
                startPos.x = width - contentSize.width;
            }
        }
        if (this.textPosition == 1) {
            textPos.x = startPos.x;
            textPos.y = startPos.y;
            imgPos.x = startPos.x + textSize.width + gap;
            imgPos.y = startPos.y;
        } else if (this.textPosition == 2) {
            textPos.x = startPos.x + this.imageSize.width + gap;
            textPos.y = startPos.y;
            imgPos.x = startPos.x;
            imgPos.y = startPos.y;
        } else if (this.textPosition == 4) {
            textPos.x = startPos.x;
            textPos.y = startPos.y;
            imgPos.x = startPos.x;
            imgPos.y = startPos.y + textSize.height + gap;
        } else {
            textPos.x = startPos.x;
            textPos.y = startPos.y + this.imageSize.height + gap;
            imgPos.x = startPos.x;
            imgPos.y = startPos.y;
        }
        if (this.textPosition == 1 || this.textPosition == 2) {
            if (this.vTextAlign == 256) {
                textPos.y += (contentSize.height - textSize.height) / 2;
            } else if (this.vTextAlign == 8) {
                textPos.y += contentSize.height - textSize.height;
            }
            if (this.vImageAlign == 256) {
                imgPos.y += (contentSize.height - this.imageSize.height) / 2;
            } else if (this.vImageAlign == 8) {
                imgPos.y += contentSize.height - this.imageSize.height;
            }
        } else {
            if (this.hImageAlign == 256) {
                textPos.x += (contentSize.width - textSize.width) / 2;
            } else if (this.hImageAlign == 2) {
                textPos.x += contentSize.width - textSize.width;
            }
            if (this.hImageAlign == 256) {
                imgPos.x += (contentSize.width - this.imageSize.width) / 2;
            } else if (this.hImageAlign == 2) {
                imgPos.x += contentSize.width - this.imageSize.width;
            }
        }
        if (this.direction == 1 && this.startingPosition >= width) {
            this.startingPosition = -contentSize.width;
        } else if (this.direction == 2 && this.startingPosition + contentSize.width < 0) {
            this.startingPosition = width;
        } else if (this.direction == 4 && this.startingPosition >= height) {
            this.startingPosition = -contentSize.height;
        } else if (this.direction == 8 && this.startingPosition + contentSize.height < 0) {
            this.startingPosition = height;
        }
        if (this.text != null) {
            textPos.y += fontAscent;
            int origX = textPos.x;
            for (int i = 0; i < multilineCount; ++i) {
                int lineWidth = (Integer)this.lineWidths.elementAt(i);
                if (this.textJustification == 256) {
                    textPos.x = origX + (textSize.width - lineWidth) / 2;
                } else if (this.textJustification == 2) {
                    textPos.x = origX + textSize.width - lineWidth;
                }
                Util.drawString(g, (String)this.multilineText.get(i), textPos.x, textPos.y, comp.isEnabled());
                textPos.y += fontHeight;
                textPos.x = origX;
            }
        }
        if (this.images != null && this.images.size() > this.rollingI) {
            g.drawImage((Image)this.images.elementAt(this.rollingI), imgPos.x, imgPos.y, comp);
        }
    }

    protected Image[] loadImageSequence(String[] srcs) {
        this.img = new ImageView();
        if (srcs == null || srcs.length == 0) {
            return null;
        }
        Image[] imgs = new Image[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            imgs[i] = this.loadImage(srcs[i]);
        }
        this.img = null;
        return imgs;
    }

    protected Image[] loadImageSequence(URL[] srcs) {
        this.img = new ImageView();
        if (srcs == null || srcs.length == 0) {
            return null;
        }
        Image[] imgs = new Image[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            imgs[i] = this.loadImage(srcs[i]);
        }
        this.img = null;
        return imgs;
    }

    protected Image loadImage(String source) {
        if (source == null) {
            return null;
        }
        if (this.img == null) {
            this.img = new ImageView();
        }
        this.img.setSource(source);
        Image imageTemp = this.img.getImage();
        if (imageTemp == null && source != null && source.length() != 0) {
            return this.img.getMissingFileImage();
        }
        return imageTemp;
    }

    protected Image loadImage(URL source) {
        return this.getToolkit().getImage(source);
    }

    protected void loadImageSize() {
        this.imageSize.width = 0;
        this.imageSize.height = 0;
        for (int i = 0; i < this.images.size(); ++i) {
            Image img = (Image)this.images.elementAt(i);
            Dimension d = new Dimension(0, 0);
            d.height = img.getHeight(this);
            d.width = img.getWidth(this);
            if (d.height > this.imageSize.height) {
                this.imageSize.height = d.height;
            }
            if (d.width <= this.imageSize.width) continue;
            this.imageSize.width = d.width;
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.precedingText = null;
        this.trailingText = null;
        if (this.vContentAlign == 0) {
            this.vContentAlign = 256;
        }
        if (this.hContentAlign == 0) {
            this.hContentAlign = 256;
        }
        if (this.vImageAlign == 0) {
            this.vImageAlign = 256;
        }
        if (this.hImageAlign == 0) {
            this.hImageAlign = 256;
        }
        if (this.vTextAlign == 0) {
            this.vTextAlign = 256;
        }
        if (this.hTextAlign == 0) {
            this.hTextAlign = 256;
        }
        if (this.textJustification == 0) {
            this.textJustification = 1;
        }
        this.imageSize = new Dimension(0, 0);
        this.lineWidths = new Vector();
        this.images = new Vector();
        this.setText(this.text);
        if (this.imageURLs != null) {
            this.setImageSequence(this.loadImageSequence(this.imageURLs));
        } else {
            this.setImageSequence(this.loadImageSequence(this.imageSources));
        }
    }

    public void setDefaultValues() {
        this.imageAnimationSpeed = 4;
        this.scrollingSpeed = 1;
        this.imgTextGap = 5;
        this.textPosition = 1;
        this.direction = 1;
        this.vContentAlign = 256;
        this.hContentAlign = 256;
        this.vTextAlign = 256;
        this.hTextAlign = 256;
        this.vImageAlign = 256;
        this.hImageAlign = 256;
        this.textJustification = 1;
        this.imageSize = new Dimension(0, 0);
        this.images = new Vector();
        this.lineWidths = new Vector();
        this.appletRelative = false;
    }
}

