/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StringCollection;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmListener;
import com.sas.visuals.ImageView;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class ImageSequence
extends ImageView
implements AlarmListener,
PropertyChangeListener,
ContentsChangedListener {
    static final long serialVersionUID = 353809234376815640L;
    static final String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    transient Vector images;
    transient int nImages = -1;
    transient int count = 0;
    Alarm frameAlarm;
    String[] imageSources;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Short description", "Alarm object to fire events when image should change."}}, {{"Name", "sequence"}, {"Short description", "Source strings for the sequence of images to display."}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "sequence";
        ebi.defaultOutputPropertyName = "sequence";
        ebi.shortDescription = "Image view with sequential display of images";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ImageSequence() {
        this.setResizeToFit(false);
        this.frameAlarm = new Alarm();
        this.frameAlarm.addAlarmListener((AlarmListener)this);
        this.frameAlarm.setInterval(500L);
        this.frameAlarm.addPropertyChangeListener((PropertyChangeListener)this);
        this.images = new Vector();
    }

    public ImageSequence(Alarm alarm) {
        this.setResizeToFit(false);
        this.frameAlarm = alarm;
        this.frameAlarm.addAlarmListener((AlarmListener)this);
        this.frameAlarm.addPropertyChangeListener((PropertyChangeListener)this);
        this.images = new Vector();
    }

    public ImageSequence(String[] sources) {
        this();
        this.setSequence(sources);
    }

    public ImageSequence(Alarm alarm, String[] sources) {
        this(alarm);
        this.setSequence(sources);
    }

    public void contentsChanged(ContentsChangedEvent evt) {
        StaticOrderedCollectionInterface model = (StaticOrderedCollectionInterface)evt.getSource();
        if (model != null) {
            this.refreshSequence(model);
        }
    }

    public void fireAlarm(AlarmEvent evt) {
        if (evt.getSource() != this.frameAlarm) {
            return;
        }
        if (this.count < this.nImages) {
            Image img = (Image)this.images.elementAt(this.count);
            this.setImage(img);
            this.count = this.count == this.nImages - 1 ? 0 : ++this.count;
        }
    }

    public Alarm getAlarm() {
        return this.frameAlarm;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public String[] getSequence() {
        if (this.nImages <= 0) {
            return null;
        }
        String[] list = new String[this.nImages];
        System.arraycopy(this.imageSources, 0, list, 0, this.nImages);
        return list;
    }

    @Override
    public void initialize() {
        if (this.getModelInterface() == null) {
            StringCollection sequence = new StringCollection();
            if (this.imageSources != null) {
                sequence = new StringCollection(this.imageSources);
            }
            sequence.initialize();
            this.setModelInterface((ModelInterface)sequence);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.frameAlarm) {
            this.firePropertyChange("alarm", null, this.frameAlarm);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.images = new Vector();
        if (this.imageSources != null) {
            this.loadSequence(this.imageSources);
        }
        this.count = 0;
        this.frameAlarm.addAlarmListener((AlarmListener)this);
        Util.addPropertyChangeListener((Object)this.frameAlarm, (PropertyChangeListener)this);
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model != null) {
            if (model instanceof OrderedCollectionInterface) {
                ((OrderedCollectionInterface)model).addContentsChangedListener((ContentsChangedListener)this);
            }
            this.refreshSequence((StaticOrderedCollectionInterface)model);
        }
    }

    protected void refreshSequence(StaticOrderedCollectionInterface model) {
        int i = 0;
        int nItems = model.count();
        this.imageSources = new String[nItems];
        Enumeration e = model.getItems();
        while (e.hasMoreElements()) {
            this.imageSources[i++] = (String)e.nextElement();
        }
        this.loadSequence(this.imageSources);
    }

    public void setAlarm(Alarm newAlarm) {
        if (!com.sas.util.Util.equal((Object)this.frameAlarm, (Object)newAlarm)) {
            Alarm oldAlarm = this.frameAlarm;
            this.frameAlarm.removeAlarmListener((AlarmListener)this);
            this.frameAlarm = newAlarm;
            this.frameAlarm.addAlarmListener((AlarmListener)this);
            Util.addPropertyChangeListener((Object)this.frameAlarm, (PropertyChangeListener)this);
            this.firePropertyChange("alarm", oldAlarm, this.frameAlarm);
        }
    }

    public synchronized void setSequence(String[] sources) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            StringCollection sequence = new StringCollection(sources);
            ((OrderedCollectionInterface)model).removeAll();
            ((OrderedCollectionInterface)model).addItems(sequence.getItems());
        } else if (model == null) {
            this.imageSources = new String[sources.length];
            System.arraycopy(sources, 0, this.imageSources, 0, sources.length);
            this.loadSequence(this.imageSources);
        }
    }

    private void loadSequence(String[] sources) {
        if (sources == null) {
            this.nImages = -1;
            return;
        }
        this.nImages = sources.length;
        this.images.removeAllElements();
        for (int i = 0; i < this.nImages; ++i) {
            Image img = this.loadImage(sources[i]);
            if (img == null) continue;
            this.images.addElement(img);
        }
        this.firePropertyChange("sequence", null, null);
    }

    private Image loadImage(String source) {
        Image img = null;
        try {
            URL imageURL = new URL(source);
            img = this.getToolkit().getImage(imageURL);
        }
        catch (MalformedURLException e) {
            img = this.getToolkit().getImage(source);
            com.sas.util.Util.println((String)"Source is not a URL: doesn't have to be, can also be a file name");
            com.sas.util.Util.println((String)("MalformedURLException thrown in ImageSequence::setSequence(String []src)  source = " + source));
        }
        return img;
    }

    public void start() {
        this.frameAlarm.start();
    }

    public void stop() {
        this.frameAlarm.stop();
    }
}

