/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.visuals.ImageView;
import com.sas.visuals.RB;
import com.sas.visuals.Resources;
import com.sas.visuals.ToggleButton;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GraphicalCheckBox
extends ToggleButton {
    static final long serialVersionUID = 7789437671608544400L;
    static final String RB_KEY = "GraphicalCheckBox.";
    static int defaultWidth = 124;
    static int defaultHeight = 23;
    public static final int CHECK = 0;
    public static final int LAMP = 1;
    public static final int LIGHT_BULB = 2;
    public static final int CHECK_INVALID = 3;
    public static final int STOP_GO = 4;
    public static final int TRAFFIC_LIGHT = 5;
    public static final int MAILBOX = 6;
    public static final int TRASH = 7;
    public static final int LOCK = 8;
    public static final int MOON_SUN = 9;
    public static final int COLOR_CHECK = 10;
    public static final int XBOX = 11;
    private static final int FIRST_IMAGE_SET = 0;
    private static final int LAST_IMAGE_SET = 11;
    private static String[][] images = new String[][]{{"res/Check0.gif", "res/Check1.gif"}, {"res/Lamp0.gif", "res/Lamp1.gif"}, {"res/LightBulb0.gif", "res/LightBulb1.gif"}, {"res/ColorX0.gif", "res/ColorCheck1.gif"}, {"res/StopGo0.gif", "res/StopGo1.gif"}, {"res/TrafficLight0.gif", "res/TrafficLight1.gif"}, {"res/Mailbox0.gif", "res/Mailbox1.gif"}, {"res/Trash0.gif", "res/Trash1.gif"}, {"res/Lock0.gif", "res/Lock1.gif"}, {"res/MoonSun0.gif", "res/MoonSun1.gif"}, {"res/ColorCheck0.gif", "res/ColorCheck1.gif"}, {"res/XBox0.gif", "res/XBox1.gif"}};
    protected ImageView offImageView;
    protected ImageView onImageView;
    protected int imageSet;

    public GraphicalCheckBox() {
        this(10);
    }

    public GraphicalCheckBox(int imageSetIn) {
        this.setHorizontalAlignment(1);
        this.imageSet = -1;
        if (this.validImageSet(imageSetIn)) {
            this.setImageSet(imageSetIn);
        } else {
            this.setImageSet(10);
        }
        if (this.isDesignTime()) {
            this.setText(RB.getStringResource((String)RB_KEY, (String)"constructor.txt"));
        }
        this.setTextPosition(2);
        this.setBorderPainted(false);
        this.setTransparent(true);
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "imageSet"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"imageSetSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"imageSet.pd.txt")}, {"Property editor class", "com.sas.beans.editors._GraphicalCheckBoxImageSetEditor"}}, {{"Name", "defaultWidth"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"defaultWidthSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Short description", RB.getStringResource((String)RB_KEY, (String)"defaultHeightSD.pd.txt")}, {"Description", RB.getStringResource((String)RB_KEY, (String)"defaultWidth.pd.txt")}}, {{"Name", "defaultIcon"}, {"Hidden", "true"}}, {{"Name", "pressedIcon"}, {"Hidden", "true"}}, {{"Name", "selectedIcon"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selected";
        ebi.defaultOutputPropertyName = "selected";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        return ebi;
    }

    private boolean validImageSet(int imageSetIn) {
        boolean result = imageSetIn >= 0 && imageSetIn <= 11;
        return result;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.offImageView != null && this.onImageView != null) {
            this.offImageView.setImage(Resources.getImage((String)images[this.imageSet][0]));
            this.onImageView.setImage(Resources.getImage((String)images[this.imageSet][1]));
        } else {
            this.offImageView = new ImageView(Resources.getImage((String)images[this.imageSet][0]));
            this.setDefaultIcon(this.offImageView);
            this.onImageView = new ImageView(Resources.getImage((String)images[this.imageSet][1]));
            this.setSelectedIcon(this.onImageView);
            this.setPressedIcon(this.onImageView);
        }
    }

    @Override
    protected void paintFocus(Graphics g) {
        Rectangle textRect = this.getTextBounds();
        int fGap = this.getFocusGap();
        textRect.x -= fGap;
        textRect.y -= fGap;
        textRect.width += 2 * fGap;
        textRect.height += 2 * fGap;
        Util.drawFocusRect(g, textRect.x, textRect.y, textRect.width, textRect.height, false);
    }

    public void setImageSet(int imageSetIn) {
        if (this.imageSet == imageSetIn) {
            return;
        }
        if (this.validImageSet(imageSetIn)) {
            int oldImageSet = this.imageSet;
            this.imageSet = imageSetIn;
            this.offImageView = new ImageView(Resources.getImage((String)images[this.imageSet][0]));
            this.setDefaultIcon(this.offImageView);
            this.onImageView = new ImageView(Resources.getImage((String)images[this.imageSet][1]));
            this.setSelectedIcon(this.onImageView);
            this.setPressedIcon(this.onImageView);
            this.firePropertyChange("imageSet", new Integer(oldImageSet), new Integer(this.imageSet));
        }
    }

    public int getImageSet() {
        return this.imageSet;
    }
}

