/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.ForwardedActionListener;
import java.io.Serializable;

public final class ForwardedActionListenerList
implements Serializable {
    private int numberOfListeners;
    private ForwardedActionListener[] listenerList;
    private ForwardedActionListener[] listeners;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;

    public ForwardedActionListenerList() {
        this.increment = 8;
    }

    public ForwardedActionListenerList(int initialIncrement) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
    }

    public int count() {
        return this.numberOfListeners;
    }

    private int indexOf(ForwardedActionListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                if (this.listenerList[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(ForwardedActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indexOf(listener) != -1) {
            return;
        }
        this.listeners = null;
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            ForwardedActionListener[] newListenerList = new ForwardedActionListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized ForwardedActionListener[] getListeners() {
        if (this.listeners == null) {
            this.listeners = new ForwardedActionListener[this.numberOfListeners];
            if (this.numberOfListeners > 0) {
                System.arraycopy(this.listenerList, 0, this.listeners, 0, this.numberOfListeners);
            }
        }
        return this.listeners;
    }

    public synchronized void remove(ForwardedActionListener listener) {
        int index = this.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners = null;
        --this.numberOfListeners;
        this.listenerList[index] = null;
        while (index < this.numberOfListeners) {
            this.listenerList[index++] = this.listenerList[index];
        }
    }
}

