/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.Container;
import com.sas.awt.Panel;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.DefaultFontList;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ComboBox;
import com.sas.visuals.MessageBox;
import com.sas.visuals.RB;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;

public class FontPanel
extends Panel
implements PropertyChangeListener {
    static final long serialVersionUID = 8746734142183854818L;
    public static final String RB_KEY = "FontPanel.";
    public ComboBox comboName;
    public ComboBox comboStyle;
    public ComboBox comboSize;
    private Label testLabel;
    private String fontname = "Dialog";
    private int fontstyle = 0;
    private int fontsize = 12;

    public FontPanel() {
        this.setInsets(new Insets(5, 5, 5, 5));
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)outerLayout);
        Container innerContainer = new Container();
        innerContainer.initialize();
        AutoSizingGridLayout innerLayout = new AutoSizingGridLayout(1, 3);
        innerLayout.setVgap(5);
        innerLayout.setHgap(15);
        innerContainer.setLayout((LayoutManager)innerLayout);
        Container label1Container = new Container();
        label1Container.initialize();
        AutoSizingGridLayout labelLayout = new AutoSizingGridLayout(2, 1);
        labelLayout.setVgap(5);
        label1Container.setLayout((LayoutManager)labelLayout);
        Label nameLabel = new Label(RB.getStringResource((String)RB_KEY, (String)"Font.txt"));
        label1Container.add(nameLabel);
        this.comboName = new ComboBox();
        this.comboName.setStyle(1);
        this.comboName.setResizeToFit(true);
        DefaultFontList dfl = new DefaultFontList();
        Enumeration enumer = dfl.getItems();
        while (enumer.hasMoreElements()) {
            Font f = (Font)enumer.nextElement();
            this.comboName.addItem(f.getName());
        }
        this.comboName.setSelectedIndex(0);
        this.comboName.initialize();
        label1Container.add(this.comboName);
        innerContainer.add(label1Container);
        Container label2Container = new Container();
        label2Container.initialize();
        label2Container.setLayout((LayoutManager)labelLayout);
        Label styleLabel = new Label(RB.getStringResource((String)RB_KEY, (String)"FontStyle.txt"));
        label2Container.add(styleLabel);
        this.comboStyle = new ComboBox();
        this.comboStyle.setStyle(1);
        this.comboStyle.setResizeToFit(true);
        String[] styleTemp = new String[]{"Plain", "Italic", "Bold", "BoldItalic"};
        this.comboStyle.setInitialItems(styleTemp);
        this.comboStyle.setText("Plain.txt");
        this.comboStyle.initialize();
        label2Container.add(this.comboStyle);
        innerContainer.add(label2Container);
        Container label3Container = new Container();
        label3Container.initialize();
        label3Container.setLayout((LayoutManager)labelLayout);
        Label sizeLabel = new Label(RB.getStringResource((String)RB_KEY, (String)"Size.txt"));
        label3Container.add(sizeLabel);
        this.comboSize = new ComboBox();
        this.comboSize.setStyle(1);
        this.comboSize.setResizeToFit(true);
        String[] sizeTemp = new String[]{"8", "10", "12", "14", "16", "18", "20", "24", "28", "36", "48", "72"};
        this.comboSize.setInitialItems(sizeTemp);
        this.comboSize.setText("12");
        this.comboSize.initialize();
        label3Container.add(this.comboSize);
        innerContainer.add(label3Container);
        this.add(innerContainer);
        Panel textContainer = new Panel();
        textContainer.initialize();
        BaseBorder border = (BaseBorder)textContainer.getBorder();
        border.setBackgroundColor(textContainer.getBackgroundColor());
        Util.configureGroupBoxBorder(border, RB.getStringResource((String)RB_KEY, (String)"Sample.txt"));
        textContainer.setInsets(new Insets(15, 15, 15, 15));
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(1, 1);
        layout2.setVgap(20);
        textContainer.setLayout((LayoutManager)layout2);
        this.testLabel = new Label();
        this.testLabel.setText(RB.getStringResource((String)RB_KEY, (String)"SampleText.txt"));
        textContainer.add(this.testLabel);
        this.add(textContainer);
    }

    @Override
    public void initialize() {
        this.comboName.addPropertyChangeListener(this);
        this.comboStyle.addPropertyChangeListener(this);
        this.comboSize.addPropertyChangeListener(this);
    }

    protected void updateFont() {
        this.firePropertyChange("selectedFont", null, this.getSelectedFont());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "text") {
            if (e.getSource() == this.comboName) {
                ModelInterface modelInterface = this.comboName.getModelInterface();
                StaticOrderedCollectionInterface collection = (StaticOrderedCollectionInterface)modelInterface;
                if (collection.contains((Object)this.comboName.getText())) {
                    this.fontname = this.comboName.getText();
                } else if (collection.count() > 0) {
                    MessageBox.showModalMessageBox(Util.getParentFrame(this), Message.format((String)RB.getStringResource((String)RB_KEY, (String)"InvalidFont.txt"), (Object)this.comboName.getText()));
                    this.comboName.requestFocus();
                }
            }
            if (e.getSource() == this.comboSize) {
                try {
                    this.fontsize = new Integer(this.comboSize.getText());
                }
                catch (NumberFormatException exc) {
                    MessageBox.showModalMessageBox(Util.getParentFrame(this), Message.format((String)RB.getStringResource((String)RB_KEY, (String)"InvalidSize.txt"), (Object)this.comboSize.getText()));
                    this.comboSize.requestFocus();
                }
            }
            if (e.getSource() == this.comboStyle) {
                String styleText = this.comboStyle.getText();
                if (styleText.equals("Plain")) {
                    this.fontstyle = 0;
                } else if (styleText.equals("Bold")) {
                    this.fontstyle = 1;
                } else if (styleText.equals("Italic")) {
                    this.fontstyle = 2;
                } else if (styleText.equals("BoldItalic")) {
                    this.fontstyle = 3;
                } else {
                    MessageBox.showModalMessageBox(Util.getParentFrame(this), Message.format((String)RB.getStringResource((String)RB_KEY, (String)"InvalidStyle.txt"), (Object)this.comboStyle.getText()));
                    this.comboStyle.requestFocus();
                }
            }
            this.testLabel.setFont(this.getSelectedFont());
            this.updateFont();
        }
    }

    public Font getSelectedFont() {
        return new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public void setSelectedFont(Font ft) {
        if (ft != null) {
            String sfontname = ft.getName();
            String sfontstyle = new Integer(ft.getStyle()).toString();
            String sfontsize = new Integer(ft.getSize()).toString();
            OrderedCollection ocname = (OrderedCollection)this.comboName.getModelInterface();
            String styleText = "";
            if (sfontstyle.equals(new Integer(0).toString())) {
                styleText = "Plain";
            } else if (sfontstyle.equals(new Integer(1).toString())) {
                styleText = "Bold";
            } else if (sfontstyle.equals(new Integer(2).toString())) {
                styleText = "Italic";
            } else if (sfontstyle.equals(new Integer(3).toString())) {
                styleText = "BoldItalic";
            }
            if (ocname.contains((Object)sfontname) && !styleText.equals("")) {
                this.comboName.setText(sfontname);
                this.comboStyle.setText(styleText);
                this.comboSize.setText(sfontsize);
                this.fontname = ft.getName();
                this.fontstyle = ft.getStyle();
                this.fontsize = ft.getSize();
            }
            this.firePropertyChange("selectedFont", null, ft);
        }
    }
}

