/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.visuals.AnimationIconView;
import com.sas.visuals.FireworkIcon;
import com.sas.visuals.RB;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class Fireworks
extends AnimationIconView {
    public static final String RB_KEY = "Fireworks.";
    static final long serialVersionUID = -6470922073762846035L;
    protected FireworkIcon fireworkIcon;
    private static int defaultHeight = 124;
    private static int defaultWidth = 124;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "alarm"}, {"Expert", "true"}}, {{"Name", "animationIcon"}, {"Hidden", "true"}}, {{"Name", "icon"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.defaultInputPropertyName = "running";
        ebi.defaultOutputPropertyName = "running";
        return ebi;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        if (parent != null) {
            Util.addPropertyChangeListener((Object)this.getParent(), (PropertyChangeListener)((Object)this));
            if (this.isTransparent()) {
                this.setBackground(parent.getBackground());
            }
        }
    }

    @Override
    public void removeNotify() {
        if (this.getParent() != null) {
            Util.removePropertyChangeListener((Object)this.getParent(), (PropertyChangeListener)((Object)this));
        }
        super.removeNotify();
    }

    public void propertyChanged(PropertyChangeEvent e) {
        Container parent = this.getParent();
        Object eSource = e.getSource();
        String name = e.getPropertyName();
        if (eSource == parent && parent != null) {
            if (name != null && name.equals("background") && this.isTransparent()) {
                this.setBackground(parent.getBackground());
            }
        } else {
            super.propertyChange(e);
        }
    }

    @Override
    protected AnimationIconView createIconObject(AnimationIconView icon) {
        Fireworks clone = (Fireworks)icon;
        FireworkIcon newFireIcon = new FireworkIcon();
        newFireIcon.setGravity(this.getGravity());
        newFireIcon.setMaxRocketNumber(this.getMaxRocketNumber());
        newFireIcon.setMaxRocketExplosionEnergy(this.getMaxRocketExplosionEnergy());
        newFireIcon.setMaxRocketPatchNumber(this.getMaxRocketPatchNumber());
        newFireIcon.setMaxRocketPatchLength(this.getMaxRocketPatchLength());
        newFireIcon.setRocketStyleVariability(this.getRocketStyleVariability());
        newFireIcon.setPreferredSize(this.getPreferredSize());
        clone.setAnimationIcon(newFireIcon);
        return clone;
    }

    public int getGravity() {
        return this.fireworkIcon.getGravity();
    }

    public int getMaxRocketNumber() {
        return this.fireworkIcon.getMaxRocketNumber();
    }

    public int getMaxRocketExplosionEnergy() {
        return this.fireworkIcon.getMaxRocketExplosionEnergy();
    }

    public int getMaxRocketPatchNumber() {
        return this.fireworkIcon.getMaxRocketPatchNumber();
    }

    public int getMaxRocketPatchLength() {
        return this.fireworkIcon.getMaxRocketPatchLength();
    }

    public int getRocketStyleVariability() {
        return this.fireworkIcon.getRocketStyleVariability();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fireworkIcon.setPreferredSize(this.getSize());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.fireworkIcon.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setBackground(Color.black);
        this.fireworkIcon = new FireworkIcon();
        this.setAnimationIcon(this.fireworkIcon);
        this.setIcon(this.fireworkIcon);
    }

    public void setGravity(int g) {
        if (g != this.fireworkIcon.getGravity()) {
            int oldG = this.fireworkIcon.getGravity();
            this.fireworkIcon.setGravity(g);
            this.firePropertyChange("gravity", new Integer(oldG), new Integer(g));
        }
    }

    public void setMaxRocketNumber(int n) {
        if (n != this.fireworkIcon.getMaxRocketNumber()) {
            int oldN = this.fireworkIcon.getMaxRocketNumber();
            this.fireworkIcon.setMaxRocketNumber(n);
            this.firePropertyChange("maxRocketNumber", new Integer(oldN), new Integer(n));
        }
    }

    public void setMaxRocketExplosionEnergy(int e) {
        if (e != this.fireworkIcon.getMaxRocketExplosionEnergy()) {
            int oldE = this.fireworkIcon.getMaxRocketExplosionEnergy();
            this.fireworkIcon.setMaxRocketExplosionEnergy(e);
            this.firePropertyChange("maxRocketExplosionEnergy", new Integer(oldE), new Integer(e));
        }
    }

    public void setMaxRocketPatchNumber(int p) {
        if (p != this.fireworkIcon.getMaxRocketPatchNumber()) {
            int oldP = this.fireworkIcon.getMaxRocketPatchNumber();
            this.fireworkIcon.setMaxRocketPatchNumber(p);
            this.firePropertyChange("maxRocketPatchNumber", new Integer(oldP), new Integer(p));
        }
    }

    public void setMaxRocketPatchLength(int l) {
        if (l != this.fireworkIcon.getMaxRocketPatchLength()) {
            int oldL = this.fireworkIcon.getMaxRocketPatchLength();
            this.fireworkIcon.setMaxRocketPatchLength(l);
            this.firePropertyChange("maxRocketPatchLength", new Integer(oldL), new Integer(l));
        }
    }

    public void setRocketStyleVariability(int var) {
        if (var != this.fireworkIcon.getRocketStyleVariability()) {
            int oldVar = this.fireworkIcon.getRocketStyleVariability();
            this.fireworkIcon.setRocketStyleVariability(var);
            this.firePropertyChange("rocketStyleVariability", new Integer(oldVar), new Integer(var));
        }
    }
}

