/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.VisualInterface;
import com.sas.visuals.AnimationIconInterface;
import com.sas.visuals.Rocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class FireworkIcon
implements AnimationIconInterface,
Serializable {
    static final long serialVersionUID = -7527701423042954758L;
    protected int rocketStyleVariability = 10;
    protected int maxRocketNumber = 9;
    protected int maxRocketExplosionEnergy = 850;
    protected int maxRocketPatchNumber = 90;
    protected int maxRocketPatchLength = 68;
    protected int gravity = 400;
    protected transient int explosionEnergy;
    protected transient int patchNumber;
    protected transient int patchLength;
    protected transient long seed;
    protected transient Rocket[] rocket;
    protected transient boolean rocketsCreated = false;
    protected transient boolean reset = false;
    protected int width;
    protected int height;

    protected void createRockets() {
        Rocket[] tempRocket = new Rocket[this.maxRocketNumber];
        for (int i = 0; i < this.maxRocketNumber; ++i) {
            tempRocket[i] = new Rocket(this.width, this.height, this.gravity);
        }
        this.rocket = tempRocket;
        this.rocketsCreated = true;
    }

    public int getGravity() {
        return this.gravity;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public int getMaxRocketNumber() {
        return this.maxRocketNumber;
    }

    public int getMaxRocketExplosionEnergy() {
        return this.maxRocketExplosionEnergy;
    }

    public int getMaxRocketPatchNumber() {
        return this.maxRocketPatchNumber;
    }

    public int getMaxRocketPatchLength() {
        return this.maxRocketPatchLength;
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(this.width, this.height);
        return prefSize;
    }

    public int getRocketStyleVariability() {
        return this.rocketStyleVariability;
    }

    @Override
    public void decrement() {
        boolean sleep = true;
        for (int i = 0; i < this.maxRocketNumber; ++i) {
            sleep = sleep && this.rocket[i].sleep;
        }
        if (sleep && Math.random() * 100.0 < (double)this.rocketStyleVariability) {
            this.explosionEnergy = (int)(Math.random() * (double)this.maxRocketExplosionEnergy * 3.0 / 4.0) + this.maxRocketExplosionEnergy / 4 + 1;
            this.patchNumber = (int)(Math.random() * (double)this.maxRocketPatchNumber * 3.0 / 4.0) + this.maxRocketPatchNumber / 4 + 1;
            this.patchLength = (int)(Math.random() * (double)this.maxRocketPatchLength * 3.0 / 4.0) + this.maxRocketPatchLength / 4 + 1;
            this.seed = (long)(Math.random() * 10000.0);
        }
    }

    @Override
    public void increment() {
        boolean sleep = true;
        for (int i = 0; i < this.maxRocketNumber; ++i) {
            sleep = sleep && this.rocket[i].sleep;
        }
        if (sleep && Math.random() * 100.0 < (double)this.rocketStyleVariability) {
            this.explosionEnergy = (int)(Math.random() * (double)this.maxRocketExplosionEnergy * 3.0 / 4.0) + this.maxRocketExplosionEnergy / 4 + 1;
            this.patchNumber = (int)(Math.random() * (double)this.maxRocketPatchNumber * 3.0 / 4.0) + this.maxRocketPatchNumber / 4 + 1;
            this.patchLength = (int)(Math.random() * (double)this.maxRocketPatchLength * 3.0 / 4.0) + this.maxRocketPatchLength / 4 + 1;
            this.seed = (long)(Math.random() * 10000.0);
        }
    }

    public void paint(Component comp, Graphics g, int x, int y, int width, int height) {
        Color background = comp.getBackground();
        if (background != null) {
            g.setColor(background);
        } else {
            g.setColor(Color.black);
        }
        if (!(comp instanceof VisualInterface) || comp instanceof VisualInterface && !((VisualInterface)((Object)comp)).isTransparent()) {
            g.fillRect(x, y, width + 1, height + 1);
        }
    }

    @Override
    public void paintAnimation(Component comp, Graphics g, int x, int y, int width, int height) {
        Color background = comp.getBackground();
        if (this.reset) {
            this.reset = false;
            if (background != null) {
                g.setColor(background);
            } else {
                g.setColor(Color.black);
            }
            if (!(comp instanceof VisualInterface) || comp instanceof VisualInterface && !((VisualInterface)((Object)comp)).isTransparent()) {
                g.fillRect(x, y, width, height);
            }
        }
        if (this.rocketsCreated && g != null) {
            for (int i = 0; i < this.maxRocketNumber; ++i) {
                Rocket r = this.rocket[i];
                if (r.sleep && Math.random() * (double)this.maxRocketNumber * (double)this.patchLength < 1.0) {
                    r.init(this.explosionEnergy, this.patchNumber, this.patchLength, this.seed);
                    r.start();
                }
                if (background != null) {
                    g.setColor(background);
                } else {
                    g.setColor(Color.black);
                }
                if (!this.rocketsCreated) continue;
                r.showRocket(g);
            }
        }
    }

    @Override
    public void reset() {
        this.explosionEnergy = (int)(Math.random() * (double)this.maxRocketExplosionEnergy * 3.0 / 4.0) + this.maxRocketExplosionEnergy / 4 + 1;
        this.patchNumber = (int)(Math.random() * (double)this.maxRocketPatchNumber * 3.0 / 4.0) + this.maxRocketPatchNumber / 4 + 1;
        this.patchLength = (int)(Math.random() * (double)this.maxRocketPatchLength * 3.0 / 4.0) + this.maxRocketPatchLength / 4 + 1;
        this.seed = (long)(Math.random() * 10000.0);
        this.createRockets();
        this.reset = true;
    }

    public void setGravity(int g) {
        this.gravity = g;
        this.createRockets();
    }

    public void setMaxRocketNumber(int n) {
        this.maxRocketNumber = n;
        this.createRockets();
    }

    public void setMaxRocketExplosionEnergy(int e) {
        this.maxRocketExplosionEnergy = e;
    }

    public void setMaxRocketPatchNumber(int p) {
        this.maxRocketPatchNumber = p;
    }

    public void setMaxRocketPatchLength(int l) {
        this.maxRocketPatchLength = l;
    }

    public void setPreferredSize(Dimension size) {
        this.width = size.width;
        this.height = size.height;
        this.rocketsCreated = false;
        this.createRockets();
    }

    public void setRocketStyleVariability(int var) {
        this.rocketStyleVariability = var;
    }
}

