/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentException;
import com.sas.ModelInterface;
import com.sas.awt.Label;
import com.sas.awt.ListBox;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Permuter;
import com.sas.collection.StaticOrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.text.Message;
import com.sas.util.IndexedSetInterface;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.CompositePanel;
import com.sas.visuals.DualSelectorLayout;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.PushButton;
import com.sas.visuals.RB;
import com.sas.visuals.Resources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class DualSelector
extends CompositePanel
implements ActionListener,
ItemListener,
ContentsChangedListener {
    static final long serialVersionUID = 3422201980233088388L;
    static final String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    private boolean list1ControlsVisible;
    private boolean list2ControlsVisible;
    private boolean transferAllControlsVisible;
    private boolean dynamic;
    private boolean modelEventsIgnored;
    private TransformInterface displayTransform;
    private ModelInterface model2;
    private int list1MaximumCount;
    private int list2MaximumCount;
    private Label l1;
    private Label l2;
    protected Label label1;
    protected Label label2;
    protected ListBox listBox1;
    protected ListBox listBox2;
    protected PushButton alternatingButton;
    protected PushButton allRightButton;
    protected PushButton allLeftButton;
    protected PushButton down1Button;
    protected PushButton down2Button;
    protected PushButton up1Button;
    protected PushButton up2Button;
    private transient OrderedCollectionInterface initialItems1;
    private transient OrderedCollectionInterface initialItems2;
    private transient OrderedCollectionInterface list1;
    private transient OrderedCollectionInterface list2;
    private transient StaticOrderedCollection staticList1;
    private transient StaticOrderedCollection staticList2;
    private transient boolean defaultModelsSetCalled;
    private transient boolean direction;
    private transient boolean linksSet;
    private transient boolean usingDynamic;
    private transient IconInterface leftArrow;
    private transient IconInterface rightArrow;
    private transient Dimension preferredSize;
    private static final boolean RIGHT = false;
    private static final boolean LEFT = true;
    static int defaultWidth = 325;
    static int defaultHeight = 148;
    private static final String RB_KEY = "DualSelector.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "displayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "dynamic"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"dynamic.pd.txt")}}, {{"Name", "list1ControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1ControlsVisible.pd.txt")}}, {{"Name", "list1Count"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Count.pd.txt")}}, {{"Name", "list1DisplayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1DisplayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "list1Items"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Items.pd.txt")}}, {{"Name", "list1Label"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1Label.pd.txt")}}, {{"Name", "list1MaximumCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list1MaximumCount.pd.txt")}}, {{"Name", "list2ControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2ControlsVisible.pd.txt")}}, {{"Name", "list2Count"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Count.pd.txt")}}, {{"Name", "list2DisplayTransform"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2DisplayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "list2Items"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Items.pd.txt")}}, {{"Name", "list2Label"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2Label.pd.txt")}}, {{"Name", "list2MaximumCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2MaximumCount.pd.txt")}}, {{"Name", "list2ModelInterface"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"list2ModelInterface.pd.txt")}, {"Property editor class", "com.sas.beans.editors._ModelInterfaceEditor"}}, {{"Name", "modelEventsIgnored"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"modelEventsIgnored.pd.txt")}, {"Expert", "true"}}, {{"Name", "transferAllControlsVisible"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"transferAllControlsVisible.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultOutputPropertyName = "list2Items";
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newValue) {
        defaultWidth = newValue;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newValue) {
        defaultHeight = newValue;
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public void setDisplayTransform(TransformInterface newValue) {
        if (newValue == this.displayTransform) {
            return;
        }
        TransformInterface oldValue = this.displayTransform;
        this.displayTransform = newValue;
        this.listBox1.setDisplayTransform(newValue);
        this.listBox2.setDisplayTransform(newValue);
        this.firePropertyChange("displayTransfrom", oldValue, newValue);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean newValue) {
        boolean isList2AnOC;
        if (this.dynamic == newValue) {
            return;
        }
        boolean isList1AnOC = this.getModelInterface() == null || this.getModelInterface() instanceof OrderedCollectionInterface;
        boolean bl = isList2AnOC = this.getList2ModelInterface() == null || this.getList2ModelInterface() instanceof OrderedCollectionInterface;
        if (!(!newValue || isList1AnOC && isList2AnOC)) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"modelNotDynamic.ex.txt"));
        }
        this.dynamic = newValue;
        this.refresh();
        this.firePropertyChange("dynamic", this.dynamic ? Boolean.FALSE : Boolean.TRUE, this.dynamic ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isList1ControlsVisible() {
        return this.list1ControlsVisible;
    }

    public void setList1ControlsVisible(boolean newValue) {
        if (newValue == this.list1ControlsVisible) {
            return;
        }
        this.list1ControlsVisible = newValue;
        this.up1Button.setVisible(newValue);
        this.down1Button.setVisible(newValue);
        this.validate();
        this.repaint();
        this.firePropertyChange("list1ControlsVisible", this.list1ControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.list1ControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getList1Count() {
        return this.listBox1.getItemCount();
    }

    public TransformInterface getList1DisplayTransform() {
        return this.listBox1.getDisplayTransform();
    }

    public void setList1DisplayTransform(TransformInterface newValue) {
        TransformInterface oldValue = this.listBox1.getDisplayTransform();
        if (newValue == oldValue) {
            return;
        }
        this.listBox1.setDisplayTransform(newValue);
        this.firePropertyChange("list1DisplayTransform", oldValue, newValue);
    }

    public StaticOrderedCollectionInterface getList1Items() {
        if (this.staticList1 == null) {
            if (this.list1 != null) {
                this.staticList1 = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.list1);
            } else {
                return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection());
            }
        }
        return this.staticList1;
    }

    public String getList1Label() {
        return this.label1.getText();
    }

    public void setList1Label(String newValue) {
        String oldLabel = this.label1.getText();
        if (Util.equal((Object)oldLabel, (Object)newValue)) {
            return;
        }
        this.label1.setText(newValue);
        this.firePropertyChange("list1Label", oldLabel, newValue);
    }

    public int getList1MaximumCount() {
        return this.list1MaximumCount;
    }

    public void setList1MaximumCount(int newValue) {
        if (newValue == this.list1MaximumCount) {
            return;
        }
        if (newValue != -1 && this.getList1Count() > newValue) {
            throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidCount.ex.txt"), (Object)new Integer(newValue), (Object)new Integer(1), (Object)new Integer(this.getList1Count())));
        }
        if (this.anyPropertyChangeListeners()) {
            Integer oldValue = new Integer(this.list1MaximumCount);
            this.list1MaximumCount = newValue;
            this.firePropertyChange("list1MaximumCount", oldValue, new Integer(newValue));
        } else {
            this.list1MaximumCount = newValue;
        }
        this.ensureButtonsEnabled();
    }

    public boolean isList2ControlsVisible() {
        return this.list2ControlsVisible;
    }

    public void setList2ControlsVisible(boolean newValue) {
        if (newValue == this.list2ControlsVisible) {
            return;
        }
        this.list2ControlsVisible = newValue;
        this.up2Button.setVisible(newValue);
        this.down2Button.setVisible(newValue);
        this.validate();
        this.repaint();
        this.firePropertyChange("list2ControlsVisible", this.list2ControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.list2ControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getList2Count() {
        return this.listBox2.getItemCount();
    }

    public TransformInterface getList2DisplayTransform() {
        return this.listBox2.getDisplayTransform();
    }

    public void setList2DisplayTransform(TransformInterface newValue) {
        TransformInterface oldValue = this.listBox2.getDisplayTransform();
        if (newValue == oldValue) {
            return;
        }
        this.listBox2.setDisplayTransform(newValue);
        this.firePropertyChange("list2DisplayTransform", oldValue, newValue);
    }

    public StaticOrderedCollectionInterface getList2Items() {
        if (this.staticList2 == null) {
            if (this.list2 != null) {
                this.staticList2 = new StaticOrderedCollection((StaticOrderedCollectionInterface)this.list2);
            } else {
                return new StaticOrderedCollection((StaticOrderedCollectionInterface)new OrderedCollection());
            }
        }
        return this.staticList2;
    }

    public String getList2Label() {
        return this.label2.getText();
    }

    public void setList2Label(String newValue) {
        String oldValue = this.label2.getText();
        if (Util.equal((Object)newValue, (Object)oldValue)) {
            return;
        }
        this.label2.setText(newValue);
        this.firePropertyChange("list2Label", oldValue, newValue);
    }

    public int getList2MaximumCount() {
        return this.list2MaximumCount;
    }

    public void setList2MaximumCount(int newValue) {
        if (newValue == this.list2MaximumCount) {
            return;
        }
        if (newValue != -1 && this.getList2Count() > newValue) {
            throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"invalidCount.ex.txt"), (Object)new Integer(newValue), (Object)new Integer(2), (Object)new Integer(this.getList2Count())));
        }
        if (this.anyPropertyChangeListeners()) {
            Integer oldValue = new Integer(this.list2MaximumCount);
            this.list2MaximumCount = newValue;
            this.firePropertyChange("list2MaximumCount", oldValue, new Integer(newValue));
        } else {
            this.list2MaximumCount = newValue;
        }
        this.ensureButtonsEnabled();
    }

    public boolean isModelEventsIgnored() {
        return this.modelEventsIgnored;
    }

    public void setModelEventsIgnored(boolean newValue) {
        if (this.modelEventsIgnored == newValue) {
            return;
        }
        this.modelEventsIgnored = newValue;
        ContentsChangedSource ccs = (ContentsChangedSource)this.getModelInterface();
        if (ccs != null) {
            if (this.modelEventsIgnored || this.isDesignTime()) {
                ccs.removeContentsChangedListener((ContentsChangedListener)this);
            } else {
                ccs.addContentsChangedListener((ContentsChangedListener)this);
            }
        }
        if ((ccs = (ContentsChangedSource)this.getList2ModelInterface()) != null) {
            if (this.modelEventsIgnored || this.isDesignTime()) {
                ccs.removeContentsChangedListener((ContentsChangedListener)this);
            } else {
                ccs.addContentsChangedListener((ContentsChangedListener)this);
            }
        }
        this.firePropertyChange("modelEventsIgnored", this.modelEventsIgnored ? Boolean.FALSE : Boolean.TRUE, this.modelEventsIgnored ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTransferAllControlsVisible() {
        return this.transferAllControlsVisible;
    }

    public void setTransferAllControlsVisible(boolean newValue) {
        if (newValue == this.transferAllControlsVisible) {
            return;
        }
        this.transferAllControlsVisible = newValue;
        this.allRightButton.setVisible(this.transferAllControlsVisible);
        this.allLeftButton.setVisible(this.transferAllControlsVisible);
        this.validate();
        this.repaint();
        this.firePropertyChange("transferAllControlsVisible", this.transferAllControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.transferAllControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    protected synchronized void moveListItem(OrderedCollectionInterface list, boolean moveItemUp) {
        ListBox listBox = list == this.list1 ? this.listBox1 : this.listBox2;
        int[] indexes = listBox.getSelectedIndexes();
        if (indexes.length > 0) {
            boolean modelIgnored = this.isModelEventsIgnored();
            if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                list.removeContentsChangedListener((ContentsChangedListener)this);
            }
            int offset = moveItemUp ? -1 : 1;
            try {
                if (indexes.length == 1) {
                    Permuter.move((IndexedSetInterface)list, (int)indexes[0], (int)offset);
                } else {
                    Permuter.move((IndexedSetInterface)list, (int[])indexes, (int)offset);
                }
                int i = 0;
                while (i < indexes.length) {
                    int n = i++;
                    indexes[n] = indexes[n] + offset;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                list.addContentsChangedListener((ContentsChangedListener)this);
            }
            if (list == this.list1) {
                this.firePropertyChange("list1Items", null, this.getList1Items());
            } else {
                this.firePropertyChange("list2Items", null, this.getList2Items());
            }
            listBox.deselectAll();
            listBox.setSelectedIndexes(indexes);
        }
    }

    public synchronized void moveList1ItemUp() {
        this.moveListItem(this.list1, true);
    }

    public synchronized void moveList1ItemDown() {
        this.moveListItem(this.list1, false);
    }

    public synchronized void moveList2ItemUp() {
        this.moveListItem(this.list2, true);
    }

    public synchronized void moveList2ItemDown() {
        this.moveListItem(this.list2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferAllItems(OrderedCollectionInterface fromList, OrderedCollectionInterface toList) {
        OrderedCollectionInterface orderedCollectionInterface = fromList;
        synchronized (orderedCollectionInterface) {
            OrderedCollectionInterface orderedCollectionInterface2 = toList;
            synchronized (orderedCollectionInterface2) {
                int maxCount;
                int count = fromList.count() + toList.count();
                int n = maxCount = fromList == this.list1 ? this.getList2MaximumCount() : this.getList1MaximumCount();
                if (maxCount == -1 || count <= maxCount) {
                    boolean modelIgnored = this.isModelEventsIgnored();
                    if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                        fromList.removeContentsChangedListener((ContentsChangedListener)this);
                        toList.removeContentsChangedListener((ContentsChangedListener)this);
                    }
                    Vector<Object> fromItems = new Vector<Object>(fromList.count());
                    int cnt = fromList.count();
                    for (int i = 0; i < cnt; ++i) {
                        fromItems.addElement(fromList.get(i));
                    }
                    fromList.removeAll();
                    toList.addItems(fromItems.elements());
                    if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                        fromList.addContentsChangedListener((ContentsChangedListener)this);
                        toList.addContentsChangedListener((ContentsChangedListener)this);
                    }
                    this.ensureButtonsEnabled();
                    if (this.anyPropertyChangeListeners()) {
                        this.firePropertyChange("list1Items", null, this.getList1Items());
                        this.firePropertyChange("list2Items", null, this.getList2Items());
                    }
                }
            }
        }
    }

    public synchronized void transferAllList1Items() {
        this.transferAllItems(this.list1, this.list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferListItems(OrderedCollectionInterface fromList, OrderedCollectionInterface toList) {
        ListBox listBox = fromList == this.list1 ? this.listBox1 : this.listBox2;
        int maxCnt = fromList == this.list1 ? this.getList2MaximumCount() : this.getList1MaximumCount();
        int[] selectedIndexes = listBox.getSelectedIndexes();
        if (selectedIndexes != null && selectedIndexes.length > 0) {
            OrderedCollectionInterface orderedCollectionInterface = fromList;
            synchronized (orderedCollectionInterface) {
                OrderedCollectionInterface orderedCollectionInterface2 = toList;
                synchronized (orderedCollectionInterface2) {
                    int count = selectedIndexes.length + toList.count();
                    if (maxCnt == -1 || count <= maxCnt) {
                        boolean modelIgnored = this.isModelEventsIgnored();
                        if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                            fromList.removeContentsChangedListener((ContentsChangedListener)this);
                            toList.removeContentsChangedListener((ContentsChangedListener)this);
                        }
                        int numberOfRemoves = 0;
                        Vector<Object> selectedItems = new Vector<Object>();
                        for (int i = 0; i < selectedIndexes.length; ++i) {
                            Object item = fromList.get(selectedIndexes[i] - numberOfRemoves);
                            selectedItems.addElement(item);
                            fromList.removeAt(selectedIndexes[i] - numberOfRemoves);
                            ++numberOfRemoves;
                        }
                        if (selectedItems.size() > 0) {
                            toList.addItems(selectedItems.elements());
                        }
                        if (this.usingDynamic && !modelIgnored || this.isDesignTime()) {
                            fromList.addContentsChangedListener((ContentsChangedListener)this);
                            toList.addContentsChangedListener((ContentsChangedListener)this);
                        }
                        listBox.deselectAll();
                        this.ensureButtonsEnabled();
                        if (this.anyPropertyChangeListeners()) {
                            this.firePropertyChange("list1Items", null, this.getList1Items());
                            this.firePropertyChange("list2Items", null, this.getList2Items());
                        }
                    }
                }
            }
        }
    }

    public synchronized void transferList1Items() {
        this.transferListItems(this.list1, this.list2);
    }

    public synchronized void transferAllList2Items() {
        this.transferAllItems(this.list2, this.list1);
    }

    public synchronized void transferList2Items() {
        this.transferListItems(this.list2, this.list1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attachModel(ModelInterface mi) {
        boolean model2IsInitialItems;
        if (mi == null) {
            return;
        }
        if (!(mi instanceof StaticOrderedCollectionInterface)) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"unsupportedModel.ex.txt"));
        ModelInterface m1 = this.getModelInterface();
        ModelInterface m2 = this.getList2ModelInterface();
        boolean model1IsInitialItems = m1 == null ? true : m1.equals(this.initialItems1);
        boolean bl = model2IsInitialItems = m2 == null ? true : m2.equals(this.initialItems2);
        if (model1IsInitialItems) {
            if (m1 != null) {
                this.detachModel(m1);
            }
            this.internalAttachModel1(mi);
            return;
        } else {
            if (!model2IsInitialItems) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"exceededModelCount.ex.txt"));
            if (m2 != null) {
                this.detachModel(m2);
            }
            this.internalAttachModel2(mi);
        }
    }

    @Override
    public Dimension computePreferredSize() {
        this.preferredSize.width = DualSelector.getDefaultWidth();
        this.preferredSize.height = DualSelector.getDefaultHeight();
        return this.preferredSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachModel(ModelInterface mi) {
        ModelInterface mi1 = this.getModelInterface();
        ModelInterface mi2 = this.getList2ModelInterface();
        if (mi instanceof StaticOrderedCollectionInterface) {
            if (mi.equals(mi1)) {
                super.detachModel(mi);
                if ((!this.isModelEventsIgnored() || this.isDesignTime()) && mi instanceof OrderedCollectionInterface) {
                    ((ContentsChangedSource)mi).removeContentsChangedListener((ContentsChangedListener)this);
                }
                this.initialItems1.removeAll();
                this.attachModel((ModelInterface)this.initialItems1);
                return;
            } else {
                if (!mi.equals(mi2)) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"detachDenied.ex.txt"));
                this.internalDetachModel2(mi);
                if ((this.isModelEventsIgnored() || this.isDesignTime()) && mi instanceof OrderedCollectionInterface) {
                    ((ContentsChangedSource)mi).removeContentsChangedListener((ContentsChangedListener)this);
                }
                this.initialItems2.removeAll();
                this.internalAttachModel2((ModelInterface)this.initialItems2);
            }
            return;
        } else {
            super.detachModel(mi);
        }
    }

    @Override
    public int dragOver(Point point, int representation, int keyState, Vector data) {
        if (representation == 4 || representation == 1) {
            return 4;
        }
        return -1;
    }

    private void ensureButtonsEnabled() {
        int list1Count = this.listBox1.getItemCount();
        int list2Count = this.listBox2.getItemCount();
        int selCount = (!this.direction ? this.listBox1.getSelectedItems().length : this.listBox2.getSelectedItems().length) - 1;
        if (selCount < 0) {
            selCount = 0;
        }
        boolean enable = false;
        int maxCnt1 = this.getList1MaximumCount();
        int maxCnt2 = this.getList2MaximumCount();
        enable = !this.direction ? list2Count + selCount < maxCnt2 || maxCnt2 == -1 : list1Count + selCount < maxCnt1 || maxCnt1 == -1;
        this.alternatingButton.setEnabled(enable);
        enable = list1Count + list2Count < maxCnt1 || maxCnt1 == -1;
        this.allLeftButton.setEnabled(enable);
        enable = list1Count + list2Count < maxCnt2 || maxCnt2 == -1;
        this.allRightButton.setEnabled(enable);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    private void init() {
        if (this.leftArrow == null) {
            this.leftArrow = new ImageView(Resources.getImage((String)"LeftArrow"));
        }
        if (this.rightArrow == null) {
            this.rightArrow = new ImageView(Resources.getImage((String)"RightArrow"));
        }
        if (this.label1 == null) {
            this.label1 = new Label(RB.getStringResource((String)RB_KEY, (String)"available.txt"));
            this.label1.initialize();
        }
        if (this.label2 == null) {
            this.label2 = new Label(RB.getStringResource((String)RB_KEY, (String)"selected.txt"));
            this.label2.initialize();
        }
        if (this.listBox1 == null) {
            this.listBox1 = new ListBox();
            this.listBox1.initialize();
        }
        this.listBox1.setMultipleMode(true);
        if (this.listBox2 == null) {
            this.listBox2 = new ListBox();
            this.listBox2.initialize();
        }
        this.listBox2.setMultipleMode(true);
        if (this.allRightButton == null) {
            this.allRightButton = new PushButton((String)null);
            this.allRightButton.initialize();
        }
        ImageView icon = new ImageView(Resources.getImage((String)"DoubleRightArrow"));
        this.allRightButton.setDefaultIcon(icon);
        if (this.alternatingButton == null) {
            this.alternatingButton = new PushButton((String)null);
            this.alternatingButton.initialize();
        }
        this.alternatingButton.setDefaultIcon(this.rightArrow);
        if (this.allLeftButton == null) {
            this.allLeftButton = new PushButton((String)null);
            this.allLeftButton.initialize();
        }
        icon = new ImageView(Resources.getImage((String)"DoubleLeftArrow"));
        this.allLeftButton.setDefaultIcon(icon);
        if (this.up1Button == null) {
            this.up1Button = new PushButton((String)null);
            this.up1Button.initialize();
        }
        icon = new ImageView(Resources.getImage((String)"UpArrow"));
        this.up1Button.setDefaultIcon(icon);
        if (this.up2Button == null) {
            this.up2Button = new PushButton((String)null);
            this.up2Button.initialize();
        }
        this.up2Button.setDefaultIcon(icon);
        if (this.down1Button == null) {
            this.down1Button = new PushButton((String)null);
            this.down1Button.initialize();
        }
        icon = new ImageView(Resources.getImage((String)"DownArrow"));
        this.down1Button.setDefaultIcon(icon);
        if (this.down2Button == null) {
            this.down2Button = new PushButton((String)null);
            this.down2Button.initialize();
        }
        this.down2Button.setDefaultIcon(icon);
        if (this.initialItems1 == null) {
            this.initialItems1 = new OrderedCollection();
        } else {
            this.initialItems1.removeAll();
        }
        if (this.initialItems2 == null) {
            this.initialItems2 = new OrderedCollection();
        } else {
            this.initialItems2.removeAll();
        }
        if (this.getModelInterface() == null) {
            this.attachModel((ModelInterface)this.initialItems1);
        }
        if (this.getList2ModelInterface() == null) {
            this.internalAttachModel2((ModelInterface)this.initialItems2);
        }
        this.preferredSize = new Dimension(DualSelector.getDefaultWidth(), DualSelector.getDefaultHeight());
        this.makeDualSelector();
        this.ensureButtonsEnabled();
        this.addListeners();
    }

    private void addListeners() {
        this.listBox1.removeItemListener(this);
        this.listBox1.addItemListener(this);
        this.listBox1.removeActionListener(this);
        this.listBox1.addActionListener(this);
        this.listBox2.removeItemListener(this);
        this.listBox2.addItemListener(this);
        this.listBox2.removeActionListener(this);
        this.listBox2.addActionListener(this);
        this.allRightButton.removeActionListener(this);
        this.allRightButton.addActionListener(this);
        this.alternatingButton.removeActionListener(this);
        this.alternatingButton.addActionListener(this);
        this.allLeftButton.removeActionListener(this);
        this.allLeftButton.addActionListener(this);
        this.up1Button.removeActionListener(this);
        this.up1Button.addActionListener(this);
        this.up2Button.removeActionListener(this);
        this.up2Button.addActionListener(this);
        this.down1Button.removeActionListener(this);
        this.down1Button.addActionListener(this);
        this.down2Button.removeActionListener(this);
        this.down2Button.addActionListener(this);
    }

    private void makeDualSelector() {
        this.removeAll();
        this.setLayout(new DualSelectorLayout());
        this.add("list1", this.listBox1);
        this.add("list2", this.listBox2);
        this.add("list1Label", this.label1);
        this.add("list2Label", this.label2);
        this.add("list1Up", this.up1Button);
        this.up1Button.setVisible(this.list1ControlsVisible);
        this.add("list1Down", this.down1Button);
        this.down1Button.setVisible(this.list1ControlsVisible);
        this.add("list2Up", this.up2Button);
        this.up2Button.setVisible(this.list2ControlsVisible);
        this.add("list2Down", this.down2Button);
        this.down2Button.setVisible(this.list2ControlsVisible);
        this.add("alternating", this.alternatingButton);
        this.add("allLeft", this.allLeftButton);
        this.add("allRight", this.allRightButton);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException, NotActiveException {
        is.defaultReadObject();
        if (this.l1 != null) {
            this.label1 = this.l1;
        }
        if (this.l2 != null) {
            this.label2 = this.l2;
        }
        this.l2 = null;
        this.l1 = null;
        this.init();
    }

    public void refresh() {
        ModelInterface mi = this.getModelInterface();
        if (mi != null) {
            this.setList(mi, true);
        }
        if ((mi = this.getList2ModelInterface()) != null) {
            this.setList(mi, false);
        }
        this.ensureButtonsEnabled();
    }

    @Override
    public void refresh(ModelInterface mi) {
        this.refresh();
    }

    @Override
    public void setBackground(Color color) {
        this.label1.setBackgroundColor(color);
        this.label2.setBackgroundColor(color);
        this.alternatingButton.setBackgroundColor(color);
        this.allLeftButton.setBackgroundColor(color);
        this.allRightButton.setBackgroundColor(color);
        this.up1Button.setBackgroundColor(color);
        this.down1Button.setBackgroundColor(color);
        this.up2Button.setBackgroundColor(color);
        this.down2Button.setBackgroundColor(color);
        super.setBackground(color);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setIDEDnDDropTarget(false);
        this.list1ControlsVisible = false;
        this.list2ControlsVisible = false;
        this.transferAllControlsVisible = true;
        this.modelEventsIgnored = true;
        this.dynamic = false;
        this.list1MaximumCount = -1;
        this.list2MaximumCount = -1;
        this.init();
    }

    @Override
    public void setFont(Font font) {
        Font oldFont = this.getFont();
        super.setFont(font);
        if (oldFont != null && !oldFont.equals(font)) {
            this.invalidate();
            this.validate();
        }
    }

    @Override
    public void setForeground(Color color) {
        this.label1.setForegroundColor(color);
        this.label2.setForegroundColor(color);
        this.listBox1.setForegroundColor(color);
        this.listBox2.setForegroundColor(color);
        super.setForeground(color);
    }

    @Override
    public void setModelInterface(ModelInterface mi) {
        super.setModelInterface(mi);
        if (mi == null) {
            this.initialItems1.removeAll();
            this.attachModel((ModelInterface)this.initialItems1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.allRightButton) {
            this.transferAllList1Items();
        } else if (source == this.alternatingButton) {
            if (!this.direction) {
                this.transferList1Items();
            } else if (this.direction) {
                this.transferList2Items();
            }
        } else if (source == this.allLeftButton) {
            this.transferAllList2Items();
        } else if (source == this.up1Button) {
            this.moveList1ItemUp();
        } else if (source == this.down1Button) {
            this.moveList1ItemDown();
        } else if (source == this.up2Button) {
            this.moveList2ItemUp();
        } else if (source == this.down2Button) {
            this.moveList2ItemDown();
        } else if (source == this.listBox1) {
            this.transferList1Items();
        } else if (source == this.listBox2) {
            this.transferList2Items();
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        Object source = event.getSource();
        if (Util.equal((Object)source, (Object)this.getModelInterface()) || Util.equal((Object)source, (Object)this.getList2ModelInterface())) {
            this.refresh();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (ie.getStateChange() == 1) {
            if (source == this.listBox1) {
                this.alternatingButton.setDefaultIcon(this.rightArrow);
                this.listBox2.deselectAll();
                this.direction = false;
            } else if (source == this.listBox2) {
                this.alternatingButton.setDefaultIcon(this.leftArrow);
                this.listBox1.deselectAll();
                this.direction = true;
            }
        }
        this.ensureButtonsEnabled();
    }

    public ModelInterface getList2ModelInterface() {
        return this.model2;
    }

    public void setList2ModelInterface(ModelInterface mi) {
        this.internalDetachModel2(this.getList2ModelInterface());
        if (mi != null) {
            this.internalAttachModel2(mi);
        } else {
            this.initialItems2.removeAll();
            this.internalAttachModel2((ModelInterface)this.initialItems2);
        }
    }

    private void internalAttachModel1(ModelInterface mi) {
        StaticOrderedCollectionInterface si;
        if (this.list1MaximumCount >= 0 && (si = (StaticOrderedCollectionInterface)mi).count() > this.list1MaximumCount) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"exceededMaxCount.ex.txt"), (Object)new Integer(1), (Object)new Integer(si.count()), (Object)new Integer(this.list1MaximumCount)));
        }
        super.attachModel(mi);
        if (!this.isModelEventsIgnored() || this.isDesignTime()) {
            ((ContentsChangedSource)mi).addContentsChangedListener((ContentsChangedListener)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalAttachModel2(ModelInterface mi) {
        StaticOrderedCollectionInterface si;
        if (this.list2MaximumCount >= 0 && (si = (StaticOrderedCollectionInterface)mi).count() > this.list2MaximumCount) {
            throw new ComponentException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"exceededMaxCount.ex.txt"), (Object)new Integer(2), (Object)new Integer(si.count()), (Object)new Integer(this.list2MaximumCount)));
        }
        if (!this.supportsRequiredInterfaces(mi)) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"unsupportedModel.ex.txt"));
        if (!mi.attachView()) throw new ComponentException(RB.getStringResource((String)RB_KEY, (String)"attachDenied.ex.txt"));
        this.setList(mi, false);
        this.model2 = mi;
        if (!this.isModelEventsIgnored() || this.isDesignTime()) {
            ((ContentsChangedSource)mi).addContentsChangedListener((ContentsChangedListener)this);
        }
        this.refresh(mi);
    }

    private void internalDetachModel2(ModelInterface mi) {
        mi.detachView();
        this.removeInterfaceTraps(mi);
        this.model2 = null;
        this.refresh(null);
    }

    private void initialAttachDefaultModels() {
        if (this.defaultModelsSetCalled) {
            return;
        }
        super.attachModel((ModelInterface)this.initialItems1);
        this.internalAttachModel2((ModelInterface)this.initialItems2);
        this.defaultModelsSetCalled = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setList(ModelInterface mi, boolean isList1) {
        if (mi instanceof OrderedCollectionInterface) {
            ModelInterface model;
            ModelInterface modelInterface = model = isList1 ? this.getModelInterface() : this.getList2ModelInterface();
            if ((this.dynamic || this.isDesignTime()) && (model == null || model instanceof OrderedCollectionInterface)) {
                this.setListItems(mi, true, isList1);
                this.usingDynamic = true;
            } else {
                if (this.dynamic) throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"listNotDynamic.ex.txt"), (Object)new Integer(2)));
                this.setListItems(mi, false, isList1);
                this.usingDynamic = false;
            }
        } else {
            if (this.dynamic) throw new IllegalStateException(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"listNotDynamic.ex.txt"), (Object)new Integer(1)));
            this.setListItems(mi, false, isList1);
            this.usingDynamic = false;
        }
        if (isList1) {
            if (this.listBox1 == null) return;
            this.listBox1.setModelInterface((ModelInterface)this.list1);
            return;
        } else {
            if (this.listBox2 == null) return;
            this.listBox2.setModelInterface((ModelInterface)this.list2);
        }
    }

    private void setListItems(ModelInterface mi, boolean isOC, boolean isList1) {
        if (isList1) {
            this.list1 = isOC ? (OrderedCollectionInterface)mi : this.getCollectionOfItems(mi);
            this.staticList1 = null;
        } else {
            this.list2 = isOC ? (OrderedCollectionInterface)mi : this.getCollectionOfItems(mi);
            this.staticList2 = null;
        }
    }

    private OrderedCollectionInterface getCollectionOfItems(ModelInterface mi) {
        OrderedCollection oci = new OrderedCollection();
        Enumeration enumer = ((StaticOrderedCollectionInterface)mi).getItems();
        if (enumer != null && enumer.hasMoreElements()) {
            oci.addItems(enumer);
        }
        return oci;
    }
}

