/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.VisualAspects;
import com.sas.visuals.image.ColorMixerFilter;
import com.sas.visuals.image.GrayFilter;
import com.sas.visuals.image.ImageCache;
import com.sas.visuals.image.TransparencyFilter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;

public class DrawingSupport
implements VisualAspects {
    public static final void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        int interval;
        float deltaX = x2 - x1;
        float deltaY = y2 - y1;
        int width = deltaX > 0.0f ? (int)deltaX : (int)(-deltaX);
        int height = deltaY > 0.0f ? (int)deltaY : (int)(-deltaY);
        int n = interval = Toolkit.getDefaultToolkit().getScreenSize().width >= 800 ? 3 : 2;
        if (width > 0) {
            if (width > height) {
                int start = Math.min(x1, x2);
                int end = Math.max(x1, x2);
                float slope = deltaY / deltaX;
                for (int x = start; x <= end; ++x) {
                    if (x % interval != 0) continue;
                    int y = (int)(slope * (float)(x - x1) + (float)y1);
                    g.drawLine(x, y, x, y);
                }
            } else {
                int start = Math.min(y1, y2);
                int end = Math.max(y1, y2);
                float slope = deltaX / deltaY;
                for (int y = start; y <= end; ++y) {
                    if (y % interval != 0) continue;
                    int x = (int)(slope * (float)(y - y1) + (float)x1);
                    g.drawLine(x, y, x, y);
                }
            }
        } else {
            int x = x1;
            int start = Math.min(y1, y2);
            int end = Math.max(y1, y2);
            for (int y = start; y <= end; ++y) {
                if (y % interval != 0) continue;
                g.drawLine(x, y, x, y);
            }
        }
    }

    public static final void drawDottedLine(Graphics g, Point point1, Point point2) {
        DrawingSupport.drawDottedLine(g, point1.x, point1.y, point2.x, point2.y);
    }

    public static final void drawLine(Graphics g, Point point1, Point point2) {
        g.drawLine(point1.x, point1.y, point2.x, point2.y);
    }

    public static final void fillRect(Graphics g, Rectangle rectangle) {
        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawRect(Graphics g, Rectangle rectangle) {
        g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public static final void clearRect(Graphics g, Rectangle rectangle) {
        g.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawRoundRect(Graphics g, Rectangle rectangle, int arcWidth, int arcHeight) {
        g.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, arcWidth, arcHeight);
    }

    public static final void fillRoundRect(Graphics g, Rectangle rectangle, int arcWidth, int arcHeight) {
        g.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, arcWidth, arcHeight);
    }

    public static final void draw3DRoundRect(Graphics g, Rectangle rectangle, int arcWidth, int arcHeight, int style) {
        Rectangle tLRect = new Rectangle(rectangle.x, rectangle.y, arcWidth, arcHeight);
        Rectangle bLRect = new Rectangle(rectangle.x, rectangle.y + rectangle.height - arcHeight, arcWidth, arcHeight);
        Rectangle tRRect = new Rectangle(rectangle.x + rectangle.width - arcWidth, rectangle.y, arcWidth, arcHeight);
        Rectangle bRRect = new Rectangle(rectangle.x + rectangle.width - arcWidth, rectangle.y + rectangle.height - arcHeight, arcWidth, arcHeight);
        Color c = g.getColor();
        Color topLeft = c.brighter();
        Color bottomRight = c.darker();
        int[] borderStyle = new int[2];
        switch (style) {
            case 0: {
                borderStyle[0] = 0;
                borderStyle[1] = 1;
                break;
            }
            case 1: {
                borderStyle[0] = 0;
                borderStyle[1] = 1;
                break;
            }
            case 2: {
                borderStyle[0] = 2;
                borderStyle[1] = 3;
                break;
            }
        }
        for (int i = 0; i < 2; ++i) {
            switch (borderStyle[i]) {
                case 0: {
                    topLeft = SystemColor.controlLtHighlight;
                    bottomRight = SystemColor.windowBorder;
                    break;
                }
                case 1: {
                    topLeft = SystemColor.control;
                    bottomRight = SystemColor.controlShadow;
                    break;
                }
                case 2: {
                    topLeft = SystemColor.controlDkShadow;
                    bottomRight = SystemColor.controlLtHighlight;
                    break;
                }
                case 3: {
                    topLeft = SystemColor.controlShadow;
                    bottomRight = SystemColor.control;
                    break;
                }
                default: {
                    topLeft = SystemColor.controlLtHighlight;
                    bottomRight = SystemColor.windowBorder;
                }
            }
            g.setColor(topLeft);
            g.drawArc(bLRect.x, bLRect.y, bLRect.width, bLRect.height, 180, 45);
            g.drawLine(bLRect.x, bLRect.y + bLRect.height / 2, bLRect.x, tLRect.y + tLRect.height / 2);
            g.drawArc(tLRect.x, tLRect.y, tLRect.width, tLRect.height, 180, -90);
            g.drawLine(tLRect.x + tLRect.width / 2, tLRect.y, tRRect.x + tRRect.width / 2, tRRect.y);
            g.drawArc(tRRect.x, tRRect.y, tRRect.width, tRRect.height, 90, -45);
            g.setColor(bottomRight);
            g.drawArc(tRRect.x, tRRect.y, tRRect.width - 1, tRRect.height - 1, 0, 45);
            g.drawLine(tRRect.x + tRRect.width - 1, tRRect.y + tRRect.height / 2, tRRect.x + tRRect.width - 1, bRRect.y + bRRect.height / 2);
            g.drawArc(bRRect.x, bRRect.y, bRRect.width - 1, bRRect.height - 1, 0, -90);
            g.drawLine(bRRect.x + bRRect.width / 2, bRRect.y + bRRect.height - 1, bLRect.x + bLRect.width / 2, bLRect.y + bLRect.height - 1);
            g.drawArc(bLRect.x, bLRect.y, bLRect.width - 1, bLRect.height - 1, 270, -45);
            tLRect.grow(-1, -1);
            bLRect.grow(-1, -1);
            tRRect.grow(-1, -1);
            bRRect.grow(-1, -1);
            g.setColor(c);
        }
    }

    public static final void draw3DRect(Graphics g, Rectangle rectangle, boolean raised) {
        g.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, raised);
    }

    public static final void fill3DRect(Graphics g, Rectangle rectangle, boolean raised) {
        g.fill3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, raised);
    }

    public static final void drawArc(Graphics g, Rectangle rectangle, int startAngle, int arcAngle) {
        g.drawArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, startAngle, arcAngle);
    }

    public static final void fillArc(Graphics g, Rectangle rectangle, int startAngle, int arcAngle) {
        g.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, startAngle, arcAngle);
    }

    public static final void drawBasicBorderRect(Graphics g, Rectangle rectangle, int style) {
        DrawingSupport.drawBasicBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height, style);
    }

    public static final void drawBasicBorderRect(Graphics g, int x, int y, int width, int height, int style) {
        SystemColor bottomRight;
        SystemColor topLeft;
        Color c = g.getColor();
        switch (style) {
            case 1: {
                topLeft = SystemColor.controlLtHighlight;
                bottomRight = SystemColor.controlShadow;
                break;
            }
            case 2: {
                topLeft = SystemColor.controlShadow;
                bottomRight = SystemColor.controlLtHighlight;
                break;
            }
            case 3: {
                topLeft = SystemColor.windowBorder;
                bottomRight = SystemColor.control;
                break;
            }
            default: {
                topLeft = SystemColor.control;
                bottomRight = SystemColor.windowBorder;
            }
        }
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, c, topLeft, bottomRight);
    }

    public static final void drawColoredBorderRect(Graphics g, Rectangle rectangle, int style, Color c) {
        DrawingSupport.drawColoredBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height, style, c);
    }

    public static final void drawColoredBorderRect(Graphics g, int x, int y, int width, int height, int style, Color c) {
        Color bottomRight;
        Color topLeft;
        switch (style) {
            case 1: {
                topLeft = c.equals(c.brighter()) ? Color.white : c.brighter();
                bottomRight = c.equals(c.darker()) ? Color.black : c.darker();
                break;
            }
            case 2: {
                topLeft = c.equals(c.darker()) ? Color.black : c.darker();
                bottomRight = c.equals(c.brighter()) ? Color.white : c.brighter();
                break;
            }
            case 3: {
                topLeft = Color.black;
                bottomRight = c;
                break;
            }
            default: {
                topLeft = c;
                bottomRight = Color.black;
            }
        }
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, c, topLeft, bottomRight);
    }

    public static final void drawBasicBorderRect(Graphics g, int x, int y, int width, int height, Color c, Color topLeft, Color bottomRight) {
        g.setColor(topLeft);
        g.drawLine(x, y, x, y + height - 2);
        g.drawLine(x, y, x + width - 2, y);
        g.setColor(bottomRight);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x, y + height - 1);
        g.setColor(c);
    }

    public static final void drawWindowBorderRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawWindowBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawWindowBorderRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, 0);
        DrawingSupport.drawBasicBorderRect(g, x + 1, y + 1, width - 2, height - 2, 1);
    }

    public static final void drawBasicButtonBorderRect(Graphics g, Rectangle rectangle, int style) {
        DrawingSupport.drawBasicButtonBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height, style);
    }

    public static final void drawBasicButtonBorderRect(Graphics g, int x, int y, int width, int height, int style) {
        Color c = g.getColor();
        Color topLeft = c.brighter();
        Color bottomRight = c.darker();
        switch (style) {
            case 0: {
                topLeft = SystemColor.controlLtHighlight;
                bottomRight = SystemColor.windowBorder;
                break;
            }
            case 1: {
                topLeft = SystemColor.control;
                bottomRight = SystemColor.controlShadow;
                break;
            }
            case 2: {
                topLeft = SystemColor.controlDkShadow;
                bottomRight = SystemColor.controlLtHighlight;
                break;
            }
            case 3: {
                topLeft = SystemColor.controlShadow;
                bottomRight = SystemColor.control;
                break;
            }
            default: {
                topLeft = SystemColor.controlLtHighlight;
                bottomRight = SystemColor.windowBorder;
            }
        }
        g.setColor(topLeft);
        g.drawLine(x, y, x, y + height - 2);
        g.drawLine(x, y, x + width - 2, y);
        g.setColor(bottomRight);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x, y + height - 1);
        g.setColor(c);
    }

    public static final void drawButtonBorderRect(Graphics g, Rectangle rectangle, int style) {
        DrawingSupport.drawButtonBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height, style);
    }

    public static final void drawButtonBorderRect(Graphics g, int x, int y, int width, int height, int style) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Color c = g.getColor();
        switch (style) {
            case 0: {
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 0);
                rectangle.grow(-1, -1);
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 1);
                rectangle.grow(-1, -1);
                g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 1: {
                g.setColor(Color.black);
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(c);
                rectangle.grow(-1, -1);
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 0);
                rectangle.grow(-1, -1);
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 1);
                break;
            }
            case 2: {
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 2);
                rectangle.grow(-1, -1);
                DrawingSupport.drawBasicButtonBorderRect(g, rectangle, 3);
                rectangle.grow(-1, -1);
                g.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
        }
    }

    public static final void drawFieldBorderRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawFieldBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawFieldBorderRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, 2);
        DrawingSupport.drawBasicBorderRect(g, x + 1, y + 1, width - 2, height - 2, 3);
    }

    public static final void drawStatusFieldBorderRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawStatusFieldBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawStatusFieldBorderRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, 2);
    }

    public static final void drawGroupBorderRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawGroupBorderRect(g, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final void drawGroupBorderRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawBasicBorderRect(g, x, y, width, height, 2);
        DrawingSupport.drawBasicBorderRect(g, x + 1, y + 1, width - 2, height - 2, 1);
    }

    public static final void drawFocusRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawFocusRect(g, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public static final void drawDottedRect(Graphics g, Rectangle rectangle) {
        DrawingSupport.drawDottedRect(g, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawDottedRect(g, x, y, width, height, true);
    }

    public static final void drawDottedRect(Graphics g, int x, int y, int width, int height) {
        DrawingSupport.drawDottedRect(g, x, y, width, height, false);
    }

    public static final void drawDottedRect(Graphics g, int x, int y, int width, int height, boolean XOR) {
        Color c = g.getColor();
        if (XOR) {
            g.setXORMode(c);
            g.setColor(Color.black);
        }
        DrawingSupport.drawDottedLine(g, x, y, x + width, y);
        DrawingSupport.drawDottedLine(g, x, y, x, y + height);
        DrawingSupport.drawDottedLine(g, x + width, y, x + width, y + height);
        DrawingSupport.drawDottedLine(g, x, y + height, x + width, y + height);
        if (XOR) {
            g.setColor(c);
            g.setPaintMode();
        }
    }

    public static final void drawString(Graphics g, String[] text, int x, int y, int drawStringMask) {
        DrawingSupport.drawString(g, text, x, y, drawStringMask, null);
    }

    public static final void drawString(Graphics g, String[] text, int x, int y, int drawStringMask, Color opaque) {
        int width = DrawingSupport.getStringSize((Graphics)g, (String[])text).width;
        int ascent = DrawingSupport.getStringAscent(g);
        int descent = DrawingSupport.getStringDescent(g);
        Point point = new Point();
        for (int i = 0; i < text.length; ++i) {
            Dimension size = DrawingSupport.getStringSize(g, text[i]);
            if ((drawStringMask & 4) != 0) {
                point.x = x;
                point.y = y + (i + 1) * ascent;
                point.y += i * descent;
                DrawingSupport.drawString(g, text[i], point.x, point.y, drawStringMask, opaque);
                continue;
            }
            if ((drawStringMask & 2) != 0) {
                point.x = x + width - size.width;
                point.y = y + (i + 1) * ascent;
                point.y += i * descent;
                DrawingSupport.drawString(g, text[i], point.x, point.y, drawStringMask, opaque);
                continue;
            }
            point.x = x + (width - size.width) / 2;
            point.y = y + (i + 1) * ascent;
            point.y += i * descent;
            DrawingSupport.drawString(g, text[i], point.x, point.y, drawStringMask, opaque);
        }
    }

    public static final void drawString(Graphics g, String text, int x, int y, int drawStringMask) {
        DrawingSupport.drawString(g, text, x, y, drawStringMask, null);
    }

    public static final void drawString(Graphics g, String text, int x, int y, int drawStringMask, Color opaque) {
        Dimension size = null;
        int ascent = -1;
        if ((drawStringMask & 0x20) != 0 && opaque != null) {
            size = DrawingSupport.getStringSize(g, text);
            ascent = DrawingSupport.getStringAscent(g);
            Color c = g.getColor();
            g.setColor(opaque);
            g.fillRect(x, y - ascent, size.width, size.height);
            g.setColor(c);
        }
        g.drawString(text, x, y);
        if ((drawStringMask & 0x10) != 0) {
            size = size == null ? DrawingSupport.getStringSize(g, text) : size;
            ascent = ascent == -1 ? DrawingSupport.getStringAscent(g) : ascent;
            g.drawLine(x, y + 1, x + (size.width - 1), y + 1);
        }
    }

    public static final void drawDisabledString(Graphics g, String[] text, int x, int y, int drawStringMask) {
        DrawingSupport.drawDisabledString(g, text, x, y, drawStringMask, null);
    }

    public static final void drawDisabledString(Graphics g, String[] text, int x, int y, int drawStringMask, Color opaque) {
        int width = DrawingSupport.getStringSize((Graphics)g, (String[])text).width;
        int ascent = DrawingSupport.getStringAscent(g);
        int descent = DrawingSupport.getStringDescent(g);
        Point point = new Point();
        for (int i = 0; i < text.length; ++i) {
            Dimension size = DrawingSupport.getStringSize(g, text[i]);
            if ((drawStringMask & 4) != 0) {
                point.x = x;
                point.y = y + (i + 1) * ascent;
                point.y += i * descent;
                DrawingSupport.drawDisabledString(g, text[i], point.x, point.y, drawStringMask, opaque);
                continue;
            }
            if ((drawStringMask & 2) != 0) {
                point.x = x + width - size.width;
                point.y = y + (i + 1) * ascent;
                point.y += i * descent;
                DrawingSupport.drawDisabledString(g, text[i], point.x, point.y, drawStringMask, opaque);
                continue;
            }
            point.x = x + (width - size.width) / 2;
            point.y = y + (i + 1) * ascent;
            point.y += i * descent;
            DrawingSupport.drawDisabledString(g, text[i], point.x, point.y, drawStringMask, opaque);
        }
    }

    public static final void drawDisabledString(Graphics g, String text, int x, int y) {
        DrawingSupport.drawDisabledString(g, text, x, y, 0, null);
    }

    public static final void drawDisabledString(Graphics g, String text, int x, int y, int drawStringMask) {
        DrawingSupport.drawDisabledString(g, text, x, y, drawStringMask, null);
    }

    public static final void drawDisabledString(Graphics g, String text, int x, int y, int drawStringMask, Color opaque) {
        Color c = g.getColor();
        g.setColor(c.brighter());
        DrawingSupport.drawString(g, text, x + 1, y + 1, drawStringMask, opaque);
        g.setColor(c.darker());
        DrawingSupport.drawString(g, text, x, y, drawStringMask, opaque);
        g.setColor(c);
    }

    public static final boolean drawDisabledImage(Graphics g, Image img, int x, int y, ImageObserver observer) {
        return DrawingSupport.drawDisabledImage(g, img, x, y, observer, ImageCache.isEnabled());
    }

    public static final boolean drawDisabledImage(Graphics g, Image img, int x, int y, ImageObserver observer, boolean cache) {
        Color c = g.getColor();
        boolean status = false;
        Image[] image = new Image[2];
        if (cache) {
            image[0] = ImageCache.getImage((Image)img, (String)"disabled sink");
            image[1] = ImageCache.getImage((Image)img, (String)"disabled grey");
        }
        if (image[0] == null || image[1] == null) {
            GrayFilter filter = new GrayFilter(c, 0);
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), (ImageFilter)filter);
            image[0] = Toolkit.getDefaultToolkit().createImage(producer);
            filter = new GrayFilter(c, 1);
            producer = new FilteredImageSource(img.getSource(), (ImageFilter)filter);
            image[1] = Toolkit.getDefaultToolkit().createImage(producer);
            if (!cache) {
                MediaTracker tracker = new MediaTracker((Component)observer);
                tracker.addImage(image[0], 0);
                tracker.addImage(image[1], 1);
                try {
                    tracker.waitForAll();
                }
                catch (Exception exception) {}
            } else {
                ImageCache.addImage((Image)img, (Image)image[0], (String)"disabled sink");
                ImageCache.addImage((Image)img, (Image)image[1], (String)"disabled grey");
            }
        }
        if (status = g.drawImage(image[0], x + 1, y + 1, observer)) {
            status = g.drawImage(image[1], x, y, observer);
        }
        return status;
    }

    public static final boolean drawMixedImage(Graphics g, Image img, int x, int y, Color c, ImageObserver observer) {
        return DrawingSupport.drawMixedImage(g, img, x, y, c, observer, ImageCache.isEnabled());
    }

    public static final boolean drawMixedImage(Graphics g, Image img, int x, int y, Color c, ImageObserver observer, boolean cache) {
        boolean status = false;
        Image image = null;
        if (cache) {
            image = ImageCache.getImage((Image)img, (String)"mixed");
        }
        if (image == null) {
            ColorMixerFilter filter = new ColorMixerFilter(c);
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), (ImageFilter)filter);
            image = Toolkit.getDefaultToolkit().createImage(producer);
            if (!cache) {
                MediaTracker tracker = new MediaTracker((Component)observer);
                tracker.addImage(image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (Exception exception) {}
            } else {
                ImageCache.addImage((Image)img, (Image)image, (String)"mixed");
            }
        }
        status = g.drawImage(image, x, y, observer);
        return status;
    }

    public static final boolean drawTransparentImage(Graphics g, Image img, int x, int y, Color c, ImageObserver observer) {
        return DrawingSupport.drawTransparentImage(g, img, x, y, c, observer, ImageCache.isEnabled());
    }

    public static final boolean drawTransparentImage(Graphics g, Image img, int x, int y, Color c, ImageObserver observer, boolean cache) {
        boolean status = false;
        Image image = null;
        if (cache) {
            image = ImageCache.getImage((Image)img, (String)"transparent");
        }
        if (image == null) {
            TransparencyFilter filter = new TransparencyFilter(c);
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), (ImageFilter)filter);
            image = Toolkit.getDefaultToolkit().createImage(producer);
            if (!cache) {
                MediaTracker tracker = new MediaTracker((Component)observer);
                tracker.addImage(image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (Exception exception) {}
            } else {
                ImageCache.addImage((Image)img, (Image)image, (String)"transparent");
            }
        }
        status = g.drawImage(image, x, y, observer);
        return status;
    }

    public static final Dimension getStringSize(Graphics g, String[] text) {
        return DrawingSupport.getStringSize(g, text, g.getFont());
    }

    public static final Dimension getStringSize(Graphics g, String[] text, Font font) {
        Dimension size = new Dimension(0, 0);
        for (int i = 0; i < text.length; ++i) {
            Dimension dim = DrawingSupport.getStringSize(g, text[i], font);
            size.width = size.width > dim.width ? size.width : dim.width;
            size.height += dim.height;
        }
        return size;
    }

    public static final Dimension getStringSize(Graphics g, String text) {
        return DrawingSupport.getStringSize(g, text, g.getFont());
    }

    public static final Dimension getStringSize(Graphics g, String text, Font font) {
        int width;
        int height;
        FontMetrics fm = g.getFontMetrics(font);
        try {
            height = text.equals("") ? 0 : fm.getMaxAscent() + fm.getMaxDescent();
            width = text.equals("") ? 0 : fm.stringWidth(text);
        }
        catch (NullPointerException e) {
            width = 0;
            height = 0;
        }
        return new Dimension(width, height);
    }

    public static final int getStringAscent(Graphics g) {
        return DrawingSupport.getStringAscent(g, g.getFont());
    }

    public static final int getStringDescent(Graphics g) {
        return DrawingSupport.getStringDescent(g, g.getFont());
    }

    public static final int getStringAscent(Graphics g, Font font) {
        int ascent;
        FontMetrics fm = g.getFontMetrics(font);
        try {
            ascent = fm.getMaxAscent();
        }
        catch (NullPointerException e) {
            ascent = 0;
        }
        return ascent;
    }

    public static final int getStringDescent(Graphics g, Font font) {
        int descent;
        FontMetrics fm = g.getFontMetrics(font);
        try {
            descent = fm.getMaxDescent();
        }
        catch (NullPointerException e) {
            descent = 0;
        }
        return descent;
    }

    public static final Dimension getImageSize(Graphics g, Image image, Component component) throws NullPointerException {
        Dimension size = new Dimension(0, 0);
        if (image == null) {
            throw new NullPointerException("null Image");
        }
        MediaTracker tracker = new MediaTracker(component);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        size.width = image.getWidth(component);
        size.height = image.getHeight(component);
        return size;
    }

    public static Applet appletFromComponent(Component component) {
        if (component == null) {
            return null;
        }
        while (!(component instanceof Applet) && component != null) {
            component = component.getParent();
        }
        return component != null ? (Applet)component : null;
    }

    public static Frame frameFromComponent(Component component) {
        if (component == null) {
            return null;
        }
        while (!(component instanceof Frame) && component != null) {
            component = component.getParent();
        }
        return component != null ? (Frame)component : null;
    }

    public static Point relativePoint(Component srcComponent, Component destComponent, Point point) {
        Point componentLocation;
        Point destPoint = new Point(point.x, point.y);
        while (!srcComponent.equals(destComponent)) {
            componentLocation = srcComponent.getLocation();
            destPoint.x += componentLocation.x;
            destPoint.y += componentLocation.y;
            srcComponent = srcComponent.getParent();
        }
        componentLocation = srcComponent.getLocation();
        destPoint.x += componentLocation.x;
        destPoint.y += componentLocation.y;
        return destPoint;
    }

    public static Point screenPoint(Component component, Point point) {
        Point pt = component.getLocationOnScreen();
        pt.x += point.x;
        pt.y += point.y;
        return pt;
    }
}

