/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.awt.AWTEventMulticaster2;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.SelectionGroupInterface;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DefaultButtonModel
extends Component
implements ButtonModelInterface {
    static final long serialVersionUID = 3971355329204640233L;
    protected String actionCommand;
    protected char keyAccelerator;
    protected int nextState;
    protected int prevState;
    protected SelectionGroupInterface selectionGroup;
    protected int state;
    protected int stateCount;
    protected boolean armed;
    protected boolean disabled;
    protected boolean rollover;
    protected boolean pressed;
    protected boolean selected;
    protected transient ActionListener actionListenerList;
    protected transient ItemListener itemListenerList;

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, listener);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListenerList = AWTEventMulticaster.add(this.itemListenerList, listener);
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public char getKeyAccelerator() {
        return this.keyAccelerator;
    }

    @Override
    public int getNextState() {
        return this.nextState;
    }

    @Override
    public int getPrevState() {
        return this.prevState;
    }

    @Override
    public SelectionGroupInterface getSelectionGroup() {
        return this.selectionGroup;
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getStateCount() {
        return this.stateCount;
    }

    @Override
    public boolean isArmed() {
        return this.armed;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            if ("itemL" == key) {
                this.addItemListener((ItemListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListenerList = AWTEventMulticaster.remove(this.itemListenerList, l);
    }

    @Override
    public void setActionCommand(String cmd) {
        if (this.actionCommand != cmd) {
            String oldCommand = this.actionCommand;
            this.actionCommand = cmd;
            this.firePropertyChange("actionCommand", oldCommand, this.actionCommand);
        }
    }

    @Override
    public void setArmed(boolean a) {
        if (!this.isDisabled() && this.armed != a) {
            this.armed = a;
            this.firePropertyChange("armed", new Boolean(!this.armed), new Boolean(this.armed));
        }
    }

    public void setDefaultValues() {
        super.setDefaultValues();
        this.stateCount = 2;
    }

    @Override
    public void setDisabled(boolean d) {
        if (this.disabled != d) {
            this.disabled = d;
            this.firePropertyChange("disabled", new Boolean(!this.disabled), new Boolean(this.disabled));
        }
    }

    @Override
    public void setKeyAccelerator(char key) {
        if (this.keyAccelerator != key) {
            char oldKey = this.keyAccelerator;
            this.keyAccelerator = key;
            this.firePropertyChange("keyAccelerator", new Character(oldKey), new Character(this.keyAccelerator));
        }
    }

    @Override
    public void setPressed(boolean p) {
        if (!this.isDisabled() && this.pressed != p) {
            this.pressed = p;
            if (this.armed && !this.pressed && this.actionListenerList != null) {
                this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
            this.firePropertyChange("pressed", new Boolean(!this.pressed), new Boolean(this.pressed));
        }
    }

    @Override
    public void setRollover(boolean r) {
        if (!this.isDisabled() && this.rollover != r) {
            this.rollover = r;
            this.firePropertyChange("rollover", new Boolean(!this.rollover), new Boolean(this.rollover));
        }
    }

    @Override
    public void setSelected(boolean s) {
        if (this.selected != s) {
            this.selected = s;
            if (this.itemListenerList != null) {
                this.itemListenerList.itemStateChanged(new ItemEvent(this, 701, this, this.selected ? 1 : 2));
            }
            this.firePropertyChange("selected", new Boolean(!this.selected), new Boolean(this.selected));
        }
    }

    @Override
    public void setSelectionGroup(SelectionGroupInterface group) {
        if (this.selectionGroup != group) {
            SelectionGroupInterface oldSelectionGroup = this.selectionGroup;
            this.selectionGroup = group;
            this.firePropertyChange("selectionGroup", oldSelectionGroup, this.selectionGroup);
        }
    }

    @Override
    public void setState(int s) {
        if (this.state != s) {
            int oldPrevState = this.prevState;
            this.nextState = this.prevState = this.state;
            this.state = s;
            if (this.state == 0) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
            this.firePropertyChange("state", new Integer(this.prevState), new Integer(this.state));
            this.firePropertyChange("prevState", new Integer(oldPrevState), new Integer(this.prevState));
            this.firePropertyChange("nextState", new Integer(this.state), new Integer(this.getNextState()));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster2.save(s, "actionL", this.actionListenerList);
        AWTEventMulticaster2.save(s, "itemL", this.itemListenerList);
        s.writeObject(null);
    }
}

