/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.Component;
import com.sas.visuals.ButtonListenerInterface;
import com.sas.visuals.ButtonModelInterface;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class DefaultButtonListener
extends Component
implements ButtonListenerInterface {
    static final long serialVersionUID = 694417977459964592L;
    protected ButtonModelInterface model;

    public DefaultButtonListener() {
    }

    public DefaultButtonListener(ButtonModelInterface btnModel) {
        this.model = btnModel;
    }

    @Override
    public ButtonModelInterface getButtonModel() {
        return this.model;
    }

    @Override
    public void setButtonModel(ButtonModelInterface btnModel) {
        if (btnModel != this.model) {
            ButtonModelInterface oldModel = btnModel;
            this.model = btnModel;
            this.firePropertyChange("buttonModel", oldModel, this.model);
        }
    }

    protected boolean isActivationKey(KeyEvent keyEvent) {
        int keyCode = keyEvent.getKeyCode();
        char keyChar = keyEvent.getKeyChar();
        return this.model != null && keyChar != '\uffff' && keyChar == this.model.getKeyAccelerator() || keyCode == 32 || keyCode == 10;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (this.model != null && this.isActivationKey(evt)) {
            this.model.setArmed(true);
            this.model.setPressed(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (this.model != null && this.isActivationKey(evt)) {
            this.model.setPressed(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.model != null && this.model.isPressed()) {
            java.awt.Component comp = (java.awt.Component)evt.getSource();
            Rectangle bounds = comp.getBounds();
            bounds.x = 0;
            bounds.y = 0;
            if (bounds.contains(evt.getPoint())) {
                this.model.setRollover(true);
                this.model.setArmed(true);
            } else {
                this.model.setRollover(false);
                this.model.setArmed(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.model != null && evt.getClickCount() == 1) {
            this.model.setArmed(true);
            this.model.setPressed(true);
            java.awt.Component button = (java.awt.Component)evt.getSource();
            button.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.model != null) {
            this.model.setPressed(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (this.model != null) {
            this.model.setRollover(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.model != null) {
            this.model.setRollover(false);
        }
    }
}

