/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.Border;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.RB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class CompositeBorder
extends Border {
    static final long serialVersionUID = -5664910637277432642L;
    public static final String RB_KEY = "CompositeBorder.";
    protected int borderGap;
    protected Border interiorBorder;
    protected Border exteriorBorder;
    protected BorderInterface intBorder;
    protected BorderInterface extBorder;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "borderGap"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"borderGap.pd.txt")}}, {{"Name", "interiorBorder"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"interiorBorder.pd.txt")}}, {{"Name", "exteriorBorder"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"exteriorBorder.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public CompositeBorder() {
        this(new BaseBorder(0), new BaseBorder(0), 0);
    }

    public CompositeBorder(BorderInterface exterior, BorderInterface interior, int gap) {
        this.borderGap = gap;
        this.intBorder = interior;
        this.extBorder = exterior;
        super.setStyle(1);
        Util.addPropertyChangeListener((Object)this.intBorder, (PropertyChangeListener)((Object)this));
        Util.addPropertyChangeListener((Object)this.extBorder, (PropertyChangeListener)((Object)this));
    }

    @Override
    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        if (this.style == 0 || g == null) {
            return;
        }
        Color currentColor = g.getColor();
        this.extBorder.drawInRect(comp, g, x, y, width, height);
        Rectangle interior = new Rectangle();
        Insets insets = this.extBorder.getInsets(comp);
        interior.x = x + insets.left;
        interior.y = y + insets.top;
        interior.width = width - insets.left - insets.right;
        interior.height = height - insets.top - insets.bottom;
        interior.grow(-this.borderGap, -this.borderGap);
        this.intBorder.drawInRect(comp, g, interior.x, interior.y, interior.width, interior.height);
        g.setColor(currentColor);
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    @Override
    public int getBorderWidth() {
        return this.getInteriorBorder().getBorderWidth() + this.getExteriorBorder().getBorderWidth() + this.borderGap;
    }

    public BorderInterface getExteriorBorder() {
        return this.extBorder;
    }

    public BorderInterface getInteriorBorder() {
        return this.intBorder;
    }

    @Override
    public Insets getInsets(Component comp) {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets interiorInsets = this.intBorder.getInsets(comp);
        Insets exteriorInsets = this.extBorder.getInsets(comp);
        insets.top = interiorInsets.top + exteriorInsets.top + this.borderGap;
        insets.bottom = interiorInsets.bottom + exteriorInsets.bottom + this.borderGap;
        insets.left = interiorInsets.left + exteriorInsets.left + this.borderGap;
        insets.right = interiorInsets.right + exteriorInsets.right + this.borderGap;
        return insets;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.intBorder) {
            this.firePropertyChange("interiorBorder", null, this.intBorder);
        } else if (event.getSource() == this.extBorder) {
            this.firePropertyChange("exteriorBorder", null, this.extBorder);
        }
    }

    @Override
    public void setBaseColor(Color c) {
        if (c != null && !c.equals(this.getBaseColor())) {
            this.setBaseColor(c);
        }
    }

    public void setBorderGap(int gap) {
        if (this.borderGap != gap) {
            int oldGap = this.borderGap;
            this.borderGap = gap;
            this.firePropertyChange("borderGap", new Integer(oldGap), new Integer(this.borderGap));
        }
    }

    @Override
    public void setBorderWidth(int width) {
    }

    public void setExteriorBorder(BorderInterface exterior) {
        if (!com.sas.util.Util.equal((Object)exterior, (Object)this.extBorder)) {
            BorderInterface oldBorder = this.extBorder;
            this.extBorder = exterior == null ? new BaseBorder(0) : exterior;
            Util.removePropertyChangeListener((Object)oldBorder, (PropertyChangeListener)((Object)this));
            Util.addPropertyChangeListener((Object)this.extBorder, (PropertyChangeListener)((Object)this));
            this.firePropertyChange("exteriorBorder", oldBorder, this.extBorder);
        }
    }

    public void setInteriorBorder(BorderInterface interior) {
        if (!com.sas.util.Util.equal((Object)interior, (Object)this.intBorder)) {
            BorderInterface oldBorder = this.intBorder;
            this.intBorder = interior == null ? new BaseBorder(0) : interior;
            Util.removePropertyChangeListener((Object)oldBorder, (PropertyChangeListener)((Object)this));
            Util.addPropertyChangeListener((Object)this.intBorder, (PropertyChangeListener)((Object)this));
            this.firePropertyChange("interiorBorder", oldBorder, this.intBorder);
        }
    }

    @Override
    public void setLightSource(int ltSrc) {
        super.setLightSource(ltSrc);
        this.getInteriorBorder().setLightSource(ltSrc);
        this.getExteriorBorder().setLightSource(ltSrc);
    }

    @Override
    public void setStyle(int s) {
        super.setStyle(s);
        this.getInteriorBorder().setStyle(s);
        this.getExteriorBorder().setStyle(s);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.interiorBorder != null) {
            this.intBorder = this.interiorBorder;
            this.interiorBorder = null;
        }
        if (this.exteriorBorder != null) {
            this.extBorder = this.exteriorBorder;
            this.exteriorBorder = null;
        }
    }
}

