/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.Border;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

class ComboButtonBorder
extends Border {
    static final long serialVersionUID = 461691284662313146L;

    public ComboButtonBorder() {
        this.borderWidth = 2;
        this.setStyle(4);
        this.setLightSource(10);
    }

    @Override
    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        if (g == null || this.borderWidth == 0) {
            return;
        }
        Color currentColor = g.getColor();
        ComboButtonBorder.drawBezel(g, x, y, width, height);
        g.setColor(currentColor);
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height) {
        g.setColor(SystemColor.controlShadow);
        g.drawLine(x, y, x + width - 1, y);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(x + width - 1, y + height - 1, x + width - 1, y);
        g.drawLine(x + width - 1, y + height - 1, x, y + height - 1);
        g.setColor(SystemColor.controlDkShadow);
        g.drawLine(x, y + 1, x + width - 3, y + 1);
        g.setColor(SystemColor.controlHighlight);
        g.drawLine(x + width - 2, y + height - 2, x + width - 2, y + 1);
        g.drawLine(x + width - 2, y + height - 2, x, y + height - 2);
    }

    @Override
    public Insets getInsets(Component comp) {
        return new Insets(2, 0, 2, 2);
    }

    @Override
    public int getBorderWidth() {
        return 2;
    }

    @Override
    public void setBorderWidth(int width) {
    }

    @Override
    protected String paramString() {
        String styleString = "BUTTON";
        String borderStruct = super.paramString() + ",Style=" + styleString;
        return borderStruct;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.paramString() + "]";
    }
}

