/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.ListBox;
import com.sas.awt.TextField;
import com.sas.visuals.ComboBox;
import com.sas.visuals.ComboButton;
import com.sas.visuals.ComboText;
import com.sas.visuals.PushButton;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

class ComboBoxFocusHandler
implements FocusListener,
ActionListener,
ItemListener,
PropertyChangeListener,
WindowListener,
KeyListener,
MouseListener,
Serializable {
    static final long serialVersionUID = -3308231135234667467L;
    private transient boolean hideListBox = true;
    public ComboBox combo;
    public ListBox lb1;
    public ComboText ctf1;
    public ComboButton cb1;
    public PushButton pb1;
    public TextField tf1;
    public Window wn1;

    ComboBoxFocusHandler() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cb1) {
            this.combo.displayList();
            this.hideListBox = false;
        } else if (e.getSource() == this.ctf1) {
            this.combo.hideList();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.ctf1 && this.combo.isAutoHighlight()) {
            if (this.combo.getStyle() != 2) {
                this.ctf1.selectAll();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.ctf1) {
            if (this.combo.isAutoHighlight()) {
                if (this.combo.getStyle() != 2) {
                    this.ctf1.deselectAll();
                }
            }
            if (this.ctf1.getText() != null) {
                this.combo.setText(this.ctf1.getText());
            }
        } else if (e.getSource() == this.lb1) {
            String version = System.getProperty("java.version");
            if (version.indexOf("1.3.1") == 0 && !this.hideListBox) {
                this.hideListBox = true;
                return;
            }
            if (version.indexOf("1.4") == 0 && e.isTemporary()) {
                this.hideListBox = true;
                return;
            }
            this.combo.hideList();
            this.combo.validate();
            this.combo.repaint();
            this.hideListBox = true;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.ctf1 && e.isAltDown() && e.getKeyCode() == 40) {
            if (this.combo.getStyle() != 1) {
                this.combo.displayList();
            } else {
                this.lb1.requestFocus();
            }
            this.hideListBox = false;
        }
        this.combo.createKeyEvent(401, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int checkKey = e.getKeyCode();
        if (checkKey == 27 && this.wn1 != null) {
            this.combo.hideList();
            this.hideListBox = true;
        }
        if (e.getSource() == this.ctf1) {
            if (checkKey == 10) {
                this.combo.textOverride = true;
                this.combo.setText(this.ctf1.getText());
                this.combo.textOverride = false;
                this.combo.createItemEvent(701, this.lb1.getSelectedItem(), 1);
            } else {
                if (checkKey == 38 && this.lb1.getSelectedIndex() > 0) {
                    this.lb1.select(this.lb1.getSelectedIndex() - 1);
                    this.combo.oldSelectedIndex = this.lb1.getSelectedIndex();
                    this.combo.setText(this.lb1.getSelectedItem());
                } else if (checkKey == 40) {
                    if (this.lb1.getSelectedIndex() < this.lb1.getItemCount() - 1) {
                        this.lb1.select(this.lb1.getSelectedIndex() + 1);
                        this.combo.oldSelectedIndex = this.lb1.getSelectedIndex();
                        this.combo.setText(this.lb1.getSelectedItem());
                    } else {
                        this.ctf1.setCaretPosition(0);
                    }
                } else if (this.combo.isMatchedEntry() && !this.combo.excludedKeys.contains((Object)new Integer(e.getKeyCode()))) {
                    String stringTyped = this.ctf1.getText();
                    this.lb1.setSelectionPrefix(stringTyped);
                    String itemSelected = this.lb1.getSelectedItem();
                    if (this.lb1.getSelectedItem() != null) {
                        if (this.combo.isMatchedEntry() && !this.combo.isAddTextToList()) {
                            this.combo.setText(this.lb1.getSelectedItem());
                        }
                        int lengthTyped = stringTyped.length();
                        this.ctf1.setSelectionStart(lengthTyped);
                        this.ctf1.setSelectionEnd(this.ctf1.getText().length());
                    }
                }
                this.combo.createItemEvent(701, this.lb1.getSelectedItem(), 1);
            }
        } else if (e.getSource() == this.lb1) {
            if (checkKey == 10 && this.wn1 != null) {
                this.combo.hideList();
                this.hideListBox = true;
            } else if (checkKey == 38 | checkKey == 40 && !e.isAltDown()) {
                this.combo.oldSelectedIndex = this.lb1.getSelectedIndex();
                this.combo.setText(this.lb1.getSelectedItem());
                this.combo.createItemEvent(701, this.lb1.getSelectedItem(), 1);
            }
        }
        this.combo.createKeyEvent(402, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.combo.createKeyEvent(400, e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.lb1) {
            String sitem = this.lb1.getSelectedItem();
            this.combo.setText(sitem);
            if (this.wn1 != null && this.combo.getStyle() != 1) {
                this.combo.hideList();
                this.hideListBox = true;
            }
            this.combo.createItemEvent(701, sitem, 1);
        } else if (e.getSource() == this.ctf1) {
            this.hideListBox = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("selectedIndex") && this.combo.getStyle() != 1 && !this.combo.isDesignTime()) {
            if (this.lb1.getSelectedItem() != null) {
                this.combo.displayList();
            } else if (this.wn1 != null) {
                this.combo.hideList();
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.wn1 != null) {
            this.combo.hideList();
            this.hideListBox = true;
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

