/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ModelInterface;
import com.sas.awt.Button;
import com.sas.awt.CheckBox;
import com.sas.awt.Color;
import com.sas.awt.Component;
import com.sas.awt.Container;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.BasicColorsPanel;
import com.sas.visuals.ComboBox;
import com.sas.visuals.CustomColorsPanel;
import com.sas.visuals.RB;
import com.sas.visuals.SpinButton;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ColorPanel
extends Panel
implements AdjustmentListener,
PropertyChangeListener,
ActionListener,
FocusListener {
    static final long serialVersionUID = 302451736955454523L;
    public static final String RB_KEY = "ColorPanel.";
    protected Panel p;
    protected ComboBox cBox;
    protected CheckBox inheritedBox;
    protected Button inheritedButton;
    protected Component colorDisplay;
    protected Label rLabel;
    protected Label bLabel;
    protected Label gLabel;
    protected TextField hiddenField;
    protected TextField redField;
    protected TextField blueField;
    protected TextField greenField;
    protected TextField hueField;
    protected TextField satField;
    protected TextField lumField;
    protected TextField hiddenField2;
    protected SpinButton redSpin;
    protected SpinButton hueSpin;
    protected SpinButton greenSpin;
    protected SpinButton satSpin;
    protected SpinButton blueSpin;
    protected SpinButton lumSpin;
    public BasicColorsPanel bcp;
    public CustomColorsPanel ccp;
    private String oldRedValue = "";
    private String oldBlueValue = "";
    private String oldGreenValue = "";
    private String oldHueValue = "";
    private String oldSatValue = "";
    private String oldLumValue = "";
    private boolean showCustom = false;
    private boolean showInherit = false;

    public ColorPanel() {
        this(true, true);
    }

    public ColorPanel(boolean showCustom) {
        this(showCustom, true);
    }

    public ColorPanel(boolean showCustom, boolean showInherit) {
        this.showCustom = showCustom;
        this.showInherit = showInherit;
        this.commonInit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inheritedButton) {
            this.setCurrentColor((Color)null);
        } else if (e.getSource() == this.redField || e.getSource() == this.blueField || e.getSource() == this.greenField) {
            this.processColorChange(true);
        } else {
            this.processColorChange(false);
        }
    }

    public void addCustomColor() {
        if (this.checkRGBFields()) {
            int blue;
            int green;
            int red = new Integer(this.redField.getText());
            Color cl = new Color(red, green = new Integer(this.greenField.getText()).intValue(), blue = new Integer(this.blueField.getText()).intValue());
            if (!this.bcp._basicCanvas.cnl.containsKey((Object)cl)) {
                this.cBox.addItem(cl.getName());
            }
            this.ccp._customCanvas.createCustomColor(cl);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.redSpin) {
            this.redField.setText(new Integer(this.redSpin.getValue()).toString());
        } else if (e.getSource() == this.blueSpin) {
            this.blueField.setText(new Integer(this.blueSpin.getValue()).toString());
        } else if (e.getSource() == this.greenSpin) {
            this.greenField.setText(new Integer(this.greenSpin.getValue()).toString());
        } else if (e.getSource() == this.hueSpin) {
            this.hueField.setText(new Integer(this.hueSpin.getValue()).toString());
        } else if (e.getSource() == this.satSpin) {
            this.satField.setText(new Integer(this.satSpin.getValue()).toString());
        } else if (e.getSource() == this.lumSpin) {
            this.lumField.setText(new Integer(this.lumSpin.getValue()).toString());
        }
        if (e.getSource() == this.redSpin || e.getSource() == this.blueSpin || e.getSource() == this.greenSpin) {
            this.processColorChange(true);
        } else {
            this.convertHSBtoRGB();
        }
    }

    private boolean checkRGBFields() {
        boolean redValue = true;
        boolean blueValue = true;
        boolean greenValue = true;
        redValue = this.validateColorField("Red", this.redSpin.getMaximum());
        if (!redValue) {
            this.redField.setText(this.oldRedValue);
            return false;
        }
        blueValue = this.validateColorField("Blue", this.blueSpin.getMaximum());
        if (!blueValue) {
            this.blueField.setText(this.oldBlueValue);
            return false;
        }
        greenValue = this.validateColorField("Green", this.greenSpin.getMaximum());
        if (!greenValue) {
            this.greenField.setText(this.oldGreenValue);
            return false;
        }
        return true;
    }

    private void commonInit() {
        this.setInsets(new Insets(10, 10, 10, 10));
        AutoSizingGridLayout layoutM = new AutoSizingGridLayout(0, 1);
        layoutM.setHgap(10);
        layoutM.setVgap(15);
        this.setLayout((LayoutManager)layoutM);
        this.inheritedButton = new Button(RB.getStringResource((String)RB_KEY, (String)"inheritedButton.txt"));
        if (this.showInherit) {
            Panel topP = new Panel();
            AutoSizingGridLayout layoutp = new AutoSizingGridLayout(1, 1);
            layoutp.setVgap(10);
            topP.setLayout((LayoutManager)layoutp);
            this.inheritedButton.initialize();
            topP.add(this.inheritedButton);
            this.add(topP);
        }
        this.p = new Panel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(2, 2);
        layout.setHgap(10);
        layout.setVgap(10);
        this.p.setLayout((LayoutManager)layout);
        Panel ctOuter = new Panel();
        AutoSizingGridLayout layoutOuter = new AutoSizingGridLayout(2, 2);
        layoutOuter.setVgap(5);
        layoutOuter.setHgap(10);
        ctOuter.setLayout((LayoutManager)layoutOuter);
        Label colorNameLabel = new Label(RB.getResources(), "ColorPanel.colorNameLabel.txt");
        ctOuter.add(colorNameLabel);
        this.hiddenField = new TextField("", 5);
        this.hiddenField.setVisible(false);
        ctOuter.add(this.hiddenField);
        this.cBox = new ComboBox();
        this.cBox.initialize();
        this.cBox.setStyle(2);
        this.cBox.setBackgroundColor(Color.white);
        this.cBox.setPreferredSize(new Dimension(200, 23));
        ctOuter.add(this.cBox);
        this.colorDisplay = new Component();
        this.colorDisplay.setTransparent(false);
        BaseBorder border1 = new BaseBorder(1, 10, 2);
        this.colorDisplay.setBorder(border1);
        this.colorDisplay.setPreferredSize(new Dimension(75, 23));
        this.colorDisplay.initialize();
        ctOuter.add(this.colorDisplay);
        this.p.add(ctOuter);
        this.hiddenField2 = new TextField("", 5);
        this.hiddenField2.setVisible(false);
        ctOuter.add(this.hiddenField2);
        this.p.add(this.hiddenField2);
        Panel basicContainer = new Panel();
        basicContainer.initialize();
        BaseBorder border2 = (BaseBorder)basicContainer.getBorder();
        Util.configureGroupBoxBorder(border2, RB.getStringResource((String)RB_KEY, (String)"basicColors.txt"));
        basicContainer.setInsets(new Insets(10, 10, 10, 10));
        AutoSizingGridLayout layoutb = new AutoSizingGridLayout(1, 1);
        basicContainer.setLayout((LayoutManager)layoutb);
        this.bcp = new BasicColorsPanel();
        this.bcp.initialize();
        basicContainer.add(this.bcp);
        this.p.add(basicContainer);
        Panel valueContainer = new Panel();
        valueContainer.initialize();
        BaseBorder borderv = (BaseBorder)valueContainer.getBorder();
        Util.configureGroupBoxBorder(borderv, RB.getStringResource((String)RB_KEY, (String)"colorValue.txt"));
        valueContainer.setInsets(new Insets(15, 10, 10, 10));
        AutoSizingGridLayout layout3 = new AutoSizingGridLayout(3, 4);
        layout3.setVgap(5);
        layout3.setHgap(5);
        valueContainer.setLayout((LayoutManager)layout3);
        Label labelred = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"redLabel.txt"), (Object)" "));
        valueContainer.add(labelred);
        Container ct2 = new Container();
        ct2.initialize();
        AutoSizingGridLayout layout2a = new AutoSizingGridLayout(1, 2);
        layout2a.setVgap(5);
        layout2a.setHgap(0);
        ct2.setLayout((LayoutManager)layout2a);
        this.redField = new TextField();
        this.redField.initialize();
        this.redField.setColumns(3);
        this.redField.setAutoHighlight(true);
        ct2.add(this.redField);
        this.redSpin = new SpinButton(0, 0, 255, 1, 10, 1);
        this.redSpin.initialize();
        this.redSpin.setSize(18, 23);
        ct2.add(this.redSpin);
        valueContainer.add(ct2);
        Label labelhue = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"hueLabel.txt"), (Object)"   "));
        valueContainer.add(labelhue);
        Container ct2b = new Container();
        ct2b.initialize();
        ct2b.setLayout((LayoutManager)layout2a);
        this.hueField = new TextField();
        this.hueField.initialize();
        this.hueField.setColumns(3);
        ct2b.add(this.hueField);
        this.hueSpin = new SpinButton(0, 0, 240, 1, 10, 1);
        this.hueSpin.initialize();
        this.hueSpin.setSize(18, 23);
        ct2b.add(this.hueSpin);
        valueContainer.add(ct2b);
        Label labelgreen = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"greenLabel.txt"), (Object)" "));
        valueContainer.add(labelgreen);
        Container ct2c = new Container();
        ct2c.initialize();
        ct2c.setLayout((LayoutManager)layout2a);
        this.greenField = new TextField();
        this.greenField.initialize();
        this.greenField.setColumns(3);
        this.greenField.setAutoHighlight(true);
        ct2c.add(this.greenField);
        this.greenSpin = new SpinButton(0, 0, 255, 1, 10, 1);
        this.greenSpin.initialize();
        this.greenSpin.setSize(18, 23);
        ct2c.add(this.greenSpin);
        valueContainer.add(ct2c);
        Label labelsat = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"satLabel.txt"), (Object)"   "));
        valueContainer.add(labelsat);
        Container ct2d = new Container();
        ct2d.initialize();
        ct2d.setLayout((LayoutManager)layout2a);
        this.satField = new TextField();
        this.satField.initialize();
        this.satField.setColumns(3);
        ct2d.add(this.satField);
        this.satSpin = new SpinButton(0, 0, 240, 1, 10, 1);
        this.satSpin.initialize();
        this.satSpin.setSize(18, 23);
        ct2d.add(this.satSpin);
        valueContainer.add(ct2d);
        Label labelblue = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"blueLabel.txt"), (Object)" "));
        valueContainer.add(labelblue);
        Container ct2e = new Container();
        ct2e.initialize();
        ct2e.setLayout((LayoutManager)layout2a);
        this.blueField = new TextField();
        this.blueField.initialize();
        this.blueField.setColumns(3);
        this.blueField.setAutoHighlight(true);
        ct2e.add(this.blueField);
        this.blueSpin = new SpinButton(0, 0, 255, 1, 10, 1);
        this.blueSpin.initialize();
        this.blueSpin.setSize(18, 23);
        ct2e.add(this.blueSpin);
        valueContainer.add(ct2e);
        Label labellum = new Label(Message.format((String)RB.getStringResource((String)RB_KEY, (String)"lumLabel.txt"), (Object)"   "));
        valueContainer.add(labellum);
        Container ct2f = new Container();
        ct2f.initialize();
        ct2f.setLayout((LayoutManager)layout2a);
        this.lumField = new TextField();
        this.lumField.initialize();
        this.lumField.setColumns(3);
        ct2f.add(this.lumField);
        this.lumSpin = new SpinButton(0, 0, 240, 1, 10, 1);
        this.lumSpin.initialize();
        this.lumSpin.setSize(18, 23);
        ct2f.add(this.lumSpin);
        valueContainer.add(ct2f);
        if (this.showCustom) {
            Panel customContainer = new Panel();
            customContainer.initialize();
            BaseBorder borderc = (BaseBorder)customContainer.getBorder();
            Util.configureGroupBoxBorder(borderc, RB.getStringResource((String)RB_KEY, (String)"customColors.txt"));
            AutoSizingGridLayout layoutc = new AutoSizingGridLayout(1, 1);
            customContainer.setLayout((LayoutManager)layoutc);
            this.ccp = new CustomColorsPanel();
            this.ccp.initialize();
            customContainer.add(this.ccp);
            Container outerContainer = new Container();
            outerContainer.initialize();
            AutoSizingGridLayout layoutx = new AutoSizingGridLayout(2, 1);
            outerContainer.setLayout((LayoutManager)layoutx);
            layoutx.setVgap(5);
            outerContainer.add(valueContainer);
            outerContainer.add(customContainer);
            this.p.add(outerContainer);
        } else {
            this.p.add(valueContainer);
        }
        this.add(this.p);
        this.cBox.attachModel((ModelInterface)this.bcp._basicCanvas.cnl);
        this.bcp._basicCanvas.addPropertyChangeListener(this);
        if (this.showCustom) {
            this.ccp._customCanvas.addPropertyChangeListener(this);
        }
    }

    private void convertHSBtoRGB() {
        boolean hueValue = true;
        boolean satValue = true;
        boolean lumValue = true;
        int[] fa = new int[3];
        hueValue = this.validateColorField("Hue", this.hueSpin.getMaximum());
        if (!hueValue) {
            this.hueField.setText(this.oldHueValue);
            this.hueField.requestFocus();
        }
        if (!(satValue = this.validateColorField("Sat", this.satSpin.getMaximum()))) {
            this.satField.setText(this.oldSatValue);
            this.satField.requestFocus();
        }
        if (!(lumValue = this.validateColorField("Lum", this.lumSpin.getMaximum()))) {
            this.lumField.setText(this.oldLumValue);
            this.lumField.requestFocus();
        }
        if (hueValue && satValue && lumValue) {
            fa = this.hsltorgb(new Integer(this.hueField.getText()), new Integer(this.satField.getText()), new Integer(this.lumField.getText()), fa);
            this.redField.setText(new Integer(fa[0]).toString());
            this.greenField.setText(new Integer(fa[1]).toString());
            this.blueField.setText(new Integer(fa[2]).toString());
        }
    }

    private void convertRGBtoHSB() {
        if (this.checkRGBFields()) {
            int[] fa = new int[3];
            fa = this.rgbtohsl(new Integer(this.redField.getText()), new Integer(this.greenField.getText()), new Integer(this.blueField.getText()), fa);
            this.hueField.setText(new Integer(fa[0]).toString());
            this.satField.setText(new Integer(fa[1]).toString());
            this.lumField.setText(new Integer(fa[2]).toString());
        }
    }

    private void extractRGB(Color tColor) {
        int red = tColor.getRed();
        int blue = tColor.getBlue();
        int green = tColor.getGreen();
        this.colorDisplay.setBackgroundColor((java.awt.Color)tColor);
        this.oldRedValue = this.redField.getText();
        this.redField.setText(new Integer(red).toString());
        this.redSpin.setValue(red);
        this.oldBlueValue = this.blueField.getText();
        this.blueField.setText(new Integer(blue).toString());
        this.blueSpin.setValue(blue);
        this.oldGreenValue = this.greenField.getText();
        this.greenField.setText(new Integer(green).toString());
        this.greenSpin.setValue(green);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.redField || e.getSource() == this.blueField || e.getSource() == this.greenField) {
            this.processColorChange(true);
        } else {
            this.processColorChange(false);
        }
    }

    public java.awt.Color getCurrentColor() {
        if (this.bcp != null && !this.showCustom) {
            return this.bcp._basicCanvas.getCurrentColor();
        }
        if (this.ccp != null && this.showCustom) {
            return this.ccp._customCanvas.getCurrentColor();
        }
        return new Color(RB.getStringResource((String)RB_KEY, (String)"white.txt"));
    }

    @Override
    public void initialize() {
        if (this.showInherit) {
            this.inheritedButton.addActionListener(this);
        }
        this.redField.addActionListener(this);
        this.blueField.addActionListener(this);
        this.greenField.addActionListener(this);
        this.hueField.addActionListener(this);
        this.satField.addActionListener(this);
        this.lumField.addActionListener(this);
        this.redSpin.addAdjustmentListener(this);
        this.blueSpin.addAdjustmentListener(this);
        this.greenSpin.addAdjustmentListener(this);
        this.hueSpin.addAdjustmentListener(this);
        this.satSpin.addAdjustmentListener(this);
        this.lumSpin.addAdjustmentListener(this);
        this.redField.addFocusListener(this);
        this.blueField.addFocusListener(this);
        this.greenField.addFocusListener(this);
        this.hueField.addFocusListener(this);
        this.satField.addFocusListener(this);
        this.lumField.addFocusListener(this);
        this.cBox.addPropertyChangeListener(this);
        this.hueSpin.setEnabled(false);
        this.satSpin.setEnabled(false);
        this.lumSpin.setEnabled(false);
        this.hueField.setEnabled(false);
        this.satField.setEnabled(false);
        this.lumField.setEnabled(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "currentColor") {
            boolean isThere = false;
            java.awt.Color cl = (java.awt.Color)e.getNewValue();
            if (cl == null) {
                return;
            }
            Color c = Color.newColor((java.awt.Color)cl);
            this.extractRGB(c);
            this.convertRGBtoHSB();
            if (cl instanceof SystemColor) {
                if (this.bcp._basicCanvas.cnl.containsKey((Object)cl)) {
                    isThere = true;
                    this.cBox.setText((String)this.bcp._basicCanvas.cnl.get((Object)cl));
                }
            } else if (this.bcp._basicCanvas.cnlNoSysCol.containsKey((Object)cl)) {
                isThere = true;
                this.cBox.setText((String)this.bcp._basicCanvas.cnl.get((Object)cl));
            }
            if (!isThere) {
                this.cBox.setText(RB.getStringResource((String)RB_KEY, (String)"custom.txt"));
            }
            if (this.showCustom) {
                if (e.getSource() == this.bcp._basicCanvas) {
                    this.ccp._customCanvas.setCurrentColor(cl);
                } else if (e.getSource() == this.ccp._customCanvas) {
                    this.bcp._basicCanvas.setCurrentColor(cl);
                }
            }
            this.convertRGBtoHSB();
        } else if (e.getPropertyName() == "text" && e.getSource() == this.cBox) {
            String colorName = this.cBox.getSelectedItem();
            if (this.bcp._basicCanvas.cnl.contains((Object)colorName)) {
                java.awt.Color c = (java.awt.Color)this.bcp._basicCanvas.cnl.getKey((Object)colorName);
                if (c != this.bcp._basicCanvas.getCurrentColor()) {
                    this.bcp._basicCanvas.setCurrentColor(c);
                }
                if (this.showCustom && c != this.ccp._customCanvas.getCurrentColor()) {
                    this.ccp._customCanvas.setCurrentColor(c);
                }
            } else if (colorName != null && !colorName.equals(RB.getStringResource((String)RB_KEY, (String)"custom.txt"))) {
                Color tempColor = new Color(colorName);
                this.extractRGB(tempColor);
                if (tempColor != this.bcp._basicCanvas.getCurrentColor()) {
                    this.bcp._basicCanvas.setCurrentColor((java.awt.Color)tempColor);
                }
                if (this.showCustom && tempColor != this.ccp._customCanvas.getCurrentColor()) {
                    this.ccp._customCanvas.setCurrentColor((java.awt.Color)tempColor);
                }
            }
        } else if (e.getSource() == this.inheritedBox) {
            if (this.inheritedBox.getState()) {
                this.p.setEnabled(false);
            } else {
                this.p.setEnabled(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String colorName = this.cBox.getSelectedItem();
        if (colorName != null && !colorName.equals(RB.getStringResource((String)RB_KEY, (String)"custom.txt")) && this.bcp._basicCanvas.cnl.contains((Object)colorName)) {
            Color tempColor = (Color)this.bcp._basicCanvas.cnl.getKey((Object)colorName);
            this.extractRGB(tempColor);
            if (tempColor != this.bcp._basicCanvas.getCurrentColor()) {
                this.bcp._basicCanvas.setCurrentColor((java.awt.Color)tempColor);
            }
            if (this.showCustom && tempColor != this.ccp._customCanvas.getCurrentColor()) {
                this.ccp._customCanvas.setCurrentColor((java.awt.Color)tempColor);
            }
        }
    }

    private void processColorChange(boolean doRGBtoHSB) {
        if (doRGBtoHSB) {
            this.convertRGBtoHSB();
        } else {
            this.convertHSBtoRGB();
        }
        if (this.redField.getText().length() > 0 && this.greenField.getText().length() > 0 && this.blueField.getText().length() > 0) {
            int blue;
            int green;
            int red = new Integer(this.redField.getText());
            Color cl = new Color(red, green = new Integer(this.greenField.getText()).intValue(), blue = new Integer(this.blueField.getText()).intValue());
            if (this.bcp._basicCanvas.cnl.contains((Object)cl)) {
                this.cBox.setText(cl.getName());
            } else {
                this.cBox.setText(RB.getStringResource((String)RB_KEY, (String)"custom.txt"));
            }
            if (cl != this.bcp._basicCanvas.getCurrentColor()) {
                this.bcp._basicCanvas.setCurrentColor((java.awt.Color)cl);
            }
            if (this.showCustom && cl != this.bcp._basicCanvas.getCurrentColor()) {
                this.ccp._customCanvas.setCurrentColor((java.awt.Color)cl);
            }
        }
    }

    public void setCurrentColor(java.awt.Color cl) {
        if (cl != null) {
            if (cl instanceof SystemColor) {
                this.bcp._basicCanvas.setCurrentColor(cl);
            } else {
                this.setCurrentColor(Color.newColor((java.awt.Color)cl));
            }
        } else {
            this.setCurrentColor((Color)null);
        }
    }

    public void setCurrentColor(Color cl) {
        if (this.bcp != null) {
            if (cl != null) {
                this.bcp._basicCanvas.setCurrentColor((java.awt.Color)cl);
            } else {
                this.bcp._basicCanvas.setCurrentColor(null);
            }
        }
    }

    private boolean validateColorField(String field, int max) {
        String testfield = "";
        if (field.equals("Red")) {
            testfield = this.redField.getText();
        } else if (field.equals("Blue")) {
            testfield = this.blueField.getText();
        } else if (field.equals("Green")) {
            testfield = this.greenField.getText();
        } else if (field.equals("Hue")) {
            testfield = this.hueField.getText();
        } else if (field.equals("Sat")) {
            testfield = this.satField.getText();
        } else if (field.equals("Lum")) {
            testfield = this.lumField.getText();
        }
        if (testfield.length() != 0) {
            String text = field;
            for (int i = 0; i < testfield.length(); ++i) {
                Character temp = new Character(testfield.charAt(i));
                if (Character.isDigit(temp.charValue()) || temp.charValue() == '-') continue;
                return false;
            }
            Integer tempInt = new Integer(testfield);
            if (tempInt < 0) {
                return false;
            }
            return tempInt <= max;
        }
        return false;
    }

    private int[] rgbtohsl(int R, int G, int B, int[] hsla) {
        float cMin;
        float cMax;
        float H = 0.0f;
        float S = 0.0f;
        float L = 0.0f;
        float f = cMax = R > G ? (float)R : (float)G;
        if ((float)B > cMax) {
            cMax = B;
        }
        float f2 = cMin = R < G ? (float)R : (float)G;
        if ((float)B < cMin) {
            cMin = B;
        }
        L = (int)(((cMax + cMin) * 240.0f + 255.0f) / 510.0f);
        if (cMax == cMin) {
            S = 0.0f;
            H = 160.0f;
        } else {
            S = L <= 120.0f ? ((cMax - cMin) * 240.0f + (cMax + cMin) / 2.0f) / (cMax + cMin) : ((cMax - cMin) * 240.0f + (510.0f - cMax - cMin) / 2.0f) / (510.0f - cMax - cMin);
            float Rdelta = ((cMax - (float)R) * 40.0f + (cMax - cMin) / 2.0f) / (cMax - cMin);
            float Gdelta = ((cMax - (float)G) * 40.0f + (cMax - cMin) / 2.0f) / (cMax - cMin);
            float Bdelta = ((cMax - (float)B) * 40.0f + (cMax - cMin) / 2.0f) / (cMax - cMin);
            if ((float)R == cMax) {
                H = Bdelta - Gdelta;
                H = (int)H;
            } else {
                int value;
                H = (float)G == cMax ? 80.0f + Rdelta - Bdelta : 160.0f + Gdelta - Rdelta;
                String temp = new Float(H).toString();
                int periodPos = temp.indexOf(46);
                if (periodPos > 0 && (value = new Integer(temp.substring(periodPos + 1, periodPos + 2)).intValue()) > 5) {
                    H = (int)H + 1;
                }
            }
            if (H < 0.0f) {
                H += 240.0f;
            }
            if (H > 240.0f) {
                H -= 240.0f;
            }
        }
        hsla[0] = new Float(H).intValue();
        hsla[1] = new Float(S).intValue();
        hsla[2] = new Float(L).intValue();
        return hsla;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] hsltorgb(int h, int s, int l, int[] rgba) {
        int B;
        int G;
        int R;
        if (s == 0) {
            int t;
            R = t = l * 255 / 240;
            G = t;
            B = t;
            if (h == 160) {
                // empty if block
            }
        } else {
            int num2 = l <= 120 ? (l * (240 + s) + 120) / 240 : l + s - (l * s + 120) / 240;
            int num1 = 2 * l - num2;
            R = (this.huetorgb(num1, num2, h + 80) * 255 + 120) / 255;
            G = (this.huetorgb(num1, num2, h) * 255 + 120) / 240;
            B = (this.huetorgb(num1, num2, h - 80) * 255 + 120) / 240;
        }
        rgba[0] = R;
        rgba[1] = G;
        rgba[2] = B;
        return rgba;
    }

    private int huetorgb(int n1, int n2, int hue) {
        if (hue < 0) {
            hue += 240;
        }
        if (hue > 240) {
            hue -= 240;
        }
        if (hue < 40) {
            return n1 + ((n2 - n1) * hue + 20) / 40;
        }
        if (hue < 120) {
            return n2;
        }
        if (hue < 160) {
            return n1 + ((n2 - n1) * (160 - hue) + 20) / 40;
        }
        return n1;
    }
}

