/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Container;
import com.sas.visuals.PushButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ButtonPanel
extends Container
implements ActionListener {
    protected Container buttons;
    protected String selectedActionCommand;

    protected PushButton makeButton(String text) {
        PushButton button = new PushButton(text);
        button.setInsets(0, 10, 0, 10);
        button.initialize();
        return button;
    }

    public ButtonPanel() {
        this.setInsets(5, 12, 8, 12);
        this.setLayout(new BorderLayout());
        this.buttons = new Container();
        GridLayout grid = new GridLayout(1, 0);
        grid.setHgap(7);
        this.buttons.setLayout(grid);
        this.buttons.initialize();
        this.add("East", this.buttons);
    }

    public ButtonPanel(String[][] buttonInfo) {
        this();
        for (int i = 0; i < buttonInfo.length; ++i) {
            PushButton button = this.addButton(buttonInfo[i][0]);
            if (buttonInfo[i].length <= 1) continue;
            button.setActionCommand(buttonInfo[i][1]);
        }
        this.add("East", this.buttons);
    }

    public PushButton addButton(String buttonText) {
        PushButton button = this.makeButton(buttonText);
        button.addActionListener(this);
        this.buttons.add(button);
        return button;
    }

    public PushButton addButton(String buttonText, String actionCommand) {
        PushButton button = this.makeButton(buttonText);
        button.addActionListener(this);
        button.setActionCommand(actionCommand);
        this.buttons.add(button);
        return button;
    }

    public PushButton removeButton(String buttonText) {
        PushButton button = this.getButton(buttonText);
        if (button != null) {
            button.removeActionListener(this);
            this.buttons.remove(button);
        }
        return button;
    }

    public PushButton getButton(String buttonText) {
        Component[] children = this.buttons.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof PushButton) || !buttonText.equals(((PushButton)children[i]).getText())) continue;
            return (PushButton)children[i];
        }
        return null;
    }

    public void removeButton(PushButton btn) {
        if (btn != null) {
            btn.removeActionListener(this);
            this.buttons.remove(btn);
        }
    }

    public PushButton getButtonFromActionCommand(String actionCommand) {
        Component[] children = this.buttons.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof PushButton) || !actionCommand.equals(((PushButton)children[i]).getActionCommand())) continue;
            return (PushButton)children[i];
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        this.setSelectedActionCommand(event.getActionCommand());
    }

    public String getSelectedActionCommand() {
        return this.selectedActionCommand;
    }

    public void setSelectedActionCommand(String selectedActionCommand) {
        this.selectedActionCommand = selectedActionCommand;
    }
}

