/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Panel;
import com.sas.visuals.BorderInterface;
import com.sas.visuals.BufferedGraphics;
import com.sas.visuals.DoubleBufferInterface;
import com.sas.visuals.VisualAspects;
import com.sas.visuals.Wallpaper;
import com.sas.visuals.Windows95Border;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class BufferedPanel
extends Panel
implements VisualAspects,
DoubleBufferInterface,
Serializable {
    protected transient BufferedGraphics _graphics;
    protected Wallpaper _wallpaper;

    public BufferedPanel() {
        this(-1, true);
    }

    public BufferedPanel(int borderStyle) {
        this(borderStyle, true);
    }

    public BufferedPanel(int borderStyle, boolean doubleBuffered) {
        this.setWindowBorderStyle(borderStyle);
        this.setDoubleBuffered(doubleBuffered);
    }

    public void setWindowBorderStyle(int s) {
        BorderInterface b = this.getBorder();
        try {
            b.setStyle(s);
        }
        catch (NullPointerException e) {
            this.setBorder(new Windows95Border(s));
        }
    }

    public int getWindowBorderStyle() {
        BorderInterface b = this.getBorder();
        try {
            return b.getStyle();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public Insets getInsets() {
        BorderInterface b = this.getBorder();
        try {
            Insets i = b.getInsets();
            return new Insets(i.top, i.left, i.bottom, i.right);
        }
        catch (NullPointerException e) {
            return new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public void setBackground(Color c) {
        Color color = c instanceof SystemColor ? new Color(c.getRGB()) : c;
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color c) {
        Color color = c instanceof SystemColor ? new Color(c.getRGB()) : c;
        super.setForeground(color);
    }

    @Override
    public boolean isDoubleBuffered() {
        try {
            return this._graphics.isDoubleBuffered();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public void setDoubleBuffered(boolean state) {
        boolean current = state;
        if (this._graphics == null) {
            this._graphics = new BufferedGraphics();
        }
        current = this._graphics.isDoubleBuffered();
        this._graphics.setDoubleBuffered(state);
        if (current != state) {
            this.repaint();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void setWallpaper(Wallpaper wallpaper) {
        this._wallpaper = wallpaper;
    }

    public Wallpaper getWallpaper() {
        return this._wallpaper;
    }

    @Override
    public void paint(Graphics g) {
        block6: {
            try {
                this._graphics.beginPaint(this, g);
            }
            catch (NullPointerException e) {
                if (this._graphics != null) break block6;
                this._graphics = new BufferedGraphics();
                this._graphics.beginPaint(this, g);
            }
        }
        Dimension size = this.getSize();
        this.paintBackground(this._graphics);
        if (g instanceof PrintGraphics) {
            this.printView(this._graphics);
        } else {
            this.paintView(this._graphics);
        }
        this.superPaint(this._graphics);
        try {
            this.getBorder().drawInRect((Graphics)this._graphics, 0, 0, size.width, size.height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this._graphics.endPaint(this, g);
    }

    protected void paintBackground(BufferedGraphics g) {
        Dimension size = this.getSize();
        if (!this.isTransparent() || this._graphics.isDoubleBuffered()) {
            if (this._wallpaper != null) {
                this._wallpaper.setBounds(0, 0, size.width, size.height);
                this._wallpaper.setParent(this);
                this._wallpaper.paintView(g);
            } else {
                Rectangle rect = new Rectangle(0, 0, size.width, size.height);
                Color c = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(rect);
                g.setColor(c);
            }
        }
    }

    protected void paintView(BufferedGraphics g) {
    }

    protected void printView(BufferedGraphics g) {
        this.paintView(g);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.setBorder(new Windows95Border(this));
    }

    @Override
    public Dimension getPreferredSize() {
        LayoutManager mgr = this.getLayout();
        Dimension size = mgr == null ? null : mgr.preferredLayoutSize(this);
        Dimension dim = size == null ? new Dimension(0, 0) : new Dimension(size);
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        LayoutManager mgr = this.getLayout();
        Dimension size = mgr == null ? null : mgr.minimumLayoutSize(this);
        Dimension dim = size == null ? new Dimension(0, 0) : new Dimension(size);
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

