/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.DoubleBufferInterface;
import com.sas.visuals.DrawingSupport;
import com.sas.visuals.VisualAspects;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BufferedGraphics
extends Graphics
implements VisualAspects,
DoubleBufferInterface {
    protected Image _image = null;
    protected Graphics _graphics = null;
    protected Dimension _size = null;
    protected boolean _doubleBuffer = false;

    public BufferedGraphics() {
    }

    public BufferedGraphics(Graphics g) {
        this(g, false);
    }

    public BufferedGraphics(Graphics g, boolean doubleBuffer) throws NullPointerException {
        this();
        if (g == null) {
            String msg = null;
            try {
                ResourceBundle res = ResourceBundle.getBundle("StringBundle");
                msg = res.getString("Null graphics");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            throw new NullPointerException(msg);
        }
        this._graphics = g;
        this.setDoubleBuffered(doubleBuffer);
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffer) {
        if (this._doubleBuffer != doubleBuffer) {
            this._doubleBuffer = doubleBuffer;
        }
    }

    @Override
    public boolean isDoubleBuffered() {
        return this._doubleBuffer;
    }

    public Graphics getGraphics() {
        return this._graphics;
    }

    protected Image getImage() {
        return this._image;
    }

    public Image getImage(Component component, boolean wait) {
        Image image = this.getImage();
        if (image != null) {
            if (component != null) {
                MediaTracker tracker = new MediaTracker(component);
                tracker.addImage(image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return image;
        }
        return null;
    }

    public void beginPaint(Component component, Graphics g) throws NullPointerException {
        this.beginPaint(component, g, component.getSize());
    }

    public void beginPaint(Component component, Graphics g, Dimension size) throws NullPointerException {
        if (g == null) {
            ResourceBundle res = ResourceBundle.getBundle("StringBundle");
            throw new NullPointerException(res.getString("Null graphics"));
        }
        this._graphics = this.isDoubleBuffered() ? this.createDoubleBuffer(component, g, size) : g;
    }

    public void endPaint(Component component, Graphics g) {
        Image image = this.getImage();
        boolean buffered = this.isDoubleBuffered();
        if (buffered && image != null && g != null) {
            try {
                g.drawImage(image, 0, 0, component);
            }
            catch (Exception exception) {}
        } else {
            this._graphics = null;
        }
    }

    protected Graphics createDoubleBuffer(Component component, Graphics g, Dimension size) {
        boolean newImage = false;
        Image image = this.getImage();
        Graphics graphics = this.getGraphics();
        try {
            if (size != null && size.width > 0 && size.height > 0 && (this._size == null || this._size.width != size.width || this._size.height != size.height)) {
                if (image != null) {
                    image.flush();
                }
                image = component.createImage(size.width, size.height);
                newImage = true;
                this._size = size;
            }
        }
        catch (OutOfMemoryError e) {
            graphics = null;
        }
        if (newImage) {
            if (graphics != null && !graphics.equals(g)) {
                graphics.dispose();
            }
            this._image = image;
            graphics = this._image.getGraphics();
            graphics.setColor(component.getBackground());
            graphics.fillRect(0, 0, size.width, size.height);
        }
        if (graphics == null) {
            this._image = null;
            this._size = null;
            System.gc();
            graphics = g;
        }
        graphics.setColor(g.getColor());
        graphics.setFont(g.getFont());
        graphics.setClip(g.getClipBounds());
        return graphics;
    }

    public void drawDottedLine(int x1, int y1, int x2, int y2) {
        DrawingSupport.drawDottedLine(this._graphics, x1, y1, x2, y2);
    }

    public void drawDottedLine(Point point1, Point point2) {
        DrawingSupport.drawDottedLine(this._graphics, point1, point2);
    }

    public void drawLine(Point point1, Point point2) {
        DrawingSupport.drawLine(this._graphics, point1, point2);
    }

    public void fillRect(Rectangle rectangle) {
        DrawingSupport.fillRect(this._graphics, rectangle);
    }

    public void drawRect(Rectangle rectangle) {
        DrawingSupport.drawRect(this._graphics, rectangle);
    }

    public void clearRect(Rectangle rectangle) {
        DrawingSupport.clearRect(this._graphics, rectangle);
    }

    public void drawRoundRect(Rectangle rectangle, int arcWidth, int arcHeight) {
        DrawingSupport.drawRoundRect(this._graphics, rectangle, arcWidth, arcHeight);
    }

    public void fillRoundRect(Rectangle rectangle, int arcWidth, int arcHeight) {
        DrawingSupport.fillRoundRect(this._graphics, rectangle, arcWidth, arcHeight);
    }

    public void draw3DRoundRect(Rectangle rectangle, int arcWidth, int arcHeight, int style) {
        DrawingSupport.draw3DRoundRect(this._graphics, rectangle, arcWidth, arcHeight, style);
    }

    public void draw3DRect(Rectangle rectangle, boolean raised) {
        DrawingSupport.draw3DRect(this._graphics, rectangle, raised);
    }

    public void fill3DRect(Rectangle rectangle, boolean raised) {
        DrawingSupport.fill3DRect(this._graphics, rectangle, raised);
    }

    public void drawArc(Rectangle rectangle, int startAngle, int arcAngle) {
        DrawingSupport.drawArc(this._graphics, rectangle, startAngle, arcAngle);
    }

    public void fillArc(Rectangle rectangle, int startAngle, int arcAngle) {
        DrawingSupport.fillArc(this._graphics, rectangle, startAngle, arcAngle);
    }

    public void drawBasicBorderRect(Rectangle rectangle, int style) {
        DrawingSupport.drawBasicBorderRect(this._graphics, rectangle, style);
    }

    public void drawBasicBorderRect(int x, int y, int width, int height, int style) {
        DrawingSupport.drawBasicBorderRect(this._graphics, x, y, width, height, style);
    }

    public void drawColoredBorderRect(Rectangle rectangle, int style, Color c) {
        DrawingSupport.drawColoredBorderRect(this._graphics, rectangle, style, c);
    }

    public void drawColoredBorderRect(int x, int y, int width, int height, int style, Color c) {
        DrawingSupport.drawColoredBorderRect(this._graphics, x, y, width, height, style, c);
    }

    public void drawBasicBorderRect(int x, int y, int width, int height, Color c, Color topLeft, Color bottomRight) {
        DrawingSupport.drawBasicBorderRect(this._graphics, x, y, width, height, c, topLeft, bottomRight);
    }

    public void drawWindowBorderRect(Rectangle rectangle) {
        DrawingSupport.drawWindowBorderRect(this._graphics, rectangle);
    }

    public void drawWindowBorderRect(int x, int y, int width, int height) {
        DrawingSupport.drawWindowBorderRect(this._graphics, x, y, width, height);
    }

    public void drawBasicButtonBorderRect(Rectangle rectangle, int style) {
        DrawingSupport.drawBasicButtonBorderRect(this._graphics, rectangle, style);
    }

    public void drawBasicButtonBorderRect(int x, int y, int width, int height, int style) {
        DrawingSupport.drawBasicButtonBorderRect(this._graphics, x, y, width, height, style);
    }

    public void drawButtonBorderRect(Rectangle rectangle, int style) {
        DrawingSupport.drawButtonBorderRect(this._graphics, rectangle, style);
    }

    public void drawButtonBorderRect(int x, int y, int width, int height, int style) {
        DrawingSupport.drawButtonBorderRect(this._graphics, x, y, width, height, style);
    }

    public void drawFieldBorderRect(Rectangle rectangle) {
        DrawingSupport.drawFieldBorderRect(this._graphics, rectangle);
    }

    public void drawFieldBorderRect(int x, int y, int width, int height) {
        DrawingSupport.drawFieldBorderRect(this._graphics, x, y, width, height);
    }

    public void drawStatusFieldBorderRect(Rectangle rectangle) {
        DrawingSupport.drawStatusFieldBorderRect(this._graphics, rectangle);
    }

    public void drawStatusFieldBorderRect(int x, int y, int width, int height) {
        DrawingSupport.drawStatusFieldBorderRect(this._graphics, x, y, width, height);
    }

    public void drawGroupBorderRect(Rectangle rectangle) {
        DrawingSupport.drawGroupBorderRect(this._graphics, rectangle);
    }

    public void drawGroupBorderRect(int x, int y, int width, int height) {
        DrawingSupport.drawGroupBorderRect(this._graphics, x, y, width, height);
    }

    public void drawFocusRect(Rectangle rectangle) {
        DrawingSupport.drawFocusRect(this._graphics, rectangle);
    }

    public void drawDottedRect(Rectangle rectangle) {
        DrawingSupport.drawDottedRect(this._graphics, rectangle);
    }

    public void drawFocusRect(int x, int y, int width, int height) {
        DrawingSupport.drawFocusRect(this._graphics, x, y, width, height);
    }

    public void drawDottedRect(int x, int y, int width, int height) {
        DrawingSupport.drawDottedRect(this._graphics, x, y, width, height);
    }

    public void drawString(String[] text, int x, int y, int drawStringMask) {
        DrawingSupport.drawString(this._graphics, text, x, y, drawStringMask);
    }

    public void drawString(String[] text, int x, int y, int drawStringMask, Color opaque) {
        DrawingSupport.drawString(this._graphics, text, x, y, drawStringMask, opaque);
    }

    public void drawString(String text, int x, int y, int drawStringMask) {
        DrawingSupport.drawString(this._graphics, text, x, y, drawStringMask);
    }

    public void drawString(String text, int x, int y, int drawStringMask, Color opaque) {
        DrawingSupport.drawString(this._graphics, text, x, y, drawStringMask, opaque);
    }

    public void drawDisabledString(String[] text, int x, int y, int drawStringMask) {
        DrawingSupport.drawDisabledString(this._graphics, text, x, y, drawStringMask);
    }

    public void drawDisabledString(String[] text, int x, int y, int drawStringMask, Color opaque) {
        DrawingSupport.drawDisabledString(this._graphics, text, x, y, drawStringMask, opaque);
    }

    public void drawDisabledString(String text, int x, int y) {
        DrawingSupport.drawDisabledString(this._graphics, text, x, y);
    }

    public void drawDisabledString(String text, int x, int y, int drawStringMask) {
        DrawingSupport.drawDisabledString(this._graphics, text, x, y, drawStringMask);
    }

    public void drawDisabledString(Graphics g, String str, int x, int y, int drawStringMask, Color opaque) {
        DrawingSupport.drawDisabledString(this._graphics, str, x, y, drawStringMask, opaque);
    }

    public boolean drawDisabledImage(Image img, int x, int y, ImageObserver observer) {
        return DrawingSupport.drawDisabledImage(this._graphics, img, x, y, observer);
    }

    public boolean drawMixedImage(Image img, int x, int y, Color c, ImageObserver observer) {
        return DrawingSupport.drawMixedImage(this._graphics, img, x, y, c, observer);
    }

    public boolean drawTransparentImage(Image img, int x, int y, Color c, ImageObserver observer) {
        return DrawingSupport.drawTransparentImage(this._graphics, img, x, y, c, observer);
    }

    public Dimension getStringSize(String[] text) {
        return DrawingSupport.getStringSize(this._graphics, text);
    }

    public Dimension getStringSize(String[] text, Font font) {
        return DrawingSupport.getStringSize(this._graphics, text, font);
    }

    public Dimension getStringSize(String text) {
        return DrawingSupport.getStringSize(this._graphics, text);
    }

    public Dimension getStringSize(String text, Font font) {
        return DrawingSupport.getStringSize(this._graphics, text, font);
    }

    public int getStringAscent() {
        return DrawingSupport.getStringAscent(this._graphics);
    }

    public int getStringAscent(Font font) {
        return DrawingSupport.getStringAscent(this._graphics, font);
    }

    public int getStringDescent() {
        return DrawingSupport.getStringDescent(this._graphics);
    }

    public int getStringDescent(Font font) {
        return DrawingSupport.getStringDescent(this._graphics, font);
    }

    public Dimension getImageSize(Image image, Component component) {
        return DrawingSupport.getImageSize(this._graphics, image, component);
    }

    @Override
    public Graphics create() {
        return this._graphics.create();
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        return this._graphics.create(x, y, width, height);
    }

    @Override
    public void translate(int x, int y) {
        this._graphics.translate(x, y);
    }

    @Override
    public Color getColor() {
        return this._graphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this._graphics.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this._graphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this._graphics.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this._graphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this._graphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this._graphics.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this._graphics.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this._graphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this._graphics.clipRect(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this._graphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this._graphics.fillRect(x, y, width, height);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this._graphics.drawRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this._graphics.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this._graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this._graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this._graphics.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this._graphics.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this._graphics.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this._graphics.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this._graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this._graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this._graphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this._graphics.drawPolygon(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this._graphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this._graphics.fillPolygon(p);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this._graphics.drawString(str, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this._graphics.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this._graphics.drawBytes(data, offset, length, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this._graphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this._graphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this._graphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this._graphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public void dispose() {
        this._graphics.dispose();
    }

    @Override
    public void finalize() {
        this._graphics.finalize();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this._graphics.setClip(x, y, width, height);
    }

    @Override
    public void setClip(Shape clip) {
        this._graphics.setClip(clip);
    }

    @Override
    public Shape getClip() {
        return this._graphics.getClip();
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this._graphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this._graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this._graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }
}

