/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.awt.Canvas;
import com.sas.models.ColorList;
import com.sas.models.ColorNameList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;

public class BasicColorsCanvas
extends Canvas {
    static final long serialVersionUID = -395080234686858998L;
    protected Color _Color;
    protected Color _SystemColor;
    public ColorList colorList;
    public ColorNameList cnl;
    public ColorNameList cnlNoSysCol;
    protected static final String BASIC_COLORS = "Basic Colors";
    protected static final int BOX_HEIGHT = 16;
    protected static final int BOX_WIDTH = 16;
    protected static final int GAP = 2;
    protected static final int NUM_COLUMNS = 8;
    protected static final int NUM_BASIC_ROWS = 6;
    protected static final int NUM_CUSTOM_ROWS = 2;
    protected int _selectedIdx = -1;
    protected static int _maxFilledIdx = -1;
    static int BASIC_PALETTE_SIZE = 48;
    static int CUSTOM_PALETTE_SIZE = 16;
    static int TOTAL_PALETTE_SIZE = BASIC_PALETTE_SIZE + CUSTOM_PALETTE_SIZE;
    static int[][] BaseColors = new int[][]{{255, 128, 128}, {255, 255, 128}, {128, 255, 128}, {0, 255, 128}, {128, 255, 255}, {0, 128, 255}, {255, 128, 192}, {255, 128, 255}, {255, 0, 0}, {255, 255, 0}, {128, 255, 0}, {0, 255, 64}, {0, 255, 255}, {0, 128, 192}, {128, 128, 192}, {255, 0, 255}, {128, 64, 64}, {255, 128, 64}, {0, 255, 0}, {0, 128, 128}, {0, 64, 128}, {128, 128, 255}, {128, 0, 64}, {255, 0, 128}, {128, 0, 0}, {255, 128, 0}, {0, 128, 0}, {0, 128, 64}, {0, 0, 255}, {0, 0, 160}, {128, 0, 128}, {128, 0, 255}, {64, 0, 0}, {128, 64, 0}, {0, 64, 0}, {0, 64, 64}, {0, 0, 128}, {0, 0, 64}, {64, 0, 64}, {64, 0, 128}, {0, 0, 0}, {128, 128, 0}, {128, 128, 64}, {128, 128, 128}, {64, 128, 128}, {192, 192, 192}, {64, 128, 64}, {255, 255, 255}};
    protected com.sas.awt.Color[] _ColorPalette = new com.sas.awt.Color[BASIC_PALETTE_SIZE + CUSTOM_PALETTE_SIZE];

    public BasicColorsCanvas() {
        this.enableEvents(84L);
        this.commonInit();
    }

    public void commonInit() {
        this._Color = null;
        if (null == this._ColorPalette[0]) {
            int idx;
            for (idx = 0; idx < BASIC_PALETTE_SIZE; ++idx) {
                this._ColorPalette[idx] = new com.sas.awt.Color(BaseColors[idx][0], BaseColors[idx][1], BaseColors[idx][2]);
            }
            idx = BASIC_PALETTE_SIZE;
            _maxFilledIdx = idx - 1;
            this.cnl = new ColorNameList();
            this.cnlNoSysCol = new ColorNameList(false);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredDimension = new Dimension(144, 114);
        return preferredDimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        int xpos = 2;
        int ypos = 2;
        int colEntries = 0;
        com.sas.awt.Color insideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.black);
        com.sas.awt.Color insideBottomRight = new com.sas.awt.Color(210, 210, 220);
        com.sas.awt.Color outsideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.gray);
        com.sas.awt.Color outsideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.white);
        for (int idx = 0; idx < BASIC_PALETTE_SIZE; ++idx) {
            Rectangle r = new Rectangle(xpos, ypos, 16, 16);
            this.paintBorder(g, r, outsideTopLeft, outsideBottomRight);
            r.grow(-1, -1);
            this.paintBorder(g, r, insideTopLeft, insideBottomRight);
            r.grow(1, 1);
            g.setColor((Color)this._ColorPalette[idx]);
            g.fillRect(xpos + 1, ypos + 1, 14, 14);
            xpos += 18;
            if (++colEntries % 8 != 0) continue;
            xpos = 2;
            ypos += 18;
            colEntries = 0;
        }
        if (this._selectedIdx > -1 && this._selectedIdx < BASIC_PALETTE_SIZE) {
            Point p = this.Palette2Coord(this._selectedIdx);
            Rectangle r = new Rectangle(p.x, p.y, 16, 16);
            insideTopLeft = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.white);
            insideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.gray);
            outsideTopLeft = new com.sas.awt.Color(210, 210, 220);
            outsideBottomRight = com.sas.awt.Color.newColor((Color)com.sas.awt.Color.black);
            this.paintBorder(g, r, outsideTopLeft, outsideBottomRight);
            r.grow(-1, -1);
            this.paintBorder(g, r, insideTopLeft, insideBottomRight);
            r.grow(1, 1);
        }
    }

    private void paintBorder(Graphics g, Rectangle r, com.sas.awt.Color topLeft, com.sas.awt.Color bottomRight) {
        g.setColor((Color)topLeft);
        g.drawLine(r.x, r.y, r.x + r.width - 2, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + r.height - 2);
        g.setColor((Color)bottomRight);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
    }

    public Point Palette2Coord(int pal) {
        Point p = new Point(pal % 8 * 16, pal / 8 * 16);
        p.x += pal % 8 * 2;
        p.y += pal / 8 * 2;
        p.x += 2;
        p.y += 2;
        return p;
    }

    public int Coord2BasicPalette(Point coordinate) {
        int pal = coordinate.x / 18 + coordinate.y / 18 * 8;
        return pal >= BASIC_PALETTE_SIZE ? -1 : pal;
    }

    public void setCurrentColor(Color c) {
        Color oldColor = this.getCurrentColor();
        if (c == null) {
            this._Color = null;
            this._selectedIdx = -1;
            this.repaint();
            this.firePropertyChange("currentColor", oldColor, null);
        } else if (c instanceof SystemColor) {
            this._Color = c;
            this._selectedIdx = -1;
            this.repaint();
            this.firePropertyChange("currentColor", oldColor, this.getCurrentColor());
        } else if (oldColor != c) {
            int oldSelectedIdx = this._selectedIdx;
            this._selectedIdx = -1;
            this._Color = c;
            com.sas.awt.Color newColor = com.sas.awt.Color.newColor((Color)c);
            for (int idx = 0; idx <= _maxFilledIdx; ++idx) {
                if (!this._ColorPalette[idx].equals((Object)newColor)) continue;
                this._selectedIdx = idx;
            }
            if (this._selectedIdx != oldSelectedIdx) {
                this.repaint();
            }
            this.firePropertyChange("currentColor", oldColor, this.getCurrentColor());
        }
    }

    public Color getCurrentColor() {
        return this._Color;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Point p;
        int idx;
        super.processMouseEvent(e);
        if (e.getID() == 501 && (idx = this.Coord2BasicPalette(p = new Point(e.getX(), e.getY()))) >= 0) {
            this.setCurrentColor((Color)this._ColorPalette[idx]);
        }
    }
}

