/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.Color;
import com.sas.awt.ContainerVisualComponent;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.lang.StringDataInterface;
import com.sas.visuals.Border;
import com.sas.visuals.RB;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BaseBorder
extends Border
implements StringDataInterface {
    static final long serialVersionUID = -5931736587553705325L;
    public static final String RB_KEY = "BaseBorder.";
    Color backgroundColor;
    Color foregroundColor;
    Color highlightColor;
    Color shadowColor;
    java.awt.Color backgroundColorJ;
    java.awt.Color foregroundColorJ;
    java.awt.Color highlightColorJ;
    java.awt.Color shadowColorJ;
    Font font;
    Component component;
    String text;
    int textGap;
    int textHeight;
    int alignment;
    int margin;
    int sidesPainted;
    int version;
    public static final int CENTER = 256;
    public static final int RIGHT = 2;
    public static final int LEFT = 1;
    public static final int ALL_SIDES = 15;
    public static final int BEZEL = 1;
    public static final int SIMPLE = 2;
    public static final int EMBOSS = 3;
    public static final int BUTTON = 4;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "backgroundColor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"backgroundColor.pd.txt")}}, {{"Name", "baseColor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"baseColor.pd.txt")}}, {{"Name", "borderWidth"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"borderWidth.pd.txt")}}, {{"Name", "component"}, {"Hidden", "true"}}, {{"Name", "font"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"font.pd.txt")}}, {{"Name", "foregroundColor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"foregroundColor.pd.txt")}}, {{"Name", "highlightColor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"highlightColor.pd.txt")}}, {{"Name", "shadowColor"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"shadowColor.pd.txt")}}, {{"Name", "text"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "textAlignment"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"textAlignment.pd.txt")}}, {{"Name", "textMargin"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"textMargin.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public BaseBorder() {
        this(1, 5, 2);
    }

    public BaseBorder(int style) {
        this(style, 5, 2);
    }

    public BaseBorder(int style, int ltSrc) {
        this(style, ltSrc, 2);
    }

    public BaseBorder(int style, int ltSrc, int width) {
        this(style, ltSrc, width, SystemColor.windowBorder, SystemColor.controlHighlight, SystemColor.controlShadow);
    }

    public BaseBorder(int style, int ltSrc, int width, java.awt.Color base) {
        this(style, ltSrc, width, base, base.brighter(), base.darker());
    }

    public BaseBorder(int style, int ltSrc, int width, java.awt.Color base, java.awt.Color highlight, java.awt.Color shadow) {
        this(style, ltSrc, width, base, highlight, shadow, null, 1, 10, Util.getDialogFont());
    }

    public BaseBorder(int style, int ltSrc, int width, java.awt.Color base, java.awt.Color highlight, java.awt.Color shadow, String txt, int align, int margin, Font f) {
        this.highlightColorJ = highlight;
        this.shadowColorJ = shadow;
        super.setBaseColor(base);
        this.backgroundColorJ = null;
        this.foregroundColorJ = null;
        this.font = f;
        this.borderWidth = width;
        this.text = txt;
        this.textHeight = 0;
        this.textGap = 3;
        this.alignment = align;
        this.setStyle(style);
        this.setLightSource(ltSrc);
        this.version = 2;
        this.sidesPainted = 15;
    }

    public int getSidesPainted() {
        return this.sidesPainted;
    }

    public void setSidesPainted(int sides) {
        if (sides != this.sidesPainted) {
            int oldSides = this.sidesPainted;
            this.sidesPainted = sides;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"sidesPainted", (int)oldSides, (int)this.sidesPainted);
        }
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, java.awt.Color topLeft, java.awt.Color bottomRight, int borderWidth) {
        int allSides = 15;
        BaseBorder.drawBezel(g, x, y, width, height, topLeft, topLeft, bottomRight, bottomRight, borderWidth, allSides);
    }

    public static void drawBezel(Graphics g, int x, int y, int width, int height, java.awt.Color top, java.awt.Color left, java.awt.Color bottom, java.awt.Color right, int borderWidth, int sides) {
        if (g == null) {
            return;
        }
        boolean paintRight = true;
        boolean paintLeft = true;
        boolean paintTop = true;
        boolean paintBottom = true;
        boolean hack = false;
        if ((sides & 4) != 4) {
            paintTop = false;
        }
        if ((sides & 8) != 8) {
            paintBottom = false;
        }
        if ((sides & 1) != 1) {
            paintLeft = false;
        }
        if ((sides & 2) != 2) {
            paintRight = false;
        }
        Polygon poly = null;
        int indent = borderWidth;
        if (paintLeft) {
            poly = new Polygon();
            poly.addPoint(x, y);
            if (!paintTop) {
                indent = 0;
            }
            poly.addPoint(x + borderWidth, y + indent);
            indent = borderWidth;
            if (!paintBottom) {
                indent = 0;
            }
            poly.addPoint(x + borderWidth, y + height - indent);
            poly.addPoint(x, y + height);
            g.setColor(left);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintTop) {
            poly = new Polygon();
            poly.addPoint(x, y);
            if (!paintLeft) {
                indent = 0;
            }
            poly.addPoint(x + indent, y + borderWidth);
            indent = borderWidth;
            if (!paintRight) {
                indent = 0;
            }
            poly.addPoint(x + width - indent, y + borderWidth);
            poly.addPoint(x + width, y);
            g.setColor(top);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintRight) {
            poly = new Polygon();
            poly.addPoint(x + width, y);
            if (!paintTop) {
                indent = 0;
            }
            poly.addPoint(x + width - borderWidth, y + indent);
            indent = borderWidth;
            if (!paintBottom) {
                indent = 0;
            }
            poly.addPoint(x + width - borderWidth, y + height - indent);
            poly.addPoint(x + width, y + height);
            g.setColor(right);
            g.fillPolygon(poly);
        }
        indent = borderWidth;
        if (paintBottom) {
            poly = new Polygon();
            poly.addPoint(x, y + height);
            if (!paintLeft) {
                indent = 0;
            }
            poly.addPoint(x + indent, y + height - borderWidth);
            indent = borderWidth;
            if (!paintRight) {
                indent = 0;
            }
            poly.addPoint(x + width - indent, y + height - borderWidth);
            poly.addPoint(x + width, y + height);
            g.setColor(bottom);
            g.fillPolygon(poly);
        }
    }

    public static void drawEmboss(Graphics g, int x, int y, int width, int height, java.awt.Color top, java.awt.Color bottom, int borderWidth) {
        int allSides = 15;
        BaseBorder.drawEmboss(g, x, y, width, height, top, bottom, borderWidth, allSides);
    }

    public static void drawEmboss(Graphics g, int x, int y, int width, int height, java.awt.Color top, java.awt.Color bottom, int borderWidth, int sides) {
        if (g == null) {
            return;
        }
        int half = borderWidth / 2;
        int tmpWidth = width - half;
        int tmpHeight = height - half;
        g.setColor(bottom);
        if ((sides & 4) == 4) {
            g.fillRect(x, y, width, borderWidth);
        }
        if ((sides & 8) == 8) {
            g.fillRect(x, y + height - borderWidth, width, borderWidth);
        } else {
            tmpHeight = height;
        }
        if ((sides & 1) == 1) {
            g.fillRect(x, y, borderWidth, height);
        }
        if ((sides & 2) == 2) {
            g.fillRect(x + width - borderWidth, y, borderWidth, height);
        } else {
            tmpWidth = width;
        }
        g.setColor(top);
        if ((sides & 4) == 4) {
            g.fillRect(x, y, tmpWidth, half);
        }
        if ((sides & 8) == 8) {
            g.fillRect(x, y + height - borderWidth, tmpWidth, half);
        }
        if ((sides & 1) == 1) {
            g.fillRect(x, y, half, tmpHeight);
        }
        if ((sides & 2) == 2) {
            g.fillRect(x + width - borderWidth, y, half, tmpHeight);
        }
    }

    @Override
    public void drawInRect(Component comp, Graphics g, int x, int y, int width, int height) {
        Rectangle oldClip;
        if (g == null || this.borderWidth == 0) {
            return;
        }
        this.setComponent(comp);
        java.awt.Color currentColor = g.getColor();
        Font currentFont = null;
        if (comp != null) {
            currentFont = comp.getFont();
        }
        if (currentFont == null) {
            currentFont = g.getFont();
        }
        int initialY = y;
        this.textHeight = 0;
        int textWidth = 0;
        Point textStart = new Point(0, 0);
        boolean borderText = false;
        if (this.text != null && this.text.length() != 0 && (this.sidesPainted & 4) == 4) {
            Font textFont = this.font;
            if (this.font == null && currentFont != null) {
                textFont = new Font(currentFont.getFamily(), currentFont.getStyle(), currentFont.getSize());
            }
            g.setFont(textFont);
            FontMetrics fontMetrics = g.getFontMetrics();
            this.textHeight = fontMetrics.getHeight();
            textWidth = fontMetrics.stringWidth(this.text) + 2 * this.textGap;
            textStart.x = x;
            textStart.y = y + this.textHeight - fontMetrics.getDescent();
            y += this.textHeight / 2;
            height -= this.textHeight / 2;
            borderText = true;
            textStart.x = this.alignment == 256 ? (textStart.x += (width - textWidth) / 2) : (this.alignment == 2 ? (textStart.x += width - textWidth - this.margin) : (textStart.x += this.margin));
        }
        if ((oldClip = g.getClipBounds()) != null && borderText) {
            Rectangle textRect = new Rectangle(textStart.x - 1, 0, textWidth, this.textHeight);
            Rectangle textI = null;
            if (oldClip.intersects(textRect)) {
                textI = oldClip.intersection(textRect);
            }
            if (textI != null) {
                Point pt1 = new Point(textI.x, textI.y);
                Point pt2 = new Point(textI.x + textI.width, textI.y);
                Point pt3 = new Point(textI.x + textI.width, textI.y + textI.height);
                Point pt4 = new Point(textI.x, textI.y + textI.height);
                Point cpt1 = new Point(oldClip.x, oldClip.y);
                Point cpt2 = new Point(oldClip.x + oldClip.width, oldClip.y);
                Point cpt3 = new Point(oldClip.x + oldClip.width, oldClip.y + oldClip.height);
                Point cpt4 = new Point(oldClip.x, oldClip.y + oldClip.height);
                Point[] pts = null;
                if (pt1.equals(cpt1)) {
                    pts = new Point[]{pt4, pt3, pt2, cpt2, cpt3, cpt4};
                } else if (pt2.equals(cpt2)) {
                    pts = new Point[]{cpt1, pt1, pt4, pt3, cpt3, cpt4};
                } else if (pt3.equals(cpt3)) {
                    pts = new Point[]{cpt1, cpt2, pt2, pt1, pt4, cpt4};
                } else if (pt4.equals(cpt4)) {
                    pts = new Point[]{cpt1, cpt2, cpt3, pt3, pt2, pt1};
                } else if (pt1.y == cpt1.y) {
                    pts = new Point[]{cpt1, pt1, pt4, pt3, pt2, cpt2, cpt3, cpt4};
                } else if (pt1.x == cpt1.x) {
                    pts = new Point[]{cpt1, cpt2, cpt3, cpt4, pt4, pt3, pt2, pt1};
                } else if (pt3.y == cpt3.y) {
                    pts = new Point[]{cpt1, cpt2, cpt3, pt3, pt2, pt1, pt4, cpt4};
                } else if (pt3.x == cpt3.x) {
                    pts = new Point[]{cpt1, cpt2, pt2, pt1, pt4, pt3, cpt3, cpt4};
                }
                if (pts != null) {
                    Polygon clipPoly = new Polygon();
                    for (int i = 0; i < pts.length; ++i) {
                        clipPoly.addPoint(pts[i].x, pts[i].y);
                    }
                    g.setClip(clipPoly);
                }
            }
        }
        if (this.getStyle() == 1) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, this.highlightColorJ, this.highlightColorJ, this.shadowColorJ, this.shadowColorJ, this.borderWidth, this.sidesPainted);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, this.shadowColorJ, this.shadowColorJ, this.highlightColorJ, this.highlightColorJ, this.borderWidth, this.sidesPainted);
            }
        } else if (this.getStyle() == 2) {
            java.awt.Color bColor = this.getBaseColor();
            BaseBorder.drawBezel(g, x, y, width, height, bColor, bColor, bColor, bColor, this.borderWidth, this.sidesPainted);
        } else if (this.getStyle() == 3) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawEmboss(g, x, y, width, height, this.highlightColorJ, this.shadowColorJ, this.borderWidth, this.sidesPainted);
            } else {
                BaseBorder.drawEmboss(g, x, y, width, height, this.shadowColorJ, this.highlightColorJ, this.borderWidth, this.sidesPainted);
            }
        } else if (this.getStyle() == 4) {
            if (this.getLightSource() == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlDkShadow, SystemColor.controlDkShadow, 1, this.sidesPainted);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlHighlight, SystemColor.controlHighlight, SystemColor.controlShadow, SystemColor.controlShadow, 1, this.sidesPainted);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, 1, this.sidesPainted);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight, 1, this.sidesPainted);
            }
        }
        if (borderText && oldClip != null) {
            g.setClip(oldClip);
        }
        if (this.text != null && this.text.length() != 0 && (this.sidesPainted & 4) == 4) {
            java.awt.Color foreColor;
            java.awt.Color backColor = this.backgroundColorJ;
            if (backColor == null && comp != null) {
                backColor = comp.getBackground();
            }
            if (backColor == null && this.component != null) {
                backColor = this.component.getBackground();
            }
            if (backColor == null) {
                backColor = java.awt.Color.white;
            }
            if (this.component instanceof ContainerVisualComponent) {
                if (!((ContainerVisualComponent)this.component).isTransparent() || this.backgroundColorJ != null) {
                    g.setColor(backColor);
                    g.fillRect(textStart.x - 1, initialY, textWidth + 2, initialY + this.textHeight);
                }
            } else {
                g.setColor(backColor);
                g.fillRect(textStart.x - 1, initialY, textWidth + 2, initialY + this.textHeight);
            }
            if ((foreColor = this.foregroundColorJ) == null && comp != null) {
                foreColor = comp.getForeground();
            }
            if (foreColor == null && this.component != null) {
                foreColor = this.component.getForeground();
            }
            if (foreColor == null) {
                foreColor = java.awt.Color.black;
            }
            g.setColor(foreColor);
            g.drawString(this.text, textStart.x + this.textGap, textStart.y);
        }
        if (currentFont != null) {
            g.setFont(currentFont);
        }
        g.setColor(currentColor);
    }

    @Override
    public int getBorderWidth() {
        if (this.getStyle() == 4) {
            return 2;
        }
        return super.getBorderWidth();
    }

    public Component getComponent() {
        return this.component;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Insets getInsets(Component comp) {
        Insets insets;
        if (this.text != null && this.text.length() != 0) {
            Component compUsed = comp;
            if (comp == null && this.component != null) {
                compUsed = this.component;
            }
            this.textHeight = 0;
            if (this.font == null) {
                if (compUsed != null && compUsed.getFont() != null) {
                    Font currentFont = compUsed.getFont();
                    FontMetrics fontMetrics = compUsed.getFontMetrics(currentFont);
                    this.textHeight = fontMetrics.getHeight();
                }
            } else if (compUsed != null) {
                FontMetrics fontMetrics = compUsed.getFontMetrics(this.font);
                this.textHeight = fontMetrics.getHeight();
            }
            int bWidth = this.getBorderWidth();
            if (this.getStyle() == 4) {
                bWidth = 2;
            } else if (this.getStyle() == 0) {
                bWidth = 0;
            }
            int top = bWidth;
            if (this.textHeight > bWidth) {
                top = this.textHeight;
            }
            insets = new Insets(top, bWidth, bWidth, bWidth);
        } else {
            int bWidth = this.getBorderWidth();
            if (this.getStyle() == 0) {
                bWidth = 0;
            } else if (this.getStyle() == 4) {
                bWidth = 2;
            }
            insets = new Insets(bWidth, bWidth, bWidth, bWidth);
        }
        if ((this.sidesPainted & 4) != 4) {
            insets.top = 0;
        }
        if ((this.sidesPainted & 8) != 8) {
            insets.bottom = 0;
        }
        if ((this.sidesPainted & 1) != 1) {
            insets.left = 0;
        }
        if ((this.sidesPainted & 2) != 2) {
            insets.right = 0;
        }
        return insets;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.alignment;
    }

    public int getTextGap() {
        return this.textGap;
    }

    public int getTextMargin() {
        return this.margin;
    }

    public java.awt.Color getBackgroundColor() {
        return this.backgroundColorJ;
    }

    public java.awt.Color getForegroundColor() {
        return this.foregroundColorJ;
    }

    public java.awt.Color getHighlightColor() {
        return this.highlightColorJ;
    }

    public java.awt.Color getShadowColor() {
        return this.shadowColorJ;
    }

    public static void paintBorder(Graphics g, int x, int y, int width, int height, java.awt.Color highlight, java.awt.Color shadow, int style, int bWidth, int lSource, int sides) {
        if (style == 1) {
            if (lSource == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, highlight, highlight, shadow, shadow, bWidth, sides);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, shadow, shadow, highlight, highlight, bWidth, sides);
            }
        } else if (style == 2) {
            BaseBorder.drawBezel(g, x, y, width, height, highlight, highlight, highlight, highlight, bWidth, sides);
        } else if (style == 3) {
            if (lSource == 5) {
                BaseBorder.drawEmboss(g, x, y, width, height, highlight, shadow, bWidth, sides);
            } else {
                BaseBorder.drawEmboss(g, x, y, width, height, shadow, highlight, bWidth, sides);
            }
        } else if (style == 4) {
            if (lSource == 5) {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, SystemColor.controlDkShadow, SystemColor.controlDkShadow, 1, sides);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlHighlight, SystemColor.controlHighlight, SystemColor.controlShadow, SystemColor.controlShadow, 1, sides);
            } else {
                BaseBorder.drawBezel(g, x, y, width, height, SystemColor.controlDkShadow, SystemColor.controlDkShadow, SystemColor.controlLtHighlight, SystemColor.controlLtHighlight, 1, sides);
                BaseBorder.drawBezel(g, x + 1, y + 1, width - 2, height - 2, SystemColor.controlShadow, SystemColor.controlShadow, SystemColor.controlHighlight, SystemColor.controlHighlight, 1, sides);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.alignment == 0) {
            this.alignment = 256;
        }
        if (this.version == 0) {
            if (this.alignment == 1) {
                this.alignment = 2;
            }
            if (this.alignment == 2) {
                this.alignment = 1;
            }
            this.version = 1;
        }
        if (this.version == 1) {
            this.sidesPainted = 15;
            this.version = 2;
        }
        if (this.backgroundColor != null) {
            this.backgroundColorJ = this.backgroundColor;
            this.backgroundColor = null;
        }
        if (this.foregroundColor != null) {
            this.foregroundColorJ = this.foregroundColor;
            this.foregroundColor = null;
        }
        if (this.highlightColor != null) {
            this.highlightColorJ = this.highlightColor;
            this.highlightColor = null;
        }
        if (this.shadowColor != null) {
            this.shadowColorJ = this.shadowColor;
            this.shadowColor = null;
        }
    }

    @Override
    public void setBorderWidth(int width) {
        super.setBorderWidth(width);
    }

    public void setComponent(Component comp) {
        if (this.component != comp) {
            this.component = comp;
            if (this.font == null && this.component.getFont() != null) {
                this.font = this.component.getFont();
                FontMetrics fontInfo = this.component.getFontMetrics(this.font);
                this.textHeight = fontInfo.getHeight();
            }
        }
    }

    public void setFont(Font f) {
        if (!com.sas.util.Util.equal((Object)this.font, (Object)f)) {
            Font oldFont = this.font;
            this.font = f;
            this.firePropertyChange("font", oldFont, this.font);
        }
    }

    public void setText(String txt) {
        if (this.text == null && txt == null) {
            return;
        }
        if (!com.sas.util.Util.equal((Object)this.text, (Object)txt)) {
            String oldText = this.text;
            this.text = txt;
            this.firePropertyChange("text", oldText, this.text);
        }
    }

    public void setTextAlignment(int a) {
        if (this.alignment != a) {
            int oldAlign = this.alignment;
            this.alignment = a;
            this.firePropertyChange("alignment", new Integer(oldAlign), new Integer(this.alignment));
        }
    }

    public void setTextGap(int g) {
        if (this.textGap != g) {
            int oldTextGap = this.textGap;
            this.textGap = g;
            this.firePropertyChange("textGap", new Integer(oldTextGap), new Integer(this.textGap));
        }
    }

    public void setTextMargin(int m) {
        if (this.margin != m) {
            int oldMargin = this.margin;
            this.margin = m;
            this.firePropertyChange("margin", new Integer(oldMargin), new Integer(this.margin));
        }
    }

    public void setBackgroundColor(java.awt.Color c) {
        java.awt.Color oldColor = this.backgroundColorJ;
        if (!com.sas.util.Util.equal((Object)c, (Object)this.backgroundColorJ)) {
            this.backgroundColorJ = c;
            this.firePropertyChange("backgroundColor", oldColor, this.backgroundColorJ);
        }
    }

    public void setForegroundColor(java.awt.Color c) {
        java.awt.Color oldColor = this.foregroundColorJ;
        if (!com.sas.util.Util.equal((Object)c, (Object)this.foregroundColorJ)) {
            this.foregroundColorJ = c;
            this.firePropertyChange("foregroundColor", oldColor, this.foregroundColorJ);
        }
    }

    @Override
    public void setBaseColor(java.awt.Color c) {
        if (c != null && !com.sas.util.Util.equal((Object)c, (Object)this.getBaseColor())) {
            super.setBaseColor(c);
            this.setHighlightColor(this.getBaseColor().brighter());
            this.setShadowColor(this.getBaseColor().darker());
        }
    }

    public void setHighlightColor(java.awt.Color c) {
        if (!com.sas.util.Util.equal((Object)c, (Object)this.highlightColorJ)) {
            java.awt.Color oldColor = this.highlightColorJ;
            this.highlightColorJ = c;
            this.firePropertyChange("highlightColor", oldColor, this.highlightColorJ);
        }
    }

    public void setShadowColor(java.awt.Color c) {
        if (!com.sas.util.Util.equal((Object)c, (Object)this.shadowColorJ)) {
            java.awt.Color oldColor = this.shadowColorJ;
            this.shadowColorJ = c;
            this.firePropertyChange("shadowColor", oldColor, this.shadowColorJ);
        }
    }

    @Override
    protected String paramString() {
        String styleString = "NONE";
        switch (this.getStyle()) {
            case 1: {
                styleString = "BEZEL";
                break;
            }
            case 4: {
                styleString = "BUTTON";
                break;
            }
            case 3: {
                styleString = "EMBOSS";
                break;
            }
            case 2: {
                styleString = "SIMPLE";
            }
        }
        String borderStruct = super.paramString() + ",Style=" + styleString + ",Shadow=" + this.shadowColorJ + ",Highlight=" + this.highlightColorJ + ",Base=" + this.getBaseColor() + ",Foreground=" + this.foregroundColorJ + ",Background=" + this.backgroundColorJ + ",Font=" + this.font + ",Text=" + this.text + ",TextMargin=" + this.margin;
        switch (this.getTextAlignment()) {
            case 256: {
                borderStruct = borderStruct + ",TextAlignment=CENTER";
                break;
            }
            case 1: {
                borderStruct = borderStruct + ",TextAlignment=LEFT";
                break;
            }
            case 2: {
                borderStruct = borderStruct + ",TextAlignment=RIGHT";
            }
        }
        return borderStruct;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.paramString() + "]";
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.getShadowColor() != null) {
            code += this.getShadowColor().hashCode();
        }
        if (this.getHighlightColor() != null) {
            code += this.getHighlightColor().hashCode();
        }
        if (this.getBackgroundColor() != null) {
            code += this.getBackgroundColor().hashCode();
        }
        if (this.getForegroundColor() != null) {
            code += this.getForegroundColor().hashCode();
        }
        if (this.getFont() != null) {
            code += this.getFont().hashCode();
        }
        if (this.getText() != null) {
            code += this.getText().hashCode();
        }
        code += this.getTextGap();
        code += this.getTextAlignment();
        code += this.getTextMargin();
        return code += this.getSidesPainted();
    }

    @Override
    public boolean equals(Object item) {
        BaseBorder baseBorder;
        if (item instanceof BaseBorder && (baseBorder = (BaseBorder)((Object)item)) != null && com.sas.util.Util.equal((Object)baseBorder.getShadowColor(), (Object)this.getShadowColor()) && com.sas.util.Util.equal((Object)baseBorder.getHighlightColor(), (Object)this.getHighlightColor()) && com.sas.util.Util.equal((Object)baseBorder.getBackgroundColor(), (Object)this.getBackgroundColor()) && com.sas.util.Util.equal((Object)baseBorder.getForegroundColor(), (Object)this.getForegroundColor()) && com.sas.util.Util.equal((Object)baseBorder.getFont(), (Object)this.getFont()) && com.sas.util.Util.equal((Object)baseBorder.getText(), (Object)this.getText()) && baseBorder.getTextGap() == this.getTextGap() && baseBorder.getTextAlignment() == this.getTextAlignment() && baseBorder.getTextMargin() == this.getTextMargin() && baseBorder.getSidesPainted() == this.getSidesPainted()) {
            return super.equals(item);
        }
        return false;
    }
}

