/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.util.Util;
import com.sas.visuals.AlarmButtonModel;
import com.sas.visuals.ArrowIcon;
import com.sas.visuals.Border;
import com.sas.visuals.ButtonModelInterface;
import com.sas.visuals.PushButton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ArrowButton
extends PushButton {
    static final long serialVersionUID = -8770345878037747084L;
    ArrowIcon arrowIcon;

    public ArrowButton() {
        this(4);
    }

    public ArrowButton(int orientation) {
        this.arrowIcon = new ArrowIcon(orientation);
        Border border = (Border)this.getBorder();
        border.setBaseColor(SystemColor.controlShadow);
        border.setBorderWidth(1);
        this.setText(null);
        AlarmButtonModel btnModel = new AlarmButtonModel();
        btnModel.setDelay(500L);
        btnModel.setStartInterval(150L);
        this.setButtonModel(btnModel);
        this.setDefaultIcon(this.arrowIcon);
        this.setFocusPainted(false);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        AlarmButtonModel alarmBtnModel;
        s.defaultReadObject();
        ButtonModelInterface btnModel = this.getButtonModel();
        if (btnModel != null && btnModel instanceof AlarmButtonModel && (alarmBtnModel = (AlarmButtonModel)btnModel).getDelay() == 0L) {
            alarmBtnModel.setDelay(500L);
        }
    }

    public int getOrientation() {
        return this.arrowIcon.getOrientation();
    }

    public void setOrientation(int orientation) {
        int oldOrient = this.arrowIcon.getOrientation();
        if (orientation != oldOrient) {
            this.arrowIcon.setOrientation(orientation);
            this.arrowIcon.setPreferredSize(null);
            this.repaint();
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"orientation", (int)oldOrient, (int)orientation);
        }
    }

    @Override
    protected void buttonModelArmed(ButtonModelInterface btnModel) {
        if (btnModel.isArmed() && btnModel.isPressed()) {
            this.getBorder().setStyle(2);
        } else {
            this.getBorder().setStyle(4);
        }
        super.buttonModelArmed(btnModel);
    }

    @Override
    protected void buttonModelPressed(ButtonModelInterface btnModel) {
        if (btnModel.isArmed() && btnModel.isPressed()) {
            this.getBorder().setStyle(2);
        } else {
            this.getBorder().setStyle(4);
        }
        super.buttonModelPressed(btnModel);
    }

    @Override
    protected void buttonModelDisabled(ButtonModelInterface btnModel) {
        super.buttonModelDisabled(btnModel);
        if (btnModel.isDisabled()) {
            this.setForeground(SystemColor.textInactiveText);
        } else {
            this.setForeground(SystemColor.textText);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension iconSize = new Dimension();
        Dimension textSize = new Dimension();
        if (this.getDefaultIcon() != null) {
            iconSize = this.arrowIcon.getMinimumSize();
        }
        if (this.label != null && this.getText() != null) {
            Font currentFont = this.getFont();
            Font labelFont = this.label.getFont();
            if (currentFont != null && !currentFont.equals(labelFont)) {
                this.label.setFont(currentFont);
            }
            textSize = this.label.getMinimumSize();
        }
        Dimension contentSize = this.getContentSize(textSize, iconSize);
        Dimension minimumSize = new Dimension();
        Insets newInsets = this.getInsets();
        int focusDist = 0;
        if (this.isFocusPainted()) {
            focusDist = this.getFocusGap();
        }
        minimumSize.width = contentSize.width + newInsets.left + newInsets.right + 2 * focusDist;
        minimumSize.height = contentSize.height + newInsets.top + newInsets.bottom + 2 * focusDist;
        return minimumSize;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        size.width = size.width - insets.left - insets.right;
        size.height = size.height - insets.top - insets.bottom;
        Dimension arrowIconSize = this.arrowIcon.getMinimumSize();
        if (size.width < arrowIconSize.width) {
            arrowIconSize.width = size.width;
        }
        if (size.height < arrowIconSize.height) {
            arrowIconSize.height = size.height;
        }
        if (Util.unequal((Object)this.arrowIcon.getMinimumSize(), (Object)arrowIconSize)) {
            this.arrowIcon.setPreferredSize(arrowIconSize);
        } else {
            this.arrowIcon.setPreferredSize(null);
        }
    }
}

