/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.PublicClonable;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmInterface;
import com.sas.util.AlarmListener;
import com.sas.visuals.AnimationIconInterface;
import com.sas.visuals.IconView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;

public class AnimationIconView
extends IconView
implements AlarmListener,
PublicClonable {
    static final long serialVersionUID = 4955688123975299936L;
    protected AlarmInterface alarm;
    protected AnimationIconInterface animationIcon;
    protected boolean running;
    protected boolean decrement;

    public AnimationIconView() {
    }

    public AnimationIconView(AnimationIconInterface animIcon) {
        this.setAnimationIcon(animIcon);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AnimationIconView clone = (AnimationIconView)super.clone();
        Alarm alarmClone = new Alarm();
        alarmClone.setStartTime(this.alarm.getStartTime());
        alarmClone.setStopTime(this.alarm.getStopTime());
        alarmClone.setRunning(this.alarm.isRunning());
        alarmClone.setCount(this.alarm.getCount());
        alarmClone.setInterval(this.alarm.getInterval());
        alarmClone.setDelay(this.alarm.getDelay());
        alarmClone.addAlarmListener((AlarmListener)clone);
        clone.setAlarm((AlarmInterface)alarmClone);
        Rectangle rect = this.getBounds();
        Dimension dim = new Dimension(rect.width, rect.height);
        AnimationIconInterface anim = this.getAnimationIcon();
        if (anim instanceof PublicClonable) {
            anim = (AnimationIconInterface)((PublicClonable)anim).clone();
            clone.setAnimationIcon(anim);
        } else {
            this.createIconObject(clone);
            clone.setPreferredSize(dim);
            this.setPreferredSize(dim);
        }
        return clone;
    }

    protected AnimationIconView createIconObject(AnimationIconView icon) {
        try {
            AnimationIconInterface temp = this.getAnimationIcon();
            AnimationIconInterface temp1 = (AnimationIconInterface)temp.getClass().newInstance();
            icon.setAnimationIcon(temp1);
            return icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void fireAlarm(AlarmEvent e) {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.animationIcon != null) {
            if (this.decrement) {
                this.animationIcon.decrement();
            } else {
                this.animationIcon.increment();
            }
            int x = insets.left;
            int y = insets.top;
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            Graphics g = this.getGraphics();
            if (g != null) {
                g.setClip(x, y, width, height);
                this.animationIcon.paintAnimation(this, g, x, y, width, height);
            }
        }
    }

    public AlarmInterface getAlarm() {
        return this.alarm;
    }

    public AnimationIconInterface getAnimationIcon() {
        return this.animationIcon;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isDecrement() {
        return this.decrement;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.alarm == null) {
            this.alarm = new Alarm();
        }
        this.alarm.addAlarmListener((AlarmListener)this);
    }

    public void setAlarm(AlarmInterface a) {
        if (a != null && this.alarm != a) {
            AlarmInterface oldAlarm = this.alarm;
            oldAlarm.removeAlarmListener((AlarmListener)this);
            this.alarm = a;
            this.alarm.addAlarmListener((AlarmListener)this);
            this.firePropertyChange("alarm", oldAlarm, this.alarm);
        }
    }

    public void setAnimationIcon(AnimationIconInterface animIcon) {
        AnimationIconInterface oldIcon = this.getAnimationIcon();
        if (oldIcon != animIcon) {
            if (this.getIcon() == null || this.getIcon() == oldIcon) {
                this.setIcon(animIcon);
            }
            this.animationIcon = animIcon;
            this.firePropertyChange("animationIcon", oldIcon, this.animationIcon);
        }
    }

    public void setDecrement(boolean d) {
        if (d != this.decrement) {
            this.decrement = d;
            this.firePropertyChange("decrement", new Boolean(!this.decrement), new Boolean(this.decrement));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.alarm = new Alarm();
        this.alarm.addAlarmListener((AlarmListener)this);
        this.alarm.setInterval(25L);
        this.running = false;
    }

    public void setRunning(boolean r) {
        if (this.isRunning() != r) {
            if (r) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    public void start() {
        if (this.running) {
            return;
        }
        if (this.animationIcon != null) {
            this.animationIcon.reset();
        }
        this.alarm.start();
        this.running = true;
        this.firePropertyChange("running", new Boolean(!this.running), new Boolean(this.running));
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.alarm.stop();
        this.running = false;
        this.firePropertyChange("running", new Boolean(!this.running), new Boolean(this.running));
    }
}

