/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.util.Alarm;
import com.sas.util.AlarmEvent;
import com.sas.util.AlarmInterface;
import com.sas.util.AlarmListener;
import com.sas.util.Util;
import com.sas.visuals.DefaultButtonModel;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class AlarmButtonModel
extends DefaultButtonModel
implements AlarmListener {
    static final long serialVersionUID = -5512481031298914390L;
    static boolean skipAWTQueueAccess = false;
    protected AlarmInterface alarm;
    protected long delay;
    protected long startInterval;

    public AlarmButtonModel() {
        this(500L, 500L);
    }

    public AlarmButtonModel(long delay, long startInterval) {
        this.delay = delay;
        this.startInterval = startInterval;
        this.alarm = new Alarm();
        this.alarm.addAlarmListener((AlarmListener)this);
        this.alarm.setDelay(delay);
        this.alarm.setInterval(startInterval);
    }

    public AlarmInterface getAlarm() {
        return this.alarm;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long d) {
        if (d != this.delay) {
            long oldDelay = this.delay;
            this.delay = d;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"delay", (long)oldDelay, (long)this.delay);
        }
    }

    public long getStartInterval() {
        return this.startInterval;
    }

    public void setStartInterval(long interval) {
        if (interval != this.startInterval) {
            long oldInterval = this.startInterval;
            this.startInterval = interval;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"startInterval", (long)oldInterval, (long)this.startInterval);
        }
    }

    public void setAlarm(AlarmInterface a) {
        if (Util.unequal((Object)this.alarm, (Object)a)) {
            AlarmInterface oldAlarm = this.alarm;
            if (this.alarm != null) {
                this.alarm.removeAlarmListener((AlarmListener)this);
            }
            this.alarm = a;
            if (this.alarm != null) {
                this.alarm.addAlarmListener((AlarmListener)this);
            }
            this.firePropertyChange("alarm", oldAlarm, this.alarm);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.alarm.addAlarmListener((AlarmListener)this);
    }

    public void fireAlarm(AlarmEvent e) {
        AWTEvent nextEvent;
        EventQueue eventQ = null;
        if (!skipAWTQueueAccess) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit != null) {
                    eventQ = toolkit.getSystemEventQueue();
                }
            }
            catch (Throwable t) {
                skipAWTQueueAccess = true;
            }
        }
        if (eventQ != null && (nextEvent = eventQ.peekEvent(502)) != null) {
            this.alarm.stop();
            return;
        }
        this.updateAlarm();
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void updateAlarm() {
        long interval = this.alarm.getInterval();
        if (interval > 50L) {
            this.alarm.setInterval(interval - 50L);
        }
    }

    @Override
    public void setDisabled(boolean d) {
        if (d) {
            super.setArmed(false);
            this.setPressed(false);
        }
        super.setDisabled(d);
    }

    @Override
    public void setPressed(boolean p) {
        if (!this.isDisabled() && this.pressed != p) {
            this.pressed = p;
            if (this.armed && this.pressed && this.actionListenerList != null) {
                this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
            if (this.pressed && this.armed) {
                this.alarm.setDelay(this.delay);
                this.alarm.setInterval(this.startInterval);
                this.alarm.start();
            } else {
                this.alarm.stop();
            }
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"pressed", (boolean)this.pressed);
        }
    }

    @Override
    public void setArmed(boolean a) {
        super.setArmed(a);
        if (this.pressed && this.armed) {
            this.alarm.setDelay(this.delay);
            this.alarm.setInterval(this.startInterval);
            this.alarm.start();
        } else {
            this.alarm.stop();
        }
    }
}

