/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.mail.ByteArrayDataSource;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableWriter;
import com.sas.util.transforms.ToDataSourceTransform;
import com.sas.util.transforms.TransformException;

public class TableDataToCSVDataSourceTransform
extends ToDataSourceTransform {
    static final long serialVersionUID = -7966250938151440503L;
    public static final TableDataToCSVDataSourceTransform defaultInstance = new TableDataToCSVDataSourceTransform();

    public TableDataToCSVDataSourceTransform() {
        this.extension = ".csv";
        this.defaultName = "table";
        this.setText("( to CSV DataSource )");
    }

    public Object transform(Object object) throws TransformException {
        ByteArrayDataSource dataSource = null;
        if (object instanceof MultidimensionalTableInterface) {
            byte[] bArray = TableWriter.getCSVAsByteArray((MultidimensionalTableInterface)object);
            dataSource = new ByteArrayDataSource(bArray, "application/octet-stream", this.getFullName());
        } else if (object instanceof StaticTableInterface) {
            byte[] bArray = TableWriter.getCSVAsByteArray((StaticTableInterface)object);
            dataSource = new ByteArrayDataSource(bArray, "application/octet-stream", this.getFullName());
        }
        return dataSource;
    }
}

