/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.collection.hlist.DoubleItem;
import com.sas.collection.hlist.HListInterface;
import com.sas.collection.hlist.StringItem;
import com.sas.table.FontStyle;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;

public class SASFontListToFontStyleTransform
implements TransformInterface {
    static final long serialVersionUID = -2284407404417813880L;
    public static final SASFontListToFontStyleTransform defaultInstance = new SASFontListToFontStyleTransform();

    public Object transform(Object input) throws TransformException {
        if (input instanceof HListInterface) {
            DoubleItem pointsItem;
            DoubleItem widthItem;
            DoubleItem weightItem;
            HListInterface fontList = (HListInterface)input;
            FontStyle fontStyle = new FontStyle();
            String family = null;
            StringItem familyItem = (StringItem)fontList.getItem("FAMNAME");
            if (familyItem != null) {
                family = familyItem.getValue().toLowerCase().trim();
            }
            if (family == null) {
                throw new TransformException();
            }
            fontStyle.setName(family);
            DoubleItem styleItem = (DoubleItem)fontList.getItem("STYLE");
            if (styleItem != null) {
                double listStyle = styleItem.getValue();
                switch ((int)listStyle) {
                    case 1: {
                        fontStyle.setStyle(3);
                    }
                    case 2: {
                        fontStyle.setStyle(1);
                    }
                    case 3: {
                        fontStyle.setStyle(2);
                    }
                    case 5: {
                        fontStyle.setStyle(5);
                    }
                    case 6: {
                        fontStyle.setStyle(4);
                    }
                }
            }
            if ((weightItem = (DoubleItem)fontList.getItem("WEIGHT")) != null) {
                double listWeight = weightItem.getValue();
                switch ((int)listWeight) {
                    case 2: {
                        fontStyle.setWeight(2);
                    }
                    case 3: {
                        fontStyle.setWeight(3);
                    }
                    case 4: {
                        fontStyle.setWeight(5);
                    }
                    case 6: {
                        fontStyle.setWeight(5);
                    }
                    case 7: {
                        fontStyle.setWeight(6);
                    }
                    case 9: {
                        fontStyle.setWeight(7);
                    }
                    case 11: {
                        fontStyle.setWeight(8);
                    }
                    case 12: {
                        fontStyle.setWeight(9);
                    }
                }
            }
            if ((widthItem = (DoubleItem)fontList.getItem("WIDTH")) != null) {
                double listWidth = widthItem.getValue();
                switch ((int)listWidth) {
                    case 2: {
                        fontStyle.setWidth(5);
                    }
                    case 5: {
                        fontStyle.setWidth(3);
                    }
                    case 9: {
                        fontStyle.setWidth(7);
                    }
                }
            }
            if ((pointsItem = (DoubleItem)fontList.getItem("POINTS")) != null) {
                int size = (int)(pointsItem.getValue() / 10.0);
                fontStyle.setSize(size);
            }
            return fontStyle;
        }
        throw new TransformException();
    }
}

