/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.lang.ObjectDataInterface;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CommandDispatcher
implements ActionListener,
ItemListener,
ObjectDataInterface,
SupportsErrorHandlerInterface,
SupportsGenericErrorHandlerInterface {
    protected Command command;
    protected Object commandData;
    protected ErrorHandlerInterface errHandler;
    protected GenericErrorHandlerInterface genericErrHandler;

    public CommandDispatcher() {
    }

    public CommandDispatcher(Command cmd) {
        this.setCommand(cmd);
    }

    public CommandDispatcher(Command cmd, Object cmdData) {
        this.setCommand(cmd);
        this.setObjectData(cmdData);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.executeCommand();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeCommand();
    }

    public void executeCommand() {
        Command cmd = this.getCommand();
        if (cmd != null) {
            ErrorHandlerInterface errorHandler = this.getErrorHandler();
            GenericErrorHandlerInterface genericErrorHandler = this.getGenericErrorHandler();
            if (errorHandler != null && cmd instanceof SupportsErrorHandlerInterface) {
                ((SupportsErrorHandlerInterface)cmd).setErrorHandler(errorHandler);
            } else if (genericErrorHandler != null && cmd instanceof SupportsGenericErrorHandlerInterface) {
                ((SupportsGenericErrorHandlerInterface)cmd).setGenericErrorHandler(genericErrorHandler);
            }
            cmd.execute(this.getObjectData());
        }
    }

    public Object getObjectData() {
        return this.commandData;
    }

    public void setObjectData(Object cmdData) {
        this.commandData = cmdData;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command cmd) {
        if (cmd != this.command) {
            this.command = cmd;
        }
    }

    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        this.errHandler = errorHandler;
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errHandler;
    }

    public void setGenericErrorHandler(GenericErrorHandlerInterface genericErrorHandler) {
        this.genericErrHandler = genericErrorHandler;
    }

    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.genericErrHandler;
    }
}

