/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.ModelInterface;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MdTo2dFormattedTable;
import com.sas.mdtable.StaticMultidimensionalTableInterface;
import com.sas.sasserver.mdtable.Axis;
import com.sas.sasserver.mdtable.MultidimensionalTableInterface;
import com.sas.sasserver.mdtable.SubsetInterface;
import com.sas.table.RB;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticFormattedDataInterface;
import com.sas.table.StaticRowLabelInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.util.ContentServer;
import com.sas.util.transforms.ObjectToStringTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormatSymbols;
import java.util.MissingResourceException;
import java.util.Vector;

public class TableWriter {
    public static final String RB_KEY = "TableWriter.";
    protected static String DEFAULT_DELIMITER;
    protected boolean formattedDataUsed = true;
    protected Writer _out;
    protected String _delimiter;
    private boolean isTransposed = false;
    protected static boolean _verbose;
    protected static final String _excelArgs = " /r ";
    protected static final String _fileExt = ".csv";
    protected static final String EXCEL = "Excel";

    public TableWriter(Writer out) {
        this(out, DEFAULT_DELIMITER);
    }

    public TableWriter(Writer out, String delimiter) {
        this._out = out;
        this.setDelimiter(delimiter);
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter != null ? delimiter : "";
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setFormattedDataUsed(boolean useFormat) {
        this.formattedDataUsed = useFormat;
    }

    public boolean isFormattedDataUsed() {
        return this.formattedDataUsed;
    }

    public void setTransposed(boolean isRotated) {
        this.isTransposed = isRotated;
    }

    public boolean isTransposed() {
        return this.isTransposed;
    }

    public static byte[] getCSVAsByteArray(StaticTableInterface model) {
        return TableWriter.getCSVAsByteArray(model, true);
    }

    public static byte[] getCSVAsByteArray(MultidimensionalTableInterface mdModel) {
        return TableWriter.getCSVAsByteArray(mdModel, true, false);
    }

    public static byte[] getCSVAsByteArray(StaticTableInterface model, boolean formattedDataUsed) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            OutputStreamWriter osw = new OutputStreamWriter(baos);
            TableWriter w = new TableWriter(osw);
            w.setFormattedDataUsed(formattedDataUsed);
            w.writeCSV(model);
            osw.flush();
            byte[] a = baos.toByteArray();
            osw.close();
            baos.close();
            return a;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getCSVAsByteArray(StaticMultidimensionalTableInterface mdModel, boolean formattedDataUsed) {
        return TableWriter.getCSVAsByteArray(mdModel, true, false);
    }

    public static byte[] getCSVAsByteArray(StaticMultidimensionalTableInterface mdModel, boolean formattedDataUsed, boolean isRotated) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            OutputStreamWriter osw = new OutputStreamWriter(baos);
            TableWriter w = new TableWriter(osw);
            w.setFormattedDataUsed(formattedDataUsed);
            w.setTransposed(isRotated);
            w.writeCSV(mdModel);
            osw.flush();
            byte[] a = baos.toByteArray();
            osw.close();
            baos.close();
            return a;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeCSV(StaticTableInterface model) throws IOException {
        block17: {
            String lineSep = "\n";
            try {
                int colCount;
                StaticRowLabelInterface srli = null;
                boolean hasRowLabels = model instanceof StaticRowLabelInterface;
                if (hasRowLabels) {
                    srli = (StaticRowLabelInterface)model;
                }
                StaticColumnLabelInterface scli = null;
                boolean hasColumnLabels = model instanceof StaticColumnLabelInterface;
                if (hasColumnLabels) {
                    scli = (StaticColumnLabelInterface)model;
                }
                StaticFormattedDataInterface sfdi = null;
                boolean isFormatted = model instanceof StaticFormattedDataInterface;
                if (isFormatted && this.formattedDataUsed) {
                    sfdi = (StaticFormattedDataInterface)model;
                }
                if ((colCount = model.getColumnCount()) > 0 && hasColumnLabels) {
                    if (hasRowLabels) {
                        this._out.write(this._delimiter);
                    }
                    Object[] colLabels = scli.getColumnLabels(1, colCount);
                    for (int i = 0; i < colLabels.length; ++i) {
                        if (colLabels[i] != null) {
                            this.writeString(colLabels[i].toString());
                        }
                        if (i >= colLabels.length) continue;
                        this._out.write(this._delimiter);
                    }
                    this._out.write(lineSep);
                }
                int i = 1;
                while (true) {
                    try {
                        Object[] row = isFormatted && this.formattedDataUsed ? sfdi.getFormattedRow(i) : model.getRow(i);
                        if (hasRowLabels) {
                            String rowLabel = "";
                            if (srli.getRowLabel(i) != null) {
                                rowLabel = srli.getRowLabel(i).toString();
                            }
                            this.writeString(rowLabel);
                            this._out.write(this._delimiter);
                        }
                        int j = 0;
                        while (j < row.length) {
                            if (isFormatted && this.formattedDataUsed) {
                                this.writeString((String)row[j]);
                            } else {
                                this.writeString((String)ObjectToStringTransform.defaultInstance.transform(row[j]));
                            }
                            if (++j >= row.length) continue;
                            this._out.write(this._delimiter);
                        }
                        this._out.write(lineSep);
                    }
                    catch (IndexOutOfBoundsException e) {
                        break;
                    }
                    ++i;
                }
            }
            catch (TableException e) {
                if (!_verbose) break block17;
                e.printStackTrace();
            }
        }
    }

    public void writeCSV(MultidimensionalTableInterface mdModel) throws IOException {
        this.writeCSV((StaticMultidimensionalTableInterface)mdModel);
    }

    public void writeCSV(StaticMultidimensionalTableInterface mdModel) throws IOException {
        String lineSep = "\n";
        MdTo2dFormattedTable model = new MdTo2dFormattedTable();
        model.setModelInterface((ModelInterface)((MultidimensionalTableInterface)mdModel));
        model.setTransposed(this.isTransposed);
        int row = 1;
        int col = 0;
        if (this.isTransposed) {
            row = 0;
            col = 1;
        }
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        try {
            SubsetInterface[] subsets = ((MultidimensionalTableInterface)mdModel).getSubsets();
            StringBuffer buf = new StringBuffer(256);
            for (int i = 0; i < subsets.length; ++i) {
                if (subsets[i] == null) continue;
                Object[] values = subsets[i].getDrillSubset();
                if (values == null) {
                    values = subsets[i].getSubset();
                }
                if (values == null || values.length <= 0) continue;
                buf.setLength(0);
                buf.append(((LevelInterface)((Object)subsets[i])).getLabel());
                buf.append(": ");
                this.writeValues(buf, values);
                this.writeString(buf.toString());
                this._out.write(lineSep);
            }
            Object[] cells = null;
            cells = this.formattedDataUsed && mdModel instanceof com.sas.mdtable.StaticFormattedDataInterface ? ((com.sas.mdtable.StaticFormattedDataInterface)((Object)mdModel)).getFormattedCells(0, mdModel.getCellCount() - 1) : mdModel.getCells(0, mdModel.getCellCount() - 1);
            String[] temp = null;
            Vector<String[]> rowLabels = new Vector<String[]>(64);
            int maxRowDepth = -1;
            String[] longestRowLabel = null;
            int longestRowInt = 0;
            String[][] sr = ((Axis)mdModel.getAxis(row)).getPointLabels(0, -1);
            for (int i = 1; i <= rowCount; ++i) {
                temp = sr[i - 1];
                if (maxRowDepth < temp.length) {
                    maxRowDepth = temp.length;
                    longestRowLabel = temp;
                    longestRowInt = i - 1;
                }
                rowLabels.addElement(temp);
            }
            int k = 0;
            Vector<String[]> columnLabels = new Vector<String[]>(64);
            int maxColDepth = -1;
            int longestColInt = 0;
            String[][] s = ((Axis)mdModel.getAxis(col)).getPointLabels(0, -1);
            for (int i = maxRowDepth; i < colCount; ++i) {
                temp = s[i - maxRowDepth];
                if (maxColDepth < temp.length) {
                    maxColDepth = temp.length;
                    longestColInt = i - maxRowDepth;
                }
                columnLabels.addElement(temp);
            }
            String last = null;
            for (int depth = 0; depth < maxColDepth; ++depth) {
                int i;
                if (depth != maxColDepth - 1) {
                    for (i = 0; i < maxRowDepth - 1; ++i) {
                        this._out.write(this._delimiter);
                    }
                    this._out.write(this._delimiter);
                } else {
                    for (i = 0; i < maxRowDepth; ++i) {
                        this._out.write(this._delimiter);
                    }
                }
                i = maxRowDepth;
                while (i < colCount) {
                    temp = (String[])columnLabels.elementAt(i - maxRowDepth);
                    if (depth < temp.length && temp[depth] != null) {
                        this.writeString(temp[depth]);
                    }
                    if (++i <= colCount) {
                        this._out.write(this._delimiter);
                    }
                    last = temp[depth];
                }
                this._out.write(lineSep);
            }
            String[] lastArray = null;
            int l = 0;
            for (int i = 1; i <= rowCount; ++i) {
                temp = (String[])rowLabels.elementAt(i - 1);
                for (int depth = 0; depth < maxRowDepth; ++depth) {
                    if (depth < temp.length && temp[depth] != null) {
                        this.writeString(temp[depth]);
                    }
                    this._out.write(this._delimiter);
                }
                lastArray = temp;
                int j = maxRowDepth;
                while (j < colCount) {
                    if (this.formattedDataUsed) {
                        this.writeString((String)cells[k++]);
                    } else {
                        this.writeString((String)ObjectToStringTransform.defaultInstance.transform(cells[k++]));
                    }
                    if (++j < colCount) {
                        this._out.write(this._delimiter);
                    }
                    if (!this.isTransposed) continue;
                    k += rowCount - 1;
                }
                if (this.isTransposed) {
                    k = ++l;
                }
                this._out.write(lineSep);
            }
        }
        catch (TableException e) {
            e.printStackTrace();
        }
    }

    private void writeValues(StringBuffer out, Object[] values) {
        if (values != null) {
            int k = 0;
            while (k < values.length) {
                if (values[k] != null) {
                    out.append(values[k].toString());
                }
                if (++k >= values.length) continue;
                out.append(this._delimiter);
                out.append(" ");
            }
        }
    }

    private void writeString(String str) throws IOException {
        this._out.write(34);
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == '\"') {
                this._out.write("\"\"");
                continue;
            }
            this._out.write(str.charAt(i));
        }
        this._out.write(34);
    }

    public static void setVerbose(boolean verbose) {
        if (_verbose == verbose) {
            return;
        }
        ContentServer.setVerbose((boolean)verbose);
        _verbose = verbose;
        if (_verbose) {
            System.err.println("TableWriter -- verbose mode on");
        }
    }

    public static void resetCheck() {
        ContentServer.resetCheck();
    }

    public static boolean isExportAllowed() {
        return ContentServer.isExportAllowed();
    }

    protected static String getExcelEXE() {
        try {
            return System.getProperty(EXCEL, "Excel.exe");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void export(StaticTableInterface table) {
        TableWriter.export(table, true);
    }

    public static void export(MultidimensionalTableInterface mdModel) {
        TableWriter.export(mdModel, true, false);
    }

    public static void export(StaticTableInterface table, boolean formattedDataUsed) {
        if (!TableWriter.isExportAllowed() || table == null) {
            return;
        }
        ContentServer.export((byte[])TableWriter.getCSVAsByteArray(table, formattedDataUsed), (String)"application/x-comma-separated-values", (String)TableWriter.getExcelEXE(), (String)_excelArgs, (String)_fileExt);
    }

    public static void export(StaticMultidimensionalTableInterface mdModel, boolean formattedDataUsed) {
        TableWriter.export(mdModel, true, false);
    }

    public static void export(StaticMultidimensionalTableInterface mdModel, boolean formattedDataUsed, boolean isRotated) {
        if (!TableWriter.isExportAllowed() || mdModel == null) {
            return;
        }
        ContentServer.export((byte[])TableWriter.getCSVAsByteArray(mdModel, formattedDataUsed, isRotated), (String)"application/x-comma-separated-values", (String)TableWriter.getExcelEXE(), (String)_excelArgs, (String)_fileExt);
    }

    static {
        try {
            DEFAULT_DELIMITER = RB.getStringResource(RB_KEY, "CSVDelimiter");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (DEFAULT_DELIMITER == null || "default".equals(DEFAULT_DELIMITER)) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            DEFAULT_DELIMITER = dfs.getDecimalSeparator() == '.' ? "," : ";";
        }
    }
}

