/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.table.CellSelection;
import com.sas.table.CellVector;
import com.sas.table.Selection;
import com.sas.table.SelectionChangedEvent;
import com.sas.table.TableElement;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class CellVectorSelection
extends Selection {
    public CellVectorSelection(CellVector anchor) {
        this(anchor, anchor);
    }

    public CellVectorSelection(CellVector anchor, CellVector end) {
        super(anchor, end);
    }

    @Override
    public boolean contains(Object item) {
        CellVector cv = (CellVector)item;
        CellVector anchor = (CellVector)this.getAnchor();
        CellVector end = (CellVector)this.getEnd();
        return (cv.getIndex() <= anchor.getIndex() || cv.getIndex() <= end.getIndex()) && (cv.getIndex() >= anchor.getIndex() || cv.getIndex() >= end.getIndex());
    }

    @Override
    public int count() {
        CellVector anchor = (CellVector)this.getAnchor();
        CellVector end = (CellVector)this.getEnd();
        return Math.abs(anchor.getIndex() - end.getIndex()) + 1;
    }

    public CellSelection getCells() {
        CellVector anchor = (CellVector)this.getAnchor();
        CellVector end = (CellVector)this.getEnd();
        int cellCount = anchor.count();
        if (cellCount == 0) {
            return null;
        }
        return new CellSelection(anchor.getCell(1), end.getCell(cellCount));
    }

    @Override
    public Enumeration getItems() {
        return new CellVectorSelectionEnumeration();
    }

    @Override
    protected void onEndChanged(TableElement oldValue, TableElement newValue) {
        CellVector anchor = (CellVector)this.getAnchor();
        CellVector oldEnd = (CellVector)oldValue;
        CellVector newEnd = (CellVector)newValue;
        Selection added = null;
        Selection deleted = null;
        Selection[] additions = null;
        Selection[] deletions = null;
        if (oldEnd.getIndex() > anchor.getIndex()) {
            if (newEnd.getIndex() > oldEnd.getIndex()) {
                added = this.newSelection(oldEnd.next(), newEnd);
            } else if (newEnd.getIndex() >= anchor.getIndex()) {
                deleted = this.newSelection(newEnd.next(), oldEnd);
            } else {
                deleted = this.newSelection(anchor.next(), oldEnd);
                added = this.newSelection(newEnd, anchor.previous());
            }
        } else if (oldEnd.getIndex() == anchor.getIndex()) {
            added = newEnd.getIndex() > anchor.getIndex() ? this.newSelection(anchor.next(), newEnd) : this.newSelection(newEnd, anchor.previous());
        } else if (newEnd.getIndex() < oldEnd.getIndex()) {
            added = this.newSelection(oldEnd.previous(), newEnd);
        } else if (newEnd.getIndex() <= anchor.getIndex()) {
            deleted = this.newSelection(newEnd.previous(), oldEnd);
        } else {
            deleted = this.newSelection(anchor.previous(), oldEnd);
            added = this.newSelection(newEnd, anchor.next());
        }
        if (added != null) {
            additions = new Selection[]{added};
        }
        if (deleted != null) {
            deletions = new Selection[]{deleted};
        }
        this.fireContentsChanged(new SelectionChangedEvent(this, additions, deletions));
    }

    private class CellVectorSelectionEnumeration
    implements Enumeration {
        private CellVector m_next;
        private CellVector m_end;

        public CellVectorSelectionEnumeration() {
            CellVector anchor = (CellVector)CellVectorSelection.this.getAnchor();
            CellVector end = (CellVector)CellVectorSelection.this.getEnd();
            if (anchor.getIndex() < end.getIndex()) {
                this.m_next = anchor;
                this.m_end = end;
            } else {
                this.m_next = end;
                this.m_end = anchor;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_next != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.m_next == null) {
                throw new NoSuchElementException();
            }
            CellVector nextElement = this.m_next;
            this.m_next = this.m_next.equals(this.m_end) ? null : this.m_next.next();
            return nextElement;
        }
    }
}

