/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.table.TableElementChangedEvent;

public abstract class CellVectorChangedEvent
extends TableElementChangedEvent {
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int ALL_REPLACED = 3;
    public static final int CELLS = 4;
    public static final int CLASS = 5;
    public static final int DEFAULT_VALUE = 6;
    private static final int MIN_HOW_CHANGED = 1;
    private static final int MAX_HOW_CHANGED = 6;
    public final int index;
    public final int count;
    public final int howChanged;

    public CellVectorChangedEvent(Object source, int index, int count, int howChanged) {
        super(source);
        this.index = index;
        this.count = count;
        this.howChanged = howChanged;
        if (index <= 0 && howChanged != 3) {
            throw new IndexOutOfBoundsException();
        }
        if (count <= 0 && howChanged != 3) {
            throw new IllegalArgumentException();
        }
        if (howChanged < 1 || howChanged > 6) {
            throw new IllegalArgumentException();
        }
    }

    public CellVectorChangedEvent(Object source) {
        super(source);
        this.index = 0;
        this.count = 0;
        this.howChanged = 3;
    }

    public String toString() {
        String howChangedString = "null";
        switch (this.howChanged) {
            case 1: {
                howChangedString = "ADDED";
                break;
            }
            case 2: {
                howChangedString = "REMOVED";
                break;
            }
            case 3: {
                howChangedString = "ALL_REPLACED";
                break;
            }
            case 4: {
                howChangedString = "CELLS";
                break;
            }
            case 5: {
                howChangedString = "CLASS";
                break;
            }
            case 6: {
                howChangedString = "DEFAULT_VALUE";
            }
        }
        return ((Object)((Object)this)).getClass().getName() + "[" + this.source + ", index=" + this.index + ", count=" + this.count + ", howChanged=" + howChangedString + "]";
    }
}

