/*
 * Decompiled with CFR 0.152.
 */
package com.sas.table;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.table.Cell;
import com.sas.table.DataCell;
import com.sas.table.LabelCell;
import com.sas.table.TableElement;
import com.sas.table.TableView;
import com.sas.util.Countable;
import java.awt.Graphics;

public abstract class CellVector
extends TableElement
implements Countable {
    private static final int DISPLAYED = 1;
    private static final int RESIZED = 4;
    private static final int PARTIAL = 8;
    private static final int CONFORMED = 16;
    private int m_flags;
    private int m_pos;
    private int m_preferredSize;
    private int m_size;
    int m_index;
    int m_version;

    protected CellVector(TableView table, int index) {
        super(table);
        this.m_index = index;
    }

    private int constrainSize(int size) {
        int max;
        Length maxL;
        Length minL = (Length)this.getEffectiveStylePropertyValue("minSize", null);
        if (minL != null) {
            int min = (int)(minL.getMagnitude((Object)this.getPixelUnit()) + 0.5);
            if (size <= min) {
                return min;
            }
        } else if (size <= 0) {
            return 0;
        }
        if ((maxL = (Length)this.getEffectiveStylePropertyValue("maxSize", null)) != null && size >= (max = (int)(maxL.getMagnitude((Object)this.getPixelUnit()) + 0.5))) {
            return max;
        }
        return size;
    }

    public boolean contains(int coord) {
        int pos = this.getPosition();
        return this.isDisplayed() && coord >= pos && coord < pos + this.getSize();
    }

    public final boolean contains(Object obj) {
        return this.contains((DataCell)obj);
    }

    public abstract boolean contains(DataCell var1);

    public final int count() {
        return this.count(0);
    }

    public abstract int count(int var1);

    @Override
    public final boolean equals(TableElement obj) {
        return obj instanceof CellVector && this.equals((CellVector)obj);
    }

    public abstract boolean equals(CellVector var1);

    public abstract DataCell getCell(int var1);

    public int getCellsToSizeCount() {
        Integer I = (Integer)this.getEffectiveStylePropertyValue("cellsToSizeCount", null);
        int cellCount = 1;
        if (I != null) {
            cellCount = I;
        }
        if (cellCount > 0) {
            int temp = this.count(cellCount);
            if (temp < cellCount) {
                cellCount = temp;
            }
        } else if (cellCount < 0) {
            cellCount = this.count(0);
        }
        return cellCount;
    }

    public int getDisplayedSize() {
        if (!this.isDisplayed()) {
            return 0;
        }
        if (!this.isPartiallyDisplayed()) {
            return this.getSize();
        }
        return this.getMaxPosition() - this.getPosition() + 1;
    }

    public abstract int getIndex();

    public abstract LabelCell getLabel();

    public abstract int getMaxPosition();

    @Override
    public String[] getModelTypes() {
        return emptyModelTypesArray;
    }

    @Override
    public StaticPropertyBagInterface[] getModelTypeStyles() {
        return emptyModelTypeStylesArray;
    }

    public abstract String getPixelUnit();

    public int getPosition() {
        return this.getThisCellVector().m_pos;
    }

    public int getPreferredSize() {
        return this.getThisCellVector().m_preferredSize;
    }

    public void setPreferredSize(int newValue) {
        CellVector self = this.getThisCellVector();
        if (self.m_preferredSize == newValue) {
            return;
        }
        if (newValue != 0) {
            newValue = this.constrainSize(newValue);
        }
        self.m_preferredSize = newValue;
    }

    public int computePreferredSize(Graphics g) {
        Length sizeL = (Length)this.getEffectiveStylePropertyValue("size", null);
        if (sizeL != null) {
            return (int)(sizeL.getMagnitude((Object)this.getPixelUnit()) + 0.5);
        }
        return this.onComputePreferredSize(g);
    }

    public int getSize() {
        if (this.isResized() || this.isConformed()) {
            return this.getThisCellVector().m_size;
        }
        return this.getPreferredSize();
    }

    @Override
    protected final TableElement getThis() {
        return this.getThisCellVector();
    }

    protected abstract CellVector getThisCellVector();

    public int hashCode() {
        return this.getIndex();
    }

    private boolean isConformed() {
        return (this.getThisCellVector().m_flags & 0x10) != 0;
    }

    @Override
    public boolean isDisplayed() {
        return (this.getThisCellVector().m_flags & 1) != 0;
    }

    public abstract boolean isHeld();

    @Override
    public boolean isModified() {
        StaticOrderedCollectionInterface modifiedCells = this.tableView.getModifiedCells();
        int maxi = modifiedCells.count();
        for (int i = 0; i < maxi; ++i) {
            DataCell dc;
            Cell cell = (Cell)modifiedCells.get(i);
            if (!(cell.isLabel() ? this.equals(((LabelCell)cell).getChild()) : (dc = (DataCell)cell).getColumn().equals(this) || dc.getRow().equals(this))) continue;
            return true;
        }
        return false;
    }

    public boolean isPartiallyDisplayed() {
        return (this.getThisCellVector().m_flags & 8) != 0;
    }

    public boolean isResizable() {
        return (Boolean)this.getEffectiveStylePropertyValue("resizable", Boolean.TRUE);
    }

    public boolean isResized() {
        return (this.getThisCellVector().m_flags & 4) != 0;
    }

    @Override
    public boolean isTransient() {
        return super.isTransient() && !this.isResized();
    }

    public CellVector next() {
        return this.onNext();
    }

    protected abstract int onComputePreferredSize(Graphics var1);

    protected abstract CellVector onNext();

    protected abstract CellVector onPrevious();

    protected abstract void onResized();

    public CellVector previous() {
        return this.onPrevious();
    }

    public void remeasure() {
        CellVector self = this.getThisCellVector();
        self.m_preferredSize = 0;
        self.m_size = 0;
        self.m_flags &= 0xFFFFFFEB;
        this.onResized();
    }

    public static int resize(OrderedCollection cellVectors, int newSize, boolean relative) {
        return CellVector.resize(cellVectors, newSize, relative, true);
    }

    public static int resize(OrderedCollection cellVectors, int newSize, boolean relative, boolean preserve) {
        int currentSize = 0;
        int resizableSize = 0;
        int maxi = cellVectors.count();
        for (int i = 0; i < maxi; ++i) {
            CellVector vector = (CellVector)cellVectors.get(i);
            int size = vector.getSize();
            currentSize += size;
            if (preserve && vector.isResized()) continue;
            resizableSize += size;
        }
        if (resizableSize == 0) {
            return currentSize;
        }
        if (relative) {
            newSize = currentSize + newSize;
        } else if (newSize <= 0) {
            throw new IllegalArgumentException("Size passed to 'resizeCellVectors' must be positive unless true is passed for the relative parameter.");
        }
        int temp = currentSize;
        currentSize = CellVector.resize(cellVectors, newSize, currentSize, resizableSize, false, preserve);
        if (currentSize != newSize) {
            currentSize = CellVector.resize(cellVectors, newSize, currentSize, resizableSize + (currentSize - temp), true, preserve);
        }
        return currentSize;
    }

    private static int resize(OrderedCollection cellVectors, int newSize, int currentSize, int resizableSize, boolean byOnes, boolean preserve) {
        int offsetToApply = newSize - currentSize;
        while (offsetToApply != 0) {
            int offsetApplied = 0;
            int maxi = cellVectors.count();
            for (int i = 0; i < maxi; ++i) {
                CellVector vector = (CellVector)cellVectors.get(i);
                if (preserve && vector.isResized()) {
                    vector.setPosition(vector.getPosition() + offsetApplied);
                    continue;
                }
                int size = vector.getSize();
                int offset = byOnes ? (offsetToApply > 0 ? 1 : -1) : (int)((double)offsetToApply * (double)size / (double)resizableSize);
                vector.setPosition(vector.getPosition() + offsetApplied);
                if (size == 1 && offset < 0) continue;
                vector.setSize(size + offset, preserve);
                offset = vector.getSize() - size;
                offsetApplied += offset;
                if (byOnes && (offsetToApply -= offset) == 0) break;
            }
            if (offsetApplied == 0) break;
            currentSize += offsetApplied;
            resizableSize += offsetApplied;
            if (byOnes) continue;
            offsetToApply -= offsetApplied;
        }
        return currentSize;
    }

    void setDisplayed(boolean newValue) {
        if (newValue) {
            this.getThisCellVector().m_flags |= 1;
        } else {
            this.getThisCellVector().m_flags &= 0xFFFFFFFE;
            this.setPartiallyDisplayed(false);
        }
    }

    void setPartiallyDisplayed(boolean newValue) {
        this.getThisCellVector().m_flags = newValue ? (this.getThisCellVector().m_flags |= 8) : (this.getThisCellVector().m_flags &= 0xFFFFFFF7);
    }

    void setPosition(int newValue) {
        this.getThisCellVector().m_pos = newValue;
    }

    public final void setSize(int newValue) {
        this.setSize(newValue, false);
    }

    private void setSize(int newValue, boolean conforming) {
        CellVector self = this.getThisCellVector();
        if (newValue == self.m_size) {
            return;
        }
        if (newValue == 0) {
            self.m_size = 0;
            self.m_flags &= 0xFFFFFFEB;
        } else {
            if ((newValue = this.constrainSize(newValue)) <= 0) {
                newValue = 1;
            }
            if (newValue == self.m_size) {
                return;
            }
            self.m_size = newValue;
            self.m_flags = conforming ? (self.m_flags |= 0x10) : (self.m_flags |= 4);
        }
        this.onResized();
    }

    void copyTo(CellVector cv, double scaleFactor) throws CloneNotSupportedException {
        StaticPropertyBagInterface style;
        if (this.isResized()) {
            cv.setSize((int)((double)this.getSize() * scaleFactor + 0.5));
        }
        if ((style = this.getStyle()) != null) {
            cv.setStyle((StaticPropertyBagInterface)style.clone());
        }
    }
}

